#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#  2002.11.02
#
# Package: 
#  wmapm-3.01-i386-1.tgz
#
# Files:
#   http://www.cs.mun.ca/~gstarkes/wmaker/dockapps/files/wmapm-3.01.tar.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=wmapm
VERSION=3.01
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}/wmapm

#make
make clean
make
make install

#makepkg
cd ..
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/bin
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/man1
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv /usr/X11R6/bin/wmapm        ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/bin
mv /usr/X11R6/man/man1/wmapm.1 ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/man/man1
cp ./BUGS    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./CHANGES ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./COPYING ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./HINTS   ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./INSTALL ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./README  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./TODO    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

