#!/bin/sh
#
# cid.sh - apply CMap to CID-Keyed font
#
# Copyright (C) 2000,2001 Taiji Yamada <taiji@aihara.co.jp>
# Copyright (C) 2001 gs-cjk project. All rights reserved.
# This software is provided under the BSD license. For full details,
# please see COPYING file.
#
# Acknowledgment:
# It is a pleasure to thank Hideyuki Suzuki <hideyuki@sat.t.u-tokyo.ac.jp>,
# Jerry Zhang <wenlongzhang@redflag-linux.com>,
# Chih-Wei Huang <cwhuang@linux.org.tw>, Yasuhiro Take <take@debian.org>,
# suzuki toshiya <mpsuzuki@hiroshima-u.ac.jp> and
# Masatake YAMATO <masata-y@is.aist-nara.ac.jp> for many precious suggestions
# and stimulating discussions about this work.
#
#ResourceDir=.
ResourceDir=`echo "pssystemparams /GenericResourceDir get =" | gsnd -q - `
#FontDir=$ResourceDir/Font
FontDir=`echo "pssystemparams /FontResourceDir get =" | gsnd -q - `
CIDFontDir=$ResourceDir/CIDFont
# unnecessary since GS 6.01
#fonts_dir=../fonts
#link_from=../Resource/Font
ListFile=./CIDFont.lst

[ -d $FontDir ] || mkdir $FontDir
[ -d $CIDFontDir ] || mkdir $CIDFontDir

case `basename $0` in
######################################################################
# Adobe CNS1
#
ac1*.sh)
if [ ! -f $ListFile ]; then # you can write entries in single quotes
FONTS='
'
else # otherwise, you can write entries in CIDFont.lst
FONTS=` \
  tr -s '	' ' ' < $ListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]CNS1/\1 /p' \
`
fi
[ -d $ResourceDir/ac14/CMap ] && CMAPS=`ls $ResourceDir/ac14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(CNS1)' *`
;;
######################################################################
# Adobe GB1
#
ag1*.sh)
if [ ! -f $ListFile ]; then # you can write entries in single quotes
FONTS='
'
else # otherwise, you can write entries in CIDFont.lst
FONTS=` \
  tr -s '	' ' ' < $ListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]GB1/\1 /p' \
`
fi
[ -d $ResourceDir/ag14/CMap ] && CMAPS=`ls $ResourceDir/ag14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(GB1)' *`
;;
######################################################################
# Adobe Japan1
#
aj1*.sh)
if [ ! -f $ListFile ]; then # you can write entries in single quotes
FONTS='
'
else # otherwise, you can write entries in CIDFont.lst
FONTS=` \
  tr -s '	' ' ' < $ListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Japan1/\1 /p' \
`
fi
[ -d $ResourceDir/aj14/CMap ] && CMAPS=`ls $ResourceDir/aj14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Japan1)' *`
;;
######################################################################
# Adobe Japan2
#
aj2*.sh)
if [ ! -f $ListFile ]; then # you can write entries in single quotes
FONTS='
'
else # otherwise, you can write entries in CIDFont.lst
FONTS=` \
  tr -s '	' ' ' < $ListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Japan2/\1 /p' \
`
fi
[ -d $ResourceDir/aj20/CMap ] && CMAPS=`ls $ResourceDir/aj20/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Japan2)' *`
;;
######################################################################
# Adobe Korea1
#
ak1*.sh)
if [ ! -f $ListFile ]; then # you can write entries in single quotes
FONTS='
'
else # otherwise, you can write entries in CIDFont.lst
FONTS=` \
  tr -s '	' ' ' < $ListFile \
  | sed -n 's/#.*$//g;s/^ *\([^ ]*\) *Adobe[- ]Korea1/\1 /p' \
`
fi
[ -d $ResourceDir/ak12/CMap ] && CMAPS=`ls $ResourceDir/ak12/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Korea1)' *`
;;
*)
do_ordering_detection='yes'
;;
esac

[ -d $ResourceDir/ai0/CMap ] && CMAPS="$CMAPS "`ls $ResourceDir/ai0/CMap/` || CMAPS="$CMAPS "`cd $ResourceDir/CMap/; grep -l 'Ordering *(Identity)' *`

case $1 in
'install')
  if [ "$2" != '' ]; then
    shift
    FONTS=$*
  fi
  for font in $FONTS; do
    if [ ! -f $CIDFontDir/$font ]; then
      echo "$font not found in $CIDFontDir"; continue
    fi
    if [ "$do_ordering_detection" = 'yes' ]; then
      Ordering=`sed -n '
/^.*\/Ordering (.*) def/{
  s/^.*\/Ordering (\(.*\)) def/\1/p
  q
}' $CIDFontDir/$font`
      case $Ordering in
      'CNS1')	##################################################
[ -d $ResourceDir/ac14/CMap ] && CMAPS=`ls $ResourceDir/ac14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(CNS1)' *`
        ;;
      'GB1')	##################################################
[ -d $ResourceDir/ag14/CMap ] && CMAPS=`ls $ResourceDir/ag14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(GB1)' *`
        ;;
      'Japan1')	##################################################
[ -d $ResourceDir/aj14/CMap ] && CMAPS=`ls $ResourceDir/aj14/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Japan1)' *`
        ;;
      'Japan2')	##################################################
[ -d $ResourceDir/aj20/CMap ] && CMAPS=`ls $ResourceDir/aj20/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Japan2)' *`
        ;;
      'Korea1')	##################################################
[ -d $ResourceDir/ak12/CMap ] && CMAPS=`ls $ResourceDir/ak12/CMap/` || CMAPS=`cd $ResourceDir/CMap/; grep -l 'Ordering *(Korea1)' *`
        ;;
      *)
        echo "$font can't detect Ordering"; continue
        ;;
      esac
[ -d $ResourceDir/ai0/CMap ] && CMAPS="$CMAPS "`ls $ResourceDir/ai0/CMap/` || CMAPS="$CMAPS "`cd $ResourceDir/CMap/; grep -l 'Ordering *(Identity)' *`
    fi
    for cmap in $CMAPS; do
      case $cmap in
      'Roman'|'Katakana'|'Hiragana'|'Hankaku'|'WP-Symbol')
        to='.'
        ;;
      *)
        to='-'
        ;;
      esac
      [ ! -f $FontDir/$font$to$cmap ] && cat <<EOF > $FontDir/$font$to$cmap && echo "+$font$to$cmap"
%!PS-Adobe-3.0 Resource-Font
%%DocumentNeededResources: $cmap (CMap)
%%IncludeResource: $cmap (CMap)
%%BeginResource: Font ($font$to$cmap)
/$font$to$cmap
/$cmap /CMap findresource
[/$font /CIDFont findresource]
composefont pop
%%EndResource
%%EOF
EOF
      # unnecessary since GS 6.01
      #[ ! -f $fonts_dir/$font$to$cmap ] && (cd $fonts_dir; ln -s $link_from/$font$to$cmap .)
    done
  done
  ;;
'uninstall')
  if [ "$2" != '' ]; then
    shift
    FONTS=$*
  fi
  if [ "$do_ordering_detection" = 'yes' ]; then
    CMAPS=`cd $ResourceDir/CMap/; grep -l 'Registry *(Adobe)' *`
  fi
  for font in $FONTS; do
    for cmap in $CMAPS; do
      case $cmap in
      'Roman'|'Katakana'|'Hiragana'|'Hankaku'|'WP-Symbol')
        #to='.'
        to=[.-]
        ;;
      *)
        to='-'
        ;;
      esac
      # unnecessary since GS 6.01
      #[ -f $fonts_dir/$font$to$cmap ] && rm -f $fonts_dir/$font$to$cmap
      [ -f $FontDir/$font$to$cmap ] && rm -f $FontDir/$font$to$cmap && echo "-$font$to$cmap"
    done
  done
  ;;
*)
  cat <<EOF
usage: $0 'install|uninstall' [Font...]
please edit the lines FONTS=... of me, before use without args.
EOF
  exit 1
  ;;
esac
exit 0
