# label.tcl --
#
# This demonstration script creates a toplevel window containing
# several label widgets.
#
# RCS: @(#) $Id: label.tcl,v 1.1 1999/03/31 15:08:35 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .label
catch {destroy $w}
toplevel $w
wm title $w "Label Demonstration"
wm iconname $w "label"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left -text [langSel \
"Five labels are displayed below: three textual ones on the left, and a bitmap label and a text label on the right.  Labels are pretty boring because you can't do anything with them." \
"$B2<$K$O(B 5$B$D$N%i%Y%k$,I=<($5$l$F$$$^$9!#:8B&$K$O%F%-%9%H%i%Y%k$,(B 3$B$D$"$j!"1&B&$K$O%S%C%H%^%C%W%i%Y%k$H%F%-%9%H%i%Y%k$,$"$j$^$9!#%i%Y%k$H$$$&$N$O$"$^$jLLGr$$$b$N$G$O$"$j$^$;$s!#$J$<$J$iD/$a$k0J302?$b$G$-$J$$$+$i$G$9!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

frame $w.left
frame $w.right
pack $w.left $w.right -side left -expand yes -padx 10 -pady 10 -fill both

label $w.left.l1 -text [langSel "First label" "$B:G=i$N%i%Y%k(B"]
label $w.left.l2 -text [langSel "Second label, raised" "2 $BHVL\!#$A$g$C$HIb$->e$,$i$;$F$_$^$7$?(B"] -relief raised
label $w.left.l3 -text [langSel "Third label, sunken" "3 $BHVL\!#D@$s$G$$$^$9(B"] -relief sunken
pack $w.left.l1 $w.left.l2 $w.left.l3 -side top -expand yes -pady 2 -anchor w

label $w.right.bitmap -borderwidth 2 -relief sunken \
	-bitmap @[file join $tk_library demos.jp images face.bmp]
label $w.right.caption -text [langSel "Tcl/Tk Proprietor" "Tcl/Tk $B=jM-<T(B"]
pack $w.right.bitmap $w.right.caption -side top
