# menu.tcl --
#
# This demonstration script creates a window with a bunch of menus
# and cascaded menus using menubars.
#
# RCS: @(#) $Id: menu.tcl,v 1.1 1999/03/31 15:08:36 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .menu
catch {destroy $w}
toplevel $w
wm title $w "Menu Demonstration"
wm iconname $w "menu"
positionWindow $w

label $w.msg -font $font -wraplength 4i -justify left 
if {$tcl_platform(platform) == "macintosh"} {
    $w.msg configure -text [langSel \
"This window contains a menubar with cascaded menus.  You can invoke entries with an accelerator by typing Command+x, where \"x\" is the character next to the command key symbol. The rightmost menu can be torn off into a palette by dragging outside of its bounds and releasing the mouse." \
"$B$3$N%&%#%s%I%&$K$O%+%9%1!<%I%a%K%e!<$r$b$D%a%K%e!<%P!<$,$"$j$^$9!#(BCommand-X $B$N%"%/%;%i%l!<%?$r;H$C$F%(%s%H%j$r<B9T$9$k$3$H$,$G$-$^$9!#(BX$B$O%a%K%e!<$N%3%^%s%I%-!<5-9f$N2#$KI=<($5$l$F$$$kJ8;z$G$9!#1&C<$N%a%K%e!<$O$=$NOH$N30B&$r%I%i%C%0$7$F%^%&%9$rN%$9$3$H$K$h$j@Z$jN%$7$F%Q%l%C%H$K$9$k$3$H$,$G$-$^$9!#(B"]
} else {
    $w.msg configure -text [langSel \
"This window contains a menubar with cascaded menus.  You can post a menu from the keyboard by typing Alt+x, where \"x\" is the character underlined on the menu.  You can then traverse among the menus using the arrow keys.  When a menu is posted, you can invoke the current entry by typing space, or you can invoke any entry by typing its underlined character.  If a menu entry has an accelerator, you can invoke the entry without posting the menu just by typing the accelerator. The rightmost menu can be torn off into a palette by selecting the first item in the menu." \
"$B$3$N%&%#%s%I%&$K$O%+%9%1!<%I%a%K%e!<$r$b$D%a%K%e!<%P!<$,$"$j$^$9!#(BAlt-X $B$rF~NO$9$k$H!"(BX$B$,%a%K%e!<$K%"%s%@!<%i%$%sIU$-$GI=<($5$l$F$$$kJ8;z$J$i$P!"%-!<%\!<%I$+$i$N;XDj$,$G$-$^$9!#Lp0u%-!<$G%a%K%e!<$N%H%i%P!<%9$b2DG=$G$9!#%a%K%e!<$,;XDj$5$l$?:]$K$O!"%9%Z!<%9%-!<$G<B9T$9$k$3$H$,$G$-$^$9!#$"$k$$$O!"%"%s%@!<%i%$%sIU$-$NJ8;z$rF~NO$9$k$3$H$G$b<B9T$G$-$^$9!#%a%K%e!<$N%(%s%H%j$,%"%/%;%i%l!<%?$r;}$C$F$$$k>l9g$O!"$=$N%"%/%;%i%l!<%?$rF~NO$9$k$3$H$G%a%K%e!<$r;XDj$9$k$3$H$J$7$K<B9T$9$k$3$H$,$G$-$^$9!#1&C<$N%a%K%e!<$O:G=i$N9`L\$rA*Br$9$k$3$H$K$h$j@Z$jN%$7$F%Q%l%C%H$K$9$k$3$H$,$G$-$^$9!#(B"]
}
pack $w.msg -side top

set menustatus "    "
frame $w.statusBar
label $w.statusBar.label -textvariable menustatus -relief sunken -bd 1 -font "Helvetica10" -anchor w
pack $w.statusBar.label -side left -padx 2 -expand yes -fill both
pack $w.statusBar -side bottom -fill x -pady 2

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

menu $w.menu -tearoff 0

set m $w.menu.file
menu $m -tearoff 0
$w.menu add cascade -label [langSel "File" "$B%U%!%$%k(B(F)"] -menu $m -underline [langSel 0 5]
$m add command -label [langSel "Open..." "$B3+$/(B ..."] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"Open...\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$B3+$/(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add command -label [langSel "New" "$B?75,(B"] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"New\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$B?75,(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add command -label [langSel "Save" "$BJ]B8(B"] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"Save\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$BJ]B8(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add command -label [langSel "Save As..." "$BL>A0$rIU$1$FJ]B8(B ..."] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"Save As...\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$BL>A0$rIU$1$FJ]B8(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add separator
$m add command -label [langSel "Print Setup..." "$B0u:~@_Dj(B ..."] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"Print Setup...\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$B0u:~@_Dj(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add command -label [langSel "Print..." "$B0u:~(B ..."] -command {
    error [langSel \
"this is just a demo: no action has been defined for the \"Print...\" entry" \
"$B$3$l$O!"%G%b$G$9$N$G(B\"$B0u:~(B ...\"$B$KBP$9$k%"%/%7%g%s$ODj5A$5$l$F$$$^$;$s!#(B"]
}
$m add separator
$m add command -label [langSel "Dismiss Menus Demo" "$B%a%K%e!<%G%bCf;_(B"] -command "destroy $w"

set m $w.menu.basic
$w.menu add cascade -label [langSel "Basic" "$B4pK\(B(B)"] -menu $m -underline [langSel 0 3]
menu $m -tearoff 0
$m add command -label [langSel "Long entry that does nothing" "$B2?$b$7$J$$D9$$%(%s%H%j(B"]
if {$tcl_platform(platform) == "macintosh"} {
    set modifier Command
} elseif {$tcl_platform(platform) == "windows"} {
    set modifier Control
} else {
    set modifier Meta
}
foreach i {A B C D E F} {
    $m add command -label [langSel "Print letter \"$i\"" "$BJ8;z(B\"$i\"$B$r0u;z(B"] -underline [langSel 14 3] \
	    -accelerator Meta+$i -command "puts $i" -accelerator $modifier+$i
    bind $w <$modifier-[string tolower $i]> "puts $i"
}

set m $w.menu.cascade
$w.menu add cascade -label [langSel "Cascades" "$B%+%9%1!<%I(B(C)"] -menu $m -underline [langSel 0 6]
menu $m -tearoff 0
$m add command -label [langSel "Print hello" "$B$3$s$K$A$O(B(H)"] \
	-command {puts stdout "Hello"} -accelerator $modifier+H -underline [langSel 6 6]
bind $w <$modifier-h> {puts stdout "Hello"}
$m add command -label [langSel "Print goodbye" "$B$5$h$&$J$i(B(G)"] -command {\
    puts stdout "Goodbye"} -accelerator $modifier+G -underline [langSel 6 6]
bind $w <$modifier-g> {puts stdout "Goodbye"}
$m add cascade -label [langSel "Check buttons" "$B%A%'%C%/%\%?%s(B(C)"] \
	-menu $w.menu.cascade.check -underline [langSel 0 8]
$m add cascade -label [langSel "Radio buttons" "$B%i%8%*%\%?%s(B(R)"] \
	-menu $w.menu.cascade.radio -underline [langSel 0 7]

set m $w.menu.cascade.check
menu $m -tearoff 0
$m add check -label [langSel "Oil checked" "$B%*%$%kE@8!(B"] -variable oil
$m add check -label [langSel "Transmission checked" "$B%H%i%s%9%_%C%7%g%sE@8!(B"] -variable trans
$m add check -label [langSel "Brakes checked" "$B%V%l!<%-E@8!(B"] -variable brakes
$m add check -label [langSel "Lights checked" "$B%i%$%HE@8!(B"] -variable lights
$m add separator
$m add command -label [langSel "Show current values" "$B8=:_$NCM$rI=<((B"] \
    -command "showVars $w.menu.cascade.dialog oil trans brakes lights"
$m invoke 1
$m invoke 3

set m $w.menu.cascade.radio
menu $m -tearoff 0
$m add radio -label [langSel "10 point" "10 $B%]%$%s%H(B"] -variable pointSize -value 10
$m add radio -label [langSel "14 point" "14 $B%]%$%s%H(B"] -variable pointSize -value 14
$m add radio -label [langSel "18 point" "18 $B%]%$%s%H(B"] -variable pointSize -value 18
$m add radio -label [langSel "24 point" "24 $B%]%$%s%H(B"] -variable pointSize -value 24
$m add radio -label [langSel " point" "32 $B%]%$%s%H(B"] -variable pointSize -value 32
$m add sep
$m add radio -label [langSel "Roman" "$B%m!<%^%s(B"] -variable style -value roman
$m add radio -label [langSel "Bold" "$B%\!<%k%I(B"] -variable style -value bold
$m add radio -label [langSel "Italic" "$B%$%?%j%C%/(B"] -variable style -value italic
$m add sep
$m add command -label [langSel "Show current values" "$B8=:_$NCM$rI=<((B"] \
	-command "showVars $w.menu.cascade.dialog pointSize style"
$m invoke 1
$m invoke 7

set m $w.menu.icon
$w.menu add cascade -label [langSel "Icons" "$B%"%$%3%s(B(I)"] -menu $m -underline [langSel 0 5]
menu $m -tearoff 0
$m add command \
    -bitmap @[file join $tk_library demos.jp images pattern.bmp] \
    -hidemargin 1 \
    -command {
	tk_dialog .pattern {Bitmap Menu Entry} [langSel \
{The menu entry you invoked displays a bitmap rather than a text string.  Other than this, it is just like any other menu entry.} \
{$B:#$"$J$?$,A*Br$7$?%a%K%e!<$N9`L\$O%F%-%9%H$G$O$J$/%S%C%H%^%C%W$rI=<($7$F$$$^$7$?!#$=$l0J30$NE@$G$OB>$N%a%K%e!<9`L\$HJQ$o$j$^$;$s!#(B}] \
{} 0 [langSel OK $BN;2r(B]
}
foreach i {info questhead error} {
    $m add command -bitmap $i -command "puts {You invoked the $i bitmap}" -hidemargin 1
}
$m entryconfigure 2 -columnbreak 1

set m $w.menu.more
$w.menu add cascade -label [langSel "More" "$B$=$NB>(B(M)"] -menu $m -underline [langSel 0 4]
menu $m -tearoff 0
foreach i [langSel \
{{An entry} {Another entry} {Does nothing} {Does almost nothing} {Make life meaningful}} \
{{$B%(%s%H%j(B} {$BJL$N%(%s%H%j(B} {$B2?$b$7$J$$(B} {$B$[$H$s$I2?$b$7$J$$(B} {$B?M@8$r0U5A$"$k$b$N$K(B}}] {
    $m add command -label $i -command [list puts "You invoked \"$i\""]
}

set m $w.menu.colors
$w.menu add cascade -label [langSel "Colors" "$B?'(B(O)"] -menu $m -underline [langSel 1 2]
menu $m
foreach i [langSel {red orange yellow green blue} {{$B@V(B red} {$B\t(B orange} {$B2+(B yellow} {$BNP(B green} {$B@D(B blue}}] {
    $m add command -label [lindex $i 0] -background [lindex $i end] \
	    -command [list puts "You invoked \"$i\""]
}

$w configure -menu $w.menu

bind Menu <<MenuSelect>> {
    global $menustatus
    if {[catch {%W entrycget active -label} label]} {
	set label "    "
    }
    set menustatus $label
    update idletasks
}
