# radio.tcl --
#
# This demonstration script creates a toplevel window containing
# several radiobutton widgets.
#
# RCS: @(#) $Id: radio.tcl,v 1.1 1999/03/31 15:08:38 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .radio
catch {destroy $w}
toplevel $w
wm title $w "Radiobutton Demonstration"
wm iconname $w "radio"
positionWindow $w
label $w.msg -font $font -wraplength 5i -justify left -text [langSel \
"Two groups of radiobuttons are displayed below.  If you click on a button then the button will become selected exclusively among all the buttons in its group.  A Tcl variable is associated with each group to indicate which of the group's buttons is selected.  Click the \"See Variables\" button to see the current values of the variables." \
"$B2<$K$O(B 2$B$D$N%i%8%*%\%?%s%0%k!<%W$,I=<($5$l$F$$$^$9!#%\%?%s$r%/%j%C%/$9$k$H!"$=$N%\%?%s$@$1$,$=$N%0%k!<%W$NCf$GA*Br$5$l$^$9!#3F%0%k!<%W$KBP$7$F$=$N%0%k!<%W$NCf$N$I$N%\%?%s$,A*Br$5$l$F$$$k$+$r<($9JQ?t$,3d$jEv$F$i$l$F$$$^$9!#8=:_$NJQ?t$NCM$r8+$k$K$O!VJQ?t;2>H!W%\%?%s$r%/%j%C%/$7$F$/$@$5$$!#(B"]
pack $w.msg -side top

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
button $w.buttons.vars -text [langSel "See Variables" "$BJQ?t;2>H(B"]  \
	-command "showVars $w.dialog size color"
pack $w.buttons.dismiss $w.buttons.code $w.buttons.vars -side left -expand 1

frame $w.left
frame $w.right
pack $w.left $w.right -side left -expand yes  -pady .5c -padx .5c

foreach i {10 12 18 24} {
    radiobutton $w.left.b$i -text [langSel "Point Size $i" "$B%]%$%s%H%5%$%:(B $i"] -variable size \
	    -relief flat -value $i
    pack $w.left.b$i  -side top -pady 2 -anchor w
}

foreach color [langSel {Red Green Blue Yellow Orange Purple} {$B@V(B(Red) $BNP(B(Green) $B@D(B(Blue) $B2+(B(Yellow) $B\t(B(Orange) $B;g(B(Purple)}] {
    if {[info commands kstring] != {}} {
	set lower [kstring tolower $color]
    } else {
	set lower [string tolower $color]
    }
    radiobutton $w.right.$lower -text $color -variable color \
	    -relief flat -value $lower
    pack $w.right.$lower -side top -pady 2 -anchor w
}
