#ifndef MD5_H

/* GLOBAL.H - RSAREFタイプと定数 */

/* もしコンパイラがファンクション引数プロトタイピングをサポートするな
  ら、PROTOTYPES はそれに設定されるべきである。
それがCコンパイラフラグによってまだ定義されていなかったならば、デフォ
ルトで PROTOTYPES は 0 になる。
 */
#ifndef PROTOTYPES
#define PROTOTYPES 0
#endif

/* POINTERは一般的なポインタタイプを定義する */
typedef unsigned char *POINTER;

/* UINT2 は2バイトワードを定義する */
typedef unsigned short int UINT2;

/* UINT4 は4バイトワードを定義する */
typedef unsigned long int UINT4;

/* PROTO_LIST は、PROTOTYPES の定義上に応じて定義される。
PROTOTYPES を使っていれば、PROTO_LIST はリストを返す、さもなくば、
それは空のリストを返す。
 */
#if PROTOTYPES
#define PROTO_LIST(list) list
#else
#define PROTO_LIST(list) ()
#endif

/* MD5.H - MD5C.Cのためのヘッダファイル
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

もしそれそれが、このソフトウェアまたはこの機能に言及するか、または参照
を付けているすべての素材の「RSA Data Security, Inc. MD5 メッセージダイ
ジェストアルゴリズム」と確認されるならば、このソフトウェアをコピーし、
用いるためにライセンスは与えられる。

ライセンスは、同じく得られたワークに言及するか、もしくは参照を付け
る材料全てにおいて「RSA Data Security, Inc. MD5 メッセージダイジェスト
アルゴリズムから得られた」ように、そのような作品が確認される限り、派生
した仕事を行って、使うことを認められる。

RSA Data Security, Inc. は、どのような特定の目的のためにでも、このソフ
トウェアの市販性またはこのソフトウェアの適合性についての説明は行なわな
い。それは、あらゆる表現や暗黙の保証なしで "ありのまま" 供給される。

これらの通知は、このドキュメンテーションおよび／またはソフトウェアのど
のような部分のどのようなコピーにおいても保たれねばならない。
 */

/* MD5 前後関係. */
typedef struct {
  UINT4 state[4];                                   /* state (ABCD) */
  UINT4 count[2];        /* ビット数、モジュロ2＾64 (lsb first) */
  unsigned char buffer[64];                         /* input buffer */
} MD5_CTX;

void MD5Init PROTO_LIST ((MD5_CTX *));
void MD5Update PROTO_LIST
  ((MD5_CTX *, unsigned char *, unsigned int));
void MD5Final PROTO_LIST ((unsigned char [16], MD5_CTX *));

#endif
