#include "config.h"
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <fcntl.h>
#include <libgen.h>
#include <stdio.h>
//#define _GNU_SOURCE 1
//#define __USE_GNU 1
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <signal.h>
#include <limits.h>
#include <dirent.h>

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

#include "saphire.h"
#include "saphire_inner.h"

// p: 対象文字列文字列内のポインタ
// start:対象文字列の最初の位置 
// word: 検索文字列
static char* strstr_back(char* p, char* start, char* word, char* sname, int sline)
{
    int n = strlen(word);

    while(p >= start) {
        BOOL flg = TRUE;
        int i;
        for(i=-1; i>=-n; i--) {
            if(p[i] != word[n+i]) {
                flg = FALSE;
                break;
            }

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                return NULL;
            }
        }

        if(flg) {
            return p -n;
        }
        else {
            p--;
        }
    }

    return NULL;
}

static char* strcasestr_back(char* p, char* start, char* word, char* sname, int sline)
{
    int n = strlen(word);

    while(p >= start) {
        BOOL flg = TRUE;
        int i;
        for(i=-1; i>=-n; i--) {
            if(isascii(p[i]) && isascii(word[n+i])) {
                if(tolower(p[i]) != tolower(word[n+i])) {
                    flg = FALSE;
                    break;
                }
            }
            else {
                if(p[i] != word[n+i]) {
                    flg = FALSE;
                    break;
                }
            }

            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                return NULL;
            }
        }

        if(flg) {
            return p -n;
        }
        else {
            p--;
        }
    }

    return NULL;
}

static regex_t* get_reg(int* r, char* regex2, BOOL ignore_case, BOOL multiline, enum eKanjiCode code)
{
    regex_t* reg;
    if(ignore_case && multiline) 
        reg = hash_item(gRegexsIM, (char*)regex2);
    else if(ignore_case)
        reg = hash_item(gRegexsI, (char*)regex2);
    else if(multiline) 
        reg = hash_item(gRegexsM, (char*)regex2);
    else
        reg = hash_item(gRegexs, (char*)regex2);
        
    if(reg == NULL) {
        OnigEncoding enc;
        if(code == kUtf8) {
            enc = ONIG_ENCODING_UTF8;
        }
        else if(code == kEucjp) {
            enc = ONIG_ENCODING_EUC_JP;
        }
        else {
            enc = ONIG_ENCODING_SJIS;
        }

        if(ignore_case && multiline) {
            OnigErrorInfo err_info;
            *r = onig_new(&reg, regex2
                    , regex2 + strlen((char*)regex2)
                    , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE
                    , enc
                    //, ONIG_SYNTAX_RUBY
                    //, ONIG_SYNTAX_PERL_NG
                    , ONIG_SYNTAX_DEFAULT
                    , &err_info);

            if(*r == ONIG_NORMAL) {
                if(hash_count(gRegexsIM) == 30) {
                    hash_it* it = hash_loop_begin(gRegexsIM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsIM);
                }
                hash_put(gRegexsIM, (char*)regex2, reg);
            }
            else {
                onig_free(reg);
            }
        }
        else if(ignore_case) {
            OnigErrorInfo err_info;
            *r = onig_new(&reg, regex2
                    , regex2 + strlen((char*)regex2)
                    , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE
                    , enc
                    //, ONIG_SYNTAX_RUBY
                    //, ONIG_SYNTAX_PERL_NG
                    , ONIG_SYNTAX_DEFAULT
                    , &err_info);

            if(*r == ONIG_NORMAL) {
                if(hash_count(gRegexsI) == 30) {
                    hash_it* it = hash_loop_begin(gRegexsI);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsI);
                }
                hash_put(gRegexsI, (char*)regex2, reg);
            }
            else {
                onig_free(reg);
            }
        }
        else if(multiline) {
            OnigErrorInfo err_info;
            *r = onig_new(&reg, regex2
                    , regex2 + strlen((char*)regex2)
                    , ONIG_OPTION_DEFAULT|ONIG_OPTION_MULTILINE
                    , enc
                    //, ONIG_SYNTAX_RUBY
                    //, ONIG_SYNTAX_PERL_NG
                    , ONIG_SYNTAX_DEFAULT
                    , &err_info);

            if(*r == ONIG_NORMAL) {
                if(hash_count(gRegexsM) == 30) {
                    hash_it* it = hash_loop_begin(gRegexsM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsM);
                }
                hash_put(gRegexsM, (char*)regex2, reg);
            }
            else {
                onig_free(reg);
            }
        }
        else {
            OnigErrorInfo err_info;
            *r = onig_new(&reg, regex2
                    , regex2 + strlen((char*)regex2)
                    , ONIG_OPTION_DEFAULT
                    , enc
                    //, ONIG_SYNTAX_RUBY
                    //, ONIG_SYNTAX_PERL_NG
                    , ONIG_SYNTAX_DEFAULT
                    , &err_info);

            if(*r == ONIG_NORMAL) {
                if(hash_count(gRegexs) == 30) {
                    hash_it* it = hash_loop_begin(gRegexs);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexs);
                }
                hash_put(gRegexs, (char*)regex2, reg);
            }
            else {
                onig_free(reg);
            }
        }
    }
    else {
        *r = ONIG_NORMAL;
    }

    return reg;
}

// 出力をCTRL-Cで止めたいので、この関数を経由して書き込む
// 戻り値 FALSE --> CTRL-Cで止められた
// 戻り値 TRUE --> 正常終了
BOOL statment_tree_internal_commands_write_nextout(sWFd* nextout, char* str)
{
    return sWFd_push_back(nextout, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin(sRFd* nextin, string_obj* str)
{
    return sRFd_read_all(nextin, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_preserve(sRFd* nextin, string_obj* str)
{
    return sRFd_read_all_preserve(nextin, str);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline(sRFd* nextin, string_obj* str, enum eLineField lf)
{
    return sRFd_read_oneline(nextin, str, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_num(sRFd* nextin, string_obj* str, int line_num, enum eLineField lf)
{
    return sRFd_read_oneline_num(nextin, str, line_num, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_preserve(sRFd* nextin, string_obj* str, enum eLineField lf)
{
    return sRFd_read_oneline_preserve(nextin, str, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_oneline_preserve_num(sRFd* nextin, string_obj* str, int line_num, enum eLineField lf)
{
    return sRFd_read_oneline_preserve_num(nextin, str, line_num, lf);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_onechar_num(sRFd* nextin, string_obj* str, int char_num)
{
    return sRFd_read_onechar_num(nextin, str, char_num);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して読み込む
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_read_nextin_onechar_preserve_num(sRFd* nextin, string_obj* str, int char_num)
{
    return sRFd_read_onechar_preserve_num(nextin, str, char_num);
}

// 出力をCTRL-Cで止めたいので、この関数を経由して配列の区切りを出力
// 戻り値 -1 --> CTRL-Cで止められた
// 戻り値 0 --> 正常終了
// 戻り値 1 --> EOF
int statment_tree_internal_commands_write_lf(sWFd* nextout, enum eLineField lf)
{
    if(lf == kLF) {
        return statment_tree_internal_commands_write_nextout(nextout, "\n"); 
    } else if(lf == kCR) {
        return statment_tree_internal_commands_write_nextout(nextout, "\r"); 
    } else if(lf == kCRLF) {
        return statment_tree_internal_commands_write_nextout(nextout, "\r\n"); 
    } else {
        return statment_tree_internal_commands_write_nextout(nextout, "\a"); 
    }
}

static void str_cut(enum eKanjiCode code, char* mbs, int termsize, SPACE char* dest_mbs, int dest_byte)
{
    if(code == kUtf8) {
        wchar_t* wcs;
        wchar_t* wcs_tmp;
        int i;

        wcs = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        wcs_tmp = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        if(mbstowcs(wcs, mbs, (termsize+1)*MB_CUR_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*MB_CUR_MAX);
        }

        for(i=0; i<wcslen(wcs); i++) {
            wcs_tmp[i] = wcs[i];
            wcs_tmp[i+1] = 0;

            if(wcswidth(wcs_tmp, wcslen(wcs_tmp)) > termsize) {
                wcs_tmp[i] = 0;
                break;
            }
        }

        wcstombs(dest_mbs, wcs_tmp, dest_byte);

        FREE(wcs);
        FREE(wcs_tmp);
    }
    else {
        int n;
        BOOL kanji = FALSE;
        for(n=0; n<termsize && n<dest_byte-1; n++) {
            if(!kanji && is_kanji(code, mbs[n])) {
                kanji = TRUE;
            }
            else {
                kanji = FALSE;
            }

            dest_mbs[n] = mbs[n];
        }
        
        if(kanji)
            dest_mbs[n-1] = 0;
        else
            dest_mbs[n] = 0;
    }
}

///////////////////////////////////////////////////
/// statment_tree_internal_commandsの子関数
///////////////////////////////////////////////////
static BOOL statment_tree_internal_commands_selector(string_obj* output, string_obj* result, int* scrolltop, int* cursor, enum eKanjiCode code, BOOL multiple, enum eLineField lf, char* sname, int sline)
{
    if(gRunningOnTerminal == FALSE) {
        err_msg("selector: not running on terminal", sname, sline);
        return FALSE;
    }
    if(isatty(0) == 0 || isatty(1) == 0) {
        err_msg("selector: stdin or stdout is not a tty", sname, sline);
        return FALSE;
    }
    if(tcgetpgrp(0) != getpgid(0)) {
        err_msg("selector: not forground process group", sname, sline);
        return FALSE;
    }

#if !defined(__FREEBSD__)
    msave_screen();
#endif
    msave_ttysettings();
    minitscr();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* lines = VECTOR_NEW(100);

    /// 入力ごとにlinesに格納 ///
    string_obj* tmp = STRING_NEW("");
    char* p = string_c_str(output);
    while(*p) {
        if(gKitutukiSigInt) {
            err_msg("selector: signal interrupt", sname, sline);
            gKitutukiSigInt = FALSE;
            int i;
            for(i=0; i<vector_size(lines); i++) {
                string_delete(vector_item(lines, i));
            }
            vector_delete(lines);
            string_delete(tmp);
            return FALSE;
        }

        if(is_line_field2(lf, p)) {
            if(lf == kCRLF) {
                p+=2;
            }
            else {
                p++;
            }
            vector_add(lines, tmp);
            tmp = STRING_NEW("");
        }
        else {
            string_push_back2(tmp, *p++);
        }
    }
    vector_add(lines, tmp);

    static int line_num = -1;
    if(line_num != -1 && vector_size(lines) != line_num) {
        *scrolltop = 0;
        *cursor = 0;
    }
    line_num = vector_size(lines);

    int* markfiles = MALLOC(sizeof(int)*vector_size(lines));
    memset(markfiles, 0, sizeof(int)*vector_size(lines));

    if(vector_size(lines) > 0) {
        while(1) {
            /// 描写 ///
            mclear();
            int n = *scrolltop;
            int y = 0;
            while(y < maxy && n < vector_size(lines)) {
                int attrs = 0;
                if(n == *cursor) {
                    attrs |= kCAReverse;
                }
                else if(markfiles[n]) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char* line = string_c_str(vector_item(lines, n));

                if(str_termlen(code, line) <= maxx) {
                    mmvprintw(y, 0, "%s", line);
                    y++;
                }
                else {
                    char* p = line;
                    while(p < line + strlen(line)) {
                        char one_line[BUFSIZ];
                        str_cut(code, p, maxx, one_line, BUFSIZ);
                        mmvprintw(y, 0, "%s", one_line);
                        y++;

                        p+=strlen(one_line);
                    }
                }

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                (*cursor)++;
            }
            else if(key == 16 || key == KEY_UP) {
                (*cursor)--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                (*cursor) += (maxy / 2);
            }
            else if(key == 21 || key == KEY_PPAGE) {
                (*cursor) -= (maxy /2);
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                mendwin();
#if !defined(__FREEBSD__)
                mrestore_screen();
#endif
                mrestore_ttysettings();
                int i;
                for(i=0; i<vector_size(lines); i++) {
                    string_delete(vector_item(lines, i));
                }
                vector_delete(lines);
                FREE(markfiles);
                return FALSE;
            }
            else if(key == 'a' && multiple) {
                int i;
                for(i=0; i<vector_size(lines); i++) {
                    markfiles[i] = !markfiles[i];
                }
            }
            else if(key == ' ' && multiple) {
                markfiles[*cursor] = !markfiles[*cursor];
                (*cursor)++;
            }
            else if(key == 10 || key == 13) {
                if(multiple) {
                    BOOL flg_mark = FALSE;
                    int k;
                    for(k=0; k<vector_size(lines); k++) {
                        if(markfiles[k]) {
                            string_push_back(result
                                , string_c_str(vector_item(lines, k)));

                            if(lf == kCR) {
                                string_push_back(result, "\r");
                            } else if(lf == kLF) {
                                string_push_back(result, "\n");
                            } else if(lf == kCRLF) {
                                string_push_back(result, "\r\n");
                            } else {
                                string_push_back(result, "\a");
                            }

                            flg_mark = TRUE;
                        }
                    }

                    if(flg_mark) {
                        string_chomp(result);
                    }
                    else {
                        string_put(result 
                            , string_c_str(vector_item(lines, *cursor)));
                    }
                }
                else {
                    string_put(result 
                        , string_c_str(vector_item(lines, *cursor)));
                }
                break;
            }

            /// 修正 ///
            if(*cursor < 0) {
                *cursor = 0;
            }
            if(*cursor >= vector_size(lines)) {
                *cursor = vector_size(lines)-1;
            }
            if(*cursor >= n) {
                *scrolltop = n;
            }
            if(*cursor < *scrolltop) {
                int i = *cursor;
                int width_sum = 0;
                while(width_sum < maxy) {
                    char* line = string_c_str(vector_item(lines, i));
                    int width = str_termlen(code, line) / maxx + 1;
                    width_sum += width;
                    i--;
                    if(i < 0) {
                        i = -2;
                        break;
                    }
                }
                
                *scrolltop = i +2;
            }
        }
    }

//mclear();
//mrefresh();
    mendwin();
#if !defined(__FREEBSD__)
    mrestore_screen();
#endif
    mrestore_ttysettings();

    int i;
    for(i=0; i<vector_size(lines); i++) {
        string_delete(vector_item(lines, i));
    }
    vector_delete(lines);
    FREE(markfiles);
    return TRUE;
}

static BOOL statment_tree_internal_commands_p(string_obj* output, int* result, int* scrolltop, int* cursor, enum eKanjiCode code, enum eLineField lf, char* sname, int sline)
{
    if(gRunningOnTerminal == FALSE) {
        err_msg("selector: not running on terminal", sname, sline);
        return FALSE;
    }
    if(isatty(0) == 0 || isatty(1) == 0) {
        err_msg("p: stdin or stdout is not a tty", sname, sline);
        return FALSE;
    }
    if(tcgetpgrp(0) != getpgid(0)) {
        err_msg("p: not forground process group", sname, sline);
        return FALSE;
    }
#if !defined(__FREEBSD__)
    msave_screen();
#endif
    msave_ttysettings();
    minitscr();

    const int maxx = mgetmaxx();
    const int maxy = mgetmaxy();

    vector_obj* lines = VECTOR_NEW(100);

    /// 入力ごとにlinesに格納 ///
    string_obj* tmp = STRING_NEW("");
    char* p = string_c_str(output);
    while(*p) {
        if(gKitutukiSigInt) {
            err_msg("p: signal interrupt", sname, sline);
            gKitutukiSigInt = FALSE;
            int i;
            for(i=0; i<vector_size(lines); i++) {
                string_delete(vector_item(lines, i));
            }
            vector_delete(lines);
            string_delete(tmp);
            return FALSE;
        }
        if(is_line_field2(lf, p)) {
            if(lf == kCRLF) {
                p+=2;
            }
            else {
                p++;
            }
            vector_add(lines, tmp);
            tmp = STRING_NEW("");
        }
        else {
            string_push_back2(tmp, *p++);
        }
    }
    vector_add(lines, tmp);

    static int line_num = -1;
    if(line_num != -1 && vector_size(lines) != line_num) {
        *scrolltop = 0;
        *cursor = 0;
    }
    line_num = vector_size(lines);

    int* markfiles = MALLOC(sizeof(int)*vector_size(lines));
    memset(markfiles, 0, sizeof(int)*vector_size(lines));

    if(vector_size(lines) > 0) {
        while(1) {
            /// 描写 ///
            mclear();
            int n = *scrolltop;
            int y = 0;
            while(y < maxy && n < vector_size(lines)) {
                int attrs = 0;
                if(n == *cursor) {
                    attrs |= kCAReverse;
                }
                else if(markfiles[n]) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char* line = string_c_str(vector_item(lines, n));

                if(str_termlen(code, line) <= maxx) {
                    mmvprintw(y, 0, "%s", line);
                    y++;
                }
                else {
                    char* p = line;
                    while(p < line + strlen(line)) {
                        char one_line[BUFSIZ];
                        str_cut(code, p, maxx, one_line, BUFSIZ);
                        mmvprintw(y, 0, "%s", one_line);
                        y++;

                        p+=strlen(one_line);
                    }
                }

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                (*cursor)++;
            }
            else if(key == 16 || key == KEY_UP) {
                (*cursor)--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                (*cursor) += (maxy / 2);
            }
            else if(key == 21 || key == KEY_PPAGE) {
                (*cursor) -= (maxy /2);
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == 'q' || key == 3 || key == 27 || key == 7) {
                break;
            }
            else if(key == ' ' || key == 10 || key == 13) 
            {
                *result = 0;
                break;
            }

            /// 修正 ///
            if(*cursor < 0) {
                *cursor = 0;
            }
            if(*cursor >= vector_size(lines)) {
                *cursor = vector_size(lines)-1;
            }
            if(*cursor >= n) {
                *scrolltop = n;
            }
            if(*cursor < *scrolltop) {
                int i = *cursor;
                int width_sum = 0;
                while(width_sum < maxy) {
                    char* line = string_c_str(vector_item(lines, i));
                    int width = str_termlen(code, line) / maxx + 1;
                    width_sum += width;
                    i--;
                    if(i < 0) {
                        i = -2;
                        break;
                    }
                }
                
                *scrolltop = i +2;
            }
        }
    }

//mclear();
//mrefresh();
    mendwin();
#if !defined(__FREEBSD__)
    mrestore_screen();
#endif
    mrestore_ttysettings();

    int i;
    for(i=0; i<vector_size(lines); i++) {
        string_delete(vector_item(lines, i));
    }
    vector_delete(lines);
    FREE(markfiles);
    return TRUE;
}

static BOOL statment_tree_internal_commands_test(int* rcode, vector_obj* argv, string_obj* input, char* sname, int sline)
{
    char* arg_last = string_c_str(
            vector_item(argv, vector_size(argv)-1));

    if(strcmp(arg_last, "]") != 0) {
        err_msg("test: missing ]", sname, sline);
        return FALSE;
    }
    else {
        BOOL reverse = FALSE;

        char* arg1;
        char* arg2;
        char* arg3;
        char* arg4;
        char* arg5;

        if(vector_size(argv) > 1) {
            arg1 = string_c_str(vector_item(argv, 1));
            if(strcmp(arg1, "!") == 0) {
                reverse = TRUE;
            }
        }

        if(reverse) {
            if(input) {
                if(vector_size(argv) == 4) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(input);
                }
                else if(vector_size(argv) == 5) {
                    arg1 = string_c_str(input);
                    arg2 = string_c_str(vector_item(argv, 2));
                    arg3 = string_c_str(vector_item(argv, 3));
                }
                else {
                    return TRUE;
                    /*
                    err_msg("test: invalid [ arguments 1", sname, sline);
                    return FALSE;
                    */
                }
            }
            else {
                if(vector_size(argv) == 5) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(vector_item(argv, 3));
                }
                else if(vector_size(argv) == 6) {
                    arg1 = string_c_str(vector_item(argv, 2));
                    arg2 = string_c_str(vector_item(argv, 3));
                    arg3 = string_c_str(vector_item(argv, 4));
                }
                else {
                    return TRUE;
                    /*
                    err_msg("test: invalid [ arguments 2", sname, sline);
                    return FALSE;
                    */
                }
            }
        }
        else {
            if(input) {
                if(vector_size(argv) == 3) {
                    arg2 = string_c_str(input);
                }
                else if(vector_size(argv) == 4) {
                    arg1 = string_c_str(input);
                    arg2 = string_c_str(vector_item(argv, 1));
                    arg3 = string_c_str(vector_item(argv, 2));
                }
                else {
                    return TRUE;
                }
            }
            else {
                if(vector_size(argv) == 4) {
                    arg2 = string_c_str(vector_item(argv, 2));
                }
                else if(vector_size(argv) == 5) {
                    arg2 = string_c_str(vector_item(argv, 2));
                    arg3 = string_c_str(vector_item(argv, 3));
                }
                else {
                    return TRUE;
                }
            }
        }
        if(!reverse && (vector_size(argv) + (input ? 1: 0)) == 4 
            || reverse && (vector_size(argv) + (input ? 1:0)) == 5) 
        {
            /// string ///
            if(strcmp(arg1, "-n") == 0) {
                if(!reverse && strcmp(arg2, "") != 0) {
                    *rcode = 0;
                }
                else if(reverse && ! strcmp(arg2, "") != 0) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg1, "-z") == 0) {
                if(!reverse && strcmp(arg2, "") == 0) {
                    *rcode = 0;
                }
                else if(reverse && ! strcmp(arg2, "") == 0) {
                    *rcode = 0;
                }
            }
            
            else {
                /// file type ///
                struct stat stat_;
                if(stat(arg2, &stat_) == 0) {
                    if(strcmp(arg1, "-b") == 0) {
                        if(!reverse && S_ISBLK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse && ! S_ISBLK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-c") == 0) {
                        if(!reverse && S_ISCHR(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISCHR(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-d") == 0) {
                        if(!reverse && S_ISDIR(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse && ! S_ISDIR(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-f") == 0) {
                        if(!reverse && S_ISREG(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISREG(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-h") == 0 
                             || strcmp(arg1, "-L") == 0) 
                    {
                        if(!reverse && S_ISLNK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISLNK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-p") == 0) {
                        if(!reverse && S_ISFIFO(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! S_ISFIFO(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-S") == 0) {
                        if(!reverse && S_ISSOCK(stat_.st_mode)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && S_ISSOCK(stat_.st_mode)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-t") == 0) {
                    }
                    /// permission ///
                    else if(strcmp(arg1, "-g") == 0) {
                        if(!reverse && (stat_.st_mode & S_ISGID)) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(stat_.st_mode & S_ISGID)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-k") == 0) {
#if defined(S_ISTXT)
                        if(!reverse && (stat_.st_mode & S_ISTXT)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISVTX)
                        if(!reverse && (stat_.st_mode & S_ISVTX)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISTXT)
                        else if(reverse && !(stat_.st_mode & S_ISTXT)) {
                            *rcode = 0;
                        }
#endif
#if defined(S_ISVTX)
                        else if(reverse && !(stat_.st_mode & S_ISVTX)) {
                            *rcode = 0;
                        }
#endif
                    }
                    else if(strcmp(arg1, "-u") == 0) {
                        if(!reverse 
                            && (stat_.st_mode & S_ISUID)) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && ! (stat_.st_mode & S_ISUID)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-r") == 0) {
                        if(!reverse 
                            && access(arg2, R_OK) == 0) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(access(arg2, R_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-w") == 0) {
                        if(!reverse 
                            && access(arg2, W_OK) == 0) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && ! ( access(arg2, W_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-x") == 0) {
                        if(!reverse && access(arg2, X_OK) == 0) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !(access(arg2, X_OK) == 0)) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-O") == 0) {
                        if(!reverse && stat_.st_uid == getuid()) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && !stat_.st_uid == getuid()) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-G") == 0) {
                        if(!reverse && stat_.st_gid == getgid()) {
                            *rcode = 0;
                        }
                        else if(reverse 
                            && ! stat_.st_gid == getgid()) 
                        {
                            *rcode = 0;
                        }
                    }
                    else if(strcmp(arg1, "-e") == 0) {
                        if(!reverse) *rcode = 0;
                    }
                    else if(strcmp(arg1, "-s") == 0) {
                        if(!reverse && stat_.st_size > 0) {
                            *rcode = 0;
                        }
                        else if(reverse && !(stat_.st_size > 0)) {
                            *rcode = 0;
                        }
                    }
                    else {
                        return TRUE;
                        /*
                        err_msg("test: invalid [ arguments 5", sname, sline);
                        return FALSE;
                        */
                    }
                }
                else {
                    if(reverse) *rcode = 0;
                }
            }
        }
        else if(!reverse && (vector_size(argv) + (input ? 1:0)) == 5 
            || reverse && (vector_size(argv) + (input ? 1:0)) == 6) 
        {
            /// string ///
            if(strcmp(arg2, "=") == 0) {
                if(!reverse && strcmp(arg1, arg3) == 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) == 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "!=") == 0) {
                if(!reverse && strcmp(arg1, arg3) != 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) != 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-slt") == 0) {
                if(!reverse && strcmp(arg1, arg3) < 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) >= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sgt") == 0) {
                if(!reverse && strcmp(arg1, arg3) > 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) <= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sle") == 0) {
                if(!reverse && strcmp(arg1, arg3) <= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) > 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sge") == 0) {
                if(!reverse && strcmp(arg1, arg3) >= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcmp(arg1, arg3) < 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-silt") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) < 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) >= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sigt") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) > 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) <= 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sile") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) <= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) > 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-sige") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) >= 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) < 0)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "=i") == 0) {
                if(!reverse && strcasecmp(arg1, arg3) == 0) {
                    *rcode = 0;
                }
                else if(reverse && !(strcasecmp(arg1, arg3) == 0)) {
                    *rcode = 0;
                }
            }
            else if(arg2[0] == '-' && arg2[1] == 'r' && arg2[2] == 'e')
            {
                char* target = arg1;
                char* regex = arg3;

                OnigEncoding enc;
                if(gKanjiCode == kUtf8) {
                    enc = ONIG_ENCODING_UTF8;
                }
                else if(gKanjiCode == kEucjp) {
                    enc = ONIG_ENCODING_EUC_JP;
                }
                else {
                    enc = ONIG_ENCODING_SJIS;
                }

                char* regex2 = regex;

                int r;
                regex_t* reg;

                if(strcmp(arg2, "-reim") == 0 
                            || strcmp(arg2, "-remi") == 0) 
                {
                    reg = hash_item(gRegexsIM, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE | ONIG_OPTION_MULTILINE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsIM) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsIM);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsIM);
                            }
                            hash_put(gRegexsIM, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else if(strcmp(arg2, "-rei") == 0) {
                    reg = hash_item(gRegexsI, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT | ONIG_OPTION_IGNORECASE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsI) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsI);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsI);
                            }
                            hash_put(gRegexsI, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else if(strcmp(arg2, "-rem") == 0) {
                    reg = hash_item(gRegexsM, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT|ONIG_OPTION_MULTILINE
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexsM) == 30) {
                                hash_it* it = hash_loop_begin(gRegexsM);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexsM);
                            }
                            hash_put(gRegexsM, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                else {
                    reg = hash_item(gRegexs, regex);

                    if(reg == NULL) {
                        OnigErrorInfo err_info;
                        r = onig_new(&reg, regex2
                            , regex2 + strlen((char*)regex2)
                            , ONIG_OPTION_DEFAULT
                            , enc
                            , ONIG_SYNTAX_DEFAULT
                            //, ONIG_SYNTAX_RUBY
                            //, ONIG_SYNTAX_PERL_NG
                            , &err_info);

                        if(r == ONIG_NORMAL) {
                            if(hash_count(gRegexs) == 30) {
                                hash_it* it = hash_loop_begin(gRegexs);
                                while(it != NULL) {
                                    onig_free(hash_loop_item(it));
                                    it = hash_loop_next(it);
                                }
                                hash_clear(gRegexs);
                            }
                            hash_put(gRegexs, regex, reg);
                        }
                        else {
                            onig_free(reg);
                        }
                    }
                    else {
                        r = ONIG_NORMAL;
                    }
                }
                

                if(r == ONIG_NORMAL) {
                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, target
                       , target + strlen(target)
                       , target, target + strlen(target)
                       , region, ONIG_OPTION_NONE);

                    if(region->num_regs > 0) {
                        if(region->beg[0] > 0) {
                            /// マッチした文字列の前 ///
                            char* tmp = MALLOC(region->beg[0] + 1);

                            memcpy(tmp, target, region->beg[0]);
                            tmp[region->beg[0]] = 0;

                            saphire_set_local_var("PREMATCH", tmp);

                            FREE(tmp);
                        }
                        else {
                            saphire_set_local_var("PREMATCH", "");
                        }

                        /// マッチした文字列 ///
                        char* tmp = MALLOC(
                                region->end[0]-region->beg[0] + 1);

                        memcpy(tmp, target + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        saphire_set_local_var("MATCH", tmp);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        const int n = strlen(target)-region->end[0];
                        if(n > 0) {
                            char* tmp = MALLOC(n + 1);

                            memcpy(tmp, target + region->end[0], n);

                            tmp[n] = 0;

                            saphire_set_local_var("POSTMATCH", tmp);

                            FREE(tmp);
                        }
                        else {
                            saphire_set_local_var("POSTMATCH", "");
                        }
                    }
                    if(r2 >= 0) {
                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp =
                                MALLOC(region->end[i]-region->beg[i]+1);

                            memcpy(tmp, target + region->beg[i]
                             , region->end[i]-region->beg[i]);

                            tmp[region->end[i]
                                - region->beg[i]] = 0;

                            char name[16];
                            snprintf(name, 16, "%d", i);

                            saphire_set_local_var(name, tmp);

                            FREE(tmp);
                        }
                    }

                    if(r2 >= 0 && !reverse || r2 < 0 && reverse) {
                        *rcode = 0;
                    }

                    onig_region_free(region, 1);
                }
                else {
                    err_msg("test: invalid regex", sname, sline);

                    return FALSE;
                }
            }

            /// number ///
            else if(strcmp(arg2, "-eq") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l == r) {
                    *rcode = 0;
                }
                else if(reverse && !(l == r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-ne") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l != r) {
                    *rcode = 0;
                }
                else if(reverse && !(l != r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-lt") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l < r) {
                    *rcode = 0;
                }
                else if(reverse && !(l < r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-le") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l <= r) {
                    *rcode = 0;
                }
                else if(reverse && !(l <= r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-gt") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l > r) {
                    *rcode = 0;
                }
                else if(reverse && !(l > r)) {
                    *rcode = 0;
                }
            }
            else if(strcmp(arg2, "-ge") == 0) {
                int l = atoi(arg1);
                int r = atoi(arg3);

                if(!reverse && l >= r) {
                    *rcode = 0;
                }
                else if(reverse && !(l >= r)) {
                    *rcode = 0;
                }
            }

            /// file ///
            else if(strcmp(arg2, "-nt") == 0) {
                struct stat lstat_;
                struct stat rstat_;

                if(lstat(arg1, &lstat_) == 0) {
                    if(lstat(arg3, &rstat_) == 0) {
                        if(!reverse 
                            && lstat_.st_mtime > rstat_.st_mtime) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && !(lstat_.st_mtime > rstat_.st_mtime)) 
                        {
                            *rcode = 0;
                        }
                    }
                }
            }
            else if(strcmp(arg2, "-ot") == 0) {
                struct stat lstat_;
                struct stat rstat_;

                if(lstat(arg1, &lstat_) == 0) {
                    if(lstat(arg3, &rstat_) == 0) {
                        if(!reverse 
                            && lstat_.st_mtime < rstat_.st_mtime) 
                        {
                            *rcode = 0;
                        }
                        else if(reverse 
                          && !(lstat_.st_mtime < rstat_.st_mtime)) 
                        {
                            *rcode = 0;
                        }
                    }
                }
            }
            else if(strcmp(arg2, "-ef") == 0) {
            }
            else {
                return TRUE;
                //err_msg("test: invalid [ arguments 6", sname, sline);
                //return FALSE;
            }
        }
    }

    return TRUE;
}

static BOOL statment_tree_internal_commands_match(char* str2
  , UChar* regex2, int* rcode, sWFd* nextout, BOOL print, BOOL line_field
  , BOOL line_num, int n, string_obj* field, BOOL line_oriented
  , int* match_count, BOOL ignore_case, BOOL multiline, char* sname, int sline, enum eKanjiCode code , enum eLineField lf)
{
    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        int position;
        position = 0;

        OnigRegion* region = onig_region_new();
        int r2 = onig_search(reg, str2
           , str2 + strlen(str2)
           , str2 + position, str2 + strlen(str2)
           //, region, ONIG_OPTION_CAPTURE_GROUP);
           , region, ONIG_OPTION_NONE);

        if(r2 >= 0) {
            *rcode = 0;
            (*match_count)++;

            if(region->num_regs > 0) {
                /// マッチした文字列の前 ///
                if(region->beg[0] > 0) {
                    char* tmp = MALLOC(region->beg[0] + 1);

                    memcpy(tmp, str2, region->beg[0]);
                    tmp[region->beg[0]] = 0;

                    saphire_set_local_var("PREMATCH", tmp);

                    FREE(tmp);

                }
                else {
                    saphire_set_local_var("PREMATCH", "");
                }

                /// マッチした文字列 ///
                char* tmp = MALLOC(
                        region->end[0]-region->beg[0] + 1);

                memcpy(tmp, str2 + region->beg[0]
                 , region->end[0]-region->beg[0]);

                tmp[region->end[0]
                    - region->beg[0]] = 0;

                saphire_set_local_var("MATCH", tmp);

                FREE(tmp);


                /// マッチした文字列の後 ///
                const int n = strlen(str2)-region->end[0];
                if(n > 0) {
                    char* tmp = MALLOC(n + 1);

                    memcpy(tmp, str2 + region->end[0], n);

                    tmp[n] = 0;

                    saphire_set_local_var("POSTMATCH", tmp);

                    FREE(tmp);
                }
                else {
                    saphire_set_local_var("POSTMATCH", "");
                }
            }

            /// マッチしたグループ化文字列 ///
            int i;
            for (i=1; i<region->num_regs; i++) {
                char* tmp = MALLOC(
                    region->end[i]-region->beg[i] + 1);

                memcpy(tmp, str2 + region->beg[i]
                 , region->end[i]-region->beg[i]);

                tmp[region->end[i]
                    - region->beg[i]] = 0;

                char name[16];
                snprintf(name, 16, "%d", i);

                saphire_set_local_var(name, tmp);

                FREE(tmp);
            }

            if(print) {
                if(line_oriented) {
                    if(line_num) {
                        char num[128];
                        snprintf(num, 128, "%d:", n);
                        if(!statment_tree_internal_commands_write_nextout(nextout, num))
                        {
                            return FALSE;
                        }
                    }
                    
                    if(!statment_tree_internal_commands_write_nextout(nextout, str2) )
                    {
                        return FALSE;
                    }
                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                        {
                            return FALSE;
                        }
                    }
                }
                else if(region->num_regs == 1) {
                    if(line_num) {
                        char num[128];
                        snprintf(num, 128, "%d:", n);
                        if(!statment_tree_internal_commands_write_nextout(nextout, num) )
                        {
                            return FALSE;
                        }
                    }
                    
                    char* match = saphire_get_local_var("MATCH");

                    if(match) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, match) )
                        {
                            return FALSE;
                        }
                    }
                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                        {
                            return FALSE;
                        }
                    }
                }
                else if(region->num_regs > 1) {
                    int i;
                    for(i=1; i<region->num_regs; i++) {
                        char name[16];
                        snprintf(name, 16, "%d", i);

                        char* match = saphire_get_local_var(name);

                        if(match) {
                            if(line_num) {
                                char num[128];
                                snprintf(num, 128, "%d:", n);
                                if(!statment_tree_internal_commands_write_nextout(nextout, num)) 
                                {
                                    return FALSE;
                                }
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, match)) 
                            {
                                return FALSE;
                            }
                        }
                        if(i==region->num_regs-1) {
                            if(line_field) {
                                if(!statment_tree_internal_commands_write_lf(nextout, lf) )
                                {
                                    return FALSE;
                                }
                            }
                        }
                        else {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(field))) 
                            {
                                return FALSE;
                            }
                        }
                    }
                }
            }
        }

        onig_region_free(region, 1);
    }
    else {
        err_msg("match: invalid regex", sname, sline);

        return FALSE;
    }

    return TRUE;
}

// sort_funにデータを渡すためのグローバル変数
static sBlock* gSortBlock;
static sWFd* gSortNextOut;
static sRFd* gSortNextIn;
static int gSortNextErr;
static vector_obj* gSortParentBlocks;
static int* gSortReturn;
static BOOL gSortEnableReturn;
static int* gSortBreak;
static BOOL gSortEnableBreak;
static vector_obj* gSortEnvs;
static sObject* gSortObject;
static sFunction* gSortRunningFun;
static sClass* gSortRunningClass;

static int sort_fun(void* left, void* right)
{
    char* left2 = string_c_str(left);
    char* right2 = string_c_str(right);

    string_obj* str = STRING_NEW("");
    string_push_back(str, left2);
    string_push_back(str, right2);

    sRFd* nextin = RFD_NEW(-1);
    sRFd_set_buffer(nextin, string_c_str(str));
    string_delete(str);

    int rcode = run(gSortBlock->mStatments
            , "sort_fun", gSortNextOut
            , nextin, gSortNextErr
            , gSortReturn, gSortEnableReturn, gSortBreak, gSortEnableBreak,  gSortParentBlocks, FALSE, gSortEnvs, gSortObject, gSortRunningFun, gSortRunningClass);

    sRFd_delete(nextin);

    if(rcode < 0) {
        return -1;
    }

    return rcode == 0;
}

BOOL statment_tree_internal_commands_printf(char* format, vector_obj* strings, sWFd* nextout, BOOL line_field, char* sname, int sline, enum eLineField lf)
{
    char* p = format;

    int strings_num = 0;
    string_obj* output = STRING_NEW("");

    while(*p) {
        if(gKitutukiSigInt) {
            gKitutukiSigInt = FALSE;
            string_delete(output);
            return FALSE;
        }

        if(*p == '%') {
            p++;

            if(*p == '%') {
                string_push_back(output, "%");
            }
            else {
                /// オプション ///
                string_obj* aformat = STRING_NEW("%");

                while(*p) {
                    if(*p == 'd' || *p == 'i' || *p == 'o' || *p == 'u' || *p == 'x' || *p == 'X' || *p == 'c') 
                    {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), atoi(string_c_str(arg)));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else if(*p == 'e' || *p == 'E' || *p == 'f' || *p == 'F' || *p == 'g' || *p == 'G' || *p == 'a' || *p == 'A')
                    {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), atof(string_c_str(arg)));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else if(*p == 's') {
                        string_push_back2(aformat, *p++);

                        if(strings_num < vector_size(strings)) {
                            string_obj* arg = vector_item(strings, strings_num++);
                            char* buf;
                            asprintf(&buf, string_c_str(aformat), string_c_str(arg));
                            string_put(aformat, "");
                            string_push_back(output, buf);
                            free(buf);
                        }
                        else {
                            string_put(aformat, "");
                        }

                        break;
                    }
                    else {
                        string_push_back2(aformat, *p++);
                    }
                }

                string_delete(aformat);
            }
        }
        else {
            string_push_back2(output, *p++);
        }
    }

    if(line_field) {
        if(lf == kCR) {
            string_push_back2(output, '\r');
        } else if(lf == kCRLF) {
            string_push_back(output, "\r\n");
        } else if(lf == kLF) {
            string_push_back2(output, '\n');
        } else {
            string_push_back2(output, '\a');
        }
    }

    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(output)))
    {
        string_delete(output);
        return FALSE;
    }

    string_delete(output);
    return TRUE;
}
#define OVECCOUNT 30


BOOL statment_tree_internal_commands_scan(vector_obj* argv, string_obj* field, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, vector_obj* blocks, int nexterr, vector_obj* parent_blocks, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, enum eKanjiCode code, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class, enum eLineField lf)
{
    int match_count = 0;

    char* regex;

    string_obj* str;
    if(input) {
        if(vector_size(argv) == 2) {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin
                    (nextin, str); 
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                string_delete(str);
                return FALSE;
            }
            regex = string_c_str(vector_item(argv, 1));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
            regex = string_c_str(vector_item(argv, 2));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }

    char* str2 = string_c_str(str);
    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        char* p = str2;
        int region_end_before = 0;
        if(vector_size(blocks) == 0) {
            while(1) {
                if(gKitutukiSigInt) {
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , p
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 >= 0) {
                    match_count++;

                    /// グループ化無し ///
                    if(region->num_regs == 1) {
                        /// マッチした文字列 ///
                        int n = region->end[0] - region->beg[0];

                        char* tmp = MALLOC(n +2 + 1);
                        memcpy(tmp, str2 + region->beg[0], n);
                        if(lf == kCR) {
                            tmp[n] = '\r';
                            tmp[n+1] = 0;
                        } else if(lf == kCRLF) {
                            tmp[n] = '\r';
                            tmp[n+1] = '\n';
                            tmp[n+2] = 0;
                        } else if(lf == kLF) {
                            tmp[n] = '\n';
                            tmp[n+1] = 0;
                        } else {
                            tmp[n] = '\a';
                            tmp[n+1] = 0;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            FREE(tmp);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                    /// グループ化 ///
                    else {
                        string_obj* out = STRING_NEW("");

                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                            tmp[region->end[i] - region->beg[i]] = 0;

                            string_push_back(out, tmp);

                            FREE(tmp);

                            if(i==region->num_regs-1) {
                                if(lf == kCR) {
                                    string_push_back(out, "\r");
                                } else if(lf == kCRLF) {
                                    string_push_back(out, "\r\n");
                                } else if(lf == kLF) {
                                    string_push_back(out, "\n");
                                } else {
                                    string_push_back(out, "\a");
                                }
                            }
                            else {
                                string_push_back(out, string_c_str(field));
                            }
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return FALSE;
                        }

                        string_delete(out);
                    }

                    p = str2 + region->end[0];
                }
                else {
                    p = p + 1;
                }

                onig_region_free(region, 1);

                /// 最後まで行ったら抜ける ///
                if(p >= str2 + strlen(str2)) {
                    break;
                }
            }
        }
        else {
            while(1) {
                if(gKitutukiSigInt) {
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , p
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 >= 0) {
                    match_count++;

                    /// グループ化無し ///
                    if(region->num_regs == 1) {
                        /// マッチした文字列 ///
                        int n = region->end[0] - region->beg[0];

                        char* tmp = MALLOC(n +2 + 1);
                        memcpy(tmp, str2 + region->beg[0], n);
                        if(lf == kCR) {
                            tmp[n] = '\r';
                            tmp[n+1] = 0;
                        } else if(lf == kCRLF) {
                            tmp[n] = '\r';
                            tmp[n+1] = '\n';
                            tmp[n+2] = 0;
                        } else if(lf == kLF) {
                            tmp[n] = '\n';
                            tmp[n+1] = 0;
                        } else {
                            tmp[n] = '\a';
                            tmp[n+1] = 0;
                        }

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        sRFd* nextin2 = RFD_NEW2(-1, tmp);
                        *rcode = run(statments
                                , fname, nextout
                                , nextin2, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                        sRFd_delete(nextin2);

                        FREE(fname);

                        if(enable_break && *break_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(enable_return && *return_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                    /// グループ化 ///
                    else {
                        string_obj* out = STRING_NEW("");

                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                            tmp[region->end[i] - region->beg[i]] = 0;

                            string_push_back(out, tmp);

                            FREE(tmp);

                            if(i==region->num_regs-1) {
                                if(lf == kCR) {
                                    string_push_back(out, "\r");
                                } else if(lf == kCRLF) {
                                    string_push_back(out, "\r\n");
                                } else if(lf == kLF) {
                                    string_push_back(out, "\n");
                                } else {
                                    string_push_back(out, "\a");
                                }
                            }
                            else {
                                string_push_back(out, string_c_str(field));
                            }

                        }

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;
                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(out));
                        *rcode = run(statments
                                , fname, nextout
                                , nextin2, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                        sRFd_delete(nextin2);

                        FREE(fname);

                        if(enable_break && *break_) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return TRUE;
                        }
                        else if(enable_return && *return_) {
                            onig_region_free(region, 1);
                            string_delete(out);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(str);
                            string_delete(out);
                            return FALSE;
                        }

                        string_delete(out);
                    }

                    p = str2 + region->end[0];
                }
                else {
                    p = p + 1;
                }

                onig_region_free(region, 1);

                /// 最後まで行ったら抜ける ///
                if(p >= str2 + strlen(str2)) {
                    break;
                }
            }
        }
    }
    else {
        err_msg("match: invalid regex", sname, sline);

        string_delete(str);
        return FALSE;
    } 

    char buf[256];
    snprintf(buf, 256, "%d", match_count);
    saphire_set_local_var("MATCH_COUNT", buf);

    if(match_count > 0) {
        *rcode = 0;
    }

    string_delete(str);
    return TRUE;
}

BOOL statment_tree_internal_commands_scan_oneline(vector_obj* argv, string_obj* field, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, vector_obj* blocks, int nexterr, vector_obj* parent_blocks, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, enum eKanjiCode code, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class, enum eLineField lf)
{
    int match_count = 0;

    char* regex;

    string_obj* str;
    if(input) {
        if(vector_size(argv) == 2) {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin
                    (nextin, str); 
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                string_delete(str);
                return FALSE;
            }
            regex = string_c_str(vector_item(argv, 1));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
            regex = string_c_str(vector_item(argv, 2));
        }
        else {
            err_msg("invalid match arguments", sname, sline);
            return FALSE;
        }
    }

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    sRFd* nextin2 = RFD_NEW(-1);
    sRFd_set_buffer(nextin2, string_c_str(str));
    string_delete(str);

    if(r == ONIG_NORMAL) {
        while(1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin2, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                sRFd_delete(nextin2);
                return FALSE;
            }
            else if(result == 1) {
                string_delete(str);
                break;
            }

            char* str2 = string_c_str(str);
                    
            char* p = string_c_str(str);
            int region_end_before = 0;
            if(vector_size(blocks) == 0) {
                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        string_delete(str);
                        sRFd_delete(nextin2);
                        return FALSE;
                    }

                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, str2
                       , str2 + strlen(str2)
                       , p
                       , str2 + strlen(str2)
                       , region, ONIG_OPTION_NONE);

                    if(r2 >= 0) {
                        match_count++;

                        /// グループ化無し ///
                        if(region->num_regs == 1) {
                            /// マッチした文字列 ///
                            int n = region->end[0] - region->beg[0];

                            char* tmp = MALLOC(n +2 + 1);
                            memcpy(tmp, str2 + region->beg[0], n);
                            if(lf == kCR) {
                                tmp[n] = '\r';
                                tmp[n+1] = 0;
                            } else if(lf == kCRLF) {
                                tmp[n] = '\r';
                                tmp[n+1] = '\n';
                                tmp[n+2] = 0;
                            } else if(lf == kLF) {
                                tmp[n] = '\n';
                                tmp[n+1] = 0;
                            } else {
                                tmp[n] = '\a';
                                tmp[n+1] = 0;
                            }


                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                err_msg("signal interrupt", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            FREE(tmp);
                        }
                        /// グループ化 ///
                        else {
                            string_obj* out = STRING_NEW("");

                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                                tmp[region->end[i] - region->beg[i]] = 0;

                                string_push_back(out, tmp);

                                FREE(tmp);

                                if(i==region->num_regs-1) {
                                    if(lf == kCR) {
                                        string_push_back(out, "\r");
                                    } else if(lf == kCRLF) {
                                        string_push_back(out, "\r\n");
                                    } else if(lf == kLF) {
                                        string_push_back(out, "\n");
                                    } else {
                                        string_push_back(out, "\a");
                                    }
                                }
                                else {
                                    string_push_back(out, string_c_str(field));
                                }
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }

                            string_delete(out);
                        }

                        p = str2 + region->end[0];
                    }
                    else {
                        p = p + 1;
                    }

                    onig_region_free(region, 1);

                    /// 最後まで行ったら抜ける ///
                    if(p >= str2 + strlen(str2)) {
                        break;
                    }
                }
            }
            else {
                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        string_delete(str);
                        sRFd_delete(nextin2);
                        return FALSE;
                    }

                    OnigRegion* region = onig_region_new();
                    int r2 = onig_search(reg, str2
                       , str2 + strlen(str2)
                       , p
                       , str2 + strlen(str2)
                       , region, ONIG_OPTION_NONE);

                    if(r2 >= 0) {
                        match_count++;

                        /// グループ化無し ///
                        if(region->num_regs == 1) {
                            /// マッチした文字列 ///
                            int n = region->end[0] - region->beg[0];

                            char* tmp = MALLOC(n +2 + 1);
                            memcpy(tmp, str2 + region->beg[0], n);
                            if(lf == kCR) {
                                tmp[n] = '\r';
                                tmp[n+1] = 0;
                            } else if(lf == kCRLF) {
                                tmp[n] = '\r';
                                tmp[n+1] = '\n';
                                tmp[n+2] = 0;
                            } else if(lf == kLF) {
                                tmp[n] = '\n';
                                tmp[n+1] = 0;
                            } else {
                                tmp[n] = '\a';
                                tmp[n+1] = 0;
                            }

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(statments
                                    , fname, nextout
                                    , nextin3, nexterr
                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                            FREE(fname);
                            sRFd_delete(nextin3);

                            if(enable_break && *break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(enable_return && *return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                        /// グループ化 ///
                        else {
                            string_obj* out = STRING_NEW("");

                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i], region->end[i]-region->beg[i]);

                                tmp[region->end[i] - region->beg[i]] = 0;

                                string_push_back(out, tmp);

                                FREE(tmp);

                                if(i==region->num_regs-1) {
                                    if(lf == kCR) {
                                        string_push_back(out, "\r");
                                    } else if(lf == kCRLF) {
                                        string_push_back(out, "\r\n");
                                    } else if(lf == kLF) {
                                        string_push_back(out, "\n");
                                    } else {
                                        string_push_back(out, "\a");
                                    }
                                }
                                else {
                                    string_push_back(out, string_c_str(field));
                                }

                            }

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;
                            sRFd* nextin4 = RFD_NEW2(-1, string_c_str(out));
                            *rcode = run(statments
                                    , fname, nextout
                                    , nextin4, nexterr
                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                            FREE(fname);

                            sRFd_delete(nextin4);

                            if(enable_break && *break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(enable_return && *return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(out);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }

                            string_delete(out);
                        }

                        p = str2 + region->end[0];
                    }
                    else {
                        p = p + 1;
                    }

                    onig_region_free(region, 1);

                    /// 最後まで行ったら抜ける ///
                    if(p >= str2 + strlen(str2)) {
                        break;
                    }
                }
            }

            string_delete(str);
        }
    }
    else {
        err_msg("match: invalid regex", sname, sline);
        sRFd_delete(nextin2);

        return FALSE;
    } 
    sRFd_delete(nextin2);

    char buf[256];
    snprintf(buf, 256, "%d", match_count);
    saphire_set_local_var("MATCH_COUNT", buf);

    if(match_count > 0) {
        *rcode = 0;
    }

    return TRUE;
}

BOOL statment_tree_internal_commands_erase(BOOL global, vector_obj* argv, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, enum eKanjiCode code)
{
    char* regex;

    string_obj* str;
    if(input) {
        if(vector_size(argv) == 2) {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin
                    (nextin, str); 
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                return TRUE;
            }
            else if(ret < 0)
            {
                string_delete(str);
                return FALSE;
            }
            regex = string_c_str(vector_item(argv, 1));
        }
        else {
            err_msg("invalid erase arguments", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
            regex = string_c_str(vector_item(argv, 2));
        }
        else {
            err_msg("invalid erase arguments", sname, sline);
            return FALSE;
        }
    }

    char* str2 = string_c_str(str);
    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        char* p = str2;
        int match = -1;
        while(1) {
            if(gKitutukiSigInt) {
                gKitutukiSigInt = FALSE;
                string_delete(str);
                return FALSE;
            }
            OnigRegion* region = onig_region_new();

            int r2 = onig_search(reg, str2
               , str2 + strlen(str2)
               , p, p + strlen(p)
               , region, ONIG_OPTION_NONE);
            if(r2 >= 0) {
                *rcode = 0;

                if(region->num_regs == 1) {
                    /// マッチしなかった文字列 ///
                    int len = region->beg[0]-(p-str2)+ 1;
                    char* tmp = MALLOC(len);

                    memcpy(tmp, p, region->beg[0]-(p-str2));
                    tmp[len-1] = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                    {
                        err_msg("signal interrupt", sname, sline);
                        onig_region_free(region, 1);
                        string_delete(str);
                        FREE(tmp);
                        return FALSE;
                    }

                    FREE(tmp);
                }
                else {
                    /// マッチしなかった文字列 ///
                    int len = region->beg[0]-(p-str2)+ 1;
                    char* tmp = MALLOC(len);

                    memcpy(tmp, p, region->beg[0]-(p-str2));
                    tmp[len-1] = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                    {
                        err_msg("signal interrupt", sname, sline);
                        onig_region_free(region, 1);
                        string_delete(str);
                        FREE(tmp);
                        return FALSE;
                    }

                    FREE(tmp);


                    /// グループ化 ///
                    int i;
                    int p2 = region->beg[0];
                    for (i=1; i<region->num_regs; i++) {
                        if(region->beg[i] >= 0) {
                            int len = region->beg[i]-p2 + 1;
                            char* tmp = MALLOC(len);
                            memcpy(tmp, str2 + p2, region->beg[i]-p2);
                            tmp[len-1] = 0;

                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                err_msg("signal interrupt", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                FREE(tmp);
                                return FALSE;
                            }

                            FREE(tmp);

                            p2 = region->end[i];
                        }
                    }

                    len = region->end[0]-p2 + 1;
                    tmp = MALLOC(len);
                    memcpy(tmp, str2 + p2, region->end[0]-p2);
                    tmp[len-1] = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                    {
                        err_msg("signal interrupt", sname, sline);
                        onig_region_free(region, 1);
                        string_delete(str);
                        FREE(tmp);
                        return FALSE;
                    }

                    FREE(tmp);
                }

                match = region->end[0];
                p = str2 + region->end[0];
            }
            else {
                if(match >= 0) {
                    char* tmp = MALLOC(strlen(str2) - match + 1);
                    xstrncpy(tmp, str2 + match, strlen(str2) - match + 1);

                    if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                    {
                        err_msg("signal interrupt", sname, sline);
                        onig_region_free(region, 1);
                        string_delete(str);
                        FREE(tmp);
                        return FALSE;
                    }

                    FREE(tmp);
                }
                else {
                    if(!statment_tree_internal_commands_write_nextout(nextout, str2))
                    {
                        err_msg("signal interrupt", sname, sline);
                        onig_region_free(region, 1);
                        string_delete(str);
                        return FALSE;
                    }
                }

                onig_region_free(region, 1);
                break;
            }

            onig_region_free(region, 1);

            if(p >= str2 + strlen(str2)) {
                break;
            }

            if(!global) {
                /// マッチしなかった文字列 ///
                if(!statment_tree_internal_commands_write_nextout(nextout, p))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                break;
            }
        }
    }
    else {
        err_msg("erase: invalid regex", sname, sline);

        string_delete(str);
        return FALSE;
    } 

    string_delete(str);
    return TRUE;
}

BOOL statment_tree_internal_commands_erase_oneline(BOOL global, vector_obj* argv, BOOL input, sWFd* nextout, sRFd* nextin, int *rcode, BOOL ignore_case, BOOL multiline, char* sname, int sline, enum eKanjiCode code, enum eLineField lf)
{
    char* regex;

    string_obj* str;
    if(input) {
        if(vector_size(argv) == 2) {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin
                    (nextin, str); 
            if(ret == 1) {
                string_delete(str);
                *rcode = 1;
                return TRUE;
            }
            else if(ret < 0)
            {
                string_delete(str);
                return FALSE;
            }
            regex = string_c_str(vector_item(argv, 1));
        }
        else {
            err_msg("invalid erase arguments", sname, sline);
            return FALSE;
        }
    }
    else {
        if(vector_size(argv) == 3) {
            str = STRING_NEW(string_c_str(vector_item(argv, 1)));
            regex = string_c_str(vector_item(argv, 2));
        }
        else {
            err_msg("invalid erase arguments", sname, sline);
            return FALSE;
        }
    }

    char* regex2 = regex;

    sRFd* nextin2 = RFD_NEW(-1);
    sRFd_set_buffer(nextin2, string_c_str(str));
    string_delete(str);

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        while(1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin2, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                sRFd_delete(nextin2);
                return FALSE;
            }
            else if(result == 1) {
                string_delete(str);
                break;
            }

            char* str2 = string_c_str(str);
                    
            char* p = str2;
            int match = -1;
            while(1) {
                if(gKitutukiSigInt) {
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    sRFd_delete(nextin2);
                    return FALSE;
                }
                OnigRegion* region = onig_region_new();

                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , p, p + strlen(p)
                   , region, ONIG_OPTION_NONE);
//printf("region->num_regs %d\nr2 %d\n", region->num_regs, r2);
                if(r2 >= 0) {
                    *rcode = 0;

                    if(region->num_regs == 1) {
                        /// マッチしなかった文字列 ///
                        int len = region->beg[0]-(p-str2)+ 1;
                        char* tmp = MALLOC(len);

                        memcpy(tmp, p, region->beg[0]-(p-str2));
                        tmp[len-1] = 0;

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            FREE(tmp);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                    else {
                        /// マッチしなかった文字列 ///
                        int len = region->beg[0]-(p-str2)+ 1;
                        char* tmp = MALLOC(len);

                        memcpy(tmp, p, region->beg[0]-(p-str2));
                        tmp[len-1] = 0;

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            FREE(tmp);
                            return FALSE;
                        }

                        FREE(tmp);


                        /// グループ化 ///
                        int i;
                        int p2 = region->beg[0];
                        for (i=1; i<region->num_regs; i++) {
                            if(region->beg[i] >= 0) {
                                int len = region->beg[i]-p2 + 1;
                                char* tmp = MALLOC(len);
                                memcpy(tmp, str2 + p2, region->beg[i]-p2);
                                tmp[len-1] = 0;

                                if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    sRFd_delete(nextin2);
                                    FREE(tmp);
                                    return FALSE;
                                }

                                FREE(tmp);

                                p2 = region->end[i];
                            }
                        }

                        len = region->end[0]-p2 + 1;
                        tmp = MALLOC(len);
                        memcpy(tmp, str2 + p2, region->end[0]-p2);
                        tmp[len-1] = 0;

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            FREE(tmp);
                            return FALSE;
                        }
                            
                        FREE(tmp);
                    }

                    match = region->end[0];

                    if(str2 + region->end[0] == p) {
                        char tmp[2];
                        xstrncpy(tmp, p, 2);

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            return FALSE;
                        }

                        p++;
                    }
                    else {
                        p = str2 + region->end[0];
                    }
                }
                else {
                    if(match >= 0) {
                        char* tmp = MALLOC(strlen(str2) - match + 1);
                        xstrncpy(tmp, str2 + match, strlen(str2) - match + 1);

                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            FREE(tmp);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, str2))
                        {
                            err_msg("signal interrupt", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(str);
                            sRFd_delete(nextin2);
                            return FALSE;
                        }
                    }

                    onig_region_free(region, 1);
                    break;
                }

                onig_region_free(region, 1);

                if(p >= str2 + strlen(str2)) {
                    break;
                }

                if(!global) {
                    /// マッチしなかった文字列 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout, p))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        sRFd_delete(nextin2);
                        return FALSE;
                    }

                    break;
                }
            }

            string_delete(str);
        }
    }
    else {
        err_msg("erase: invalid regex", sname, sline);
        sRFd_delete(nextin2);

        return FALSE;
    } 
    sRFd_delete(nextin2);

    return TRUE;
}

BOOL statment_tree_internal_commands_split(sWFd* nextout, string_obj* field, BOOL multiline, BOOL ignore_case, char* sname, int sline, enum eKanjiCode code, enum eLineField lf, BOOL input, vector_obj* argv, sRFd* nextin, int* rcode, string_obj* field2)
{
    string_obj* line;
    char* regex;

    if(input) {
        if(vector_size(argv) <= 2) {
            if(vector_size(argv) == 2) {
                regex = string_c_str(vector_item(argv, 1));
            }
            else {
                regex = "\\s+";
            }

            line = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, line);
            if(ret < 0) {
                err_msg("interrupt b", sname, sline);
                string_delete(line);
                return FALSE;
            }
            else if(ret == 1) {
                string_delete(line);
                return TRUE;
            }
        }
    }
    else {
        if(vector_size(argv) >= 2) {
            if(vector_size(argv) == 2) {
                regex = "\\s+";
            }
            else {
                regex = string_c_str(vector_item(argv, 2));
            }

            line = STRING_NEW(string_c_str(vector_item(argv, 1)));
        }
    }

    string_chomp(line);
    char* p = string_c_str(line);
    
    char* regex2 = regex;
    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    if(r == ONIG_NORMAL) {
        string_obj* new_line = STRING_NEW("");
        while(*p) {
            if(gKitutukiSigInt) {
                err_msg("singal interrupt", sname, sline);
                string_delete(line);
                string_delete(new_line);
                return FALSE;
            }
            char* target = p;
            OnigRegion* region = onig_region_new();

            int r2 = onig_search(reg, string_c_str(line)
               , string_c_str(line) + string_length(line)
               , target, string_c_str(line) + string_length(line)
               , region, ONIG_OPTION_NONE);
               
            if(region->num_regs == 1) {
                if(region->beg[0] == -1 && region->end[0] == -1) {
                    string_put(new_line, p);
                    p = p + strlen(p);

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else if(region->beg[0] == region->end[0]) {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    if(size > 0) {
                        char* tmp = MALLOC(size + 1);
                        memcpy(tmp, target, size);
                        tmp[size] = 0;

                        string_put(new_line, tmp);
                        FREE(tmp);
                        string_push_back(new_line, string_c_str(field));
                        string_push_back2(new_line, *(target + size));

                        p = string_c_str(line) + region->end[0] +1;
                    }
                    else {
                        char* end_byte = str_kanjipos2pointer(code, target, 1);
                        char* tmp = MALLOC(end_byte-target + 1);
                        memcpy(tmp, target, end_byte-target);
                        tmp[end_byte-target] = 0;

                        string_put(new_line, string_c_str(field));
                        string_push_back(new_line, tmp);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        p = end_byte;
                    }

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    char* tmp = MALLOC(size + 1);
                    memcpy(tmp, target, size);
                    tmp[size] = 0;

                    string_put(new_line, tmp);

                    FREE(tmp);

                    /// マッチした文字列の後 ///
                    p = string_c_str(line) + region->end[0];

                    /// 出力 ///
                    string_push_back(new_line, string_c_str(field));
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
            }
            else if(region->num_regs > 1) {
                if(region->beg[0] == -1 && region->end[0] == -1) {
                    string_put(new_line, p);
                    p = p + strlen(p);

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else if(region->beg[0] == region->end[0]) {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    if(size > 0) {
                        char* tmp = MALLOC(size + 1);
                        memcpy(tmp, target, size);
                        tmp[size] = 0;

                        string_put(new_line, tmp);
                        FREE(tmp);
                        string_push_back(new_line, string_c_str(field));
                        string_push_back2(new_line, *(target + size));

                        p = string_c_str(line) + region->end[0] +1;
                    }
                    else {
                        char* end_byte = str_kanjipos2pointer(code, target, 1);
                        char* tmp = MALLOC(end_byte-target + 1);
                        memcpy(tmp, target, end_byte-target);
                        tmp[end_byte-target] = 0;

                        string_put(new_line, string_c_str(field));
                        string_push_back(new_line, tmp);

                        FREE(tmp);

                        /// マッチした文字列の後 ///
                        p = end_byte;
                    }

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }
                }
                else {
                    /// マッチした文字列の前 ///
                    int size = region->beg[0]-(target-string_c_str(line));
                    char* tmp = MALLOC(size + 1);
                    memcpy(tmp, target, size);
                    tmp[size] = 0;

                    string_put(new_line, tmp);

                    FREE(tmp);

                    /// マッチした文字列の後 ///
                    p = string_c_str(line) + region->end[0];

                    /// 出力 ///
                    string_push_back(new_line, string_c_str(field));
                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(new_line)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(line);
                        string_delete(new_line);
                        onig_region_free(region, 1);
                        return FALSE;
                    }

                    /// グループ化文字列出力 ///
                    int i;
                    for(i=1; i<region->num_regs; i++) {
                        int n = region->end[i]-region->beg[i] + strlen(string_c_str(field)) + 1;
                        char* tmp = MALLOC(n);

                        memcpy(tmp, string_c_str(line) + region->beg[i], region->end[i]-region->beg[i]);
                        tmp[region->end[i]-region->beg[i]] = 0;
                        strncat(tmp, string_c_str(field), n);

                        if(!statment_tree_internal_commands_write_nextout(nextout,  tmp))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(line);
                            string_delete(new_line);
                            FREE(tmp);
                            onig_region_free(region, 1);
                            return FALSE;
                        }

                        FREE(tmp);
                    }
                }
            }

            onig_region_free(region, 1);
        }

        string_delete(new_line);
    }
    else {
        err_msg("split: invalid regex", sname, sline);

        string_delete(line);
        return FALSE;
    }

    *rcode = 0;

    string_delete(line);

    return TRUE;
}

static BOOL statment_tree_internal_commands_sub(BOOL global, vector_obj* blocks, BOOL quiet, BOOL multiline, BOOL check, BOOL ignore_case, int* rcode, sWFd* nextout, char* sname, int sline, sRFd* nextin, int nexterr, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, vector_obj* parent_blocks, enum eKanjiCode code, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class, BOOL input, vector_obj* argv)
{
    string_obj* str;
    char* regex;
    char* destination;

    if(input) {
        if(vector_size(argv) == 3 || vector_size(argv) == 2 && vector_size(blocks) >= 1) 
        {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str);
            if(ret == 1) { // EOF
                string_delete(str);
                return TRUE;
            }
            else if(ret == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            regex = string_c_str(vector_item(argv, 1));
            if(vector_size(blocks) >= 1) {
                destination = NULL;
            }
            else {
                destination = string_c_str(vector_item(argv, 2));
            }
        }
        else {
            err_msg("invalid argument.", sname, sline);
            return FALSE;
        }
    }
    else if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) 
    {
        str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        regex = string_c_str(vector_item(argv, 2));
        if(vector_size(blocks) >= 1) {
            destination = NULL;
        }
        else {
            destination = string_c_str(vector_item(argv, 3));
        }
    }
    else {
        err_msg("invalid argument.", sname, sline);
        return FALSE;
    }

    BOOL check_all = FALSE;
    BOOL check_all_no = FALSE;
    int hennkann_kaisuu = 0;

    int i;

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    char* str2 = string_c_str(str);
    if(r == ONIG_NORMAL) {
        int point = 0;
        int region_end_before = 0;
        string_obj* hennkan_mojiretu = STRING_NEW("");
        while(1) {
            if(gKitutukiSigInt) {
                err_msg("interrupt", sname, sline);
                gKitutukiSigInt = FALSE;
                string_delete(str);
                string_delete(hennkan_mojiretu);
                return FALSE;
            }

            OnigRegion* region = onig_region_new();
            OnigErrorInfo err_info;

            int r2 = onig_search(reg, str2
               , str2 + strlen(str2)
               , str2 + point
               , str2 + strlen(str2)
               , region, ONIG_OPTION_NONE);

            if(r2 == ONIG_MISMATCH) {
                //point++;
                onig_region_free(region, 1);
                break;
            }
            else {
                /// チェック ///
                BOOL quetion;

                if(check_all_no) {
                    quetion = FALSE;
                }
                else if(check_all) {
                    quetion = TRUE;
                }
                else if(check) 
                {
                    if(gRunningOnTerminal == FALSE) {
                        err_msg("selector: not running on terminal", sname, sline);
                        gKitutukiSigInt = FALSE;
                        onig_region_free(region, 1);
                        string_delete(hennkan_mojiretu);
                        string_delete(str);
                        return FALSE;
                    }
#if !defined(__FREEBSD__)
                    msave_screen();
#endif
                    msave_ttysettings();
                    minitscr();

                    mclear();

                    /// 変換場所から行前を表示 ///
                    int count = 0;
                    char* p = str2+region->beg[0];
                    while(p > str2) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            mendwin();
#if !defined(__FREEBSD__)
                            mrestore_screen();
#endif
                            mrestore_ttysettings();
                            return FALSE;
                        }
                        if(is_line_field2(gLineField, p)) {
                            if(gLineField == kCRLF) {
                                count++;
                                if(count == 6) {
                                    p+=2;
                                    break;
                                }
                            }
                            else {
                                count++;
                                if(count == 6) {
                                    p++;
                                    break;
                                }
                            }

                            p--;
                        }
                        else {
                            p--;
                        }
                    }

                    char* tmp = MALLOC(str2+region->beg[0]-p+1);
                    memcpy(tmp, p, str2+region->beg[0]-p);
                    tmp[str2+region->beg[0]-p] = 0;

                    mprintw(tmp);
                    
                    FREE(tmp);

                    /// 変換文字列を表示 ///
                    tmp = MALLOC(region->end[0]-region->beg[0]+1);
                    memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                    tmp[region->end[0]-region->beg[0]] = 0;

                    mattron(kCAReverse);
                    mprintw(tmp);
                    mattroff();

                    FREE(tmp);

                    /// 変換場所から行後を表示 ///
                    count = 0;
                    p = str2+region->end[0];
                    while(p < str2+strlen(str2)) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            mendwin();
#if !defined(__FREEBSD__)
                            mrestore_screen();
#endif
                            mrestore_ttysettings();
                            return FALSE;
                        }
                        if(is_line_field2(gLineField, p)) {
                            if(gLineField == kCRLF) {
                                count++;
                                if(count == 6) {
                                    p-=2;
                                    break;
                                }
                            }
                            else {
                                count++;
                                if(count == 6) {
                                    p--;
                                    break;
                                }
                            }

                            p++;
                        }
                        else {
                            p++;
                        }
                    }

                    tmp = MALLOC(p-str2-region->end[0]+1);
                    memcpy(tmp, str2+region->end[0], p-str2-region->end[0]);
                    tmp[p-str2-region->end[0]] = 0;

                    mprintw(tmp);

                    FREE(tmp);

                    mprintw("\n");
                    mprintw("sub ok? (y)es/(n)o/(a)ll yes/(A)ll no");
                    mrefresh();

                    int meta;
                    int key = mgetch(&meta);
                    
                    mendwin();
#if !defined(__FREEBSD__)
                    mrestore_screen();
#endif
                    mrestore_ttysettings();

                    if(key == 3) {
                        break;
                    }
                    quetion = key == 'y' || key == 'a';
                    check_all = key == 'a';
                    check_all_no = key == 'A';
                }
                else {
                    quetion = TRUE;
                }

                if(destination) {
                    /// グループ化したものを
                    ///  \\1 \\2などに変換 ///
                    
                    char* p = destination;
                    string_put(hennkan_mojiretu, "");

                    while(*p) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            gKitutukiSigInt = FALSE;
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                        if(*p == '\\' 
                            && *(p+1) == '\\')
                        {
                            p++;
                            string_push_back2(
                                hennkan_mojiretu
                                    , *p++);
                        }
                        else if(*p == '\\' 
                            && *(p+1) >= '1'
                            && *(p+1) <= '9')
                        {
                            char tmp[BUFSIZ];
                            int n = *(p+1) - '0';

                            if(n < region->num_regs) 
                            {
                                p+=2;
                                memcpy(tmp
                                    , str2 
                                    + region->beg[n]
                                    , region->end[n]
                                    -region->beg[n]);

                                tmp[region->end[n]
                                  - region->beg[n]] 
                                    = 0;

                                char* p3 = tmp;
                                while(*p3) {
                                    if(gKitutukiSigInt) {
                                        err_msg("interrupt", sname, sline);
                                        gKitutukiSigInt = FALSE;
                                        onig_region_free(region, 1);
                                        string_delete(hennkan_mojiretu);
                                        string_delete(str);
                                        return FALSE;
                                    }

                                   string_push_back2(hennkan_mojiretu, *p3++);
                                }
                            }
                            else {
                                string_push_back2(
                                    hennkan_mojiretu
                                    , *p++);
                                string_push_back2(
                                    hennkan_mojiretu
                                    , *p++);
                            }
                        }
                        else { 
                            string_push_back2(
                                hennkan_mojiretu
                                    , *p++);
                        }
                    }
                }
                else {
                    if(region->num_regs > 1) {
                        /// マッチしたグループ化文字列 ///
                        int i;
                        for (i=1; i<region->num_regs; i++) {
                            char* tmp = MALLOC(
                                region->end[i]-region->beg[i] + 1);

                            memcpy(tmp, str2 + region->beg[i]
                             , region->end[i]-region->beg[i]);

                            tmp[region->end[i]
                                - region->beg[i]] = 0;

                            char name[16];
                            snprintf(name, 16, "%d", i);

                            saphire_set_local_var(name, tmp);

                            FREE(tmp);
                        }
                        
                        /// run
                        char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                        memcpy(tmp
                         , str2 + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        if(vector_size(blocks) == 0) {
                            err_msg("few blocks", sname, sline);
                            FREE(tmp);
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        sWFd* nextout2 = WFD_NEW(-1);
                        sRFd* nextin2 = RFD_NEW2(-1, tmp);

                        FREE(tmp);
                        *rcode = run(statments, fname, nextout2
                                    , nextin2, nexterr
                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                        string_put(hennkan_mojiretu, nextout2->mBuffer);
                        sWFd_delete(nextout2);
                        sRFd_delete(nextin2);

                        if(enable_break && *break_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(enable_return && *return_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                    else {
                        char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                        memcpy(tmp
                         , str2 + region->beg[0]
                         , region->end[0]-region->beg[0]);

                        tmp[region->end[0]
                            - region->beg[0]] = 0;

                        if(vector_size(blocks) == 0) {
                            err_msg("few blocks", sname, sline);
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }

                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        char* fname = MALLOC(strlen(sname) + 32);
                        snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                        sWFd* nextout2 = WFD_NEW(-1);
                        sRFd* nextin2 = RFD_NEW2(-1, tmp);
                        FREE(tmp);
                        *rcode = run(statments, fname, nextout2
                                    , nextin2, nexterr
                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                        FREE(fname);

                        string_put(hennkan_mojiretu, nextout2->mBuffer);

                        sWFd_delete(nextout2);
                        sRFd_delete(nextin2);

                        if(enable_break && *break_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(enable_return && *return_) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                }

                /// 変換開始 ///
                if(quetion) {
                    /// マッチした文字列の前 ///
                    char* tmp = MALLOC(
                        region->beg[0] - point + 1);

                    memcpy(tmp, str2 + point
                        , region->beg[0] - point);
                    tmp[region->beg[0] - point] = 0;
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    FREE(tmp);

                    /// 変換文字列を入れる ///
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(hennkan_mojiretu)))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    if(region->beg[0] == region->end[0]) 
                    {
                        char buf[2];
                        buf[0] = str2[region->beg[0]];
                        buf[1] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                        point = region->end[0] + 1;
                    }
                    else {
                        point = region->end[0];
                    }

                    hennkann_kaisuu++;
                }
                else {
                    /// マッチした文字列の前 ///
                    char* tmp = MALLOC(
                        region->beg[0] - point + 1);

                    memcpy(tmp, str2 + point
                        , region->beg[0] - point);
                    tmp[region->beg[0] - point] = 0;
                    if(!quiet) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                        {
                            onig_region_free(region, 1);
                            string_delete(hennkan_mojiretu);
                            FREE(tmp);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    FREE(tmp);


                    if(region->beg[0] == region->end[0]) {
                        char buf[2];
                        buf[0] = str2[region->beg[0]];
                        buf[1] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                        point = region->end[0] + 1;
                    }
                    else {
                        char* tmp = MALLOC(region->end[0] - region->beg[0] + 1);
                        memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                        tmp[region->end[0]-region->beg[0]] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(hennkan_mojiretu);
                                FREE(tmp);
                                string_delete(str);
                                return FALSE;
                            }
                        }

                        FREE(tmp);

                        point = region->end[0];

                    }
                }

                onig_region_free(region, 1);

                if(str2 + point>=str2 + strlen(str2)) 
                {
                    break;
                }

                if(!global) {
                    break;
                }
            }
        }

        string_delete(hennkan_mojiretu);

        if(point < strlen(str2)) {
            if(!quiet) {
                if(!statment_tree_internal_commands_write_nextout(nextout, str2 + point))
                {
                    string_delete(str);
                    return FALSE;
                }
            }
        }
    }

    /// 出力 ///

    char buf[128];
    snprintf(buf, 128, "%d", hennkann_kaisuu);
    saphire_set_local_var("SUB_COUNT", buf);

    if(hennkann_kaisuu > 0) {
        *rcode = 0;
    }

    string_delete(str);

    return TRUE;
}

static BOOL statment_tree_internal_commands_sub_oneline(BOOL global, vector_obj* blocks, BOOL quiet, BOOL multiline, BOOL check, BOOL ignore_case, int* rcode, sWFd* nextout, char* sname, int sline, sRFd* nextin, int nexterr, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, vector_obj* parent_blocks, enum eKanjiCode code, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class, BOOL input, vector_obj* argv, enum eLineField lf)
{
    string_obj* str;
    char* regex;
    char* destination;

    if(input) {
        if(vector_size(argv) == 3 || vector_size(argv) == 2 && vector_size(blocks) >= 1) 
        {
            str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str);
            if(ret == 1) { // EOF
                string_delete(str);
                return TRUE;
            }
            else if(ret == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            regex = string_c_str(vector_item(argv, 1));
            if(vector_size(blocks) >= 1) {
                destination = NULL;
            }
            else {
                destination = string_c_str(vector_item(argv, 2));
            }
        }
        else {
            err_msg("invalid argument", sname, sline);
            return FALSE;
        }
    }
    else if(vector_size(argv) == 4 || vector_size(argv) == 3 && vector_size(blocks) >= 1) 
    {
        str = STRING_NEW(string_c_str(vector_item(argv, 1)));
        regex = string_c_str(vector_item(argv, 2));
        if(vector_size(blocks) >= 1) {
            destination = NULL;
        }
        else {
            destination = string_c_str(vector_item(argv, 3));
        }
    }
    else {
        err_msg("invalid argument", sname, sline);
        return FALSE;
    }

    BOOL check_all = FALSE;
    BOOL check_all_no = FALSE;
    int hennkann_kaisuu = 0;

    int i;

    char* regex2 = regex;

    int r;
    regex_t* reg = get_reg(&r, regex2, ignore_case, multiline, code);

    sRFd* nextin2 = RFD_NEW(-1);
    sRFd_set_buffer(nextin2, string_c_str(str));
    string_delete(str);

    if(r == ONIG_NORMAL) {
        while(1) {
            string_obj* str = STRING_NEW("");
            int result = statment_tree_internal_commands_read_nextin_oneline(nextin2, str, lf);
            if(result < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                sRFd_delete(nextin2);
                return FALSE;
            }
            else if(result == 1) {
                string_delete(str);
                break;
            }

            char* str2 = string_c_str(str);
            int point = 0;
            int region_end_before = 0;
            string_obj* hennkan_mojiretu = STRING_NEW("");
            while(1) {
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    string_delete(hennkan_mojiretu);
                    sRFd_delete(nextin2);
                    return FALSE;
                }

                OnigRegion* region = onig_region_new();
                OnigErrorInfo err_info;
                int r2 = onig_search(reg, str2
                   , str2 + strlen(str2)
                   , str2 + point
                   , str2 + strlen(str2)
                   , region, ONIG_OPTION_NONE);

                if(r2 == ONIG_MISMATCH) {
                    //point++;
                    onig_region_free(region, 1);
                    break;
                }
                else {
                    /// チェック ///
                    BOOL quetion;

                    if(check_all_no) {
                        quetion = FALSE;
                    }
                    else if(check_all) {
                        quetion = TRUE;
                    }
                    else if(check) 
                    {
#if !defined(__FREEBSD__)
                        msave_screen();
#endif
                        msave_ttysettings();
                        minitscr();

                        mclear();

                        /// 変換場所から行前を表示 ///
                        int count = 0;
                        char* p = str2+region->beg[0];
                        while(p > str2) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                sRFd_delete(nextin2);
                                string_delete(hennkan_mojiretu);
                                return FALSE;
                            }
                            if(is_line_field2(gLineField, p)) {
                                if(gLineField == kCRLF) {
                                    count++;
                                    if(count == 6) {
                                        p+=2;
                                        break;
                                    }
                                }
                                else {
                                    count++;
                                    if(count == 6) {
                                        p++;
                                        break;
                                    }
                                }

                                p--;
                            }
                            else {
                                p--;
                            }
                        }

                        char* tmp = MALLOC(str2+region->beg[0]-p+1);
                        memcpy(tmp, p, str2+region->beg[0]-p);
                        tmp[str2+region->beg[0]-p] = 0;

                        mprintw(tmp);
                        
                        FREE(tmp);

                        /// 変換文字列を表示 ///
                        tmp = MALLOC(region->end[0]-region->beg[0]+1);
                        memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                        tmp[region->end[0]-region->beg[0]] = 0;

                        mattron(kCAReverse);
                        mprintw(tmp);
                        mattroff();

                        FREE(tmp);

                        /// 変換場所から行後を表示 ///
                        count = 0;
                        p = str2+region->end[0];
                        while(p < str2+strlen(str2)) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                            if(is_line_field2(gLineField, p)) {
                                if(gLineField == kCRLF) {
                                    count++;
                                    if(count == 6) {
                                        p-=2;
                                        break;
                                    }
                                }
                                else {
                                    count++;
                                    if(count == 6) {
                                        p--;
                                        break;
                                    }
                                }

                                p++;
                            }
                            else {
                                p++;
                            }
                        }

                        tmp = MALLOC(p-str2-region->end[0]+1);
                        memcpy(tmp, str2+region->end[0], p-str2-region->end[0]);
                        tmp[p-str2-region->end[0]] = 0;

                        mprintw(tmp);

                        FREE(tmp);

                        mprintw("\n");
                        mprintw("sub ok? (y)es/(n)o/(a)ll yes/(A)ll no");
                        mrefresh();

                        int meta;
                        int key = mgetch(&meta);
                        
                        mendwin();
#if !defined(__FREEBSD__)
                        mrestore_screen();
#endif
                        mrestore_ttysettings();

                        if(key == 3) {
                            break;
                        }
                        quetion = key == 'y' || key == 'a';
                        check_all = key == 'a';
                        check_all_no = key == 'A';
                    }
                    else {
                        quetion = TRUE;
                    }

                    if(destination) {
                        /// グループ化したものを
                        ///  \\1 \\2などに変換 ///
                        
                        char* p = destination;
                        string_put(hennkan_mojiretu, "");

                        while(*p) {
                            if(gKitutukiSigInt) {
                                err_msg("interrupt", sname, sline);
                                gKitutukiSigInt = FALSE;
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                            if(*p == '\\' 
                                && *(p+1) == '\\')
                            {
                                p++;
                                string_push_back2(
                                    hennkan_mojiretu
                                        , *p++);
                            }
                            else if(*p == '\\' 
                                && *(p+1) >= '1'
                                && *(p+1) <= '9')
                            {
                                char tmp[BUFSIZ];
                                int n = *(p+1) - '0';

                                if(n < region->num_regs) 
                                {
                                    p+=2;
                                    memcpy(tmp
                                        , str2 
                                        + region->beg[n]
                                        , region->end[n]
                                        -region->beg[n]);

                                    tmp[region->end[n]
                                      - region->beg[n]] 
                                        = 0;

                                    char* p3 = tmp;
                                    while(*p3) {
                                        if(gKitutukiSigInt) {
                                            err_msg("interrupt", sname, sline);
                                            gKitutukiSigInt = FALSE;
                                            onig_region_free(region, 1);
                                            string_delete(str);
                                            string_delete(hennkan_mojiretu);
                                            sRFd_delete(nextin2);
                                            return FALSE;
                                        }

                                       string_push_back2(hennkan_mojiretu, *p3++);
                                    }
                                }
                                else {
                                    string_push_back2(
                                        hennkan_mojiretu
                                        , *p++);
                                    string_push_back2(
                                        hennkan_mojiretu
                                        , *p++);
                                }
                            }
                            else { 
                                string_push_back2(
                                    hennkan_mojiretu
                                        , *p++);
                            }
                        }
                    }
                    else {
                        if(region->num_regs > 1) {
                            /// マッチしたグループ化文字列 ///
                            int i;
                            for (i=1; i<region->num_regs; i++) {
                                char* tmp = MALLOC(
                                    region->end[i]-region->beg[i] + 1);

                                memcpy(tmp, str2 + region->beg[i]
                                 , region->end[i]-region->beg[i]);

                                tmp[region->end[i]
                                    - region->beg[i]] = 0;

                                char name[16];
                                snprintf(name, 16, "%d", i);

                                saphire_set_local_var(name, tmp);

                                FREE(tmp);
                            }
                            
                            /// run
                            char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                            memcpy(tmp
                             , str2 + region->beg[0]
                             , region->end[0]-region->beg[0]);

                            tmp[region->end[0]
                                - region->beg[0]] = 0;

                            if(vector_size(blocks) == 0) {
                                err_msg("few blocks", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            sWFd* nextout2 = WFD_NEW(-1);
                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(statments, fname, nextout2
                                        , nextin3, nexterr
                                        , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                            FREE(fname);

                            string_put(hennkan_mojiretu, nextout2->mBuffer);
                            sWFd_delete(nextout2);
                            sRFd_delete(nextin3);

                            if(enable_break && *break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(enable_return && *return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                        else {
                            char* tmp = MALLOC(region->end[0]-region->beg[0]+1);

                            memcpy(tmp
                             , str2 + region->beg[0]
                             , region->end[0]-region->beg[0]);

                            tmp[region->end[0]
                                - region->beg[0]] = 0;

                            if(vector_size(blocks) == 0) {
                                err_msg("few blocks", sname, sline);
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }

                            sBlock* block = vector_item(blocks, 0);
                            sStatments* statments = block->mStatments;

                            char* fname = MALLOC(strlen(sname) + 32);
                            snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                            sWFd* nextout2 = WFD_NEW(-1);
                            sRFd* nextin3 = RFD_NEW2(-1, tmp);
                            FREE(tmp);
                            *rcode = run(statments, fname, nextout2
                                        , nextin3, nexterr
                                        , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                            FREE(fname);

                            string_put(hennkan_mojiretu, nextout2->mBuffer);

                            sWFd_delete(nextout2);
                            sRFd_delete(nextin3);

                            if(enable_break && *break_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(enable_return && *return_) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return TRUE;
                            }
                            else if(*rcode < 0) {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }
                    }

                    /// 変換開始 ///
                    if(quetion) {
                        /// マッチした文字列の前 ///
                        char* tmp = MALLOC(
                            region->beg[0] - point + 1);

                        memcpy(tmp, str2 + point
                            , region->beg[0] - point);
                        tmp[region->beg[0] - point] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }
                        }

                        FREE(tmp);

                        /// 変換文字列を入れる ///
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(hennkan_mojiretu)))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                return FALSE;
                            }
                        }

                        if(region->beg[0] == region->end[0]) 
                        {
                            char buf[2];
                            buf[0] = str2[region->beg[0]];
                            buf[1] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }
                            point = region->end[0] + 1;
                        }
                        else {
                            point = region->end[0];
                        }

                        hennkann_kaisuu++;
                    }
                    else {
                        /// マッチした文字列の前 ///
                        char* tmp = MALLOC(
                            region->beg[0] - point + 1);

                        memcpy(tmp, str2 + point
                            , region->beg[0] - point);
                        tmp[region->beg[0] - point] = 0;
                        if(!quiet) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                            {
                                onig_region_free(region, 1);
                                string_delete(str);
                                string_delete(hennkan_mojiretu);
                                sRFd_delete(nextin2);
                                FREE(tmp);
                                return FALSE;
                            }
                        }

                        FREE(tmp);


                        if(region->beg[0] == region->end[0]) {
                            char buf[2];
                            buf[0] = str2[region->beg[0]];
                            buf[1] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }
                            point = region->end[0] + 1;
                        }
                        else {
                            char* tmp = MALLOC(region->end[0] - region->beg[0] + 1);
                            memcpy(tmp, str2 + region->beg[0], region->end[0]-region->beg[0]);
                            tmp[region->end[0]-region->beg[0]] = 0;
                            if(!quiet) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, tmp))
                                {
                                    onig_region_free(region, 1);
                                    string_delete(str);
                                    string_delete(hennkan_mojiretu);
                                    FREE(tmp);
                                    sRFd_delete(nextin2);
                                    return FALSE;
                                }
                            }

                            point = region->end[0];

                            FREE(tmp);
                        }
                    }

                    onig_region_free(region, 1);

                    if(str2 + point>=str2 + strlen(str2)) 
                    {
                        break;
                    }

                    if(!global) {
                        break;
                    }
                }
            }

            string_delete(hennkan_mojiretu);

            if(point < strlen(str2)) {
                if(!quiet) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, str2 + point))
                    {
                        string_delete(str);
                        sRFd_delete(nextin2);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
        }
    }
    else {
        err_msg("erase: invalid regex", sname, sline);
        sRFd_delete(nextin2);

        return FALSE;
    } 

    sRFd_delete(nextin2);

    /// 出力 ///
    char buf[128];
    snprintf(buf, 128, "%d", hennkann_kaisuu);
    saphire_set_local_var("SUB_COUNT", buf);

    if(hennkann_kaisuu > 0) {
        *rcode = 0;
    }

    return TRUE;
}

int str_lflen(enum eLineField lf, char* str)
{
    char* p = str;
    int result = 0;

    if(lf == kCR) {
        while(*p) {
            if(*p == '\r') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else if(lf == kLF) {
        while(*p) {
            if(*p == '\n') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else if(lf == kBel) {
        while(*p) {
            if(*p == '\a') {
                result++;
                p++;
            }
            else {
                p++;
            }
        }
    }
    else {
        while(*p) {
            if(*p == '\r' && *(p+1) == '\n') {
                result++;
                p+=2;
            }
            else {
                p++;
            }
        }
    }

    return result;
}

typedef struct {
    string_obj* mName;

    struct stat mStat;                // stat()のキャッシュ
} sFile;

sFile* sFile_new(char* name, struct stat* stat_)
{
    sFile* self = MALLOC(sizeof(sFile));

    self->mName = STRING_NEW(name);
    self->mStat = *stat_;

    return self;
}

void sFile_delete(sFile* self)
{
    string_delete(self->mName);

    FREE(self);
}

static BOOL sort_name(void* left, void* right)
{
    sFile* l = (sFile*) left;
    sFile* r = (sFile*) right;

    char* lfname = string_c_str(l->mName);
    char* rfname = string_c_str(r->mName);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    if(!S_ISDIR(l->mStat.st_mode) && !S_ISDIR(r->mStat.st_mode)
        || S_ISDIR(l->mStat.st_mode) && S_ISDIR(r->mStat.st_mode) )
    {
        return strcasecmp(lfname, rfname) < 0;
    }

    if(S_ISDIR(l->mStat.st_mode))
        return TRUE;
    else
        return FALSE;
}

// pathの最後は/をつける
static BOOL select_file_read(vector_obj* v, char* path)
{
    DIR* dir = opendir(path);
    if(dir == NULL) {
        return FALSE;
    }
    
    struct dirent* entry;
    while(entry = readdir(dir)) {
        char fpath[PATH_MAX];
        xstrncpy(fpath, path, PATH_MAX);
        xstrncat(fpath, entry->d_name, PATH_MAX);

        struct stat stat_;
        memset(&stat_, 0, sizeof(struct stat));
        if(stat(fpath, &stat_) < 0) {
            continue;
        }

        sFile* file = sFile_new(entry->d_name, &stat_);

        vector_add(v, file);
    }
    
    closedir(dir);

    /// ソート ///
    vector_sort(v, sort_name);

    return TRUE;
}

static void str_cut2(enum eKanjiCode code, char* mbs, int termsize, char* dest_mbs, int dest_byte)
{
    if(code == kUtf8) {
        int i;
        int n;

        wchar_t* wcs 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);
        wchar_t* tmp 
            = (wchar_t*)MALLOC(sizeof(wchar_t)*(termsize+1)*MB_CUR_MAX);

        if(mbstowcs(wcs, mbs, (termsize+1)*MB_CUR_MAX) == -1) {
            mbstowcs(wcs, "?????", (termsize+1)*MB_CUR_MAX);
        }

        i = 0;
        while(1) {
            if(i < wcslen(wcs)) {
                tmp[i] = wcs[i];
                tmp[i+1] = 0;
            }
            else {
                tmp[i] = ' ';
                tmp[i+1] = 0;
            }

            n = wcswidth(tmp, wcslen(tmp));
            if(n < 0) {
                xstrncpy(dest_mbs, "?????", dest_byte);

                FREE(wcs);
                FREE(tmp);

                return;
            }
            else {
                if(n > termsize) {
                    tmp[i] = 0;

                    if(wcswidth(tmp, wcslen(tmp)) != termsize) {
                        tmp[i] = ' ';
                        tmp[i+1] = 0;
                    }
                    break;
                }
            }

            i++;
        }

        FREE(wcs);

        wcstombs(dest_mbs, tmp, dest_byte);
        FREE(tmp);
    }
    else {
        int n;
        BOOL tmpend = FALSE;
        BOOL kanji = FALSE;
        for(n=0; n<termsize && n<dest_byte-1; n++) {
            if(kanji)
                kanji = FALSE;
            else if(!tmpend && is_kanji(code, mbs[n])) {
                kanji = TRUE;
            }

            if(!tmpend && mbs[n] == 0) tmpend = TRUE;
                        
            if(tmpend)
                dest_mbs[n] = ' ';
            else
                dest_mbs[n] = mbs[n];
        }
        
        if(kanji) dest_mbs[n-1] = ' ';
        dest_mbs[n] = 0;
    }
}

static BOOL statment_tree_internal_commands_fselector(sWFd* nextout, char* sname, int sline, BOOL multiple)
{
    vector_obj* v = VECTOR_NEW(10);
    char cwd_path[PATH_MAX];
    mygetcwd(cwd_path, PATH_MAX);
    xstrncat(cwd_path, "/", PATH_MAX);

    char current_dir[PATH_MAX];
    xstrncpy(current_dir, cwd_path, PATH_MAX);
    select_file_read(v, current_dir);

    vector_obj* mark_files = VECTOR_NEW(10);

    if(vector_size(v) > 0) {
        msave_ttysettings();       // 端末の設定の保存
#if !defined(__FREEBSD__)
        msave_screen();
#endif
        minitscr();

        const int maxx = mgetmaxx();
        const int maxy = mgetmaxy();

        int cursor = 0;
        while(1) {
            /// 描写 ///
            mclear();
            mmvprintw(0,0,"%s", current_dir);

            int page = cursor/((maxy-1)*4);
            int n = page*4*(maxy-1);
            while(n < page*4*(maxy-1)+(maxy-1)*4 && n < vector_size(v)) {
                sFile* file = vector_item(v, n);

                int attrs = 0;
                if(n == cursor) {
                    attrs |= kCAReverse;
                }
                if(S_ISDIR(file->mStat.st_mode)) {
                    attrs |= kCACyan;
                    attrs |= kCABold;
                }
                if(attrs) mattron(attrs);

                char file2[PATH_MAX];
                str_cut2(kUtf8, string_c_str(file->mName), maxx/4-2, file2, PATH_MAX);

                int y = (n-page*4*(maxy-1)) / 4 + 1;
                int x = ((n-page*4*(maxy-1)) % 4)*maxx/4;

                char full_path[PATH_MAX];
                xstrncpy(full_path, current_dir, PATH_MAX);
                xstrncat(full_path, string_c_str(file->mName), PATH_MAX);

                BOOL marked = FALSE;
                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mark_file = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mark_file), full_path) == 0) {
                        marked = TRUE;
                        break;
                    }
                }

                if(marked) 
                    mmvprintw(y, x, "*%s", file2);
                else
                    mmvprintw(y, x, " %s", file2);

                if(attrs) {
                    mattroff();
                }

                n++;
            }
            mrefresh();

            /// インプット ///
            int meta;
            int key = mgetch(&meta);

            if(key == 14 || key == KEY_DOWN) {
                cursor+=4;
            }
            else if(key == 16 || key == KEY_UP) {
                cursor-=4;
            }
            else if(key == 6 || key == KEY_RIGHT) {
                cursor++;
            }
            else if(key == 2 || key == KEY_LEFT) {
                cursor--;
            }
            else if(key == 4 || key == KEY_NPAGE) {
                cursor += (maxy-1)*4;
            }
            else if(key == 21 || key == KEY_PPAGE) {
                cursor -= (maxy-1)*4;
            }
            else if(key == 12) {
                mclear();
                mrefresh();
            }
            else if(key == ' ' && multiple) {
                sFile* cursor_file = vector_item(v, cursor);

                string_obj* cursor_mfile = NULL;

                char cursor_path[PATH_MAX];
                xstrncpy(cursor_path, current_dir, PATH_MAX);
                xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

                int i;
                for(i=0; i<vector_size(mark_files); i++) {
                    string_obj* mfile = vector_item(mark_files, i);

                    if(strcmp(string_c_str(mfile), cursor_path) == 0) {
                        cursor_mfile = mfile;
                        break;
                    }
                }

                if(!cursor_mfile) {
                    vector_add(mark_files, STRING_NEW(cursor_path));
                }
                else {
                    string_delete(vector_item(mark_files, vector_index(mark_files, cursor_mfile)));
                    vector_erase(mark_files
                        , vector_index(mark_files, cursor_mfile));
                }

                cursor++;
            }
            else if(key == '\\') {
                xstrncpy(current_dir, "/", PATH_MAX);

                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_clear(v);

                select_file_read(v, current_dir);
                cursor = 0;
            }
            else if(key == '\t' || key == 'w') {
                break;
            }
            else if(key == 'q' || key == 3 | key == 27 || key == 7) {
                err_msg("canceled", sname, sline);
                mendwin();
#if !defined(__FREEBSD__)
                mrestore_screen();
#endif
                mrestore_ttysettings();    // 端末の設定の復帰
                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_delete(v);
                for(i=0; i<vector_size(mark_files); i++) {
                    string_delete(vector_item(mark_files, i));
                }
                vector_delete(mark_files);
                return FALSE;
            }
            else if(key == 10 || key == 13) {
                sFile* cursor_file = vector_item(v, cursor);

                if(strcmp(string_c_str(cursor_file->mName), ".") != 0
                    && S_ISDIR(cursor_file->mStat.st_mode)) 
                {
                    char path2[PATH_MAX];
                    if(correct_path(current_dir
                            , string_c_str(cursor_file->mName), path2, PATH_MAX)) 
                    {
                        xstrncpy(current_dir, path2, PATH_MAX);
                        if(current_dir[strlen(current_dir)-1] != '/') {
                            xstrncat(current_dir, "/", PATH_MAX);
                        }

                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_clear(v);

                        select_file_read(v, current_dir);
                        cursor = 0;
                    }
                }
            }
            else if(key == 8 || key == KEY_BACKSPACE) {    // CTRL-H
                char parent_path[PATH_MAX];
                parentname(parent_path, PATH_MAX, current_dir);
                xstrncpy(current_dir, parent_path, PATH_MAX);

                int i;
                for(i=0; i<vector_size(v); i++) {
                    sFile_delete(vector_item(v, i));
                }
                vector_clear(v);

                select_file_read(v, current_dir);
                cursor = 0;
            }

            /// 修正 ///
            if(cursor < 0) {
                cursor = 0;
            }
            if(cursor >= vector_size(v)) {
                cursor = vector_size(v)-1;
            }
        }

//mclear();
//mrefresh();
        mendwin();
#if !defined(__FREEBSD__)
        mrestore_screen();
#endif
        mrestore_ttysettings();    // 端末の設定の復帰

        if(vector_size(mark_files) == 0) {
            sFile* cursor_file = vector_item(v, cursor);

            /// 現在のカレントディレクトリのパスなら
            /// ディレクトリ名を取る
            char cursor_path[PATH_MAX];
            xstrncpy(cursor_path, current_dir, PATH_MAX);
            xstrncat(cursor_path, string_c_str(cursor_file->mName), PATH_MAX);

            /// カレントのファイル、子ディレクトリのファイルなら
            /// 相対ディレクトリ
            if(memcmp(cursor_path
                    , cwd_path, strlen(cwd_path)) == 0 )
            {
                char cursor_path2[PATH_MAX];
                memcpy(cursor_path2
                    , cursor_path+strlen(cwd_path)
                    , strlen(cursor_path) - strlen(cwd_path)+1);

                if(!statment_tree_internal_commands_write_nextout(nextout, cursor_path2))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, cursor_path))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        sFile_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    for(i=0; i<vector_size(mark_files); i++) {
                        string_delete(vector_item(mark_files, i));
                    }
                    vector_delete(mark_files);
                    return FALSE;
                }
            }
        }
        else {
            int j;
            for(j=0; j<vector_size(mark_files); j++) {
                char full_path[PATH_MAX];
                xstrncpy(full_path
                    , string_c_str(vector_item(mark_files, j))
                    , PATH_MAX);

                if(strstr(full_path, cwd_path) == full_path) {
                    char full_path2[PATH_MAX];
                    memcpy(full_path2
                        , full_path + strlen(cwd_path) 
                        , strlen(full_path) - strlen(cwd_path));
                    full_path2[strlen(full_path) - strlen(cwd_path)] = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, full_path2))
                    {
                        err_msg("signal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                }
                else {
                    if(!statment_tree_internal_commands_write_nextout(nextout, full_path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            sFile_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        for(i=0; i<vector_size(mark_files); i++) {
                            string_delete(vector_item(mark_files, i));
                        }
                        vector_delete(mark_files);
                        return FALSE;
                    }
                }
            }
        }
    }

    int i;
    for(i=0; i<vector_size(v); i++) {
        sFile_delete(vector_item(v, i));
    }
    vector_delete(v);
    for(i=0; i<vector_size(mark_files); i++) {
        string_delete(vector_item(mark_files, i));
    }
    vector_delete(mark_files);

    return TRUE;
}

typedef struct {
    int kind;   // 0: num 1: range 2: baisuu
    int num1;
    int num2;
    sStatments* statments;
    string_obj* condition;
} sLinesArg;

// TRUE 正常終了
// FALSE エラー
BOOL statment_tree_internal_commands(sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, int j, char* title, BOOL input, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, char* sname, int sline, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class)
{
//printf("command->mKind %d\n", command->mKind);
//printf("kPinrt %d\n", kPrint);
    /// go ///
    switch(command->mKind) {
        case kObject: {
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL mem = FALSE;
            BOOL new_ = FALSE;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// -mem
            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* objname = string_c_str(vector_item(argv, i));
                    sObject* object2 = NULL;
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameObjects, vector_size(gStackFrameObjects)-1);

                        object2 = hash_item(top_stack, objname);
                    } 
                    else if(!global && object) {
                        object2 = hash_item(object->mObjects, objname);
                    }
                    else {
                        object2 = hash_item(gObjects, objname);
                    }

                    if(object2) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", object2);
#else
                        snprintf(buf, 1024, "%p\n", object2);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            /// -new
            else if(new_) {
                if(vector_size(blocks) == 1) {
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    sObject* object2 = sObject_new("refference", "", object, 0);

                    // スタックを掘る
                    int k;
                    vector_obj* argv2 = sAry_new(30, 1);
                    for(k=1; k<vector_size(argv); k++) {
                        char* value = string_c_str(vector_item(argv, k));
                        vector_add(argv2, STRING_NEW(value));
                    }
                    vector_obj* fun_argv_before;
                    dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                    *rcode = run(statments, title, nextout
                                    , nextin, nexterr
                                    , return_, TRUE, break_, FALSE, parent_blocks, FALSE, envs, object2, running_fun, running_class);
                    *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                    *break_ = FALSE;

                    // スタックを埋める
                    string_obj* sname_strace;
                    int line_strace;
                    burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                    if(*rcode < 0) {
                        string_push_back(gErrMsg, string_c_str(sname_strace));
                        string_delete(sname_strace);
                        char tmp[1024];
                        snprintf(tmp, 1024, ":%d\n", line_strace);
                        string_push_back(gErrMsg, tmp);

                        return FALSE;
                    }
                    else {
                        string_delete(sname_strace);
                    }

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", object2);
#else
                    snprintf(buf, 1024, "%p\n", object2);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else {
                    sObject* object2 = sObject_new("refference", "", object, 0);
                    *rcode = 0;

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", object2);
#else
                    snprintf(buf, 1024, "%p\n", object2);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
            }
            /// ブロックがある
            else if(vector_size(blocks) == 1) {
                if(vector_size(argv) >= 2) {
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    char* objname = string_c_str(vector_item(argv, 1));

                    sObject* object2 = sObject_new(objname, "", object, 1);
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameObjects, vector_size(gStackFrameObjects)-1);

                        sObject* obj = hash_item(top_stack, objname);
                        if(obj) {
                            err_msg("the same name object exists", sname, sline);
                            sObject_delete(object2);

                            return FALSE;
                        }
                        hash_put(top_stack, objname, object2);
                    } 
                    else if(!global && object) {
                        sObject* obj = hash_item(object->mObjects, objname);
                        if(obj) {
                            err_msg("the same name object exists", sname, sline);
                            sObject_delete(object2);

                            return FALSE;
                        }
                        hash_put(object->mObjects, objname, object2);
                    }
                    else {
                        sObject* obj = hash_item(gObjects, objname);
                        if(obj) {
                            err_msg("the same name object exists", sname, sline);
                            sObject_delete(object2);

                            return FALSE;
                        }
                        hash_put(gObjects, objname, object2);
                    }

                    // スタックを掘る
                    vector_obj* argv2 = sAry_new(30, 1);
                    int k;
                    for(k=2; k<vector_size(argv); k++) {
                        char* value = string_c_str(vector_item(argv, k));
                        vector_add(argv2, STRING_NEW(value));
                    }
                    vector_obj* fun_argv_before;
                    dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                    *rcode = run(statments, title, nextout
                                    , nextin, nexterr
                                    , return_, TRUE, break_, FALSE, parent_blocks, FALSE, envs, object2, running_fun, running_class);
                    *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                    *break_ = FALSE;

                    // スタックを埋める
                    string_obj* sname_strace;
                    int line_strace;
                    burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                    if(*rcode < 0) {
                        string_push_back(gErrMsg, string_c_str(sname_strace));
                        string_delete(sname_strace);
                        char tmp[1024];
                        snprintf(tmp, 1024, ":%d\n", line_strace);
                        string_push_back(gErrMsg, tmp);

                        return FALSE;
                    }
                    else {
                        string_delete(sname_strace);
                    }
                }
            }
            else {
                if(vector_size(argv) >= 2) {
                    int i;
                    for(i=1; i<vector_size(argv); i++) {
                        char* objname = string_c_str(vector_item(argv, i));

                        if(local) {
                            hash_obj* top_stack
                                 = vector_item(gStackFrameObjects, vector_size(gStackFrameObjects)-1);

                            sObject* object2 = hash_item(top_stack, objname);
                            if(object2) {
                                char buf[1024];
#if defined(__SUNOS__)
                                snprintf(buf, 1024, "%#x\n", object2);
#else
                                snprintf(buf, 1024, "%p\n", object2);
#endif
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }
                            else {
                                object2 = sObject_new(objname, "", object, 1);
                                hash_put(top_stack, objname, object2);
                            }
                        } 
                        else if(!global && object) {
                            sObject* object2 = hash_item(object->mObjects, objname);
                            if(object2) {
                                char buf[1024];
#if defined(__SUNOS__)
                                snprintf(buf, 1024, "%#x\n", object2);
#else
                                snprintf(buf, 1024, "%p\n", object2);
#endif
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }
                            else {
                                object2 = sObject_new(objname, "", object, 1);
                                hash_put(object->mObjects, objname, object2);
                            }
                        }
                        else {
                            sObject* object2 = hash_item(gObjects, objname);
                            if(object2) {
                                char buf[1024];
#if defined(__SUNOS__)
                                snprintf(buf, 1024, "%#x\n", object2);
#else
                                snprintf(buf, 1024, "%p\n", object2);
#endif
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }
                            else {
                                object2 = sObject_new(objname, "", object, 1);
                                hash_put(gObjects, objname, object2);
                            }
                        }
                        *rcode = 0;
                    }
                }
                else {
                    err_msg("reuire object name", sname, sline);
                    return FALSE;
                }
            }
            }
            break;

        case kRef: {
            int i;
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL print = FALSE;
            enum eLineField lf = gLineField;
            BOOL mem = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    sRef* ref;
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        ref = hash_item(object->mRefs, name);

                        if(ref == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref = hash_item(parent->mRefs, name);
                                if(ref) break;
                                parent = parent->mParent;
                            }
                            if(ref == NULL) {
                                ref = hash_item(gRefs, name);
                            }
                        }
                    } else {
                        ref = hash_item(gRefs, name);
                    }
                    
                    if(ref) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", ref);
#else
                        snprintf(buf, 1024, "%p\n", ref);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            else if(input) {
                if(vector_size(argv) == 1) {
                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, kLF);
                    if(result < 0) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    else if(result == 1) {
                        *rcode = 1;
                        string_delete(str);
                        return TRUE;
                    }
                    string_chomp(str);

                    char* str2 = string_c_str(str);
                    if(strlen(str2) > 2 && str2[0] == '0' && str2[1] == 'x') {
                        void* address = (void*)(unsigned long)strtoll(str2, NULL, 16);
                        string_delete(str);

                        int kind = memchecker_is_enable_mem(address);
                        if(kind == kMCObject) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Object"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCArray) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Array"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCHash) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Hash"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCRef) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Refference"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCVar) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Var"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCGlobal) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Global"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCFunction) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Function"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(kind == kMCClass) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, "Class"))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                            *rcode = 0;
                        }
                    }
                }
                else {
                    int j;
                    for(j=1; j<vector_size(argv); j++) {
                        char* name = string_c_str(vector_item(argv, j));

                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                        if(ret == -1) {
                            err_msg("interrupt", sname, sline);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {
                            string_delete(line);
                            break;
                        }

                        void* mem = (void*)(unsigned long)strtoll(string_c_str(line), NULL, 16);
                        string_delete(line);

                        int kind = memchecker_is_enable_mem(mem);

                        sRef* ref = NULL;
                        if(strlen(name) > 1 && name[0] == '$') {
                            sRef* ref2;
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref2 = hash_item(top_stack, name + 1);
                            if(ref2 == NULL && object) {
                                ref2 = hash_item(object->mRefs, name + 1);
                                if(ref2 == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        ref2 = hash_item(parent->mRefs, name + 1);
                                        if(ref2) break;
                                        parent = parent->mParent;
                                    }
                                }
                            }
                            if(ref2 == NULL) {
                                ref2 = hash_item(gRefs, name + 1);
                            }

                            if(ref2) {
                                if(ref2->mKind == kMCRef && memchecker_is_enable_mem(ref2->mMem) == kMCRef) {
                                    ref = ref2->mMem;
                                    sRef_dec_refcount(ref);
                                    ref->mMem = mem;
                                    ref->mKind = kind;
                                    sRef_inc_refcount(ref);
                                }
                                else {
                                    err_msg("invalid refference", sname, sline);
                                    return FALSE;
                                }
                            }
                        }
                        else if(local) {
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref = hash_item(top_stack, name);
                            if(ref) { sRef_delete(ref); }

                            ref = sRef_new(mem, kind);
                            hash_put(top_stack, name, ref);
                        }
                        else if(object && !global) {
                            ref = hash_item(object->mRefs, name);
                            if(ref) { sRef_delete(ref); }

                            ref = sRef_new(mem, kind);
                            hash_put(object->mRefs, name, ref);
                        } else {
                            ref = hash_item(gRefs, name);
                            if(ref) { sRef_delete(ref); }

                            ref = sRef_new(mem, kind);
                            hash_put(gRefs, name, ref);
                        }

                        if(ref) {
                            *rcode = 0;

                            if(print) {
                                char buf[1024];
#if defined(__SUNOS__)
                                snprintf(buf, 1024, "%#x\n", ref->mMem);
#else
                                snprintf(buf, 1024, "%p\n", ref->mMem);
#endif

                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }
                        }
                    }
                }
            }
            else {
                int j;
                for(j=1; j<vector_size(argv); j++) {
                    char* name = string_c_str(vector_item(argv, j));

                    sRef* ref = NULL;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCRef && memchecker_is_enable_mem(ref2->mMem) == kMCRef) {
                                ref = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(object && !global) {
                        ref = hash_item(object->mRefs, name);

                        if(ref == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref = hash_item(parent->mRefs, name);
                                if(ref) break;
                                parent = parent->mParent;
                            }
                            if(ref == NULL) {
                                ref = hash_item(gRefs, name);
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref = hash_item(top_stack, name);
                    }
                    else {
                        ref = hash_item(gRefs, name);
                    }

                    if(ref) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x", ref->mMem);
#else
                        snprintf(buf, 1024, "%p", ref->mMem);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            }
            break;

        case kVar:
            {
            int i;
            BOOL print = FALSE;
            BOOL num = FALSE;
            BOOL line_field = FALSE;
            BOOL mem = FALSE;
            BOOL shift = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0) {
                    num = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-shift") == 0) {
                    shift = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// メモリの出力 ///
            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++ ) {
                    char* name = string_c_str(vector_item(argv, i));
                    string_obj* var;
                    hash_obj* top_stack
                         = vector_item(gStackFrame, vector_size(gStackFrame)-1);

                    var = hash_item(top_stack, name);

                    if(var) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", var);
#else
                        snprintf(buf, 1024, "%p\n", var);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }

            /// 入力 ///
            else if(input) {
                int k;
                for(k=1; k<vector_size(argv); k++) {
                    char* item = string_c_str(vector_item(argv, k));

                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(result < 0) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    else if(result == 1) {
                        saphire_set_local_var(item, "");
                        *rcode = 1;
                        string_delete(str);
                        break;
                    }
                    
                    string_chomp(str);

                    if(strlen(item) > 1 && item[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, item + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, item + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, item + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, item + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCVar && memchecker_is_enable_mem(ref2->mMem) == kMCVar) {
                                string_obj* var = ref2->mMem;
                                string_put(var, string_c_str(str));
                                *rcode = 0;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                    }
                    else {
                        saphire_set_local_var(item, string_c_str(str));
                        *rcode = 0;
                    }

                    if(print) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    string_delete(str);
                }

                //// shiftがあれば残りを出力 ///
                if(shift) {
                    string_obj* str = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                    if(ret == 1) {
                        string_delete(str);
                        break;
                    }
                    else if(ret < 0)
                    {
                        *rcode = 2;
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    string_delete(str);
                }
            }

            /// 変数の参照 ///
            else {
                if(vector_size(argv) > 1) {
                    hash_obj* top_stack
                         = vector_item(gStackFrame, vector_size(gStackFrame)-1);
                    for(i=1; i<vector_size(argv); i++) {
                        char* name = string_c_str(vector_item(argv, i));

                        string_obj* var = NULL;
                        if(strlen(name) > 1 && name[0] == '$') {
                            sRef* ref2;
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref2 = hash_item(top_stack, name + 1);
                            if(ref2 == NULL && object) {
                                ref2 = hash_item(object->mRefs, name + 1);
                                if(ref2 == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        ref2 = hash_item(parent->mRefs, name + 1);
                                        if(ref2) break;
                                        parent = parent->mParent;
                                    }
                                }
                            }
                            if(ref2 == NULL) {
                                ref2 = hash_item(gRefs, name + 1);
                            }

                            if(ref2) {
                                if(ref2->mKind == kMCVar && memchecker_is_enable_mem(ref2->mMem) == kMCVar) {
                                    var = ref2->mMem;
                                }
                                else {
                                    err_msg("invalid refference", sname, sline);
                                    return FALSE;
                                }
                            }
                        }
                        else {
                            var = hash_item(top_stack, name);
                        }

                        /// ローカル変数を参照 ///
                        if(var) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(var)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(line_field || i != vector_size(argv)-1) {
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }
                            *rcode = 0;
                        }
                        else {
                            char buf[128];

                            if(num) {
                                int n = 0;
                                snprintf(buf, 128, "%d", n);
                                saphire_set_local_var(name, buf);
                            }
                            else {
                                buf[0] = 0;
                                saphire_set_local_var(name, "");
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(line_field || i != vector_size(argv)-1) {
                                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    return FALSE;
                                }
                            }

                            *rcode = 0;
                        }
                    }
                }
            }
            }
            break;

        case kGlobal:
            {
            int i;
            BOOL print = FALSE;
            BOOL line_field = FALSE;
            BOOL global = FALSE;
            enum eLineField lf = gLineField;
            BOOL mem = FALSE;
            BOOL new_ = FALSE;
            BOOL local = FALSE;
            BOOL shift = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-shift") == 0) {
                    shift = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// -mem
            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));
                    string_obj* var = NULL;

                    if(object && !global) {
                        var = hash_item(object->mGlobals, name);

                        if(var == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                var = hash_item(parent->mGlobals, name);
                                if(var) break;
                                parent = parent->mParent;
                            }
                            if(var == NULL) {
                                var = hash_item(gGlobals, name);
                            }
                        }
                    }
                    else {
                        var = hash_item(gGlobals, name);
                    }

                    if(var) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", var);
#else
                        snprintf(buf, 1024, "%p\n", var);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }

            /// -new
            else if(new_) {
                if(input) {
                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(result == 1) {
                        *rcode = 1;
                        string_delete(str);
                        break;
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    string_chomp(str);

                    string_obj* global = sGlobal_new(string_c_str(str), 0);
                    string_delete(str);
                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", global);
#else
                    snprintf(buf, 1024, "%p\n", global);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else {
                    string_obj* global = sGlobal_new("", 0);
                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", global);
#else
                    snprintf(buf, 1024, "%p\n", global);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }

            /// 入力
            else if(input) {
                int k;
                for(k=1; k<vector_size(argv); k++) {
                    char* item = string_c_str(vector_item(argv, k));

                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(result == 1) {
                        *rcode = 1;
                        string_delete(str);
                        break;
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    string_chomp(str);

                    if(strlen(item) > 1 && item[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, item + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, item + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, item + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, item + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCGlobal && memchecker_is_enable_mem(ref2->mMem) == kMCGlobal) {
                                string_obj* var = ref2->mMem;
                                string_put(var, string_c_str(str));
                                *rcode = 0;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                string_delete(str);
                                return FALSE;
                            }
                        }
                    }
                    else if(object && !global) {
                        saphire_set_global_var2(item, string_c_str(str), object);
                        *rcode = 0;
                    }
                    else {
                        saphire_set_global_var(item, string_c_str(str));
                        *rcode = 0;
                    }

                    if(print) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    string_delete(str);
                }

                if(shift) {
                    string_obj* str = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                    if(ret == 1) {
                        string_delete(str);
                        break;
                    }
                    else if(ret < 0)
                    {
                        *rcode = 2;
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }

                    string_delete(str);
                }
            }

            /// 出力
            else {
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    string_obj* var;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCGlobal && memchecker_is_enable_mem(ref2->mMem) == kMCGlobal) {
                                var = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(object && !global) {
                        var = hash_item(object->mGlobals, name);

                        if(var == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                var = hash_item(parent->mGlobals, name);
                                if(var) break;
                                parent = parent->mParent;
                            }
                            if(var == NULL) {
                                var = hash_item(gGlobals, name);
                            }
                        }
                    }
                    else {
                        var = hash_item(gGlobals, name);
                    }

                    if(var) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(var)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(line_field || i != vector_size(argv)-1) {
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                        *rcode = 0;
                    }
                }
            }
            }
            break;

        case kExport: {
            int i;
            BOOL chomp = TRUE;
            BOOL print = FALSE;
            BOOL line_field = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-nc") == 0) {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// 入力
            if(input) {
                int k;
                for(k=1; k<vector_size(argv); k++) {
                    char* item = string_c_str(vector_item(argv, k));

                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(result == 1) {
                        string_delete(str);
                        setenv(item, "", 1);
                        break;
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    if(chomp) string_chomp(str);

                    setenv(item, string_c_str(str), 1);
                    *rcode = 0;

                    if(print) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            string_delete(str);
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        string_delete(str);
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                    else {
                        string_delete(str);
                    }
                }
            }

            /// 出力
            else {
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    char* var = getenv(name);
                    if(var) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, var))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(line_field || i != vector_size(argv) -1) {
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                        *rcode = 0;
                    }
                }
            }
            }
            break;

        case kAry: {
            int i;
            BOOL chomp = TRUE;
            BOOL print = FALSE;
            BOOL size = FALSE;
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL mem = FALSE;
            BOOL new_ = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-size") == 0) 
                {
                    size = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nc") == 0) 
                {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) 
                {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) 
                {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) 
                {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) 
                {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// -mem
            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    vector_obj* array = NULL;
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                        array = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        array = hash_item(object->mArrays, name);

                        if(array == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                array = hash_item(parent->mArrays, name);
                                if(array) break;
                                parent = parent->mParent;
                            }
                            if(array == NULL) {
                                array = hash_item(gArrays, name);
                            }
                        }
                    } else {
                        array = hash_item(gArrays, name);
                    }
                    
                    if(array) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", array);
#else
                        snprintf(buf, 1024, "%p\n", array);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }

            /// -size
            else if(size) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));
                    vector_obj* ary = NULL;

                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                                ary = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                        ary = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        ary = hash_item(object->mArrays, name);

                        if(ary == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ary = hash_item(parent->mArrays, name);
                                if(ary) break;
                                parent = parent->mParent;
                            }
                            if(ary == NULL) {
                                ary = hash_item(gArrays, name);
                            }
                        }
                    } 
                    else {
                        ary = hash_item(gArrays, name);
                    }

                    if(ary) {
                        char buf[1024];
                        snprintf(buf, 1024, "%d", vector_size(ary));
                        if(!statment_tree_internal_commands_write_nextout(nextout,  buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }

                        *rcode = 0;
                    }
                }
            }

            /// -new
            else if(new_) {
                if(input) {
                    vector_obj* array = sAry_new(50, 0);

                    while(1) {
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                        if(ret == -1) {
                            err_msg("interrupt", sname, sline);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {
                            string_delete(line);
                            break;
                        }
                        if(chomp) string_chomp(line);

                        vector_add(array, line);
                    }

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", array);
#else
                    snprintf(buf, 1024, "%p\n", array);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else {
                    vector_obj* array = sAry_new(50, 0);

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", array);
#else
                    snprintf(buf, 1024, "%p\n", array);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }

            /// 入力
            else if(input) {
                if(vector_size(argv) != 2) {
                    err_msg("require one argument", sname, sline);

                    return FALSE;
                }

                char* key = string_c_str(vector_item(argv, 1));

                vector_obj* v;
                if(strlen(key) > 1 && key[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, key + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, key + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, key + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, key + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                            v = ref2->mMem;
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_clear(v);
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                    else {
                        v = NULL;
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                    v = hash_item(top_stack, key);
                    if(v) {
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_clear(v);
                    }
                    else {
                        v = sAry_new(50, 1);
                        hash_put(top_stack, key, v);
                    }
                }
                else if(object && !global) {
                    v = hash_item(object->mArrays, key);
                    if(v) {
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_clear(v);
                    }
                    else {
                        v = sAry_new(50,1 );
                        hash_put(object->mArrays, key, v);
                    }
                } else {
                    v = hash_item(gArrays, key);
                    if(v) {
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_clear(v);
                    }
                    else {
                        v = sAry_new(50, 1);
                        hash_put(gArrays, key, v);
                    }
                }

                if(v) {
                    while(1) {
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                        if(ret == -1) {
                            err_msg("interrupt", sname, sline);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {
                            string_delete(line);
                            break;
                        }
                        if(chomp) string_chomp(line);

                        vector_add(v, line);

                        if(print) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                
                    *rcode = 0;
                }
            }

            /// 出力
            else {
                if(vector_size(argv) == 2) {
                    char* name = string_c_str(vector_item(argv, 1));
                    vector_obj* array = NULL;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                                array = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                        array = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        array = hash_item(object->mArrays, name);

                        if(array == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                array = hash_item(parent->mArrays, name);
                                if(array) break;
                                parent = parent->mParent;
                            }
                            if(array == NULL) {
                                array = hash_item(gArrays, name);
                            }
                        }
                    } else {
                        array = hash_item(gArrays, name);
                    }
                    
                    if(array) {
                        int k;
                        for(k=0; k<vector_size(array); k++) {
                            string_obj* str = vector_item(array, k);

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }

                        *rcode = 0;
                    }
                }
                else if(vector_size(argv) >= 3) {
                    char* name = string_c_str(vector_item(argv, 1));

                    vector_obj* array = NULL;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                                array = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                        array = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        array = hash_item(object->mArrays, name);

                        if(array == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                array = hash_item(parent->mArrays, name);
                                if(array) break;
                                parent = parent->mParent;
                            }
                            if(array == NULL) {
                                array = hash_item(gArrays, name);
                            }
                        }
                    } else {
                        array = hash_item(gArrays, name);
                    }

                    if(array) {
                        for(i=2; i<vector_size(argv); i++) {
                            int index = atoi(string_c_str(vector_item(argv, i)));
                            if(index < 0) {
                                index += vector_size(array);
                            }
                            if(index >= 0 && index < vector_size(array)) 
                            {
                                string_obj* str = vector_item(array, index);
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }

                                if(i != vector_size(argv) -1) {
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        return FALSE;
                                    }
                                }
                                *rcode = 0;
                            }
                        }
                    }
                }
                else {
                    err_msg("invalid argument number on ary", sname, sline);
                    return FALSE;
                }
            }
            }
            break;

        case kAryAdd: {
            int i;
            BOOL flg_n = FALSE;
            BOOL chomp = TRUE;
            BOOL print = FALSE;
            BOOL line_field = FALSE;
            BOOL local = FALSE;
            BOOL global = FALSE;
            enum eLineField lf = gLineField;
            int n;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-n") == 0 
                        && i+1 < vector_size(argv)) 
                {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) 
                {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) 
                {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nc") == 0) 
                {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// 入力
            if(input) {
                /// 標準入力から、設定
                if(vector_size(argv) != 2) {
                    err_msg("ary_add: invalid option number", sname, sline);
                    return FALSE;
                }

                char* key = string_c_str(vector_item(argv, 1));

                vector_obj* v = NULL;
                if(strlen(key) > 1 && key[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, key + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, key + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, key + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, key + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                            v = ref2->mMem;
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                    v = hash_item(top_stack, key);
                    if(v == NULL) {
                        v = sAry_new(50, 1);
                        hash_put(top_stack, key, v);
                    }
                }
                else if(object && !global) {
                    v = hash_item(object->mArrays, key);
                    if(v == NULL) {
                        v = sAry_new(50, 1);
                        hash_put(object->mArrays, key, v);
                    }
                } else {
                    v = hash_item(gArrays, key);
                    if(v == NULL) {
                        v = sAry_new(50, 1);
                        hash_put(gArrays, key, v);
                    }
                }

                if(v) {
                    int i=0;
                    while(1) {
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

                        if(ret == -1) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {      // EOF
                            string_delete(line);
                            break;
                        }

                        if(chomp) string_chomp(line);

                        if(flg_n) {
                            if(n < 0) {
                                n = n + vector_size(v) + 1;
                            }

                            if(n < 0 || n+i > vector_size(v)) {
                                *rcode = 1;
                                string_delete(line);
                                return TRUE;
                            }

                            if(n+i < vector_size(v)) {
                                vector_insert(v, n+i, line);
                            }
                            else {
                                vector_add(v, line);
                            }
                        }
                        else {
                            vector_add(v, line);
                        }

                        if(print) {
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }

                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }
                        }
                        
                        *rcode = 0;
                        i++;
                    }
                }
            }

            }
            break;

        case kAryErase: {
            int i;
            BOOL global = FALSE;
            BOOL local = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-g") == 0) 
                {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) 
                {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(argv) == 3) {
                char* key = string_c_str(vector_item(argv, 1));
                char* number = string_c_str(vector_item(argv, 2));
                int n = atoi(number);

                vector_obj* v = NULL;
                if(strlen(key) > 1 && key[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, key + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, key + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, key + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, key + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCArray && memchecker_is_enable_mem(ref2->mMem) == kMCArray) {
                            v = ref2->mMem;
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameArrays, vector_size(gStackFrameArrays)-1);
                    v = hash_item(top_stack, key);
                }
                else if(object && !global) {
                    v = hash_item(object->mArrays, key);
                } else {
                    v = hash_item(gArrays, key);
                }

                if(v) {
                    if(n < 0) {
                        n+=vector_size(v);
                    }

                    if(n >= 0 && n < vector_size(v)) {
                        string_delete(vector_item(v, n));
                        vector_erase(v, n);
                        *rcode = 0;
                    }
                }
            }
            }
            break;

        case kHash: {
            BOOL chomp = TRUE;
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL print = FALSE;
            BOOL new_ = FALSE;
            BOOL mem = FALSE;
            enum eLineField lf = gLineField;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-nc") == 0) 
                {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            /// -mem
            if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    hash_obj* hash = NULL;
                    if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                        hash = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        hash = hash_item(object->mHashs, name);

                        if(hash == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                hash = hash_item(parent->mHashs, name);
                                if(hash) break;
                                parent = parent->mParent;
                            }
                            if(hash == NULL) {
                                hash = hash_item(gHashs, name);
                            }
                        }
                    } else {
                        hash = hash_item(gHashs, name);
                    }
                    
                    if(hash) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", hash);
#else
                        snprintf(buf, 1024, "%p\n", hash);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            /// -new
            else if(new_) {
                if(input) {
                    hash_obj* hash = sHash_new(50, 0);

                    BOOL key = TRUE;
                    string_obj* key_str = STRING_NEW("");

                    while(1) {
                        if(gKitutukiSigInt) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(key_str);
                            return FALSE;
                        }
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

                        if(ret == -1) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(key_str);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {      // EOF
                            string_delete(line);
                            break;
                        }

                        if(chomp || key) string_chomp(line);

                        if(key) {
                            string_put(key_str, string_c_str(line));
                            string_delete(line);
                        }
                        else {
                            string_obj* str = hash_item(hash, string_c_str(key_str));
                            if(str) {
                                string_delete(str);
                            }
                            hash_put(hash
                                , string_c_str(key_str), line);
                        }

                        key = !key;
                    }

                    string_delete(key_str);

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", hash);
#else
                    snprintf(buf, 1024, "%p\n", hash);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else {
                    hash_obj* hash = sHash_new(50, 0);

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", hash);
#else
                    snprintf(buf, 1024, "%p\n", hash);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
            /// 入力
            else if(input) {
                if(vector_size(argv) != 2) {
                    err_msg("invalid argument on hash",sname,sline);
                    return FALSE;
                }

                char* k = string_c_str(vector_item(argv, 1));

                hash_obj* hash = NULL;
                if(strlen(k) > 1 && k[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, k + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, k + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, k + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, k + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCHash && memchecker_is_enable_mem(ref2->mMem) == kMCHash) {
                            hash = ref2->mMem;
                            hash_it* it = hash_loop_begin(hash);
                            while(it) {
                                string_delete(hash_loop_item(it));
                                it = hash_loop_next(it);
                            }
                            hash_clear(hash);
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                    hash = hash_item(top_stack, k);
                    if(hash) {
                        hash_it* it = hash_loop_begin(hash);
                        while(it) {
                            string_delete(hash_loop_item(it));
                            it = hash_loop_next(it);
                        }
                        hash_clear(hash);
                    }
                    else {
                        hash = sHash_new(100, 1);
                        hash_put(top_stack, k , hash);
                    }
                }
                else if(object && !global) {
                    hash = hash_item(object->mHashs, k);
                    if(hash) {
                        hash_it* it = hash_loop_begin(hash);
                        while(it) {
                            string_delete(hash_loop_item(it));
                            it = hash_loop_next(it);
                        }
                        hash_clear(hash);
                    }
                    else {
                        hash = sHash_new(100, 1);
                        hash_put(object->mHashs, k , hash);
                    }
                } else {
                    hash = hash_item(gHashs, k);
                    if(hash) {
                        hash_it* it = hash_loop_begin(hash);
                        while(it) {
                            string_delete(hash_loop_item(it));
                            it = hash_loop_next(it);
                        }
                        hash_clear(hash);
                    }
                    else {
                        hash = sHash_new(100, 1);
                        hash_put(gHashs, k , hash);
                    }
                }

                if(hash) {
                    BOOL key = TRUE;
                    string_obj* key_str = STRING_NEW("");

                    while(1) {
                        if(gKitutukiSigInt) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(key_str);
                            return FALSE;
                        }
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

                        if(ret == -1) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(key_str);
                            string_delete(line);
                            return FALSE;
                        }
                        else if(ret == 1) {      // EOF
                            string_delete(line);
                            break;
                        }

                        if(chomp || key) string_chomp(line);

                        if(key) {
                            string_put(key_str, string_c_str(line));
                            string_delete(line);
                        }
                        else {
                            string_obj* str = hash_item(hash, string_c_str(key_str));
                            if(str) {
                                string_delete(str);
                            }

                            hash_put(hash
                                , string_c_str(key_str), line);
                        }

                        key = !key;
                    }

                    string_delete(key_str);

                    if(print) {
                        hash_it* it = hash_loop_begin(hash);
                        while(it != NULL) {
                            string_obj* str = hash_loop_item(it);
                            char* key = hash_loop_key(it);

                            if(!statment_tree_internal_commands_write_nextout(nextout, key))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }

                            it = hash_loop_next(it);
                        }
                    }

                    *rcode = 0;
                }
            }
            /// 出力
            else {
                if(vector_size(argv) == 2) {
                    char* name = string_c_str(vector_item(argv, 1));
                    hash_obj* hash = NULL;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCHash && memchecker_is_enable_mem(ref2->mMem) == kMCHash) {
                                hash = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                        hash = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        hash = hash_item(object->mHashs, name);

                        if(hash == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                hash = hash_item(parent->mHashs, name);
                                if(hash) break;
                                parent = parent->mParent;
                            }
                            if(hash == NULL) {
                                hash = hash_item(gHashs, name);
                            }
                        }
                    } else {
                        hash = hash_item(gHashs, name);
                    }

                    if(hash) {
                        hash_it* it = hash_loop_begin(hash);
                        int k = 0;
                        while(it != NULL) {
                            string_obj* str = hash_loop_item(it);
                            char* key = hash_loop_key(it);

                            if(!statment_tree_internal_commands_write_nextout(nextout, key))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                            {
                                err_msg("singal interrupt", sname, sline);
                                return FALSE;
                            }

                            it = hash_loop_next(it);
                            k++;
                        }
                        *rcode = 0;
                    }
                }
                else if(vector_size(argv) >= 3) {
                    char* name = string_c_str(vector_item(argv, 1));
                    hash_obj* hash = NULL;
                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCHash && memchecker_is_enable_mem(ref2->mMem) == kMCHash) {
                                hash = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(local) {
                        hash_obj* top_stack
                             = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                        hash = hash_item(top_stack, name);
                    }
                    else if(object && !global) {
                        hash = hash_item(object->mHashs, name);

                        if(hash == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                hash = hash_item(parent->mHashs, name);
                                if(hash) break;
                                parent = parent->mParent;
                            }
                            if(hash == NULL) {
                                hash = hash_item(gHashs, name);
                            }
                        }
                    }
                    else {
                        hash = hash_item(gHashs, name);
                    }
                    if(hash) {
                        int i;
                        for(i=2; i<vector_size(argv); i++) {
                            char* index = string_c_str(vector_item(argv, i));
                            string_obj* str = hash_item(hash, index);

                            if(str) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }

                                if(i != vector_size(argv) -1) {
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        return FALSE;
                                    }
                                }
                                *rcode = 0;
                            }
                        }
                    }
                }
            }
            }
            break;

        case kHashAdd: {
            BOOL chomp = TRUE;
            BOOL global = FALSE;
            BOOL local = FALSE;
            BOOL print = FALSE;
            enum eLineField lf = gLineField;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-nc") == 0) 
                {
                    chomp = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                char* k = string_c_str(vector_item(argv, 1));
                hash_obj* hash = NULL;

                if(strlen(k) > 1 && k[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, k + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, k + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, k + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, k + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCHash && memchecker_is_enable_mem(ref2->mMem) == kMCHash) {
                            hash = ref2->mMem;
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                    hash = hash_item(top_stack, k);

                    if(hash == NULL) {
                        hash = sHash_new(100, 1);
                        hash_put(top_stack, k , hash);
                    }
                }
                else if(object && !global) {
                    hash = hash_item(object->mHashs, k);

                    if(hash == NULL) {
                        hash = sHash_new(100, 1);
                        hash_put(object->mHashs, k , hash);
                    }
                }
                else {
                    hash = hash_item(gHashs, k);

                    if(hash == NULL) {
                        hash = sHash_new(100, 1);
                        hash_put(gHashs, k , hash);
                    }
                }

                if(hash) {
                    BOOL key = TRUE;
                    string_obj* key_str = STRING_NEW("");
                    vector_obj* v = VECTOR_NEW(10);

                    while(1) {
                        if(gKitutukiSigInt) {
                            err_msg("innterrupt", sname, sline);
                            string_delete(key_str);
                            int i;
                            for(i=0; i<vector_size(v) ;i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                        string_obj* line = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);

                        if(ret == -1) {
                            err_msg("intterrupt", sname, sline);
                            string_delete(key_str);
                            string_delete(line);
                            int i;
                            for(i=0; i<vector_size(v) ;i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                        else if(ret == 1) {      // EOF
                            string_delete(line);
                            break;
                        }

                        if(chomp || key) string_chomp(line);

                        if(key) {
                            string_put(key_str, string_c_str(line));
                            string_delete(line);
                        }
                        else {
                            string_obj* str = hash_item(hash, string_c_str(key_str));
                            if(str) { string_delete(str); }

                            vector_add(v, STRING_NEW(string_c_str(key_str)));
                            vector_add(v, STRING_NEW(string_c_str(line)));
                            hash_put(hash, string_c_str(key_str), line);
                            *rcode = 0;
                        }

                        key = !key;
                    }

                    string_delete(key_str);

                    if(print) {
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_obj* str = vector_item(v, i);

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                int i;
                                for(i=0; i<vector_size(v) ;i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                return FALSE;
                            }
                            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                            {
                                err_msg("singal interrupt", sname, sline);
                                int i;
                                for(i=0; i<vector_size(v) ;i++) {
                                    string_delete(vector_item(v, i));
                                }
                                vector_delete(v);
                                return FALSE;
                            }
                        }
                    }

                    int i;
                    for(i=0; i<vector_size(v) ;i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                }
            }
            }
            break;

        case kHashErase: {
            BOOL global = FALSE;
            BOOL local = FALSE;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    local = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(argv) == 3) {
                char* var_name = string_c_str(vector_item(argv, 1));
                char* key = string_c_str(vector_item(argv, 2));

                if(strlen(var_name) > 1 && var_name[0] == '$') {
                    sRef* ref2;
                    hash_obj* top_stack
                         = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                    ref2 = hash_item(top_stack, var_name + 1);
                    if(ref2 == NULL && object) {
                        ref2 = hash_item(object->mRefs, var_name + 1);
                        if(ref2 == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                ref2 = hash_item(parent->mRefs, var_name + 1);
                                if(ref2) break;
                                parent = parent->mParent;
                            }
                        }
                    }
                    if(ref2 == NULL) {
                        ref2 = hash_item(gRefs, var_name + 1);
                    }

                    if(ref2) {
                        if(ref2->mKind == kMCHash && memchecker_is_enable_mem(ref2->mMem) == kMCHash) {
                            hash_obj* hash = ref2->mMem;
                            string_obj* item = hash_item(hash, key);

                            if(item) {
                                string_delete(item);
                                hash_erase(hash, key);
                                *rcode = 0;
                            }
                        }
                        else {
                            err_msg("invalid refference", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else if(local) {
                    hash_obj* top_stack
                         = vector_item(gStackFrameHashs, vector_size(gStackFrameHashs)-1);
                    hash_obj* hash = hash_item(top_stack, var_name);
                    if(hash) {
                        string_obj* item = hash_item(hash, key);
                        if(item) {
                            string_delete(item);
                            hash_erase(hash, key);
                            *rcode = 0;
                        }
                    }
                }
                else if(object && !global) {
                    hash_obj* hash = hash_item(object->mHashs, var_name);
                    if(hash) {
                        string_obj* item = hash_item(hash, key);
                        if(item) {
                            string_delete(item);
                            hash_erase(hash, key);
                            *rcode = 0;
                        }
                    }
                } 
                else {
                    hash_obj* hash = hash_item(gHashs, var_name);
                    if(hash) {
                        string_obj* item = hash_item(hash, key);
                        if(item) {
                            string_delete(item);
                            hash_erase(hash, key);
                            *rcode = 0;
                        }
                    }
                }
            }
            }
            break;

        case kDef: {
            BOOL print = FALSE;
            char* arg_name = NULL;
            enum eLineField lf = gLineField;
            BOOL global = FALSE;
            BOOL print_arg_name = FALSE;
            BOOL mem = FALSE;
            BOOL override = FALSE;
            BOOL new_ = FALSE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-A") == 0) {
                    print_arg_name = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-a") == 0 && l+1 < vector_size(argv)) {
                    arg_name = STRDUP(string_c_str((vector_item(argv, l+1))));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-override") == 0) {
                    override = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            /// -new
            if(new_) {
                if(vector_size(blocks) >= 1) {
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    sFunction* fun = sFunction_new("refference", statments, arg_name, NULL, 0);

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", fun);
#else
                    snprintf(buf, 1024, "%p\n", fun);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        if(arg_name) FREE(arg_name);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else {
                    if(input) {
                        string_obj* str = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                        if(ret == 1) {
                            string_delete(str);
                            *rcode = 1;
                            break;
                        }
                        else if(ret < 0)
                        {
                            *rcode = 2;
                            err_msg("interrupt", sname, sline);
                            string_delete(str);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                        
                        sStatments* statments = STATMENTS_NEW();
                        int sline2 = 1;
                        if(!parse(string_c_str(str), "def", &sline2, statments)) 
                        {
                            string_delete(str);
                            sStatments_delete(statments);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }

                        string_delete(str);

                        sFunction* fun = sFunction_new("refference", statments, arg_name, NULL, 0);

                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", fun);
#else
                        snprintf(buf, 1024, "%p\n", fun);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            sStatments_delete(statments);
                            return FALSE;
                        }

                        sStatments_delete(statments);

                        *rcode = 0;
                    }
                    else {
                        sStatments* statments = STATMENTS_NEW();
                        sFunction* fun = sFunction_new("refference", statments, arg_name, NULL,0);

                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", fun);
#else
                        snprintf(buf, 1024, "%p\n", fun);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            sStatments_delete(statments);
                            return FALSE;
                        }
                        *rcode = 0;

                        sStatments_delete(statments);
                    }
                }
            }
            /// -mem
            else if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));
                    sFunction* fun;

                    if(object && !global) {
                        fun = hash_item(object->mMethods, name);

                        if(fun == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                fun = hash_item(parent->mMethods, name);
                                if(fun) break;
                                parent = parent->mParent;
                            }

                            if(fun == NULL) {
                                fun = hash_item(gFuncs, name);
                            }
                        }
                    }
                    else {
                        fun = hash_item(gFuncs, name);
                    }

                    if(fun) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", fun);
#else
                        snprintf(buf, 1024, "%p\n", fun);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            /// -A
            else if(print_arg_name) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    if(input) {
                        string_obj* arg_name2 = STRING_NEW("");
                        int result = statment_tree_internal_commands_read_nextin(nextin, arg_name2);
                        if(result == 1) {
                            string_delete(arg_name2);
                            *rcode = 1;
                            break;
                        }
                        else if(result == -1) {
                            *rcode = 2;
                            err_msg("interrupt", sname, sline);
                            if(arg_name) FREE(arg_name);
                            string_delete(arg_name2);
                            return FALSE;
                        }

                        if(object && !global) {
                            sFunction* fun = hash_item(object->mMethods, name);
                            if(fun == NULL) {
                                err_msg("not exist function", sname, sline);
                                if(arg_name) FREE(arg_name);
                                string_delete(arg_name2);
                                return FALSE;
                            }
                            string_put(fun->arg_name, string_c_str(arg_name2));

                            if(print) { 
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    string_delete(arg_name2);
                                    return FALSE;
                                }
                            }
                        }
                        else {
                            sFunction* fun = hash_item(gFuncs, name);
                            if(fun == NULL) {
                                err_msg("not exist function", sname, sline);
                                if(arg_name) FREE(arg_name);
                                string_delete(arg_name2);
                                return FALSE;
                            }
                            string_put(fun->arg_name, string_c_str(arg_name2));
                            if(print) { 
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    string_delete(arg_name2);
                                    return FALSE;
                                }
                            }
                        }

                        string_delete(arg_name2);
                    }
                    else {
                        if(object && !global) {
                            sFunction* fun = hash_item(object->mMethods, name);

                            if(fun == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    fun = hash_item(parent->mMethods, name);
                                    if(fun) break;
                                    parent = parent->mParent;
                                }

                                if(fun == NULL) {
                                    fun = hash_item(gFuncs, name);
                                }
                            }

                            if(fun) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                            }
                        }
                        else {
                            sFunction* fun = hash_item(gFuncs, name);

                            if(fun) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->arg_name)))
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                                {
                                    err_msg("singal interrupt", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                            }
                        }
                    }

                    *rcode = 0;
                }
            }
            else {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));

                    if(vector_size(blocks) >= 1) {
                        sBlock* block = vector_item(blocks, 0);
                        sStatments* statments = block->mStatments;

                        if(strlen(name) > 1 && name[0] == '$') {
                            sRef* ref2;
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref2 = hash_item(top_stack, name + 1);
                            if(ref2 == NULL && object) {
                                ref2 = hash_item(object->mRefs, name + 1);
                                if(ref2 == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        ref2 = hash_item(parent->mRefs, name + 1);
                                        if(ref2) break;
                                        parent = parent->mParent;
                                    }
                                }
                            }
                            if(ref2 == NULL) {
                                ref2 = hash_item(gRefs, name + 1);
                            }

                            if(ref2) {
                                if(ref2->mKind == kMCFunction && memchecker_is_enable_mem(ref2->mMem) == kMCFunction) {
                                    if(override) {
                                        sFunction* fun = ref2->mMem;
                                        if(fun) {
                                            if(fun->statments) sStatments_delete(fun->statments);
                                            fun->statments = STATMENTS_NEW2(statments);
                                        }
                                    }
                                    else {
                                        err_msg("require -override option on input def of refference", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        return FALSE;
                                    }
                                    *rcode = 0;
                                }
                                else {
                                    err_msg("invalid refference", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                            }
                        }
                        else if(object && !global) {
                            if(override) {
                                sFunction* fun = hash_item(object->mMethods, name);
                                if(fun) {
                                    if(fun->statments) sStatments_delete(fun->statments);
                                    fun->statments = STATMENTS_NEW2(statments);
                                }
                                else {
                                    err_msg("not exist function", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                            }
                            else {
                                sFunction* old_fun = hash_item(object->mMethods, name);
                                sFunction* new_fun = sFunction_new(name, statments, arg_name, old_fun, 1);

                                hash_put(object->mMethods, name, new_fun);
                            }
                        }
                        else {
                            if(override) {
                                sFunction* fun = hash_item(gFuncs, name);

                                if(fun) {
                                    if(fun->statments) sStatments_delete(fun->statments);
                                    fun->statments = STATMENTS_NEW2(statments);
                                }
                                else {
                                    err_msg("not exist function", sname, sline);
                                    if(arg_name) FREE(arg_name);
                                    return FALSE;
                                }
                            }
                            else {
                                sFunction* old_fun = hash_item(gFuncs, name);
                                sFunction* new_fun = sFunction_new(name, statments, arg_name, old_fun, 1);
                                hash_put(gFuncs, name, new_fun);
                            }
                        }

                        *rcode = 0;
                    }
                    else {
                        if(input) {
                            string_obj* str = STRING_NEW("");
                            int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                            if(ret == 1) {
                                string_delete(str);
                                *rcode = 1;
                                break;
                            }
                            else if(ret < 0)
                            {
                                *rcode = 2;
                                err_msg("interrupt", sname, sline);
                                string_delete(str);
                                if(arg_name) FREE(arg_name);
                                return FALSE;
                            }
                            
                            sStatments* statments = STATMENTS_NEW();
                            int sline2 = 1;
                            if(!parse(string_c_str(str), "def", &sline2, statments)) 
                            {
                                sStatments_delete(statments);
                                string_delete(str);
                                if(arg_name) FREE(arg_name);
                                return FALSE;
                            }

                            if(strlen(name) > 1 && name[0] == '$') {
                                sRef* ref2;
                                hash_obj* top_stack
                                     = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                                ref2 = hash_item(top_stack, name + 1);
                                if(ref2 == NULL && object) {
                                    ref2 = hash_item(object->mRefs, name + 1);
                                    if(ref2 == NULL) {
                                        sObject* parent = object->mParent;
                                        while(parent) {
                                            ref2 = hash_item(parent->mRefs, name + 1);
                                            if(ref2) break;
                                            parent = parent->mParent;
                                        }
                                    }
                                }
                                if(ref2 == NULL) {
                                    ref2 = hash_item(gRefs, name + 1);
                                }

                                if(ref2) {
                                    if(ref2->mKind == kMCFunction && memchecker_is_enable_mem(ref2->mMem) == kMCFunction) {
                                        if(override) {
                                            sFunction* fun = ref2->mMem;
                                            if(fun) {
                                                if(fun->statments) sStatments_delete(fun->statments);
                                                fun->statments = STATMENTS_NEW2(statments);
                                            }
                                        }
                                        else {
                                            err_msg("require -override option on input def of refference", sname, sline);
                                            if(arg_name) FREE(arg_name);
                                            string_delete(str);
                                            sStatments_delete(statments);
                                            return FALSE;
                                        }

                                        *rcode = 0;
                                    }
                                    else {
                                        err_msg("invalid refference", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        string_delete(str);
                                        sStatments_delete(statments);
                                        return FALSE;
                                    }
                                }
                            }
                            else if(object && !global) {
                                if(override) {
                                    sFunction* fun = hash_item(object->mMethods, name);
                                    if(fun) {
                                        if(fun->statments) sStatments_delete(fun->statments);
                                        fun->statments = STATMENTS_NEW2(statments);
                                    }
                                    else {
                                        err_msg("not exist function", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        string_delete(str);
                                        sStatments_delete(statments);
                                        return FALSE;
                                    }
                                }
                                else {
                                    sFunction* old_fun = hash_item(object->mMethods, name);
                                    sFunction* new_fun = sFunction_new(name, statments, arg_name, old_fun, 1);

                                    hash_put(object->mMethods, name, new_fun);
                                }
                            }
                            else {
                                if(override) {
                                    sFunction* fun = hash_item(gFuncs, name);
                                    if(fun) {
                                        if(fun->statments) sStatments_delete(fun->statments);
                                        fun->statments = STATMENTS_NEW2(statments);
                                    }
                                    else {
                                        err_msg("not exist function", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        string_delete(str);
                                        sStatments_delete(statments);
                                        return FALSE;
                                    }
                                }
                                else {
                                    sFunction* old_fun = hash_item(gFuncs, name);
                                    sFunction* new_fun = sFunction_new(name, statments, arg_name, old_fun, 1);

                                    hash_put(gFuncs, name, new_fun);
                                }
                            }

                            if(print) { 
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    string_delete(str);
                                    if(arg_name) FREE(arg_name);
                                    sStatments_delete(statments);
                                    return FALSE;
                                }
                            }

                            *rcode = 0;

                            string_delete(str);
                            sStatments_delete(statments);
                        }
                        else {
                            if(strlen(name) > 1 && name[0] == '$') {
                                sRef* ref2;
                                hash_obj* top_stack
                                     = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                                ref2 = hash_item(top_stack, name + 1);
                                if(ref2 == NULL && object) {
                                    ref2 = hash_item(object->mRefs, name + 1);
                                    if(ref2 == NULL) {
                                        sObject* parent = object->mParent;
                                        while(parent) {
                                            ref2 = hash_item(parent->mRefs, name + 1);
                                            if(ref2) break;
                                            parent = parent->mParent;
                                        }
                                    }
                                }
                                if(ref2 == NULL) {
                                    ref2 = hash_item(gRefs, name + 1);
                                }

                                if(ref2) {
                                    if(ref2->mKind == kMCFunction && memchecker_is_enable_mem(ref2->mMem) == kMCFunction) {
                                        sFunction* fun = ref2->mMem;
                                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(fun->statments->mSource))) 
                                        {
                                            err_msg("signal interrupt", sname, sline);
                                            if(arg_name) FREE(arg_name);
                                            return FALSE;
                                        }
                                        *rcode = 0;
                                    }
                                    else {
                                        err_msg("invalid refference", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        return FALSE;
                                    }
                                }
                            }
                            else if(object && !global) {
                                sFunction* method = hash_item(object->mMethods, name);

                                if(method == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        method = hash_item(parent->mMethods, name);
                                        if(method) break;
                                        parent = parent->mParent;
                                    }
                                    if(method == NULL) {
                                        method = hash_item(gFuncs, name);
                                    }
                                }

                                if(method) {
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(method->statments->mSource))) 
                                    {
                                        err_msg("signal interrupt", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        return FALSE;
                                    }
                                    *rcode = 0;
                                }
                            }
                            else {
                                sFunction* func2 = hash_item(gFuncs, name);

                                if(func2) {
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(func2->statments->mSource))) 
                                    {
                                        err_msg("signal interrupt", sname, sline);
                                        if(arg_name) FREE(arg_name);
                                        return FALSE;
                                    }
                                    *rcode = 0;
                                }
                            }
                        }
                    }
                }
            }

            if(arg_name) FREE(arg_name);

            }
            break;

        case kClass: {
            BOOL print = FALSE;
            BOOL global = FALSE;
            BOOL mem = FALSE;
            BOOL override = FALSE;
            BOOL new_ = FALSE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-p") == 0) {
                    print = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-mem") == 0) {
                    mem = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-override") == 0) {
                    override = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-new") == 0) {
                    new_ = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(new_) {
                if(vector_size(blocks) >= 1) {
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    sClass* klass = sClass_new("refference", statments, NULL, 0);

                    char buf[1024];
#if defined(__SUNOS__)
                    snprintf(buf, 1024, "%#x\n", klass);
#else
                    snprintf(buf, 1024, "%p\n", klass);
#endif
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
                else {
                    if(input) {
                        string_obj* str = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                        if(ret == 1) {
                            string_delete(str);
                            *rcode = 1;
                            break;
                        }
                        else if(ret < 0)
                        {
                            *rcode = 2;
                            string_delete(str);
                            err_msg("interrupt", sname, sline);
                            return FALSE;
                        }
                        
                        sStatments* statments = STATMENTS_NEW();
                        int sline2 = 1;
                        if(!parse(string_c_str(str), "def", &sline2, statments)) 
                        {
                            sStatments_delete(statments);
                            string_delete(str);
                            return FALSE;
                        }

                        string_delete(str);

                        sClass* klass = sClass_new("refference", statments, NULL, 0);

                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", klass);
#else
                        snprintf(buf, 1024, "%p\n", klass);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            sStatments_delete(statments);
                            return FALSE;
                        }

                        *rcode = 0;

                        sStatments_delete(statments);
                    }
                    else {
                        sClass* klass = sClass_new("refference", NULL, NULL, 0);

                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", klass);
#else
                        snprintf(buf, 1024, "%p\n", klass);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            else if(mem) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* name = string_c_str(vector_item(argv, i));
                    sClass* klass = NULL;

                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCClass && memchecker_is_enable_mem(ref2->mMem) == kMCClass) {
                                klass = ref2->mMem;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(object && !global) {
                        klass = hash_item(object->mClasses, name);

                        if(klass == NULL) {
                            sObject* parent = object->mParent;
                            while(parent) {
                                klass = hash_item(parent->mClasses, name);
                                if(klass) break;
                                parent = parent->mParent;
                            }

                            if(klass == NULL) {
                                klass = hash_item(gClasses, name);
                            }
                        }
                    }
                    else {
                        klass = hash_item(gClasses, name);
                    }

                    if(klass) {
                        char buf[1024];
#if defined(__SUNOS__)
                        snprintf(buf, 1024, "%#x\n", klass);
#else
                        snprintf(buf, 1024, "%p\n", klass);
#endif
                        if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        *rcode = 0;
                    }
                }
            }
            else if(vector_size(argv) >= 2) {
                char* name = string_c_str(vector_item(argv, 1));

                if(vector_size(blocks) >= 1) {
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    if(strlen(name) > 1 && name[0] == '$') {
                        sRef* ref2;
                        hash_obj* top_stack
                             = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                        ref2 = hash_item(top_stack, name + 1);
                        if(ref2 == NULL && object) {
                            ref2 = hash_item(object->mRefs, name + 1);
                            if(ref2 == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    ref2 = hash_item(parent->mRefs, name + 1);
                                    if(ref2) break;
                                    parent = parent->mParent;
                                }
                            }
                        }
                        if(ref2 == NULL) {
                            ref2 = hash_item(gRefs, name + 1);
                        }

                        if(ref2) {
                            if(ref2->mKind == kMCClass && memchecker_is_enable_mem(ref2->mMem) == kMCClass) {
                                sClass* klass = ref2->mMem;
                                if(override) {
                                    if(klass) {
                                        if(klass->statments) sStatments_delete(klass->statments);
                                        klass->statments = STATMENTS_NEW2(statments);
                                    }
                                }
                                else {
                                    err_msg("need -override option in input class of refference", sname, sline);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            else {
                                err_msg("invalid refference", sname, sline);
                                return FALSE;
                            }
                        }
                    }
                    else if(object && !global) {
                        if(override) {
                            sClass* klass = hash_item(object->mClasses, name);
                            if(klass) {
                                if(klass->statments) sStatments_delete(klass->statments);
                                klass->statments = STATMENTS_NEW2(statments);
                            }
                        }
                        else {
                            sClass* old_klass = hash_item(object->mClasses, name);
                            sClass* new_klass = sClass_new(name, statments, old_klass, 1);

                            hash_put(object->mClasses, name, new_klass);
                        }
                    }
                    else {
                        if(override) {
                            sClass* klass = hash_item(gClasses, name);
                            if(klass) {
                                if(klass->statments) sStatments_delete(klass->statments);
                                klass->statments = STATMENTS_NEW2(statments);
                            }
                        }
                        else {
                            sClass* old_klass = hash_item(gClasses, name);
                            sClass* new_klass = sClass_new(name, statments, old_klass, 1);

                            hash_put(gClasses, name, new_klass);
                        }
                    }

                    *rcode = 0;
                }
                else {
                    if(input) {
                        string_obj* str = STRING_NEW("");
                        int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                        if(ret == 1) {
                            string_delete(str);
                            *rcode = 1;
                            break;
                        }
                        else if(ret < 0)
                        {
                            *rcode = 2;
                            string_delete(str);
                            err_msg("interrupt", sname, sline);
                            return FALSE;
                        }
                        
                        sStatments* statments = STATMENTS_NEW();
                        int sline2 = 1;
                        if(!parse(string_c_str(str), "class", &sline2, statments)) 
                        {
                            sStatments_delete(statments);
                            string_delete(str);
                            return FALSE;
                        }

                        if(strlen(name) > 1 && name[0] == '$') {
                            sRef* ref2;
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref2 = hash_item(top_stack, name + 1);
                            if(ref2 == NULL && object) {
                                ref2 = hash_item(object->mRefs, name + 1);
                                if(ref2 == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        ref2 = hash_item(parent->mRefs, name + 1);
                                        if(ref2) break;
                                        parent = parent->mParent;
                                    }
                                }
                            }
                            if(ref2 == NULL) {
                                ref2 = hash_item(gRefs, name + 1);
                            }

                            if(ref2) {
                                if(ref2->mKind == kMCClass && memchecker_is_enable_mem(ref2->mMem) == kMCClass) {
                                    sClass* klass = ref2->mMem;
                                    if(override) {
                                        if(klass) {
                                            if(klass->statments) sStatments_delete(klass->statments);
                                            klass->statments = STATMENTS_NEW2(statments);
                                        }
                                    }
                                    else {
                                        err_msg("need -override option in input class of refference", sname, sline);
                                        string_delete(str);
                                        sStatments_delete(statments);
                                        return FALSE;
                                    }
                                    *rcode = 0;
                                }
                                else {
                                    err_msg("invalid refference", sname, sline);
                                    string_delete(str);
                                    sStatments_delete(statments);
                                    return FALSE;
                                }
                            }
                        }
                        else if(object && !global) {
                            if(override) {
                                sClass* klass = hash_item(object->mClasses, name);
                                if(klass) {
                                    if(klass->statments) sStatments_delete(klass->statments);
                                    klass->statments = STATMENTS_NEW2(statments);
                                }
                            }
                            else {
                                sClass* old_klass = hash_item(object->mClasses, name);
                                sClass* new_klass = sClass_new(name, statments, old_klass, 1);

                                hash_put(object->mClasses, name, new_klass);
                            }
                        }
                        else {
                            if(override) {
                                sClass* klass = hash_item(gClasses, name);
                                if(klass) {
                                    if(klass->statments) sStatments_delete(klass->statments);
                                    klass->statments = STATMENTS_NEW2(statments);
                                }
                            }
                            else {
                                sClass* old_klass = hash_item(gClasses, name);
                                sClass* new_klass = sClass_new(name, statments, old_klass, 1);

                                hash_put(gClasses, name, new_klass);
                            }
                        }

                        if(print) { 
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                            {
                                err_msg("signal interrupt", sname, sline);
                                string_delete(str);
                                sStatments_delete(statments);
                                return FALSE;
                            }
                        }

                        string_delete(str);

                        sStatments_delete(statments);

                        *rcode = 0;
                    }
                    else {
                        if(strlen(name) > 1 && name[0] == '$') {
                            sRef* ref2;
                            hash_obj* top_stack
                                 = vector_item(gStackFrameRefs, vector_size(gStackFrameRefs)-1);
                            ref2 = hash_item(top_stack, name + 1);
                            if(ref2 == NULL && object) {
                                ref2 = hash_item(object->mRefs, name + 1);
                                if(ref2 == NULL) {
                                    sObject* parent = object->mParent;
                                    while(parent) {
                                        ref2 = hash_item(parent->mRefs, name + 1);
                                        if(ref2) break;
                                        parent = parent->mParent;
                                    }
                                }
                            }
                            if(ref2 == NULL) {
                                ref2 = hash_item(gRefs, name + 1);
                            }

                            if(ref2) {
                                if(ref2->mKind == kMCClass && memchecker_is_enable_mem(ref2->mMem) == kMCClass) {
                                    sClass* klass = ref2->mMem;
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(klass->statments->mSource))) 
                                    {
                                        err_msg("signal interrupt", sname, sline);
                                        return FALSE;
                                    }
                                    *rcode = 0;
                                }
                                else {
                                    err_msg("invalid refference", sname, sline);
                                    return FALSE;
                                }
                            }
                        }
                        else if(object && !global) {
                            sClass* klass = hash_item(object->mClasses, name);

                            if(klass == NULL) {
                                sObject* parent = object->mParent;
                                while(parent) {
                                    klass = hash_item(parent->mClasses, name);
                                    if(klass) break;
                                    parent = parent->mParent;
                                }

                                if(klass == NULL) {
                                    klass = hash_item(gClasses, name);
                                }
                            }

                            if(klass) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(klass->statments->mSource))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                        }
                        else {
                            sClass* klass = hash_item(gClasses, name);

                            if(klass) {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(klass->statments->mSource))) 
                                {
                                    err_msg("signal interrupt", sname, sline);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                        }
                    }
                }
            }

            }
            break;

        case kSelf: {
            if(object) {
                char buf[1024];
#if defined(__SUNOS__)
                snprintf(buf, 1024, "%#x\n", object);
#else
                snprintf(buf, 1024, "%p\n", object);
#endif
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                *rcode = 0;
            }
            }
            break;

        case kInherit: {
            if(running_fun) {
                char* arg0 = string_c_str(running_fun->name);
                sInnerCommand* inner_fun = hash_item(gInnerCommands, arg0);

                if(running_fun->parent) {
                    sFunction* fun = running_fun->parent; 

                    /// 引数名が指定されていなければスタックフレームを増やす ///
                    vector_obj* fun_argv_before;
                    vector_obj* fun_argv;
                    if(strcmp(string_c_str(fun->arg_name), "") == 0) {
                        // スタックを掘る
                        int k;
                        vector_obj* argv2 = sAry_new(30, 1);
                        for(k=1; k<vector_size(argv); k++) {
                            char* value = string_c_str(vector_item(argv, k));
                            vector_add(argv2, STRING_NEW(value));
                        }
                        dig_stack_frame(sname, sline, &fun_argv_before, argv2);
                        fun_argv = NULL;
                    }
                    /// 引数名が指定されていなければスタックフレームは増やさない
                    else {
                        /// 前の引数を保存 ///
                        fun_argv_before = hash_item(gArrays
                                                , string_c_str(fun->arg_name));

                        /// 引数を渡す ///
                        int k;
                        fun_argv = sAry_new(30, 1);
                        for(k=1; k<vector_size(argv); k++) {
                            char* value = string_c_str(vector_item(argv, k));
                            vector_add(fun_argv, STRING_NEW(value));
                        }
                        
                        hash_put(gArrays, string_c_str(fun->arg_name), fun_argv);

                        /// スタックフレームの記録を付ける
                        vector_add(gStackTraceFName, STRING_NEW(sname));
                        vector_add(gStackTraceLineNum, (void*)sline);
                    }

                    /// 実行 ///
                    *rcode = run(fun->statments, title
                        , nextout, nextin, nexterr, return_, TRUE, break_, FALSE, blocks, FALSE, envs, object, fun, running_class);
                    *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                    *break_ = FALSE;

                    string_obj* sname_strace;
                    int line_strace;
                    if(fun_argv == NULL) {
                        burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);
                    }
                    else {
                        int k;
                        for(k=0; k<vector_size(fun_argv); k++) {
                            string_delete(vector_item(fun_argv, k));
                        }
                        sAry_delete(fun_argv);
                        
                        if(fun_argv_before) {
                            hash_put(gArrays, string_c_str(fun->arg_name) , fun_argv_before);
                        }
                        else {
                            hash_erase(gArrays, string_c_str(fun->arg_name));
                        }

                        /// スタックフレームの記録を消す
                        sname_strace = vector_pop_back(gStackTraceFName);
                        line_strace = (int)vector_pop_back(gStackTraceLineNum);
                    }

                    if(*rcode < 0) {
                        string_push_back(gErrMsg, string_c_str(sname_strace));
                        string_delete(sname_strace);
                        char tmp[1024];
                        snprintf(tmp, 1024, ":%d\n", line_strace);
                        string_push_back(gErrMsg, tmp);
                        
                        return FALSE;
                    }
                    else {
                        string_delete(sname_strace);
                    }
                }
                else if(object == NULL && (inner_fun || get_command_kind(arg0))) {
                    if(inner_fun) {
                        vector_obj* argv2 = sAry_new(30, 1);
                        int k;
                        vector_add(argv2, STRING_NEW(arg0));
                        for(k=1; k<vector_size(argv); k++) {
                            char* value = string_c_str(vector_item(argv, k));
                            vector_add(argv2, STRING_NEW(value));
                        }
                        vector_obj* fun_argv_before;
                        dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                        BOOL r = inner_fun->mFun(rcode, argv2
                                    , blocks, parent_blocks
                                    , nextout, nextin, nexterr
                                    , title, input, sname, sline);
                        *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                        *break_ = FALSE;

                        // スタックを埋める
                        string_obj* sname_strace;
                        int line_strace;
                        burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                        if(*rcode < 0) {
                            string_push_back(gErrMsg, string_c_str(sname_strace));
                            string_delete(sname_strace);
                            char tmp[1024];
                            snprintf(tmp, 1024, ":%d\n", line_strace);
                            string_push_back(gErrMsg, tmp);
                            
                            return FALSE;
                        }
                        else {
                            string_delete(sname_strace);
                        }
                    }
                    else {
                        command->mKind = get_command_kind(arg0);

                        if(command->mKind == kCommand) {
                            err_msg("can't inherit external command or can't find the parent.", sname, sline);
                            return FALSE;
                        }

                        /// 引数を渡す ///
                        int k;
                        vector_obj* argv2 = sAry_new(30, 1);
                        vector_add(argv2, STRING_NEW(arg0));
                        for(k=1; k<vector_size(argv); k++) {
                            char* value = string_c_str(vector_item(argv, k));
                            vector_add(argv2, STRING_NEW(value));
                        }
                        vector_obj* fun_argv_before;
                        dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                        BOOL r = statment_tree_internal_commands(
                              command, rcode
                            , argv2, blocks, parent_blocks, nextout
                            , nextin, nexterr, j, title, input
                            , return_, enable_return, break_
                            , enable_break, sname, sline, envs
                            , object, running_fun, running_class);
                        *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                        *break_ = FALSE;

                        // スタックを埋める
                        string_obj* sname_strace;
                        int line_strace;
                        burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                        if(!r) {
                            string_push_back(gErrMsg, string_c_str(sname_strace));
                            string_delete(sname_strace);
                            char tmp[1024];
                            snprintf(tmp, 1024, ":%d\n", line_strace);
                            string_push_back(gErrMsg, tmp);

                            return FALSE;
                        }
                        else {
                            string_delete(sname_strace);
                        }
                    }
                }
                else {
                    err_msg("parent function do not exists", sname, sline);
                    return FALSE;
                }
            }
            else if(running_class && running_class->parent) {
                sClass* klass = running_class->parent;

                /// 引数を渡す ///
                int k;
                vector_obj* argv2 = sAry_new(30, 1);
                for(k=1; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    vector_add(argv2, STRING_NEW(value));
                }
                vector_obj* fun_argv_before;
                dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                *rcode = run(klass->statments, title, nextout
                                , nextin, nexterr
                                , return_, TRUE, break_, FALSE, parent_blocks, FALSE, envs, object, NULL, klass);
                *return_ = FALSE; // ユーザー関数が復帰したらreturn終わり
                *break_ = FALSE;

                // スタックを埋める
                string_obj* sname_strace;
                int line_strace;
                burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                if(*rcode < 0) {
                    string_push_back(gErrMsg, string_c_str(sname_strace));
                    string_delete(sname_strace);
                    char tmp[1024];
                    snprintf(tmp, 1024, ":%d\n", line_strace);
                    string_push_back(gErrMsg, tmp);

                    return FALSE;
                }
                else {
                    string_delete(sname_strace);
                }
            }
            else {
                err_msg("parent function or class do not exists", sname, sline);
                return FALSE;
            }
            }
            break;


        case kStackFrame: {
            *rcode = 0;
            int i;
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Vars +++"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gStackFrame); i++) {
                char buf[256];
                snprintf(buf, 256, "+++ %d +++", i);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                hash_obj* hash = vector_item(gStackFrame, i);
                hash_it* it = hash_loop_begin(hash);
                while(it) {
                    char* key = hash_loop_key(it);
                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                }
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Hashs +++"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gStackFrameHashs); i++) {
                char buf[256];
                snprintf(buf, 256, "+++ %d +++", i);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                hash_obj* hash = vector_item(gStackFrameHashs, i);
                hash_it* it = hash_loop_begin(hash);
                while(it) {
                    char* key = hash_loop_key(it);
                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                }
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Arrays +++"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gStackFrameArrays); i++) {
                char buf[256];
                snprintf(buf, 256, "+++ %d +++", i);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                hash_obj* hash = vector_item(gStackFrameArrays, i);
                hash_it* it = hash_loop_begin(hash);
                while(it) {
                    char* key = hash_loop_key(it);
                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                }
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gStackFrameObjects); i++) {
                char buf[256];
                snprintf(buf, 256, "+++ %d +++", i);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                hash_obj* hash = vector_item(gStackFrameObjects, i);
                hash_it* it = hash_loop_begin(hash);
                while(it) {
                    char* key = hash_loop_key(it);
                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                }
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Refs +++"))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gStackFrameRefs); i++) {
                char buf[256];
                snprintf(buf, 256, "+++ %d +++", i);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                hash_obj* hash = vector_item(gStackFrameRefs, i);
                hash_it* it = hash_loop_begin(hash);
                while(it) {
                    char* key = hash_loop_key(it);
                    if(!statment_tree_internal_commands_write_nextout(nextout, key))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    it = hash_loop_next(it);
                }
            }
            }
            break;

        case kShow: {
            int i;
            BOOL verbose = FALSE;
            BOOL global = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-v") == 0) {
                    verbose = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }
            if(!global && object) {
                if(!statment_tree_internal_commands_write_nextout(nextout, "++++++ Object Attributes ++++++\n"))
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_write_nextout(nextout, "++++++ Global Space Variables ++++++\n"))
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Globals +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            hash_it* it;
            if(!global && object) {
                it = hash_loop_begin(object->mGlobals);
            }
            else {
                it = hash_loop_begin(gGlobals);
            }

            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(verbose) {
                    if(!statment_tree_internal_commands_write_nextout(nextout,   ":")) 
                    {
                        err_msg("interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout,   string_c_str(hash_loop_item(it)))) 
                    {
                        err_msg("interrupt", sname, sline);
                        return FALSE;
                    }
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Arrays +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mArrays);
            }
            else {
                it = hash_loop_begin(gArrays);
            }

            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Hashs +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mHashs);
            }
            else {
                it = hash_loop_begin(gHashs);
            }

            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Refferences +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mRefs);
            }
            else {
                it = hash_loop_begin(gRefs);
            }
            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mObjects);
            }
            else {
                it = hash_loop_begin(gObjects);
            }
            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Funcs +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mMethods);
            }
            else {
                it = hash_loop_begin(gFuncs);
            }
            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Classes +++\n"))
            {
                err_msg("interrupt", sname, sline);
                return FALSE;
            }

            if(!global && object) {
                it = hash_loop_begin(object->mClasses);
            }
            else {
                it = hash_loop_begin(gClasses);
            }
            while(it != NULL) {
                if(!statment_tree_internal_commands_write_nextout(nextout,  hash_loop_key(it))) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout,  "\n")) 
                {
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }

                it = hash_loop_next(it);
            }
            
            *rcode = 0;
            }
            break;

        case kSweep: {
            int i;
            BOOL funcs = FALSE;
            BOOL classes = FALSE;
            BOOL regs = FALSE;
            BOOL global_pipes = FALSE;
            BOOL global = FALSE;
            BOOL gc = FALSE;
            BOOL all = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-f") == 0) {
                    funcs = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-all") == 0) {
                    all = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-gc") == 0) {
                    gc = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0) {
                    classes = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-reg") == 0) {
                    regs = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-gp") == 0) {
                    global_pipes = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(gc) {
                int count = saphire_gc_sweep(nextout);

                if(count < 0) {
                    return FALSE;
                }

                char buf[BUFSIZ];
                snprintf(buf, BUFSIZ, "%d objects deleted\n", count);
                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    return FALSE;
                }

                *rcode = 0;
            }
            else if(funcs) {
                if(!global && object) {
                    hash_it* it = hash_loop_begin(object->mMethods);
                    while(it) {
                        sFunction_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    
                    hash_clear(object->mMethods);
                    *rcode = 0;
                }
                else {
                    hash_it* it = hash_loop_begin(gFuncs);
                    while(it) {
                        sFunction_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gFuncs);
                    *rcode = 0;
                }
            }
            else if(classes) {
                if(!global && object) {
                    hash_it* it = hash_loop_begin(object->mClasses);
                    while(it) {
                        sClass_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    
                    hash_clear(object->mClasses);
                    *rcode = 0;
                }
                else {
                    hash_it* it = hash_loop_begin(gClasses);
                    while(it) {
                        sClass_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    
                    hash_clear(gClasses);
                    *rcode = 0;
                }
            }
            else if(regs) {
                hash_it* it = hash_loop_begin(gRegexs);
                while(it != NULL) {
                    onig_free(hash_loop_item(it));
                    it = hash_loop_next(it);
                }
                hash_clear(gRegexs);

                it = hash_loop_begin(gRegexsI);
                while(it != NULL) {
                    onig_free(hash_loop_item(it));
                    it = hash_loop_next(it);
                }
                hash_clear(gRegexsI);

                it = hash_loop_begin(gRegexsM);
                while(it != NULL) {
                    onig_free(hash_loop_item(it));
                    it = hash_loop_next(it);
                }
                hash_clear(gRegexsM);

                it = hash_loop_begin(gRegexsIM);
                while(it != NULL) {
                    onig_free(hash_loop_item(it));
                    it = hash_loop_next(it);
                }
                hash_clear(gRegexsIM);
                *rcode = 0;
            }
            else if(global_pipes) {
                string_put(gGlobalPipe, "");

                for(i=0; i<10; i++) {
                    string_put(gGlobalPipeNum[i], "");
                }
                *rcode = 0;
            }
            else if(all) {
                if(!global && object) {
                    hash_it* it = hash_loop_begin(object->mGlobals);
                    while(it) {
                        sGlobal_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(object->mGlobals);
                    it = hash_loop_begin(object->mArrays);
                    while(it) {
                        vector_obj* v = hash_loop_item(it);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        sAry_delete(v);
                        it = hash_loop_next(it);
                    }
                    hash_clear(object->mArrays);
                    it = hash_loop_begin(object->mHashs);
                    while(it) {
                        hash_obj* h = hash_loop_item(it);

                        hash_it* it2 = hash_loop_begin(h);
                        while(it2) {
                            string_delete(hash_loop_item(it2));
                            it2 = hash_loop_next(it2);
                        }

                        sHash_delete(h);

                        it = hash_loop_next(it);
                    }
                    hash_clear(object->mHashs);
                    it = hash_loop_begin(object->mObjects);
                    while(it) {
                        sObject_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(object->mObjects);
                    it = hash_loop_begin(object->mRefs);
                    while(it) {
                        sRef* ref = hash_loop_item(it);
                        sRef_delete(ref);
                        it = hash_loop_next(it);
                    }
                    hash_clear(object->mRefs);
                }
                else {
                    hash_it* it = hash_loop_begin(gGlobals);
                    while(it) {
                        sGlobal_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gGlobals);
                    it = hash_loop_begin(gArrays);
                    while(it) {
                        vector_obj* v = hash_loop_item(it);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        sAry_delete(v);
                        it = hash_loop_next(it);
                    }
                    hash_clear(gArrays);
                    it = hash_loop_begin(gHashs);
                    while(it) {
                        hash_obj* h = hash_loop_item(it);

                        hash_it* it2 = hash_loop_begin(h);
                        while(it2) {
                            string_delete(hash_loop_item(it2));
                            it2 = hash_loop_next(it2);
                        }

                        sHash_delete(h);

                        it = hash_loop_next(it);
                    }
                    hash_clear(gHashs);
                    it = hash_loop_begin(gObjects);
                    while(it) {
                        sObject_delete(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gObjects);
                    it = hash_loop_begin(gRefs);
                    while(it) {
                        sRef* ref = hash_loop_item(it);
                        sRef_delete(ref);
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRefs);
                }
                *rcode = 0;
            }
            else if(vector_size(argv) >= 2) {
                if(!global && object) {
                    int i;
                    for(i=1; i<vector_size(argv); i++) {
                        char* arg = string_c_str(vector_item(argv, i));

                        string_obj* str = hash_item(object->mGlobals, arg);
                        if(str) {
                            string_delete(str);
                            hash_erase(object->mGlobals, arg);
                            *rcode = 0;
                        }

                        vector_obj* v = hash_item(object->mArrays, arg);
                        if(v) {
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            sAry_delete(v);
                            hash_erase(object->mArrays, arg);
                            *rcode = 0;
                        }

                        hash_obj* h = hash_item(object->mHashs, arg);
                        if(h) {
                            hash_it* it2 = hash_loop_begin(h);
                            while(it2) {
                                string_delete(hash_loop_item(it2));
                                it2 = hash_loop_next(it2);
                            }
                            sHash_delete(h);
                            hash_erase(object->mHashs, arg);
                            *rcode = 0;
                        }

                        sObject* o = hash_item(object->mObjects, arg);
                        if(o) {
                            sObject_delete(o);
                            hash_erase(object->mObjects, arg);
                            *rcode = 0;
                        }

                        sRef* r = hash_item(object->mRefs, arg);
                        if(r) {
                            sRef_delete(r);
                            hash_erase(object->mRefs, arg);
                            *rcode = 0;
                        }

                        sFunction* f = hash_item(object->mMethods, arg);
                        if(f) {
                            sFunction_delete(f);
                            hash_erase(object->mMethods, arg);
                            *rcode = 0;
                        }
                        sClass* c = hash_item(object->mClasses, arg);
                        if(c) {
                            sClass_delete(c);
                            hash_erase(object->mClasses, arg);
                            *rcode = 0;
                        }
                    }
                }
                else {
                    int i;
                    for(i=1; i<vector_size(argv); i++) {
                        char* arg = string_c_str(vector_item(argv, i));

                        string_obj* str = hash_item(gGlobals, arg);
                        if(str) {
                            string_delete(str);
                            hash_erase(gGlobals, arg);
                            *rcode = 0;
                        }

                        vector_obj* v = hash_item(gArrays, arg);
                        if(v) {
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            sAry_delete(v);
                            hash_erase(gArrays, arg);
                            *rcode = 0;
                        }

                        hash_obj* h = hash_item(gHashs, arg);
                        if(h) {
                            hash_it* it2 = hash_loop_begin(h);
                            while(it2) {
                                string_delete(hash_loop_item(it2));
                                it2 = hash_loop_next(it2);
                            }
                            sHash_delete(h);
                            hash_erase(gHashs, arg);
                            *rcode = 0;
                        }

                        sObject* o = hash_item(gObjects, arg);
                        if(o) {
                            sObject_delete(o);
                            hash_erase(gObjects, arg);
                            *rcode = 0;
                        }

                        sRef* r = hash_item(gRefs, arg);
                        if(r) {
                            sRef_delete(r);
                            hash_erase(gRefs, arg);
                            *rcode = 0;
                        }

                        sFunction* f = hash_item(gFuncs, arg);
                        if(f) {
                            sFunction_delete(f);
                            hash_erase(gFuncs, arg);
                            *rcode = 0;
                        }

                        sClass* c = hash_item(gClasses, arg);
                        if(c) {
                            sClass_delete(c);
                            hash_erase(gClasses, arg);
                            *rcode = 0;
                        }
                    }
                }
            }

            }
            break;

        case kSubshell: {
            if(command->mExtra) {
                sSubshell* s = (sSubshell*) command->mExtra;
                *rcode = run(s->contents, title, nextout
                                , nextin, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
            }
            }
            break;

        case kMSleep: {
            if(vector_size(argv) == 2) {
                /// 出力 ///
                char c [] = {'.', 'o', 'O'};
                int n = atoi(string_c_str(vector_item(argv, 1)));
                int i;
                for(i=0; i < n*5; i++) {
                    *rcode = 0;

                    char buf[32];
                    snprintf(buf, 32, "%c\033[D", c[i % 3]);

                    if(!statment_tree_internal_commands_write_nextout(nextout, buf)) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!sWFd_flash(nextout)) {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }

                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        gKitutukiSigInt = FALSE;
                        return FALSE;
                    }

                    usleep(200000);
                }
            }
            }
            break;

        case kTrue: 
            *rcode = 0;
            break;

        case kFalse:
            break;

        case kTest: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));

                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str;

            /// 標準入力で受け取る場合は第1引数に代入 ///
            if(input) {
                str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    *rcode = 2;
                    string_delete(str);
                    err_msg("interrupt", sname, sline);
                    return FALSE;
                }
            }
            /// 違う場合はstr = NULL
            else {
                str = NULL;
            }

            if(!statment_tree_internal_commands_test(rcode, argv, str, sname, sline)) {
                if(str)string_delete(str);
                return FALSE;
            }

            if(str)string_delete(str);
            }
            break;

        case kIndex: {
            BOOL quiet = FALSE;
            BOOL new_line = TRUE;
            BOOL flg_n = FALSE;
            int n;
            BOOL flg_c = FALSE;
            int c;
            enum eKanjiCode code = gKanjiCode;
            BOOL byte = FALSE;
            BOOL terminal = FALSE;
            BOOL ignore_case = FALSE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-i") == 0) {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-t") == 0) {
                    terminal = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
                    flg_c = TRUE;
                    c = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            char* word;
            char* target;
            int start;
            int match_count;
            string_obj* str = STRING_NEW("");

            if(input) {
                if(vector_size(argv) != 2) {
                    err_msg("index -I string", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                /// 文字列 ///
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                target = string_c_str(str);

                /// 検索文字列 ///
                word = string_c_str(vector_item(argv, 1));

                /// 検索文字列開始位置 ///
                if(flg_n) {
                    start = n;

                    if(start < 0) {
                        start = str_kanjilen(code, target) + start;
                    }

                    if(start < 0 || start >= str_kanjilen(code, target))
                    {
                        string_delete(str);
                        break;
                    }
                }
                else {
                    start = 0;
                }

                /// 検索文字列の検索回数 ///
                if(flg_c) {
                    match_count = c;
                    if(match_count <= 0) {
                        err_msg("index -> invalid -c range", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
                else {
                    match_count = 1;
                }
            }
            else {
                if(vector_size(argv) != 3) {
                    err_msg("index -> invalid option number", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                /// 検索文字列 ///
                word = string_c_str(vector_item(argv, 2));

                /// 文字列 ///
                target = string_c_str(vector_item(argv, 1));

                /// 検索文字列開始位置 ///
                if(flg_n) {
                    start = n;

                    if(start < 0) {
                        start = str_kanjilen(code, target) + start;
                    }

                    if(start < 0 || start >= str_kanjilen(
                            code, target)) 
                    {
                        string_delete(str);
                        break;
                    }
                }
                else {
                    start = 0;
                }

                /// 検索文字列の検索回数 ///
                if(flg_c) {
                    match_count = c;
                    if(match_count <= 0) {
                        err_msg("index -> invalid -c range", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
                else {
                    match_count = 1;
                }
            }

            char* start_byte = str_kanjipos2pointer(code, target, start);
            int count = match_count;
            char* p = start_byte;
            char* result = NULL;
            if(ignore_case) {
                while(p < start_byte + strlen(start_byte)) {
                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    result = (char*)strcasestr((const char*) p, (const char*)word);
                    if(result) {
                        count--;
                        if(count == 0) {
                            break;
                        }
                        p = result+strlen(word);
                    }
                    else {
                        break;
                    }
                }
            }
            else {
                while(p < start_byte + strlen(start_byte)) {
                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    result = strstr(p, word);
                    if(result) {
                        count--;
                        if(count == 0) {
                            break;
                        }
                        p = result+strlen(word);
                    }
                    else {
                        break;
                    }
                }
            }

            char msg[64];
            if(result == NULL || count !=0) {
                snprintf(msg, 64, "-1");
            }
            else {
                int c;
                if(byte) {
                    c = result - target;
                }
                else if(terminal) {
                    int pos = str_pointer2kanjipos(code, target, result);
                    c = str_termlen2(code, target, pos);
                }
                else {
                    c = str_pointer2kanjipos(code, target, result);
                }
                snprintf(msg, 64, "%d", c);
                *rcode = 0;
            }

            /// 出力 ///
            if(quiet == FALSE) {
                if(!statment_tree_internal_commands_write_nextout(nextout, msg))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                if(new_line) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
            }
            break;

        case kRIndex: {
            BOOL quiet = FALSE;
            BOOL new_line = TRUE;
            BOOL flg_n = FALSE;
            int n;
            BOOL flg_c = FALSE;
            BOOL byte = FALSE;
            BOOL terminal = FALSE;
            int c;
            enum eKanjiCode code = gKanjiCode;
            BOOL ignore_case = FALSE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-i") == 0) {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-t") == 0) {
                    terminal = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
                    flg_c = TRUE;
                    c = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            char* word;
            char* target;
            int start;
            int match_count;
            string_obj* str = STRING_NEW("");

            if(input) {
                if(vector_size(argv) != 2) {
                    err_msg("index -I string", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                /// 文字列 ///
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("intterrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                target = string_c_str(str);

                /// 検索文字列 ///
                word = string_c_str(vector_item(argv, 1));

                /// 検索文字列開始位置 ///
                if(flg_n) {
                    start = n;

                    if(start < 0) {
                        start = str_kanjilen(code, target) + start;
                    }

                    if(start < 0 || start >= str_kanjilen(code, target)) 
                    {
                        string_delete(str);
                        break;
                    }
                }
                else {
                    start = str_kanjilen(code, target) -1;
                }

                /// 検索文字列の検索回数 ///
                if(flg_c) {
                    match_count = c;
                    if(match_count <= 0) {
                        err_msg("index -> invalid -c range", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
                else {
                    match_count = 1;
                }
            }
            else {
                if(vector_size(argv) != 3) {
                    err_msg("index -> invalid option number", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                /// 文字列 ///
                word = string_c_str(vector_item(argv, 2));

                /// 検索文字列 ///
                target = string_c_str(vector_item(argv, 1));

                /// 検索文字列開始位置 ///
                if(flg_n) {
                    start = n;

                    if(start < 0) {
                        start = str_kanjilen(code, target) + start;
                    }

                    if(start < 0 || start >= str_kanjilen(
                                code, target)) 
                    {
                        string_delete(str);
                        break;
                    }
                }
                else {
                    start = str_kanjilen(code, target) -1;
                }

                /// 検索文字列の検索回数 ///
                if(flg_c) {
                    match_count = c;
                    if(match_count <= 0) {
                        err_msg("index -> invalid -c range", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
                else {
                    match_count = 1;
                }
            }
            
            int count = match_count;

            char* start_byte = str_kanjipos2pointer(code
                    , target, start+1);
            char* p = start_byte;
            char* result = NULL;
            if(ignore_case) {
                while(p>=target) {
                    result = strcasestr_back(p, target, word, sname, sline);

                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        *rcode = 1;
                        string_delete(str);
                        return FALSE;
                    }

                    if(result != NULL) {
                        count--;
                        if(count == 0) {
                            break;
                        }
                        p = result - 1;
                    }
                    else {
                        break;
                    }
                }
            }
            else {
                while(p>=target) {
                    result = strstr_back(p, target, word, sname, sline);

                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        *rcode = 1;
                        string_delete(str);
                        return FALSE;
                    }

                    if(result != NULL) {
                        count--;
                        if(count == 0) {
                            break;
                        }
                        p = result - 1;
                    }
                    else {
                        break;
                    }
                }
            }

            char msg[64];
            if(result == NULL || count !=0) {
                snprintf(msg, 64, "-1");
            }
            else {
                int c;
                if(byte) {
                    c = result - target;
                }
                else if(terminal) {
                    int pos = str_pointer2kanjipos(code, target, result);
                    c = str_termlen2(code, target, pos);
                }
                else {
                    c = str_pointer2kanjipos(code, target, result);
                }
                snprintf(msg, 64, "%d", c);
                *rcode = 0;
            }

            if(quiet == FALSE) {
                if(!statment_tree_internal_commands_write_nextout(nextout, msg))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                if(new_line) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }
            }

            string_delete(str);
            }
            break;

        case kLength: {
            int i;
            BOOL line_field = TRUE;
            enum eKanjiCode code = gKanjiCode;
            BOOL terminal = FALSE;
            BOOL byte = FALSE;
            BOOL line_field_count = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nl") == 0) {
                    line_field = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-t") == 0) {
                    terminal = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0) {
                    line_field_count = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                            nextin, str);

                /// EOF
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    int len;
                    if(terminal)
                        len = str_termlen(code, string_c_str(str));
                    else if(byte)
                        len = strlen(string_c_str(str));
                    else if(line_field_count)
                        len = str_lflen(gLineField, string_c_str(str));
                    else
                        len = str_kanjilen(code, string_c_str(str));

                    char buf[128];
                    if(line_field)
                        snprintf(buf, 128, "%d\n", len);
                    else
                        snprintf(buf, 128, "%d", len);

                    if(!statment_tree_internal_commands_write_nextout(nextout,  buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) == 2) {
                    int len;
                    if(terminal)
                        len = str_termlen(code, string_c_str(vector_item(argv, 1)));
                    else if(byte) 
                        len = strlen(string_c_str(vector_item(argv, 1)));
                    else if(line_field_count)
                        len = str_lflen(gLineField, string_c_str(vector_item(argv, 1)));
                    else
                        len = str_kanjilen(code, string_c_str(vector_item(argv, 1)));
                    char buf[128];

                    if(line_field)
                        snprintf(buf, 128, "%d\n", len);
                    else
                        snprintf(buf, 128, "%d", len);

                    if(!statment_tree_internal_commands_write_nextout(nextout, buf)) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
            }
            break;

        case kUc: {
            int i;
            BOOL line_field = FALSE;
            enum eKanjiCode code = gKanjiCode;

            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                                nextin, str);

                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    string_toupper(str, code);

                    /// 出力 ///
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) == 2) {
                    string_obj* str = STRING_NEW(
                        string_c_str(vector_item(argv, 1)));

                    string_toupper(str, code);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;

                    string_delete(str);
                }
            }
            }
            break;

        case kLc: {
            int i;
            BOOL line_field = FALSE;
            enum eKanjiCode code = gKanjiCode;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                    nextin, str);

                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    string_tolower(str, code);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) == 2) {
                    string_obj* str = STRING_NEW(
                        string_c_str(vector_item(argv, 1)));

                    string_tolower(str, code);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    if(line_field) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;

                    string_delete(str);
                }
            }
            }
            break;

        case kChomp: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
    //puts("read_nextin start");
                int ret = statment_tree_internal_commands_read_nextin(
                        nextin, str);

                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    string_chomp(str);
                    *rcode = 0;

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                }

                string_delete(str);
            }
            else if(vector_size(argv) >= 2) {
                string_obj* str = vector_item(argv, 1);
                if(string_chomp(str)) {
                    *rcode = 0;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
            }
            }
            break;

        case kSubstr: {
            int i;
            BOOL line_field = FALSE;
            BOOL byte = FALSE;
            BOOL terminal = FALSE;
            enum eKanjiCode code = gKanjiCode;

            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str = NULL;
            char* p;
            int index;
            int count = 1;
            if(input) {
                str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                        nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) 
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                p = string_c_str(str);

                if(vector_size(argv) < 2) {
                    err_msg("substr: invalid arguments", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                index = atoi(string_c_str(vector_item(argv, 1)));

                if(vector_size(argv) >= 3) {
                    count = atoi(string_c_str(vector_item(argv, 2)));
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) < 3) {
                    err_msg("substr: invalid arguments", sname, sline);
                    return FALSE;
                }

                p = string_c_str(vector_item(argv, 1));
                index = atoi(string_c_str(vector_item(argv, 2)));

                if(vector_size(argv) >= 4) {
                    count = atoi(string_c_str(vector_item(argv, 3)));
                }
            }

            if(index < 0) index += str_kanjilen(code, p);
            if(index < 0 || index >= str_kanjilen(code, p)) {
                *rcode = 1;
                break;
            }

            if(count <= 0) {
                count = 1;
            }
            if(index + count > strlen(p)) {
                count = strlen(p)-index;
            }

            char* p1;
            char* p2;
            if(byte) {
                p1 = p + index;
                p2 = p + index + count;
            }
            else {
                p1 = str_kanjipos2pointer(code, p, index);
                p2 = str_kanjipos2pointer(code, p, index + count);
            }


            char* buf = MALLOC(p2 -p1 + 1);
            memcpy(buf, p1, p2-p1);
            buf[p2-p1] = 0;

            /// 出力 ///
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                FREE(buf);
                return FALSE;
            }

            FREE(buf);
            if(line_field) {
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
            }


            *rcode = 0;
            }
            break;

        case kEval: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                        nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) 
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                
                *rcode = saphire_shell4(string_c_str(str), fname
                                , nextout, nextin, nexterr, object);

                FREE(fname);

                if(*rcode < 0) {
                    string_delete(str);
                    return FALSE;
                }

                if(*rcode < 0) {
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            else if(vector_size(blocks) == 1) {
                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;

                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                
                *rcode = run(statments, fname, nextout
                            , nextin, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                FREE(fname);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
            }
            }
            break;

        case kFg:
            if(gAppType != kATOptC && gJobControl) {
                if(vector_size(argv) >= 2) {
                    int num 
                       = atoi(string_c_str((string_obj*)vector_item(argv, 1)));
                    if(!forground_job(num-1)) {
                        return FALSE;
                    }

                    *rcode = 0;
                }
                else {
                    if(!forground_job(0)) {
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
            break;

        case kBg:
            if(gAppType != kATOptC && gJobControl) {
                if(vector_size(argv) >= 2) {
                    char* argv2 = string_c_str((string_obj*)vector_item(argv, 1));
                    if(argv2[0] >= '1' && argv2[0] <= '9') {
                        int num = argv2[0] - '0';
                        background_job(num-1);
                    }

                    *rcode = 0;
                }
                else {
                    background_job(0);
                    *rcode = 0;
                }
            }
            break;


        case kJobs:
            {
            int i;
            if(!statment_tree_internal_commands_write_nextout(nextout, "number name pgroup\n")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            for(i=0; i<vector_size(gJobs); i++) {
                sJob* job = vector_item(gJobs, i);
                char* str = MALLOC(string_length(job->mName) + 16);
                snprintf(str, string_length(job->mName) + 16, "%d. %s %d\n", i+1, string_c_str(job->mName), job->mPGroup);
                if(!statment_tree_internal_commands_write_nextout(nextout, str)) 
                {
                    FREE(str);
                    return FALSE;
                }
                
                FREE(str);
            }
            *rcode = 0;
            }
            break;

        case kRehash:
            saphire_rehash();
            *rcode = 0;
            break;

        case kKanjiCode: {
            int l;
            BOOL quiet = FALSE;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-s") == 0) {
                    *rcode = 0;
                    gKanjiCode = kSjis;

                    /// エンコーディングが変わるので正規表現をクリア ///
                    hash_it* it = hash_loop_begin(gRegexs);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexs);

                    it = hash_loop_begin(gRegexsI);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsI);

                    it = hash_loop_begin(gRegexsM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsM);

                    it = hash_loop_begin(gRegexsIM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsIM);
                    
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    *rcode = 0;
                    gKanjiCode = kEucjp;
                    /// エンコーディングが変わるので正規表現をクリア ///
                    hash_it* it = hash_loop_begin(gRegexs);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexs);

                    it = hash_loop_begin(gRegexsI);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsI);

                    it = hash_loop_begin(gRegexsM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsM);

                    it = hash_loop_begin(gRegexsIM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsIM);
                    
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    *rcode = 0;
                    gKanjiCode = kUtf8;
                    /// エンコーディングが変わるので正規表現をクリア ///
                    hash_it* it = hash_loop_begin(gRegexs);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexs);

                    it = hash_loop_begin(gRegexsI);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsI);

                    it = hash_loop_begin(gRegexsM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsM);

                    it = hash_loop_begin(gRegexsIM);
                    while(it != NULL) {
                        onig_free(hash_loop_item(it));
                        it = hash_loop_next(it);
                    }
                    hash_clear(gRegexsIM);
                    
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(!quiet) {
                if(gKanjiCode == kSjis) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "sjis\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else if(gKanjiCode == kEucjp) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "eucjp\n")) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "utf8\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                *rcode = 0;
            }

            }
            break;

        case kLineField: {
            int l;
            BOOL quiet = FALSE;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-Lw") == 0) {
                    *rcode = 0;
                    gLineField = kCRLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    *rcode = 0;
                    gLineField = kCR;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    *rcode = 0;
                    gLineField = kLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    *rcode = 0;
                    gLineField = kBel;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            /// 出力 ///
            if(!quiet) {
                if(gLineField == kLF) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "LF\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else if(gLineField == kBel) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "BEL\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else if(gLineField == kCRLF) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "CRLF\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                else {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "CR\n"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                *rcode = 0;
            }
            }
            break;

        case kPrint:
        case kPuts: 
            {
            int i;

            BOOL line_field;
            string_obj* field = STRING_NEW(" ");
            if(command->mKind == kPrint) {
                line_field= FALSE;
            }
            else {
                line_field = TRUE;
            }
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-l") == 0) {
                    line_field = !line_field;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-f") == 0 && i+1 < vector_size(argv)) 
                {
                    string_put(field 
                         , string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                                    nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    string_delete(field);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt a", sname, sline);
                    string_delete(str);
                    string_delete(field);
                    return FALSE;
                }

                *rcode = 0;
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)) )
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(field);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            else if(vector_size(argv) > 1) {
                int k;
                for(k=1; k<vector_size(argv); k++) {
                    char* arg = string_c_str((string_obj*)
                                        vector_item(argv, k));
                    if(!statment_tree_internal_commands_write_nextout(nextout,  arg))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(field);
                        return FALSE;
                    }

                    if(k<vector_size(argv)-1) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(field)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(field);
                            return FALSE;
                        }
                    }
                }
                if(line_field) {
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(field);
                        return FALSE;
                    }
                }
                *rcode = 0;
            }
            string_delete(field);
            }
            break;

        case kCompile: 
            if(vector_size(argv) == 2) {
                char* fname = string_c_str(vector_item(argv, 1));
                char out_fname[PATH_MAX];

                noextname(out_fname, PATH_MAX, fname);
                strncat(out_fname, ".sao", PATH_MAX-1);

                if(!statment_tree_internal_commands_write_nextout(nextout, out_fname))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, "\n"))
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }

                if(!saphire_compile(fname, out_fname)) {
                    return FALSE;
                }

                *rcode = 0;
            }
            break;

        case kRaise: 
            if(vector_size(argv) == 2) {
                char* msg = string_c_str(vector_item(argv, 1));

                err_msg(msg, sname, sline);
                *rcode = 0;

                return FALSE;
            }
            break;

        case kLoad: {
            BOOL compiled = FALSE;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-sao") == 0) {
                    compiled = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(argv) >= 2) {
                char* fname = string_c_str(vector_item(argv, 1));
                if(access(fname, R_OK) != 0) {
                    err_msg("can't load file", sname, sline);
                    return FALSE;
                }

                // スタックを掘る
                int k;
                vector_obj* argv2 = sAry_new(30, 1);
                for(k=2; k<vector_size(argv); k++) {
                    char* value = string_c_str(vector_item(argv, k));
                    vector_add(argv2, STRING_NEW(value));
                }
                vector_obj* fun_argv_before;
                dig_stack_frame(sname, sline, &fun_argv_before, argv2);

                if(compiled) {
                    *rcode = saphire_load_obj(
                        string_c_str(vector_item(argv, 1))
                        , nextout, nextin, nexterr, blocks);
                }
                else {
                    *rcode = saphire_load(
                            string_c_str(vector_item(argv, 1))
                            , nextout, nextin, nexterr);
                }
                gKitutukiExit = -1; // exitされても無視したい

                // スタックを埋める
                string_obj* sname_strace;
                int line_strace;
                burry_stack_frame(fun_argv_before, &sname_strace, &line_strace);

                if(*rcode < 0) {
                    string_push_back(gErrMsg, string_c_str(sname_strace));
                    string_delete(sname_strace);
                    char tmp[1024];
                    snprintf(tmp, 1024, ":%d\n", line_strace);
                    string_push_back(gErrMsg, tmp);

                    return FALSE;
                }
                else {
                    string_delete(sname_strace);
                }
            }

            }
            break;


        case kWhile: {
            sWhile* w = (sWhile*)command->mExtra;

            *rcode = 0;

            while(1) {
                int rcode2 = run(w->joukensiki, title, nextout
                                , nextin, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                if(enable_break && *break_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(rcode2 < 0) {
                    *rcode = rcode2;
                    return FALSE;
                }
                else if(rcode2 == SIGINT) {
                    *rcode = 0;
                    break;
                }
                else if(rcode2 != 0) {
                    *rcode = 0;
                    break;
                }

                *rcode = run(w->contents, "while command", nextout
                            , nextin, nexterr, 
                            return_, enable_return, break_, TRUE, parent_blocks, FALSE, envs, object, running_fun, running_class);
                if(*break_) {
                    *break_ = FALSE;
                    break;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
                else if(*rcode == SIGINT) {
                    break;
                }
            }
            }
            break;

        case kBreak:
            if(vector_size(argv) == 1) {
                *break_ = TRUE;
                *rcode = 0;
                return TRUE;
            }
            else if(vector_size(argv) > 1) {
                *break_ = TRUE;
                *rcode = atoi(string_c_str(vector_item(argv, 1)));
                return TRUE;
            }
            break;

        case kTry: {
            if(vector_size(blocks) == 2 && vector_size(argv) >= 1) {
                sBlock* loop_block = vector_item(blocks, 0);
                sStatments* loop = loop_block->mStatments;

                int rcode2 = run(loop, title, nextout, nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, TRUE, envs, object, running_fun, running_class);

                if(enable_break && *break_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(rcode2 == 0) {
                    *rcode = 0;
                }
                else {
                    sBlock* loop2_block = vector_item(blocks, 1);
                    sStatments* loop2 = loop2_block->mStatments;

                    *rcode = run(loop2, "try command", nextout , nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                    if(enable_break && *break_) {
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        return TRUE;
                    }
                    else if(*rcode < 0) {
                        return FALSE;
                    }
                    else if(*rcode == SIGINT) {
                        break;
                    }
                }
            }
            }
            break;

        case kEnvSpace: {
            if(vector_size(blocks) == 1) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    char* p = string_c_str(vector_item(argv, i));

                    if(strstr(p, "=")) {
                        string_obj* name = STRING_NEW("");
                        while(*p != '=') {
                            string_push_back2(name, *p);
                            p++;
                        }
                        p++;
                        string_obj* value = STRING_NEW(p);

                        vector_add(envs, name);
                        vector_add(envs, value);
                    }
                }

                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;
                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: env", sname, sline);
                *rcode = run(statments, fname, nextout
                            , nextin, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                FREE(fname);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
            }
            }
            break;

        case kExit: {
            BOOL force = FALSE;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-f") == 0)
                {
                    force = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }
            if(force) {
                saphire_kill_all_jobs();
                if(vector_size(argv) == 2) {
                    gKitutukiExit = atoi(string_c_str(vector_item(argv, 1)));
                }
                else {
                    gKitutukiExit = 0;
                }

                err_msg("exited", sname, sline);
                *rcode = 0;

                return FALSE;
            }
            else {
                if(vector_size(gJobs) > 0) {
                    err_msg("jobs exist", sname, sline);
                    return FALSE;
                }
                if(vector_size(argv) == 2) {
                    gKitutukiExit = atoi(string_c_str(vector_item(argv, 1)));
                }
                else {
                    gKitutukiExit = 0;
                }

                err_msg("exited", sname, sline);
                *rcode = 0;

                return FALSE;
            }
            }
            break;

        case kIf: {
            sIf* if_ = (sIf*)command->mExtra;

            /// if, elif節 ///
            int k;
            for(k=0; k<vector_size(if_->joukensiki_list); k++) {
                sStatments* joukensiki 
                        = vector_item(if_->joukensiki_list, k);
                int rcode2 = run(joukensiki, title
                                , nextout, nextin, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                if(enable_break && *break_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    *rcode = rcode2;
                    return TRUE;
                }
                else if(rcode2 == 0) {
                    sStatments* contents 
                            = vector_item(if_->contents_list, k);
                    *rcode = run(contents, title, nextout, nextin
                                , nexterr, 
                                return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                    if(enable_break && *break_) {
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        return TRUE;
                    }
                    else if(*rcode < 0) {
                        return FALSE;
                    }
                    goto if_end;
                }
                else if(rcode2 < 0) {
                    *rcode = rcode2;
                    return FALSE;
                }
            }

            /// else節 ///
            if(vector_size(if_->contents_list) 
                    > vector_size(if_->joukensiki_list)) 
            {
                sStatments* contents = vector_item(if_->contents_list, k);
                *rcode = run(contents, title, nextout, nextin
                            , nexterr,
                            return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
            }
if_end:
            null_fun();
            }
            break;

        case kSplit: {
            BOOL ignore_case = FALSE;
            BOOL multiline = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;
            string_obj* field2 = STRING_NEW("\t");
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-i") == 0)
                {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-f") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    string_put(field2 
                         , string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0)
                {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* field;
            if(lf == kCRLF) {
                field = STRING_NEW("\r\n");
            } 
            else if(lf == kLF) {
                field = STRING_NEW("\n");
            }
            else if(lf == kCR) {
                field = STRING_NEW("\r");
            }
            else {
                field = STRING_NEW("\a");
            }

            if(!statment_tree_internal_commands_split(nextout, field, multiline, ignore_case, sname, sline, code, lf, input, argv, nextin, rcode, field2)) {
                string_delete(field);
                string_delete(field2);
                return FALSE;
            }

            string_delete(field);
            string_delete(field2);

            }
            break;

        case kAdd: {
            BOOL flg_n = FALSE;
            int n;
            BOOL flg_l = FALSE;
            int l;
            BOOL byte = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;

            int k;
            for(k=0; k<vector_size(argv); k++) {
                char* arg = string_c_str(vector_item(argv, k));

                if(strcmp(arg, "-n") == 0 && k+1 < vector_size(argv)) {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, k+1)));
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0 && k+1 < vector_size(argv)) {
                    flg_l = TRUE;
                    l = atoi(string_c_str(vector_item(argv, k+1)));
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
            }

            string_obj* str_ = STRING_NEW("");
            if(vector_size(blocks) >= 1) {
                int j;
                for(j=0; j<vector_size(blocks); j++) {
                    sWFd* nextout2 = WFD_NEW(-1);
                    sBlock* block = vector_item(blocks, j);
                    sStatments* statments = block->mStatments;
                    char* fname = MALLOC(strlen(sname) + 32);
                    snprintf(fname, strlen(sname) + 32, "%s %d: add", sname, sline);
                    *rcode = run(statments, fname, nextout2
                                , nextin, nexterr
                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                    FREE(fname);
                    string_push_back(str_, nextout2->mBuffer);
                    sWFd_delete(nextout2);

                    if(enable_break && *break_) {
                        string_delete(str_);
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        string_delete(str_);
                        return TRUE;
                    }
                    else if(*rcode < 0) {
                        string_delete(str_);
                        return FALSE;
                    }
                }
            }
            else if(vector_size(argv) >= 2) {
                int j;
                for(j=1; j<vector_size(argv); j++) {
                    string_push_back(str_, string_c_str(vector_item(argv, j)));
                }
            }
            else {
                string_delete(str_);
                return TRUE;
            }

            if(flg_l) {
                vector_obj* v = VECTOR_NEW(100);

                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        err_msg("interrupt c", sname, sline);
                        *rcode = 1;
                        string_delete(str_);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                    string_obj* line = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                    if(ret == -1) {
                        err_msg("interrupt d", sname, sline);
                        string_delete(line);
                        string_delete(str_);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                    else if(ret == 1) {
                        string_delete(line);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        break;
                    }

                    vector_add(v, line);
                }

                if(l < 0) {
                    l+=vector_size(v)+1;
                }
                if(l < 0) {
                    l = 0;
                }
                if(l > vector_size(v)) {
                    l = vector_size(v);
                }

                if(l < vector_size(v)) {
                    int k;
                    for(k=0; k<l; k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str_);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str_)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str_);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }

                    for(k=l; k<vector_size(v); k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str_);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }
                }
                else {
                    int k;
                    for(k=0; k<vector_size(v); k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str_);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str_)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str_);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                }

                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
            }
            else if(flg_n) {
                string_obj* str = STRING_NEW("");

                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret < 0) 
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    string_delete(str_);
                    return FALSE;
                }
                else if(ret == 1) {
                    *rcode = 1;
                    string_delete(str_);
                    string_delete(str);
                    break;
                }
                else
                {
                    char* str2 = string_c_str(str_);
                    if(byte) {
                        if(n < 0) {
                            n = strlen(string_c_str(str)) + n + 1;
                        }
                        if(n < 0 || n > strlen(string_c_str(str))) {
                            *rcode = 1;
                            string_delete(str_);
                            string_delete(str);
                            break;
                        }

                        string_insert(str, n, str2);
                    }
                    else {
                        if(n < 0) {
                            n = str_kanjilen(code, string_c_str(str)) + n + 1;
                        }

                        if(n < 0 || n > str_kanjilen(code, string_c_str(str))) 
                        {
                            *rcode = 1;
                            string_delete(str_);
                            string_delete(str);
                            break;
                        }

                        int m = str_kanjipos2pointer(code, string_c_str(str), n) - string_c_str(str);
                        string_insert(str, m, str2);
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout,  string_c_str(str)))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str_);
                        string_delete(str);
                        return FALSE;
                    }
                    *rcode = 0;
                }

                string_delete(str);
            }
            else {
                string_obj* str = STRING_NEW("");

                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else {
                    char* str2 = string_c_str(str_);

                    string_push_back(str, str2);

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }

            string_delete(str_);
            }
            break;

        case kDel: {
            BOOL flg_n = FALSE;
            int n;
            BOOL byte = FALSE;
            enum eKanjiCode code = gKanjiCode;
            BOOL flg_l = FALSE;
            int L;
            enum eLineField lf = gLineField;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0 && l+1 < vector_size(argv)) {
                    flg_l = TRUE;
                    L = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-b") == 0) {
                    byte = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(flg_l) {
                int N;
                if(vector_size(argv) >= 2) {
                    N = atoi(string_c_str(vector_item(argv, 1)));
                    if(N < 1) {
                        N = 1;
                    }
                }
                else {
                    N = 1;
                }
                vector_obj* v = VECTOR_NEW(100);

                while(1) {
                    if(gKitutukiSigInt) {
                        gKitutukiSigInt = FALSE;
                        err_msg("interrupt", sname, sline);
                        *rcode = 1;
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                    string_obj* line = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                    if(ret == -1) {
                        err_msg("interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                    else if(ret == 1) {
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        break;
                    }

                    vector_add(v, line);
                }

                if(L < 0) {
                    L+=vector_size(v);
                }
                if(L < 0 || L >= vector_size(v)) {
                    *rcode = 1;

                    int k;
                    for(k=0; k<vector_size(v); k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }
                    break;
                }

                if(L < vector_size(v)) {
                    int k;
                    for(k=0; k<L; k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }

                    for(k=L + N; k<vector_size(v); k++) {
                        char* str = string_c_str(vector_item(v, k));

                        if(!statment_tree_internal_commands_write_nextout(nextout, str))
                        {
                            err_msg("singal interrupt", sname, sline);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
            }
            else if(flg_n) {
                string_obj* str = STRING_NEW("");

                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret == -1)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    int num;
                    if(vector_size(argv) >= 2) {
                        char* arg1 = string_c_str(vector_item(argv, 1));
                        num = atoi(arg1);
                    }
                    else {
                        num = 1;
                    }

                    if(byte) {
                        if(n < 0) {
                            n = strlen(string_c_str(str)) + n + 1;
                        }

                        if(n < 0 || n > strlen(string_c_str(str))) {
                            *rcode = 1;
                            string_delete(str);
                            break;
                        }

                        string_erase(str, n, num);
                    }
                    else {
                        if(n < 0) {
                            n = str_kanjilen(code, string_c_str(str)) + n + 1;
                        }

                        if(n < 0 || n > str_kanjilen(code, string_c_str(str))) {
                            *rcode = 1;
                            string_delete(str);
                            break;
                        }

                        int m = str_kanjipos2pointer(code, string_c_str(str), n) - string_c_str(str);
                        int l = str_kanjipos2pointer(code, string_c_str(str), n+num) - string_c_str(str);
                        string_erase(str, m, l-m);
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    *rcode = 0;
                }

                string_delete(str);
            }
            else {
                string_obj* str = STRING_NEW("");

                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1)
                {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    int num;
                    if(vector_size(argv) >= 2) {
                        char* arg1 = string_c_str(vector_item(argv, 1));
                        num = atoi(arg1);
                    }
                    else {
                        num = 1;
                    }

                    if(byte) {
                        string_trunc(str, string_length(str)-num);
                    }
                    else {
                        int m = str_kanjipos2pointer(code, string_c_str(str), str_kanjilen(code, string_c_str(str))-num) - string_c_str(str);
                        
                        string_trunc(str, m);
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            }
            break;

        case kX: {
            int i;
            BOOL line_field = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) 
                {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            int count;
            string_obj* str;
            if(vector_size(argv) == 3) {
                str = STRING_NEW(string_c_str(vector_item(argv, 1)));
                count = atoi(string_c_str(vector_item(argv, 2)));
            }
            else if(vector_size(argv) == 2 && input) {
                count = atoi(string_c_str(vector_item(argv, 1)));
                str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }
            else {
                err_msg("invalid argument with x", sname, sline);
                return FALSE;
            }

            string_obj* out = STRING_NEW("");
            for(i=0; i<count; i++) {
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    gKitutukiSigInt = FALSE;
                    string_delete(str);
                    string_delete(out);
                    return FALSE;
                }
                string_push_back(out, string_c_str(str));
            }

            if(line_field) {
                string_push_back2(out, '\n');
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                string_delete(out);
                return FALSE;
            }

            *rcode = 0;

            string_delete(str);
            string_delete(out);
            }
            break;

        case kJoin: {
            int i;
            BOOL bash_quote = FALSE;
            BOOL saphire_quote = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0) {
                    saphire_quote = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Q") == 0) {
                    bash_quote = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                char* field;
                if(vector_size(argv) == 2) {
                    field = string_c_str(vector_item(argv, 1));
                }
                else {
                    field = " ";
                }

                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                else {
                    string_chomp(str);
                    char* p = string_c_str(str);
                    string_obj* buf = STRING_NEW("");
                    while(*p) {
                        if(gKitutukiSigInt) {
                            err_msg("interrupt", sname, sline);
                            string_delete(buf);
                            string_delete(str);
                            return FALSE;
                        }
                        if(is_line_field2(lf, p)) {
                            if(bash_quote) {
                                string_obj* quoted = STRING_NEW("");
                                bash_get_quoted_fname(string_c_str(buf), quoted);
                                string_put(buf, string_c_str(quoted));
                                string_delete(quoted);
                            }
                            else if(saphire_quote) {
                                string_obj* quoted = STRING_NEW("");
                                saphire_get_quoted_fname(string_c_str(buf), quoted);
                                string_put(buf, string_c_str(quoted));
                                string_delete(quoted);
                            }

                            if(lf == kCRLF) {
                                p+=2;
                            }
                            else {
                                p++;
                            }
                            string_push_back(buf, field);

                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                string_delete(str);
                                string_delete(buf);
                                return FALSE;
                            }

                            string_put(buf, "");
                        }
                        else {
                            string_push_back2(buf, *p++);
                        }
                    }

                    if(strcmp(string_c_str(buf), "") != 0) {
                        if(bash_quote) {
                            string_obj* quoted = STRING_NEW("");
                            bash_get_quoted_fname(string_c_str(buf), quoted);
                            string_put(buf, string_c_str(quoted));

                            string_delete(quoted);
                        }
                        else if(saphire_quote) {
                            string_obj* quoted = STRING_NEW("");
                            saphire_get_quoted_fname(string_c_str(buf), quoted);
                            string_put(buf, string_c_str(quoted));
                            string_delete(quoted);
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            string_delete(buf);
                            return FALSE;
                        }
                    }

                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        string_delete(str);
                        string_delete(buf);
                        return FALSE;
                    }

                    *rcode = 0;

                    string_delete(buf);
                }

                string_delete(str);
            }
            else if(vector_size(argv) > 1) {
                char* field;
                if(vector_size(argv) == 2) {
                    field = " ";
                }
                else {
                    field = string_c_str(vector_item(argv, 2));
                }

                char* p = string_c_str(vector_item(argv, 1));
                string_obj* buf = STRING_NEW("");
                while(*p) {
                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        string_delete(buf);
                        return FALSE;
                    }
                    if(is_line_field2(lf, p)) {
                        if(lf == kCRLF) {
                            p+=2;
                        }
                        else {
                            p++;
                        }
                        if(bash_quote) {
                            string_obj* quoted = STRING_NEW("");
                            bash_get_quoted_fname(string_c_str(buf), quoted);
                            string_put(buf, string_c_str(quoted));

                            string_delete(quoted);
                        }
                        else if(saphire_quote) {
                            string_obj* quoted = STRING_NEW("");
                            saphire_get_quoted_fname(string_c_str(buf), quoted);
                            string_put(buf, string_c_str(quoted));
                            string_delete(quoted);
                        }
                        string_push_back(buf, field);

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(buf);
                            return FALSE;
                        }

                        string_put(buf, "");
                    }
                    else {
                        string_push_back2(buf, *p++);
                    }
                }

                if(strcmp(string_c_str(buf), "") != 0) {
                    if(bash_quote) {
                        string_obj* quoted = STRING_NEW("");
                        bash_get_quoted_fname(string_c_str(buf), quoted);
                        string_put(buf, string_c_str(quoted));
                        string_delete(quoted);
                    }
                    else if(saphire_quote) {
                        string_obj* quoted = STRING_NEW("");
                        saphire_get_quoted_fname(string_c_str(buf), quoted);
                        string_put(buf, string_c_str(quoted));
                        string_delete(quoted);
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(buf)))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(buf);
                        return FALSE;
                    }
                }

                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(buf);
                    return FALSE;
                }

                *rcode = 0;

                string_delete(buf);
            }
            }
            break;

        case kRows: {
            int i;

            sLinesArg* larg = MALLOC(sizeof(sLinesArg)*vector_size(argv));
            enum eKanjiCode code = gKanjiCode;
            int larg_num = 0;
            BOOL terminal = FALSE;
            BOOL reverse = FALSE;
            int block_num = 0;

            for(i=1; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                string_obj* next_arg;
                if(i+1 < vector_size(argv)) {
                    next_arg = vector_item(argv, i+1);
                }
                else {
                    next_arg = NULL;
                }

                if(strcmp(arg, "-t") == 0) {
                    terminal = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-r") == 0) {
                    reverse = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                /// 倍数 ///
                else if(arg[0] == 'x') {
                    char* p = arg + 1;
                    char* start = MALLOC(sizeof(arg) + 1);
                    char* n = MALLOC(sizeof(arg) + 1);

                    char* p2 = n;
                    if(*p == '-' || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    *p2 = 0;

                    if(*p == 0) {
                        strcpy(start, "0");
                    }
                    else if(*p == '+') {
                        p++;

                        p2 = start;
                        if(*p == '-' || *p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        while(*p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        *p2 = 0;
                    }
                    else if(*p == 'b') {
                    }
                    else {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(start);
                        FREE(n);
                        FREE(larg);
                        return FALSE;
                    }

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            if(*p == 'b') {
                                larg[larg_num].kind = 3;
                            }
                            else {
                                larg[larg_num].kind = 4;
                            }
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 3;
                        larg[larg_num].statments = NULL;
                    }

                    larg[larg_num].num1 = atoi(n);

                    if(larg[larg_num].num1 == 0) {
                        err_msg("invalid N number. N is zero", sname, sline);

                        FREE(start);
                        FREE(n);
                        FREE(larg);
                        return FALSE;
                    }
                    larg[larg_num].num2 = atoi(start);
                    larg_num++;

                    FREE(start);
                    FREE(n);
                }
                /// 倍数 ///
                else if(arg[0] == '*') {
                    char* p = arg + 1;
                    char* start = MALLOC(sizeof(arg) + 1);
                    char* n = MALLOC(sizeof(arg) + 1);

                    char* p2 = n;
                    if(*p == '-' || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    *p2 = 0;

                    if(*p == 0) {
                        strcpy(start, "0");
                    }
                    else if(*p == '+') {
                        p++;

                        p2 = start;
                        if(*p == '-' || *p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        while(*p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        *p2 = 0;
                    }
                    else if(*p == 'b') {
                    }
                    else {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(larg);
                        FREE(start);
                        FREE(n);
                        return FALSE;
                    }

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            if(*p == 'b') {
                                larg[larg_num].kind = 5;
                            }
                            else {
                                larg[larg_num].kind = 6;
                            }
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 6;
                        larg[larg_num].statments = NULL;
                    }

                    larg[larg_num].num1 = atoi(n);
                    larg[larg_num].num2 = atoi(start);
                    larg_num++;

                    FREE(start);
                    FREE(n);
                }
                /// 範囲 ///
                else if(strstr(arg, "..")) {
                    char* first = MALLOC(sizeof(arg) + 1);
                    char* last = MALLOC(sizeof(arg) + 1);
                    char* p = arg;

                    char* p2 = first;

                    if(*p == '-'  || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    *p2 = 0;

                    if(*p != '.' || *(p+1) != '.') {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(larg);
                        FREE(first);
                        FREE(last);
                        return FALSE;
                    }
                    p+=2;

                    p2 = last;

                    if(*p == '-'  || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    *p2 = 0;

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            if(*p == 'b') {
                                larg[larg_num].kind = 2;
                            }
                            else {
                                larg[larg_num].kind = 1;
                            }
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 1;
                        larg[larg_num].statments = NULL;
                    }

                    larg[larg_num].num1 = atoi(first);
                    larg[larg_num].num2 = atoi(last);
                    larg_num++;

                    FREE(first);
                    FREE(last);
                }
                /// 数値一つ
                else if(arg[0] == '-' || arg[0] >= '0' && arg[0] <= '9') {
                    larg[larg_num].kind = 0;
                    larg[larg_num].num1 = atoi(arg);

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].statments = NULL;
                    }
                    larg_num++;
                }
                /// 文字列
                else {
                    larg[larg_num].kind = 7;

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].statments = NULL;
                    }
                    larg_num++;
                }
            }

            string_obj* line = STRING_NEW("");

            int ret = statment_tree_internal_commands_read_nextin(nextin, line);
            if(ret == 1) {
                *rcode = 1;
                string_delete(line);
                FREE(larg);
                return TRUE;
            }
            else if(ret == -1) {
                err_msg("interrupt", sname, sline);
                string_delete(line);
                FREE(larg);
                return FALSE;
            }

            if(reverse) {
                if(code == kUtf8) {
                    char* p = string_c_str(line);
                    int len = strlen(p);
                    wchar_t* wcs = MALLOC((len+1)*MB_CUR_MAX);
                    if(mbstowcs(wcs, p, (len+1)*MB_CUR_MAX) < 0) {
                        err_msg("mbstowcs err", sname, sline);
                        string_delete(line);
                        FREE(wcs);
                        FREE(larg);
                        return FALSE;
                    }
                    wchar_t* wcs2 = MALLOC(len*MB_CUR_MAX+1);
                    int i;
                    int j;
                    for(i=wcslen(wcs)-1, j=0; i>=0; i--, j++) {
                        wcs2[j] = wcs[i];
                    }
                    wcs2[j] = 0;

                    char* mbs = MALLOC(len*MB_CUR_MAX+1);
                    if(wcstombs(mbs, wcs2, len*MB_CUR_MAX+1) < 0) {
                        err_msg("wcstombs err", sname, sline);
                        string_delete(line);
                        FREE(larg);
                        FREE(wcs);
                        FREE(wcs2);
                        FREE(mbs);
                        return FALSE;
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, mbs))
                    {
                        err_msg("interrupt", sname, sline);
                        string_delete(line);
                        FREE(wcs);
                        FREE(wcs2);
                        FREE(larg);
                        FREE(mbs);
                        return FALSE;
                    }

                    *rcode = 0;

                    FREE(wcs);
                    FREE(wcs2);
                    FREE(mbs);
                }
                else {
                    char* p = string_c_str(line);
                    int len = strlen(p);
                    char* str = MALLOC(len+1);
                    char* p2 = str + len;
                    *p2=0;
                    p2--;

                    while(*p) {
                        if(is_kanji(code, *p)) {
                            *(p2-1) = *p++;
                            *p2 = *p++;
                            p2-=2;
                        }
                        else {
                            *p2-- = *p++;
                        }
                    }

                    if(!statment_tree_internal_commands_write_nextout(nextout, str))
                    {
                        err_msg("interrupt", sname, sline);
                        string_delete(line);
                        FREE(larg);
                        FREE(str);
                        return FALSE;
                    }

                    *rcode = 0;

                    FREE(str);
                }
            }
            else {
                for(i=0; i<larg_num; i++) {
                    switch(larg[i].kind) {
                        case 0: {
                            int n = larg[i].num1;
                            char buf[MB_CUR_MAX + 1];

                            if(n < 0) {
                                n += str_kanjilen(code, string_c_str(line));
                            }

                            if(n < 0) {
                                n = 0;
                            }
                            if(n >= str_kanjilen(code, string_c_str(line))) 
                            {
                                n = str_kanjilen(code, string_c_str(line)) -1;
                            }

                            char* c = str_kanjipos2pointer(code, string_c_str(line), n);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), n+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            /// ブロックがあるなら ///
                            if(larg[i].statments) {
                                sRFd* nextin2 = RFD_NEW2(-1, buf);

                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                                *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                FREE(fname);
                                sRFd_delete(nextin2);
                                if(enable_break && *break_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(enable_return && *return_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                            }
                            else {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            }
                            break;

                        case 1: {
                            int n1 = larg[i].num1;
                            int n2 = larg[i].num2;

                            if(n1 < 0) {
                                n1 += str_kanjilen(code, string_c_str(line));
                            }

                            if(n1 < 0) {
                                n1 = 0;
                            }
                            if(n1 >= str_kanjilen(code, string_c_str(line)))
                            {
                                n1 = str_kanjilen(code, string_c_str(line)) -1;
                            }

                            if(n2 < 0) {
                                n2 += str_kanjilen(code, string_c_str(line));
                            }

                            if(n2 < 0) {
                                n2 = 0;
                            }
                            if(n2 >= str_kanjilen(code, string_c_str(line))) 
                            {
                                n2 = str_kanjilen(code, string_c_str(line)) -1;
                            }

                            if(n1 > n2) {
                                err_msg("invalid range", sname, sline);

                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }

                            char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                            char* c = str_kanjipos2pointer(code, string_c_str(line), n1);
                            char* d = str_kanjipos2pointer(code, string_c_str(line), n2+1);
                            memcpy(buf, c, d-c);
                            buf[d-c] = 0;

                            if(larg[i].statments) {
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                sRFd* nextin2 = RFD_NEW2(-1, buf);

                                *rcode = run(larg[i].statments
                                        , fname, nextout
                                        , nextin2, nexterr
                                        , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                sRFd_delete(nextin2);
                                FREE(fname);
                                if(enable_break && *break_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(enable_return && *return_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }

                            }
                            else {
                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            }
                            break;

                        case 2: {
                            int n1 = larg[i].num1;
                            int n2 = larg[i].num2;

                            if(n1 < 0) {
                                n1 += str_kanjilen(code, string_c_str(line));
                            }

                            if(n2 < 0) {
                                n2 += str_kanjilen(code, string_c_str(line));
                            }

                            if(n1 < 0) {
                                n1 = 0;
                            }
                            if(n1 >= str_kanjilen(code, string_c_str(line)))
                            {
                                n1 = str_kanjilen(code, string_c_str(line)) -1;
                            }

                            if(n2 < 0) {
                                n2 += str_kanjilen(code, string_c_str(line));
                            }

                            if(n2 < 0) {
                                n2 = 0;
                            }
                            if(n2 >= str_kanjilen(code, string_c_str(line))) 
                            {
                                n2 = str_kanjilen(code, string_c_str(line)) -1;
                            }

                            if(n1 > n2) {
                                err_msg("invalid range", sname, sline);

                                string_delete(line);
                                FREE(larg);
                                return FALSE;
                            }

                            if(larg[i].statments) {
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                int j;
                                for(j=n1; j<=n2; j++) {
                                    char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    sRFd* nextin2 = RFD_NEW2(-1, buf);

                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                    sRFd_delete(nextin2);
                                    if(enable_break && *break_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                FREE(fname);

                            }
                            else {
                                char buf[MB_CUR_MAX * (n2-n1+1) + 1];

                                char* c = str_kanjipos2pointer(code, string_c_str(line), n1);
                                char* d = str_kanjipos2pointer(code, string_c_str(line), n2+1);
                                memcpy(buf, c, d-c);
                                buf[d-c] = 0;

                                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            }
                            break;

                        case 3: {
                            int baisuu = larg[i].num1;
                            int start = larg[i].num2;

                            if(larg[i].statments) {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                for(j=start; j<max; j++) {
                                    char buf[MB_CUR_MAX * 1 + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    sRFd* nextin2 = RFD_NEW2(-1, buf);

                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                    sRFd_delete(nextin2);
                                    if(enable_break && *break_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                FREE(fname);
                            }
                            else {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                                {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            }
                            break;

                        case 4: {
                            int baisuu = larg[i].num1;
                            int start = larg[i].num2;

                            if(larg[i].statments) {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                for(j=start; j<max; j+=baisuu) {
                                    char buf[MB_CUR_MAX * baisuu + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+baisuu);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    sRFd* nextin2 = RFD_NEW2(-1, buf);

                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                    sRFd_delete(nextin2);

                                    if(enable_break && *break_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                FREE(fname);
                            }
                            else {
                                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(line)))
                                {
                                    string_delete(line);
                                    return FALSE;
                                }
                                *rcode = 0;
                            }
                            }
                            break;

                        case 5: {
                            int baisuu = larg[i].num1;
                            int start = larg[i].num2;

                            if(larg[i].statments) {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                for(j=start; j<max; j+=baisuu) {
                                    char buf[MB_CUR_MAX * 1 + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    sRFd* nextin2 = RFD_NEW2(-1, buf);

                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                    sRFd_delete(nextin2);

                                    if(enable_break && *break_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        string_delete(line);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                FREE(fname);
                            }
                            else {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                for(j=start; j<max; j+=baisuu) {
                                    char buf[MB_CUR_MAX * 1 + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                    {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                *rcode = 0;
                            }
                            }
                            break;

                        case 6: {
                            int baisuu = larg[i].num1;
                            int start = larg[i].num2;

                            if(larg[i].statments) {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                string_obj* str = STRING_NEW("");
                                for(j=start; j<max; j+=baisuu) {
                                    char buf[MB_CUR_MAX * 1 + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    string_push_back(str, buf);
                                }

                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                string_delete(str);

                                *rcode = run(larg[i].statments
                                        , fname, nextout
                                        , nextin2, nexterr
                                        , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                sRFd_delete(nextin2);
                                FREE(fname);

                                if(enable_break && *break_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(enable_return && *return_) {
                                    FREE(larg);
                                    string_delete(line);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }

                            }
                            else {
                                int j;
                                int max = str_kanjilen(code, string_c_str(line));
                                for(j=start; j<max; j+=baisuu) {
                                    char buf[MB_CUR_MAX * 1 + 1];

                                    char* c = str_kanjipos2pointer(code, string_c_str(line), j);
                                    char* d = str_kanjipos2pointer(code, string_c_str(line), j+1);
                                    memcpy(buf, c, d-c);
                                    buf[d-c] = 0;

                                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                                    {
                                        string_delete(line);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                }

                                *rcode = 0;
                            }
                            }
                            break;

                        case 7: {
                            /// ブロックがあるなら ///
                            if(larg[i].statments) {
                                char* fname = MALLOC(strlen(sname) + 32);
                                snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                                *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                FREE(fname);
                                if(enable_break && *break_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(enable_return && *return_) {
                                    string_delete(line);
                                    FREE(larg);
                                    return TRUE;
                                }
                                else if(*rcode < 0) {
                                    string_delete(line);
                                    FREE(larg);
                                    return FALSE;
                                }
                            }
                            }
                            break;

                    }
                }
            }

            string_delete(line);

            FREE(larg);

            }
            break;

        case kSelect: {
            int i;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(blocks) >= 1) {
                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;

                string_obj* arg;
                if(vector_size(block->mArgs) >= 1) {
                    arg = vector_item(block->mArgs, 0);
                }
                else {
                    arg = NULL;
                }

                int i = 0;
                while(1) {
                    if(gKitutukiSigInt)  {
                        err_msg("intterrupt", sname, sline);
                        FREE(fname);
                        return FALSE;
                    }
                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

                    if(result == -1) {  // CTRL_C
                        err_msg("interrupt", sname, sline);
                        string_delete(str);

                        FREE(fname);
                        return FALSE;
                    }
                    else if(result == 1) { // EOF
                        string_delete(str);
                        break;
                    }

                    if(arg) {
                        char buf[1024];
                        snprintf(buf, 1024, "%d", i);
                        saphire_set_local_var(string_c_str(arg), buf);
                    }

                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                    int rcode2 = run(statments
                            , fname, nextout
                            , nextin2, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                    sRFd_delete(nextin2);

                    if(enable_break && *break_) {
                        string_delete(str);
                        *rcode = rcode2;
                        FREE(fname);
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        string_delete(str);
                        *rcode = rcode2;
                        FREE(fname);
                        return TRUE;
                    }
                    else if(rcode2 < 0) {
                        string_delete(str);
                        *rcode = rcode2;
                        FREE(fname);
                        return FALSE;
                    }

                    if(rcode2 == 0) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            FREE(fname);
                            string_delete(str);
                            return FALSE;
                        }
                    }
                    string_delete(str);

                    i++;
                }

                FREE(fname);

                *rcode = 0;
            }
            }
            break;

        case kLines: {
            int i;
            BOOL reverse = FALSE;
            enum eLineField lf = gLineField;

            sLinesArg* larg = MALLOC(sizeof(sLinesArg)*vector_size(argv));
            int larg_num = 0;
            int block_num = 0;

            for(i=1; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                string_obj* next_arg;
                if(i+1 < vector_size(argv)) {
                    next_arg = vector_item(argv, i+1);
                }
                else {
                    next_arg = NULL;
                }

                if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-r") == 0) {
                    reverse = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                /// 倍数 ///
                else if(arg[0] == 'x') {
                    char* p = arg + 1;
                    char* start = MALLOC(sizeof(arg) + 1);
                    char* n = MALLOC(sizeof(arg) + 1);

                    char* p2 = n;
                    if(*p == '-' || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    *p2 = 0;

                    if(*p == '+') {
                        p++;

                        p2 = start;
                        if(*p == '-' || *p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        while(*p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        *p2 = 0;
                    }
                    else if(*p == 0) {
                        strcpy(start, "0");
                    }
                    else if(*p == 'b') {
                    }
                    else {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(larg);
                        FREE(start);
                        FREE(n);
                        return FALSE;
                    }

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            if(*p == 'b') {
                                larg[larg_num].kind = 6;
                            }
                            else {
                                larg[larg_num].kind = 7;
                            }

                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 8;
                        larg[larg_num].statments = NULL;
                    }

                    larg[larg_num].num1 = atoi(n);
                    larg[larg_num].num2 = atoi(start);
                    larg_num++;

                    FREE(start);
                    FREE(n);
                }
                /// 倍数 ///
                else if(arg[0] == '*') {
                    char* p = arg + 1;
                    char* start = MALLOC(sizeof(arg) + 1);
                    char* n = MALLOC(sizeof(arg) + 1);

                    char* p2 = n;
                    if(*p == '-' || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }
                    *p2 = 0;

                    if(*p == '+') {
                        p++;

                        p2 = start;
                        if(*p == '-' || *p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        while(*p >= '0' && *p <= '9') {
                            *p2++ = *p++;
                        }
                        *p2 = 0;
                    }
                    else if(*p == 0) {
                        strcpy(start, "0");
                    }
                    else if(*p == 'b') {
                    }
                    else {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(larg);
                        FREE(start);
                        FREE(n);
                        return FALSE;
                    }

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            
                            if(*p == 'b') {
                                larg[larg_num].kind = 2;
                            }
                            else {
                                larg[larg_num].kind = 5;
                            }
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 2;
                        larg[larg_num].statments = NULL;
                    }

                    larg[larg_num].num1 = atoi(n);
                    larg[larg_num].num2 = atoi(start);
                    larg_num++;

                    FREE(start);
                    FREE(n);
                }
                /// 範囲 ///
                else if(strstr(arg, "..")) {
                    char* first = MALLOC(sizeof(arg) + 1);
                    char* last = MALLOC(sizeof(arg) + 1);
                    char* p = arg;
                    char* p2 = first;

                    if(*p == '-'  || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    *p2 = 0;

                    if(*p != '.' || *(p+1) != '.') {
                        err_msg("invalid lines argument", sname, sline);
                        FREE(larg);
                        FREE(first);
                        FREE(last);
                        return FALSE;
                    }
                    p+=2;

                    p2 = last;

                    if(*p == '-'  || *p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    while(*p >= '0' && *p <= '9') {
                        *p2++ = *p++;
                    }

                    *p2 = 0;

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            if(*p == 'b') {
                                larg[larg_num].kind = 1;
                            }
                            else {
                                larg[larg_num].kind = 4;
                            }
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].kind = 1;
                        larg[larg_num].statments = NULL;
                    }
                    larg[larg_num].num1 = atoi(first);
                    larg[larg_num].num2 = atoi(last);
                    larg_num++;

                    FREE(first);
                    FREE(last);
                }
                /// 数値１つ
                else if(arg[0] == '-' || arg[0] >= '0' && arg[0] <= '9') {
                    larg[larg_num].kind = 0;
                    larg[larg_num].num1 = atoi(arg);

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].statments = NULL;
                    }
                    larg_num++;
                }
                /// 文字列 ///
                else {
                    larg[larg_num].kind = 9;

                    /// 次の引数がブロックなら ///
                    BOOL found = FALSE;
                    int j;
                    for(j=0; j<vector_size(blocks); j++) {
                        sBlock* block = vector_item(blocks, j);
                        if(block->mCount == i) {
                            found = TRUE;
                            larg[larg_num].statments = block->mStatments;
                            break;
                        }
                    }
                    
                    if(found == FALSE) {
                        larg[larg_num].statments = NULL;
                    }
                    larg_num++;
                }
            }

            vector_obj* v = VECTOR_NEW(100);

            while(1) {
                if(gKitutukiSigInt) {
                    err_msg("interrupt", sname, sline);
                    *rcode = 1;
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    FREE(larg);
                    return FALSE;
                }
                string_obj* line = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, line, lf);
                //string_chomp(line);
                if(ret == -1) {
                    err_msg("interrupt", sname, sline);
                    string_delete(line);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    FREE(larg);
                    return FALSE;
                }
                else if(ret == 1) {
                    string_delete(line);
                    break;
                }

                vector_add(v, line);
            }

            if(vector_size(v) > 0) {
                /// 反転 ///
                if(reverse) {
                    const int size = vector_size(v);
                    for(i=0; i<size; i++) {
                        char* str = string_c_str(vector_item(v, size-i-1));
                        string_obj* str2 = STRING_NEW(str);
                        string_chomp(str2);

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                        {
                            string_delete(str2);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            FREE(larg);
                            vector_delete(v);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str2);
                            int i;
                            for(i=0; i<vector_size(v); i++) {
                                string_delete(vector_item(v, i));
                            }
                            vector_delete(v);
                            FREE(larg);
                            return FALSE;
                        }

                        string_delete(str2);
                    }

                    *rcode = 0;
                }
                else {
                    for(i=0; i<larg_num; i++) {

                        switch(larg[i].kind) {
                            case 0: {
                                int n = larg[i].num1;

                                if(n < 0) {
                                    n += vector_size(v);
                                }
                                if(n < 0) {
                                    n = 0;
                                }
                                if(n >= vector_size(v)) {
                                    n = vector_size(v)-1;
                                }

                                string_obj* str = vector_item(v, n);

                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                    FREE(fname);
                                    sRFd_delete(nextin2);

                                    if(enable_break && *break_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    //gGPipeStat = save_value;
                                }
                                else {
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp(str2);
                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    *rcode = 0;
                                    string_delete(str2);
                                }
                                }
                                break;

                            case 1: {
                                int n1 = larg[i].num1;
                                int n2 = larg[i].num2;

                                if(n1 < 0) {
                                    n1+=vector_size(v);
                                }
                                if(n1 < 0) {
                                    n1 = 0;
                                }
                                if(n2 < 0) {
                                    n2+=vector_size(v);
                                }
                                if(n2 < 0) {
                                    n2 = 0;
                                }
                                if(n1 >= vector_size(v)) {
                                    n1 = vector_size(v)-1;
                                }
                                if(n2 >= vector_size(v)) {
                                    n2 = vector_size(v)-1;
                                }

                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    if(n1 < n2) {
                                        int k;
                                        for(k=n1; k<=n2; k++) {
                                            string_obj* str = vector_item(v, k);
                                            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                            *rcode = run(larg[i].statments
                                                    , fname, nextout
                                                    , nextin2, nexterr
                                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                            sRFd_delete(nextin2);
                                            if(enable_break && *break_) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return TRUE;
                                            }
                                            else if(enable_return && *return_) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return TRUE;
                                            }
                                            else if(*rcode < 0) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }
                                        }
                                    }
                                    else {
                                        int k;
                                        for(k=n1; k>=n2; k--) {
                                            string_obj* str = vector_item(v, k);
                                            sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                            *rcode = run(larg[i].statments
                                                    , fname, nextout
                                                    , nextin2, nexterr
                                                    , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                            if(enable_break && *break_) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return TRUE;
                                            }
                                            else if(enable_return && *return_) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return TRUE;
                                            }
                                            else if(*rcode < 0) {
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }
                                        }
                                    }

                                    FREE(fname);
                                }
                                else {
                                    if(n1 < n2) {
                                        int k;
                                        for(k=n1; k<=n2; k++) {
                                            string_obj* str = vector_item(v, k);
                                            string_obj* str2 = STRING_NEW(string_c_str(str));
                                            string_chomp(str2);
                                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                            {
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }
                                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                            {
                                                err_msg("singal interrupt", sname, sline);
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }

                                            string_delete(str2);
                                        }
                                    }
                                    else {
                                        int k;
                                        for(k=n1; k>=n2; k--) {
                                            string_obj* str = vector_item(v, k);
                                            string_obj* str2 = STRING_NEW(string_c_str(str));
                                            string_chomp(str2);
                                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                            {
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);

                                                FREE(larg);
                                                return FALSE;
                                            }
                                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                            {
                                                err_msg("singal interrupt", sname, sline);
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }

                                            string_delete(str2);
                                        }
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 2: {
                                int baisuu = larg[i].num1;
                                int start = larg[i].num2;

                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    int k = 0;
                                    while(1) {
                                        int x = k * baisuu + start;

                                        if(x < 0 || x >= vector_size(v)) {
                                            break;
                                        }

                                        string_obj* str = vector_item(v, x);

                                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                        *rcode = run(larg[i].statments
                                                , fname, nextout
                                                , nextin2, nexterr
                                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                        sRFd_delete(nextin2);

                                        if(enable_break && *break_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(enable_return && *return_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(*rcode < 0) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }


                                        k++;
                                    }

                                    FREE(fname);
                                }
                                else {
                                    int k = 0;
                                    while(1) {
                                        int x = k * baisuu + start;

                                        if(x < 0 || x >= vector_size(v)) {
                                            break;
                                        }

                                        string_obj* str = vector_item(v, x);
                                        string_obj* str2 = STRING_NEW(string_c_str(str));
                                        string_chomp(str2);

                                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                        {
                                            string_delete(str2);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }
                                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                        {
                                            string_delete(str2);
                                            err_msg("singal interrupt", sname, sline);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }

                                        k++;

                                        string_delete(str2);
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 4: {
                                int n1 = larg[i].num1;
                                int n2 = larg[i].num2;

                                if(n1 < 0) {
                                    n1+=vector_size(v);
                                }
                                if(n1 < 0) {
                                    n1=0;
                                }
                                if(n1 >= vector_size(v)) {
                                    n1=vector_size(v)-1;
                                }
                                if(n2 < 0) {
                                    n2+=vector_size(v);
                                }
                                if(n2 < 0) {
                                    n2=0;
                                }
                                if(n2 >= vector_size(v)) {
                                    n2=vector_size(v)-1;
                                }

                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    if(n1 < n2) {
                                        string_obj* str = STRING_NEW("");
                                        int k;
                                        for(k=n1; k<=n2; k++) {
                                            if(gKitutukiSigInt) {
                                                err_msg("interrupt", sname, sline);
                                                string_delete(str);
                                                FREE(larg);
                                                return FALSE;
                                            }
                                            string_obj* str2 = vector_item(v, k);
                                            string_push_back(str, string_c_str(str2));
                                        }

                                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                        string_delete(str);
                                        *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                        sRFd_delete(nextin2);

                                        if(enable_break && *break_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(enable_return && *return_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(*rcode < 0) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }
                                    }
                                    else {
                                        string_obj* str = STRING_NEW("");

                                        int k;
                                        for(k=n1; k>=n2; k--) {
                                            if(gKitutukiSigInt) {
                                                err_msg("interrupt", sname, sline);
                                                string_delete(str);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }

                                            string_obj* str2 = vector_item(v, k);
                                            string_push_back(str, string_c_str(str2));
                                        }

                                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                                        string_delete(str);

                                        *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                        sRFd_delete(nextin2);

                                        if(enable_break && *break_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(enable_return && *return_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(*rcode < 0) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }
                                    }

                                    FREE(fname);
                                }
                                else {
                                    if(n1 < n2) {
                                        int k;
                                        for(k=n1; k<=n2; k++) {
                                            string_obj* str = vector_item(v, k);
                                            string_obj* str2 = STRING_NEW(string_c_str(str));
                                            string_chomp(str2);
                                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                            {
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);

                                                return FALSE;
                                            }
                                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                            {
                                                err_msg("singal interrupt", sname, sline);
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }

                                            string_delete(str2);
                                        }
                                    }
                                    else {
                                        int k;
                                        for(k=n1; k>=n2; k--) {
                                            string_obj* str = vector_item(v, k);
                                            string_obj* str2 = STRING_NEW(string_c_str(str));
                                            string_chomp(str2);
                                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                            {
                                                string_delete(str2);

                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }
                                            if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                            {
                                                err_msg("singal interrupt", sname, sline);
                                                string_delete(str2);
                                                int i;
                                                for(i=0; i<vector_size(v); i++) {
                                                    string_delete(vector_item(v, i));
                                                }
                                                vector_delete(v);
                                                FREE(larg);
                                                return FALSE;
                                            }

                                            string_delete(str2);
                                        }
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 5: {
                                int baisuu = larg[i].num1;
                                int start = larg[i].num2;

                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    string_obj* str = STRING_NEW("");
                                    int k = 0;
                                    while(1) {
                                        int x = k * baisuu + start;

                                        if(x < 0 || x >= vector_size(v)) {
                                            break;
                                        }

                                        string_push_back(str, string_c_str(vector_item(v, x)));


                                        k++;
                                    }

                                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                    string_delete(str);

                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin2, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                    sRFd_delete(nextin2);

                                    if(enable_break && *break_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);

                                        FREE(larg);
                                        return FALSE;
                                    }

                                    FREE(fname);
                                }
                                else {
                                    int k = 0;
                                    while(1) {
                                        int x = k * baisuu + start;

                                        if(x < 0 || x >= vector_size(v)) {
                                            break;
                                        }

                                        string_obj* str = vector_item(v, x);
                                        string_obj* str2 = STRING_NEW(string_c_str(str));
                                        string_chomp(str2);

                                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                        {
                                            string_delete(str2);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }
                                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                        {
                                            err_msg("singal interrupt", sname, sline);
                                            string_delete(str2);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }

                                        string_delete(str2);

                                        k++;
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 6: {
                                int baisuu = larg[i].num1;
                                int start = larg[i].num2;

                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    int k = start;
                                    while(k < vector_size(v)) {
                                        string_obj* str = vector_item(v, k);

                                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                        *rcode = run(larg[i].statments
                                                , fname, nextout
                                                , nextin2, nexterr
                                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                        sRFd_delete(nextin2);

                                        if(enable_break && *break_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(enable_return && *return_) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(*rcode < 0) {
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }

                                        k++;
                                    }

                                    FREE(fname);
                                }
                                else {
                                    int k = start;
                                    while(k < vector_size(v)) {
                                        string_obj* str = vector_item(v, k);
                                        string_obj* str2 = STRING_NEW(string_c_str(str));
                                        string_chomp(str2);

                                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                        {
                                            string_delete(str2);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }
                                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                        {
                                            err_msg("singal interrupt", sname, sline);
                                            string_delete(str2);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }

                                        string_delete(str2);

                                        k++;
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 7: {
                                int baisuu = larg[i].num1;
                                int start = larg[i].num2;

                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);

                                    int k = start;
                                    while(k < vector_size(v)) {
                                        string_obj* str = STRING_NEW("");
                                        int l;
                                        for(l=k; l<k+baisuu && l<vector_size(v); l++) {
                                            string_push_back(str, string_c_str(vector_item(v, l)));
                                        }

                                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                                        *rcode = run(larg[i].statments
                                                , fname, nextout
                                                , nextin2, nexterr
                                                , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                                        sRFd_delete(nextin2);

                                        if(enable_break && *break_) {
                                            string_delete(str);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(enable_return && *return_) {
                                            string_delete(str);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return TRUE;
                                        }
                                        else if(*rcode < 0) {
                                            string_delete(str);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }

                                        k+=baisuu;

                                        string_delete(str);
                                    }

                                    FREE(fname);
                                }
                                else {
                                    int k = start;
                                    while(k < vector_size(v)) {
                                        string_obj* str = STRING_NEW("");
                                        int l;
                                        for(l=k; l<k+baisuu && l<vector_size(v); l++) {
                                            string_push_back(str, string_c_str(vector_item(v, l)));
                                        }
                                        string_chomp(str);

                                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                                        {
                                            string_delete(str);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);

                                            return FALSE;
                                        }
                                        if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                        {
                                            err_msg("singal interrupt", sname, sline);
                                            string_delete(str);
                                            int i;
                                            for(i=0; i<vector_size(v); i++) {
                                                string_delete(vector_item(v, i));
                                            }
                                            vector_delete(v);
                                            FREE(larg);
                                            return FALSE;
                                        }

                                        k+=baisuu;

                                        string_delete(str);
                                    }

                                    *rcode = 0;
                                }
                                }
                                break;

                            case 8: {
                                int start = larg[i].num2;
                                int k = start;
                                while(k < vector_size(v)) {
                                    string_obj* str = vector_item(v, k);
                                    string_obj* str2 = STRING_NEW(string_c_str(str));
                                    string_chomp(str2);

                                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str2)))
                                    {
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);

                                        return FALSE;
                                    }
                                    if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                                    {
                                        err_msg("singal interrupt", sname, sline);
                                        string_delete(str2);
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }

                                    k++;

                                    string_delete(str2);
                                }

                                *rcode = 0;
                                }
                                break;

                            case 9: {
                                /// ブロックがあるなら ///
                                if(larg[i].statments) {
                                    char* fname = MALLOC(strlen(sname) + 32);
                                    snprintf(fname, strlen(sname) + 32, "%s %d: eval", sname, sline);
                                    *rcode = run(larg[i].statments
                                            , fname, nextout
                                            , nextin, nexterr
                                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                                    if(enable_break && *break_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(enable_return && *return_) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return TRUE;
                                    }
                                    else if(*rcode < 0) {
                                        int i;
                                        for(i=0; i<vector_size(v); i++) {
                                            string_delete(vector_item(v, i));
                                        }
                                        vector_delete(v);
                                        FREE(larg);
                                        return FALSE;
                                    }
                                    //gGPipeStat = save_value;
                                }
                                }
                                break;

                        }
                    }
                }
            }

            for(i=0;i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);

            FREE(larg);

            }
            break;


        case kScan: {
            BOOL ignore_case = FALSE;
            BOOL multiline = FALSE;
            string_obj* field = STRING_NEW("\t");
            BOOL quiet = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-i") == 0)
                {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0)
                {
                    quiet = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0)
                {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0)
                {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-f") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    string_put(field 
                         , string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(multiline) {
                if(!statment_tree_internal_commands_scan(argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, parent_blocks, return_, enable_return, break_, enable_break, code, envs, object, running_fun, running_class, lf)) {
                    string_delete(field);
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_scan_oneline(argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, parent_blocks, return_, enable_return, break_, enable_break, code, envs, object, running_fun, running_class, lf)) {
                    string_delete(field);
                    return FALSE;
                }
            }
            
            if(enable_break && *break_) {
                string_delete(field);
                return TRUE;
            }
            else if(enable_return && *return_) {
                string_delete(field);
                return TRUE;
            }

            string_delete(field);
            }
            break;

        case kErase: {
            BOOL ignore_case = FALSE;
            BOOL multiline = FALSE;
            BOOL global = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-i") == 0)
                {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0)
                {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0)
                {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0)
                {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(multiline || !global) {
                if(!statment_tree_internal_commands_erase(global, argv, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, code)) {
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_erase_oneline(global, argv, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, code, lf)) {
                    return FALSE;
                }
            }

            }
            break;

        case kMatch: {
            BOOL quiet = FALSE;
            BOOL line_field = TRUE;
            BOOL all = FALSE;
            BOOL line_num = FALSE;
            BOOL global = FALSE;
            BOOL line_oriented = FALSE;
            BOOL ignore_case = FALSE;
            BOOL multiline = FALSE;
            enum eKanjiCode code = gKanjiCode;
            string_obj* field = STRING_NEW("\t");
            enum eLineField lf = gLineField;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-q") == 0)
                {
                    quiet = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-L") == 0)
                {
                    line_oriented = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-i") == 0)
                {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0)
                {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-g") == 0)
                {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-a") == 0)
                {
                    all = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-nl") == 0)
                {
                    line_field = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0)
                {
                    line_num = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0)
                {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-f") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    string_put(field 
                         , string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(global) {
                if(multiline) {
                    if(!statment_tree_internal_commands_scan(argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, parent_blocks, return_, enable_return, break_, enable_break, code, envs, object, running_fun, running_class, lf)) {
                        string_delete(field);
                        return FALSE;
                    }
                    
                    if(enable_break && *break_) {
                        string_delete(field);
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        string_delete(field);
                        return TRUE;
                    }
                }
                else {
                    if(!statment_tree_internal_commands_scan_oneline(argv, field, input, nextout, nextin, rcode, ignore_case, multiline, sname, sline, blocks, nexterr, parent_blocks, return_, enable_return, break_, enable_break, code, envs, object, running_fun, running_class, lf)) {
                        string_delete(field);
                        return FALSE;
                    }
                    
                    if(enable_break && *break_) {
                        string_delete(field);
                        return TRUE;
                    }
                    else if(enable_return && *return_) {
                        string_delete(field);
                        return TRUE;
                    }
                }
            }
            else if(input) {
                int match_count = 0;

                if(vector_size(argv) >= 2) {
                    if(line_oriented) {
                        char* regex = string_c_str(vector_item(argv, 1));
                        char* regex2 = regex;

                        int n = 1;
                        for(;;) {
                            string_obj* str = STRING_NEW("");
                            int ret = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                            if(ret == -1) {
                                err_msg("interrupt", sname, sline);
                                string_delete(field);
                                string_delete(str);
                                return FALSE;
                            }
                            else if(ret == 1) 
                            {
                                string_delete(str);
                                break;
                            }

                            string_chomp(str);
                            
                            if(!statment_tree_internal_commands_match(
                                string_c_str(str), regex2, rcode, nextout
                                , !quiet, line_field, line_num, n, field
                                , line_oriented, &match_count
                                , ignore_case
                                , multiline
                                , sname
                                , sline
                                , code
                                , lf
                                ))
                            {
                                string_delete(str);
                                string_delete(field);
                                return FALSE;
                            }

                            n++;

                            string_delete(str);
                        }
                    }
                    else {
                        char* regex = string_c_str(vector_item(argv, 1));
                        char* regex2 = regex;

                        int n = 0;
                        string_obj* str = STRING_NEW("");
                        BOOL ret = statment_tree_internal_commands_read_nextin(nextin, str);
                        if(ret == 1) {
                            string_delete(str);
                            *rcode = 1;
                            break;
                        }
                        else if(ret < 0) {
                            err_msg("interrupt", sname, sline);
                            string_delete(field);
                            string_delete(str);
                            return FALSE;
                        }
                        
                        if(!statment_tree_internal_commands_match(
                            string_c_str(str), regex2, rcode, nextout
                            , !quiet, line_field, line_num, n, field
                            , line_oriented, &match_count, ignore_case
                            , multiline
                            , sname
                            , sline
                            , code
                            , lf
                            ))
                        {
                            string_delete(str);
                            string_delete(field);
                            return FALSE;
                        }

                        string_delete(str);
                    }
                }

                char buf[256];
                snprintf(buf, 256, "%d", match_count);
                saphire_set_local_var("MATCH_COUNT", buf);
            }
            else {
                int match_count = 0;

                string_obj* str;
                if(vector_size(argv) == 3) {
                    str = STRING_NEW(string_c_str(vector_item(argv, 1)));
                }
                else {
                    break;
                }

                char* str2 = string_c_str(str);

                char* regex = string_c_str(vector_item(argv, 2));
                char* regex2 = regex;

                if(!statment_tree_internal_commands_match(
                    str2, regex2, rcode, nextout, !quiet, line_field
                    , line_num, 1, field, line_oriented, &match_count
                    , ignore_case
                    , multiline
                    , sname
                    , sline
                    , code
                    , lf
                    ))
                {
                    string_delete(field);
                    string_delete(str);
                    return FALSE;
                }


                char buf[256];
                snprintf(buf, 256, "%d", match_count);
                saphire_set_local_var("MATCH_COUNT", buf);

                string_delete(str);
            }

            string_delete(field);

            }
            break;

        case kSub: {
            BOOL global = FALSE;
            BOOL quiet = FALSE;
            BOOL multiline = FALSE;
            BOOL check = FALSE;
            BOOL ignore_case = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-g") == 0) {
                    global = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-i") == 0) {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0) {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0) {
                    check = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }
            if(multiline || !global) {
                if(!statment_tree_internal_commands_sub(global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, code, envs, object, running_fun, running_class, input, argv))
                {
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_sub_oneline(global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, code, envs, object, running_fun, running_class, input, argv, lf))
                {
                    return FALSE;
                }
            }
            if(enable_break && *break_) {
                return TRUE;
            }
            else if(enable_return && *return_) {
                return TRUE;
            }

            }
            break;

        case kGSub: {
            BOOL global = TRUE;
            BOOL quiet = FALSE;
            BOOL multiline = FALSE;
            BOOL check = FALSE;
            BOOL ignore_case = FALSE;
            enum eKanjiCode code = gKanjiCode;
            enum eLineField lf = gLineField;
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv, i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-i") == 0) {
                    ignore_case = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0) {
                    multiline = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-q") == 0) {
                    quiet = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0) {
                    check = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-s") == 0) {
                    code = kSjis;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-e") == 0) {
                    code = kEucjp;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-w") == 0) {
                    code = kUtf8;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(multiline) {
                if(!statment_tree_internal_commands_sub(global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, code, envs, object, running_fun, running_class, input, argv))
                {
                    return FALSE;
                }
            }
            else {
                if(!statment_tree_internal_commands_sub_oneline(global, blocks, quiet, multiline, check, ignore_case, rcode, nextout, sname, sline, nextin, nexterr, return_, enable_return, break_, enable_break, parent_blocks, code, envs, object, running_fun, running_class, input, argv, lf))
                {
                    return FALSE;
                }
            }
            if(enable_break && *break_) {
                return TRUE;
            }
            else if(enable_return && *return_) {
                return TRUE;
            }

            }
            break;

        case kRead: {
            BOOL flg_n = FALSE;
            int n;
            BOOL flg_c = FALSE;
            int c;
            BOOL all = FALSE;
            BOOL preserve = FALSE;
            enum eLineField lf = gLineField;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-n") == 0 && l+1 < vector_size(argv)) {
                    flg_n = TRUE;
                    n = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0 && l+1 < vector_size(argv)) {
                    flg_c = TRUE;
                    c = atoi(string_c_str(vector_item(argv, l+1)));
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-a") == 0) {
                    all = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-p") == 0) {
                    preserve = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(vector_size(argv) == 1) {
                if(all) {
                    string_obj* str = STRING_NEW("");
                    int ret;
                    if(preserve) {
                        ret = statment_tree_internal_commands_read_nextin_preserve(nextin, str);
                    }
                    else {
                        ret = statment_tree_internal_commands_read_nextin(nextin, str);
                    }

                    if(ret == 1) {
                        string_delete(str);
                        *rcode = 1;
                        break;
                    }
                    else if(ret < 0)
                    {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }

                        *rcode = 0;
                    }

                    string_delete(str);
                }
                else if(flg_c) {
                    if(preserve) {
                        string_obj* out = STRING_NEW("");

                        int result = statment_tree_internal_commands_read_nextin_onechar_preserve_num(nextin, out, c);

                        if(result == -1) {
                            err_msg("interrupt", sname, sline);

                            string_delete(out);
                            return FALSE;
                        }
                        else if(result == 1) {
                            string_delete(out);
                            break;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(out);

                            return FALSE;
                        }
                        *rcode = 0;

                        string_delete(out);
                    }
                    else {
                        string_obj* out = STRING_NEW("");

                        int result = statment_tree_internal_commands_read_nextin_onechar_num(nextin, out, c);

                        if(result == -1) {
                            err_msg("interrupt", sname, sline);

                            string_delete(out);
                            return FALSE;
                        }
                        else if(result == 1) {
                            string_delete(out);
                            break;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(out);

                            return FALSE;
                        }
                        *rcode = 0;

                        string_delete(out);
                    }
                }
                else if(flg_n) {
                    if(preserve) {
                        string_obj* out = STRING_NEW("");

                        int result = statment_tree_internal_commands_read_nextin_oneline_preserve_num(nextin, out, n, lf);

                        if(result == -1) {
                            err_msg("interrupt", sname, sline);

                            string_delete(out);
                            return FALSE;
                        }
                        else if(result == 1) {
                            string_delete(out);
                            break;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(out)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(out);

                            return FALSE;
                        }
                        *rcode = 0;

                        string_delete(out);
                    }
                    else {
                        string_obj* str = STRING_NEW("");
                        int result = statment_tree_internal_commands_read_nextin_oneline_num(nextin, str, n, lf);

                        if(result == -1) {
                            err_msg("interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                        else if(result == 1) {
                            string_delete(str);
                            break;
                        }

                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);

                            string_delete(str);
                            return FALSE;
                        }
                        *rcode = 0;

                        string_delete(str);
                    }
                }
                else {
                    string_obj* str = STRING_NEW("");
                    int result;
                    if(preserve) {
                        result = statment_tree_internal_commands_read_nextin_oneline_preserve(nextin, str, lf);
                    }
                    else {
                        result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    }

                    if(result == 0) { 
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);

                            string_delete(str);

                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);

                        return FALSE;
                    }

                    string_delete(str);
                }
            }
            else if(vector_size(argv) == 2) {
                char* fname = string_c_str(vector_item(argv, 1));

                sRFd* rfd = hash_item(gReadBuffers, fname);
                if(rfd == 0) {
                    int fd = open(fname, O_RDONLY);

                    if(fd < 0) {
                        char buf[64];
                        snprintf(buf, 64, "read: can't open file %s", fname);
                        err_msg(buf, sname, sline);
                        return FALSE;
                    }
                    
                    rfd = RFD_NEW(fd);
                    hash_put(gReadBuffers, fname, rfd);
                }

                if(all) {
                    string_obj* str = STRING_NEW("");
                    int ret = statment_tree_internal_commands_read_nextin(rfd, str);
                    if(ret == 1) {
                        *rcode = 1;
                        sRFd_close(rfd);
                        string_delete(str);
                        sRFd_delete(rfd);
                        hash_erase(gReadBuffers, fname);
                        break;
                    }
                    else if(ret < 0)
                    {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }

                        sRFd_close(rfd);
                        sRFd_delete(rfd);
                        hash_erase(gReadBuffers, fname);

                        *rcode = 0;
                    }

                    string_delete(str);
                }
                else if(flg_n) {
                    int i;
                    for(i=0; i<n; i++) {
                        string_obj* str = STRING_NEW("");
                        int result = statment_tree_internal_commands_read_nextin_oneline(rfd, str, lf);

                        if(result == 0) { 
                            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                            {
                                err_msg("signal interrupt", sname, sline);
                                string_delete(str);

                                return FALSE;
                            }
                            *rcode = 0;
                        }
                        else if(result == -1) {
                            err_msg("interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                        else {
                            sRFd_close(rfd);
                            sRFd_delete(rfd);
                            hash_erase(gReadBuffers, fname);
                            string_delete(str);
                            break;
                        }

                        string_delete(str);
                    }
                }
                else {
                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(rfd, str, lf);

                    if(result == 0) { 
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
                        {
                            err_msg("signal interrupt", sname, sline);
                            string_delete(str);

                            return FALSE;
                        }
                        *rcode = 0;
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    else {
                        sRFd_close(rfd);
                        sRFd_delete(rfd);
                        hash_erase(gReadBuffers, fname);
                    }

                    string_delete(str);
                }
            }

            }
            break;

        case kClose: {
            BOOL all = FALSE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-a") == 0) {
                    all = TRUE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(vector_size(argv) == 1 && all) {
                hash_it* it = hash_loop_begin(gReadBuffers);
                while(it) {
                    sRFd* rfd = hash_loop_item(it);
                    (void)close(rfd->mFd);
                    it = hash_loop_next(it);
                }
                hash_clear(gReadBuffers);
                *rcode = 0;
            }
            else if(vector_size(argv) == 2) {
                char* fname = string_c_str(vector_item(argv, 1));

                sRFd* rfd = hash_item(gReadBuffers, fname);
                if(rfd) {
                    (void)close(rfd->mFd);
                    sRFd_close(rfd);

                    sRFd_delete(rfd);
                    hash_erase(gReadBuffers, fname);
                    *rcode = 0;
                }
            }

            }
            break;

        case kCd:
            if(vector_size(argv) == 1) {
                char* path = getenv("HOME");
                if(path) {
                    char cwd[PATH_MAX];
                    char path2[PATH_MAX];

                    mygetcwd(cwd, PATH_MAX);

                    if(correct_path(cwd, path, path2, PATH_MAX)) {
                        struct stat stat_;
                        if(stat(path2, &stat_) == 0) {
                            if(S_ISDIR(stat_.st_mode)) {
                                setenv("PWD", path2, 1);
                                if(chdir(path2) >= 0) {
                                    *rcode = 0;
                                }
                            }
                        }
                    }
                }
            }
            else if(vector_size(argv) == 2) {
                char* path = string_c_str(vector_item(argv, 1));
                char cwd[PATH_MAX];
                char path2[PATH_MAX];

                mygetcwd(cwd, PATH_MAX);
                if(correct_path(cwd, path, path2, PATH_MAX)) {
                    struct stat stat_;
                    if(stat(path2, &stat_) == 0) {
                        if(S_ISDIR(stat_.st_mode)) {
                            setenv("PWD", path2, 1);
                            if(chdir(path2) >= 0) {
                                *rcode = 0;
                            }
                        }
                    }
                }
            }
            break;

        case kSelector: {
            static int scrolltop = 0;
            static int cursor = 0;
            BOOL multiple = FALSE;
            BOOL init_cursor = TRUE;
            BOOL init_scrolltop = TRUE;
            enum eLineField lf = gLineField;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-r") == 0) {
                    init_cursor = FALSE;
                    init_scrolltop = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-c") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    init_cursor = FALSE;
                    cursor = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-t") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    init_scrolltop = FALSE;
                    scrolltop = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-m") == 0) {
                    multiple = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(init_scrolltop) {
                scrolltop = 0;
            }
            if(init_cursor) {
                cursor = 0;
            }

            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin,str) ;
            if(ret == 1) {
                string_delete(str);
                *rcode = 1;
                break;
            }
            else if(ret < 0)
            {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            string_obj* result = STRING_NEW("");
            if(!statment_tree_internal_commands_selector(str,result
                    , &scrolltop, &cursor, kUtf8, multiple, lf
                    , sname, sline))
            {
                string_delete(result);
                string_delete(str);

                return FALSE;
            }
            string_delete(str);

            if(strcmp(string_c_str(result), "") != 0) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(result)))
                {
                    err_msg("sinal interrupt", sname, sline);
                    string_delete(result);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  lf))
                {
                    err_msg("singal interrupt", sname, sline);
                    string_delete(result);
                    return FALSE;
                }
                *rcode = 0;
            }

            string_delete(result);
            }
            break;

        case kMax: {
            BOOL new_line = TRUE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(vector_size(argv) == 3) {
                int left = atoi(string_c_str(vector_item(argv, 1)));
                int right = atoi(string_c_str(vector_item(argv, 2)));

                if(left > right) {
                    *rcode = 0;
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 1))))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else {
                    *rcode = 0;
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 2))))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                }
            }
            }
            break;

        case kMin: {
            BOOL new_line = TRUE;

            int l;
            for(l=0; l<vector_size(argv); l++) {
                char* arg = string_c_str(vector_item(argv, l));

                if(strcmp(arg, "-l") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, l));
                    vector_erase(argv, l);
                    l--;
                    continue;
                }
            }

            if(vector_size(argv) == 3) {
                int left = atoi(string_c_str(vector_item(argv, 1)));
                int right = atoi(string_c_str(vector_item(argv, 2)));

                if(left < right) {
                    *rcode = 0;
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 1))))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                }
                else {
                    *rcode = 0;
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(argv, 2))))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                }
            }
            }
            break;
        

        case kExtName: {
            BOOL new_line = TRUE;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                string_obj* item = vector_item(argv, i);
                if(strcmp(string_c_str(item), "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(string_c_str(item), "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 1 && input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                char* target = string_c_str(str);
                char path[PATH_MAX];
                extname(path, PATH_MAX, target);

                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else if(vector_size(argv) == 2) {
                char path[PATH_MAX];
                extname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }
            }
            }
            break;

        case kParentName: {
            BOOL new_line = TRUE;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                string_obj* item = vector_item(argv, i);
                if(strcmp(string_c_str(item), "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(string_c_str(item), "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(argv) == 1 && input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                char* target = string_c_str(str);
                char path[PATH_MAX];
                parentname(path, PATH_MAX, target);
                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else if(vector_size(argv) == 2) {
                char path[PATH_MAX];
                parentname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                    *rcode = 0;
                }
            }
            }
            break;

        case kNoExtName: {
            BOOL new_line = TRUE;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                string_obj* item = vector_item(argv, i);
                if(strcmp(string_c_str(item), "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(string_c_str(item), "-nl") == 0) {
                    new_line = FALSE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(argv) == 1 && input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                        nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                char* target = string_c_str(str);
                char path[PATH_MAX];
                noextname(path, PATH_MAX, target);
                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        string_delete(str);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            string_delete(str);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }

                string_delete(str);
            }
            else if(vector_size(argv) == 2) {
                char path[PATH_MAX];
                noextname(path, PATH_MAX, string_c_str(vector_item(argv, 1)));
                if(strcmp(path, "") != 0) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, path))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(new_line) {
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }

                    *rcode = 0;
                }
            }
            }
            break;

        case kPopd: {
            string_obj* pwd = vector_pop_back(gDirStack);

            if(pwd) {
                char* path = string_c_str(pwd);
                char cwd[PATH_MAX];
                char path2[PATH_MAX];

                mygetcwd(cwd, PATH_MAX);
                if(correct_path(cwd, path, path2, PATH_MAX)) {
                    struct stat stat_;

                    if(stat(path2, &stat_) == 0) {
                        if(S_ISDIR(stat_.st_mode)) {
                            setenv("PWD", path2, 1);
                            if(chdir(path2) >= 0) {
                                *rcode = 0;
                            }
                        }
                    }
                }

                string_delete(pwd);
            }
            }
            break;

        case kPushd:
            vector_add(gDirStack, STRING_NEW(getenv("PWD")));
            *rcode = 0;
            break;

        case kSort: {
            int k;
            enum eLineField lf = gLineField;
            for(k=0; k<vector_size(argv); k++) {
                char* arg = string_c_str(vector_item(argv,k));
                if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, k));
                    vector_erase(argv, k);
                    k--;
                    continue;
                }
            }

            sBlock* sort_block;
            sBlock* maked_block = NULL;
            int line = 1;
            if(vector_size(blocks) >= 1) {
                sort_block = vector_item(blocks, 0);
            }
            else if(vector_size(argv) == 1) {
                sStatments* statments = STATMENTS_NEW();
                if(lf == kLF) {
                    if(! parse("| var -Lu _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
                    {
                        err_msg("invalid sort block", sname, sline);
                        sStatments_delete(statments);
                        return FALSE;
                    }
                }
                else if(lf == kCR) {
                    if(! parse("| var -Lm _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
                    {
                        err_msg("invalid sort block", sname, sline);
                        sStatments_delete(statments);
                        return FALSE;
                    }
                }
                else if(lf == kCRLF) {
                    if(! parse("| var -Lw _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
                    {
                        err_msg("invalid sort block", sname, sline);
                        sStatments_delete(statments);
                        return FALSE;
                    }
                }
                else {
                    if(! parse("| var -La _a _b; [ $(var _a) -slt $(var _b) ]", "sort block", &line, statments))
                    {
                        err_msg("invalid sort block", sname, sline);
                        sStatments_delete(statments);
                        return FALSE;
                    }
                }

                vector_obj* args = VECTOR_NEW(10);
                maked_block = sort_block = sBlock_new(MANAGED statments, MANAGED args, 0);
            }
            else {
                break;
            }

            vector_obj* v = VECTOR_NEW(100);
            while(1) {
                if(gKitutukiSigInt)  {
                    err_msg("intterrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
                string_obj* str = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

                if(result == -1) {  // CTRL_C
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
                else if(result == 1) { // EOF
                    string_delete(str);
                    break;
                }

                vector_add(v, str);
            }

            gSortBlock = sort_block;
            gSortNextOut = nextout;
            gSortNextIn = nextin;
            gSortNextErr = nexterr;
            gSortParentBlocks = parent_blocks;
            gSortReturn = return_;
            gSortEnableReturn = enable_return;
            gSortBreak = break_;
            gSortEnableBreak = enable_break;
            gSortEnvs = envs;
            gSortObject = object;
            gSortRunningFun = running_fun;
            gSortRunningClass = running_class;
            if(!vector_sort(v, sort_fun)) {
                err_msg("interrupt", sname, sline);
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return FALSE;
            }
            if(*return_) {
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                return TRUE;
            }

            /// 出力 ///
            int i;
            for(i=0; i<vector_size(v); i++) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(vector_item(v, i))))
                {
                    err_msg("signal interrupt", sname, sline);
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
            }

            for(i=0; i<vector_size(v); i++) {
                string_delete(vector_item(v, i));
            }
            vector_delete(v);

            if(maked_block) {
                sBlock_delete(maked_block);
            }

            *rcode = 0;
            }
            break;

        case kMinusMinus: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) - 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);

                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
                *rcode = 0;

                string_delete(str);
            }
            else {
                if(vector_size(argv) == 2) {
                    char* arg = string_c_str(vector_item(argv, 1));

                    char* var = saphire_get_local_var(arg);
                    if(var) {
                        int n = atoi(var) - 1;
                        char buf[128];
                        snprintf(buf, 128, "%d", n);
                        saphire_set_local_var(arg, buf);
                    }
                    else {
                        int n = - 1;
                        char buf[128];
                        snprintf(buf, 128, "%d", n);
                        saphire_set_local_var(arg, buf);
                    }
                    *rcode = 0;
                }
            }
            }
            break;

        case kPlusPlus: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) + 1;
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;

                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            else {
                if(vector_size(argv) == 2) {
                    char* arg = string_c_str(vector_item(argv, 1));

                    char* var = saphire_get_local_var(arg);
                    if(var) {
                        int n = atoi(var) + 1;
                        char buf[128];
                        snprintf(buf, 128, "%d", n);
                        saphire_set_local_var(arg, buf);
                    }
                    else {
                        int n = 1;
                        char buf[128];
                        snprintf(buf, 128, "%d", n);
                        saphire_set_local_var(arg, buf);
                    }
                    *rcode = 0;
                }
            }
            }
            break;

        case kPlus: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) + atoi(string_c_str(vector_item(argv, 1)));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kMinus: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) - atoi(string_c_str(vector_item(argv, 1)));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kMult: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    string_delete(str);
                    *rcode = 1;
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) * atoi(string_c_str(vector_item(argv, 1)));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kDiv: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) 
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) / atoi(string_c_str(vector_item(argv, 1)));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kMod: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = atoi(string_c_str(str)) % atoi(string_c_str(vector_item(argv, 1)));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kPow: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                int n = pow(atoi(string_c_str(str)), atoi(string_c_str(vector_item(argv, 1))));
                char buf[128];
                snprintf(buf, 128, "%d", n);
                *rcode = 0;


                if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_delete(str);
            }
            }
            break;

        case kRange: {
            if(vector_size(argv) == 3) {
                int first = atoi(string_c_str(vector_item(argv, 1)));
                int last = atoi(string_c_str(vector_item(argv, 2)));

                int i;
                for(i=first; i<=last; i++) {
                    char buf[BUFSIZ];
                    snprintf(buf, BUFSIZ, "%d", i);
                    if(!statment_tree_internal_commands_write_nextout(nextout, buf))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                    *rcode = 0;
                }
            }
            }
            break;

        case kPrintf: {
            int i;
            BOOL line_field = FALSE;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-l") == 0) {
                    line_field = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(input && vector_size(argv) == 2) {
                /// 引数を取る ///
                vector_obj* v = VECTOR_NEW(30);
                while(1) {
                    if(gKitutukiSigInt) {
                        err_msg("interrupt", sname, sline);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }

                    string_obj* str = STRING_NEW("");
                    int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);
                    if(result == 0) {
                        string_chomp(str);
                        vector_add(v, str);
                    }
                    else if(result == -1) {
                        err_msg("interrupt", sname, sline);
                        string_delete(str);
                        int i;
                        for(i=0; i<vector_size(v); i++) {
                            string_delete(vector_item(v, i));
                        }
                        vector_delete(v);
                        return FALSE;
                    }
                    else {
                        string_delete(str);
                        break;
                    }
                }

                /// 本題 ///
                char* format = string_c_str(vector_item(argv, 1));

                if(!statment_tree_internal_commands_printf(format, v, nextout, line_field, sname, sline, lf)) {

                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }
                *rcode = 0;
                int i;
                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
            }
            else if(vector_size(argv) > 2) {
                /// 引数を取る ///
                vector_obj* v = VECTOR_NEW(30);
                int i;
                for(i=2; i<vector_size(argv); i++) {
                    vector_add(v, STRING_NEW(string_c_str(vector_item(argv, i))));
                }

                /// 本題 ///
                char* format = string_c_str(vector_item(argv, 1));

                if(!statment_tree_internal_commands_printf(format, v, nextout, line_field, sname, sline, lf)) 
                {
                    int i;
                    for(i=0; i<vector_size(v); i++) {
                        string_delete(vector_item(v, i));
                    }
                    vector_delete(v);
                    return FALSE;
                }

                for(i=0; i<vector_size(v); i++) {
                    string_delete(vector_item(v, i));
                }
                vector_delete(v);
                *rcode = 0;

            }
            
            }
            break;

        case kPomch: {
            int i;
            enum eLineField lf = gLineField;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str;
            if(input) {
                str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }
            else {
                if(vector_size(argv) >= 2) {
                    str = STRING_NEW(string_c_str(vector_item(argv, 1)));
                }
                else {
                    str = STRING_NEW("");
                }
            }

            string_pomch(str, lf);
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str))) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            *rcode = 0;
            string_delete(str);
            }
            break;

        case kPTee: {
            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                break;
            }
            else if(ret < 0) {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            int i;
            for(i=0; i<vector_size(blocks); i++) {
                sBlock* block = vector_item(blocks, i);
                sStatments* statments = block->mStatments;
                sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));

                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: ptee", sname, sline);
                *rcode = run(statments, fname, nextout
                            , nextin2, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                FREE(fname);
                sRFd_delete(nextin2);

                if(enable_break && *break_) {
                    string_delete(str);
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    string_delete(str);
                    return TRUE;
                }
                else if(*rcode < 0) {
                    string_delete(str);
                    return FALSE;
                }
            }

            string_delete(str);

            }
            break;

        case kPCat: {
            int i;
            for(i=0; i<vector_size(blocks); i++) {
                sBlock* block = vector_item(blocks, i);
                sStatments* statments = block->mStatments;

                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: pcat", sname, sline);
                *rcode = run(statments, fname, nextout
                            , nextin, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);
                FREE(fname);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                else if(*rcode < 0) {
                    return FALSE;
                }
            }
            }
            break;

        case kReturn: {
            if(vector_size(argv) == 1) {
                *return_ = TRUE;
                *rcode = 0;
                return TRUE;
            }
            else if(vector_size(argv) > 1) {
                *return_ = TRUE;
                *rcode = atoi(string_c_str(vector_item(argv, 1)));
                return TRUE;
            }
            }
            break;

        case kMInitScr:
            minitscr();
            *rcode = 0;
            break;

        case kMEndWin:
            mendwin();
            *rcode = 0;
            break;

        case kMClear:
            mclear();
            *rcode = 0;
            break;

        case kMClearImmediately:
            mclear_immediately();
            *rcode = 0;
            break;

        case kMRefresh:
            mrefresh();
            *rcode = 0;
            break;

        case kMMove:
            if(vector_size(argv) == 3) {
                mmove(atoi(string_c_str(vector_item(argv, 1)))
                    , atoi(string_c_str(vector_item(argv, 2))));
                *rcode = 0;
            }
            break;

        case kMMoveImmediately:
            if(vector_size(argv) == 3) {
                mmove_immediately(atoi(string_c_str(vector_item(argv, 1)))
                    , atoi(string_c_str(vector_item(argv, 2))));
                *rcode = 0;
            }
            break;

        case kMPrintw: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str;
            if(input) {
                str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }
            else {
                if(vector_size(argv) >= 2) {
                    str = STRING_NEW(string_c_str(vector_item(argv, 1)));
                }
                else {
                    str = STRING_NEW("");
                }
            }

            *rcode = 0;
            mprintw("%s", string_c_str(str));

            string_delete(str);
            }
            break;

        case kYeild: {
            int block_num;
            if(vector_size(argv) > 1) {
                block_num = atoi(string_c_str(vector_item(argv, 1)));
            }
            else {
                block_num = 0;
            }

            if(parent_blocks && block_num < vector_size(parent_blocks)) {
                sBlock* block = vector_item(parent_blocks, block_num);
                sStatments* statments = block->mStatments;

                int i;
                for(i=0; i<vector_size(block->mArgs); i++) {
                    string_obj* arg = vector_item(block->mArgs, i);

                    if(i+2 < vector_size(argv)) {
                        saphire_set_local_var(string_c_str(arg), string_c_str(vector_item(argv, i+2)));
                    }
                }

                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: yeild", sname, sline);

                *rcode = run(statments, fname, nextout
                            , nextin, nexterr
                            , return_, enable_return, break_, enable_break, parent_blocks, FALSE, envs, object, running_fun, running_class);

                FREE(fname);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                if(*rcode < 0) {
                    return FALSE;
                }
            }
            }
            break;

        case kEach: {
            int i;
            enum eLineField lf = gLineField;
            int number = 1;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-n") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    number = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(vector_size(blocks) >= 1) {
                if(number == 1) {
                    char* fname = MALLOC(strlen(sname) + 32);
                    snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    string_obj* arg;
                    if(vector_size(block->mArgs) >= 1) {
                        arg = vector_item(block->mArgs, 0);
                    }
                    else {
                        arg = NULL;
                    }

                    int i = 0;
                    while(1) {
                        if(gKitutukiSigInt)  {
                            err_msg("intterrupt", sname, sline);
                            FREE(fname);
                            return FALSE;
                        }
                        string_obj* str = STRING_NEW("");
                        int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, lf);

                        if(result == -1) {  // CTRL_C
                            err_msg("interrupt KKKK", sname, sline);
                            string_delete(str);
                            FREE(fname);
                            return FALSE;
                        }
                        else if(result == 1) { // EOF
                            string_delete(str);
                            break;
                        }

                        if(arg) {
                            char buf[1024];
                            snprintf(buf, 1024, "%d", i);
                            saphire_set_local_var(string_c_str(arg), buf);
                        }

                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                        *rcode = run(statments
                                , fname, nextout
                                , nextin2, nexterr
                                , return_, enable_return, break_, TRUE, parent_blocks, FALSE, envs, object, running_fun, running_class);

                        sRFd_delete(nextin2);

                        if(*break_) {
                            *break_ = FALSE;
                            string_delete(str);
                            break;
                        }
                        else if(enable_return && *return_) {
                            string_delete(str);
                            FREE(fname);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(str);
                            FREE(fname);
                            return FALSE;
                        }
                        i++;

                        string_delete(str);
                    }

                    FREE(fname);
                }
                else if(number >= 2) {
                    char* fname = MALLOC(strlen(sname) + 32);
                    snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
                    sBlock* block = vector_item(blocks, 0);
                    sStatments* statments = block->mStatments;

                    string_obj* arg;
                    if(vector_size(block->mArgs) >= 1) {
                        arg = vector_item(block->mArgs, 0);
                    }
                    else {
                        arg = NULL;
                    }

                    int i = 0;
                    while(1) {
                        if(gKitutukiSigInt)  {
                            err_msg("intterrupt", sname, sline);
                            FREE(fname);
                            return FALSE;
                        }
                        string_obj* str = STRING_NEW("");
                        int result = statment_tree_internal_commands_read_nextin_oneline_num(nextin, str, number, lf);

                        if(result == -1) {  // CTRL_C
                            err_msg("interrupt KKKK", sname, sline);
                            string_delete(str);
                            FREE(fname);
                            return FALSE;
                        }
                        else if(result == 1) { // EOF
                            string_delete(str);
                            break;
                        }

                        if(arg) {
                            char buf[1024];
                            snprintf(buf, 1024, "%d", i);
                            saphire_set_local_var(string_c_str(arg), buf);
                        }

                        sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                        *rcode = run(statments
                                , fname, nextout
                                , nextin2, nexterr
                                , return_, enable_return, break_, TRUE, parent_blocks, FALSE, envs, object, running_fun, running_class);

                        sRFd_delete(nextin2);

                        if(*break_) {
                            *break_ = FALSE;
                            string_delete(str);
                            break;
                        }
                        else if(enable_return && *return_) {
                            string_delete(str);
                            FREE(fname);
                            return TRUE;
                        }
                        else if(*rcode < 0) {
                            string_delete(str);
                            FREE(fname);
                            return FALSE;
                        }
                        i++;

                        string_delete(str);
                    }

                    FREE(fname);
                }
            }
            }
            break;

        case kForeach: {
            if(vector_size(blocks) >= 1) {
                char* fname = MALLOC(strlen(sname) + 32);
                snprintf(fname, strlen(sname) + 32, "%s %d: each", sname, sline);
                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;

                int i;
                for(i=1; i<vector_size(argv); i++) {
                    if(gKitutukiSigInt)  {
                        err_msg("intterrupt", sname, sline);
                        FREE(fname);
                        return FALSE;
                    }
                    string_obj* str = vector_item(argv, i);

                    sRFd* nextin2 = RFD_NEW2(-1, string_c_str(str));
                    *rcode = run(statments
                            , fname, nextout
                            , nextin2, nexterr
                            , return_, enable_return, break_, TRUE, parent_blocks, FALSE, envs, object, running_fun, running_class);
                    sRFd_delete(nextin2);

                    if(enable_break && *break_) {
                        *break_ = FALSE;
                        break;
                    }
                    else if(enable_return && *return_) {
                        FREE(fname);
                        return TRUE;
                    }
                    else if(*rcode < 0) {
                        FREE(fname);
                        return FALSE;
                    }
                }

                FREE(fname);
            }
            }
            break;

        case kAbs: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str = STRING_NEW("");
            if(input) {
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) {
                    *rcode = 2;
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }
            else if(vector_size(argv) >= 2){
                string_put(str, string_c_str(vector_item(argv, 1)));
            }
            else {
                err_msg("abs: invalid argument", sname, sline);
                string_delete(str);
                return FALSE;
            }

            int n = abs(atoi(string_c_str(str)));
            string_delete(str);
            *rcode = 0;

            char buf[1024];
            snprintf(buf, 1024, "%d", n);
            if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
            {
                err_msg("interrupt Kasdf", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }


            
            }
            break;

        case kFAbs: {
            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-I") == 0) {
                    input = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str = STRING_NEW("");
            if(input) {
                int ret = statment_tree_internal_commands_read_nextin(nextin, str) ;
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0) {
                    *rcode = 2;
                    err_msg("interrupt asdfasdfas", sname, sline);
                    string_delete(str);
                    return FALSE;
                }
            }
            else if(vector_size(argv) >= 2){
                string_put(str, string_c_str(vector_item(argv, 1)));
            }
            else {
                err_msg("abs: invalid argument", sname, sline);
                string_delete(str);
                return FALSE;
            }

            double n = fabs(atof(string_c_str(str)));
            string_delete(str);
            *rcode = 0;

            char buf[1024];
            snprintf(buf, 1024, "%lf", n);
            if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
            {
                err_msg("interrupt GGG", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }


            
            }
            break;

        case kP: {
            int scrolltop = -1;
            int cursor = -1;
            enum eLineField lf = gLineField;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-c") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    cursor = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-t") == 0 
                    && i+1 < vector_size(argv)) 
                {
                    scrolltop = atoi(string_c_str(vector_item(argv, i+1)));
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(scrolltop == -1) {
                scrolltop = 0;
            }
            if(cursor == -1) {
                cursor = 0;
            }

            string_obj* str = STRING_NEW("");
            int ret = statment_tree_internal_commands_read_nextin(nextin,str) ;
            if(ret == 1) {
                *rcode = 1;
                string_delete(str);
                break;
            }
            else if(ret < 0)
            {
                err_msg("interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }
            int result = -1;
            if(!statment_tree_internal_commands_p(str, &result, &scrolltop, &cursor, kUtf8, lf,sname, sline))
            {
                string_delete(str);
                return FALSE;
            }

            if(result == -1 || !statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("interrupt", sname, sline);

                string_delete(str);

                return FALSE;
            }
            *rcode = 0;

            string_delete(str);

            }
            break;

        case kQuote: {
            int i;
            BOOL bashquote = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-b") == 0) {
                    bashquote = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }
            if(input) {
                string_obj* str = STRING_NEW("");
                int ret = statment_tree_internal_commands_read_nextin(
                                    nextin, str);
                if(ret == 1) {
                    *rcode = 1;
                    string_delete(str);
                    break;
                }
                else if(ret < 0)
                {
                    err_msg("interrupt a", sname, sline);
                    string_delete(str);
                    return FALSE;
                }

                string_obj* quoted = STRING_NEW("");
                if(bashquote) {
                    bash_get_quoted_fname(string_c_str(str), quoted);
                }
                else {
                    saphire_get_quoted_fname(string_c_str(str), quoted);
                }
                string_delete(str);
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(quoted)) )
                {
                    err_msg("signal interrupt", sname, sline);
                    string_delete(quoted);
                    return FALSE;
                }

                *rcode = 0;
                string_delete(quoted);
            }
            else if(vector_size(argv) >= 1) {
                int i;
                for(i=1; i<vector_size(argv); i++) {
                    string_obj* str = vector_item(argv, i);

                    string_obj* quoted = STRING_NEW("");
                    if(bashquote) {
                        bash_get_quoted_fname(string_c_str(str), quoted);
                    }
                    else {
                        saphire_get_quoted_fname(string_c_str(str), quoted);
                    }
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(quoted)) )
                    {
                        string_delete(quoted);
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    string_delete(quoted);
                }

                *rcode = 0;
            }
            }
            break;

        case kTime: {
            if(vector_size(blocks) >= 1) {
                sBlock* block = vector_item(blocks, 0);
                sStatments* statments = block->mStatments;


                time_t timer;
                time(&timer);

                *rcode = run(statments
                        , "time", nextout
                        , nextin, nexterr
                        , return_, enable_return, break_, TRUE, parent_blocks, FALSE, envs, object, running_fun, running_class);

                if(enable_break && *break_) {
                    return TRUE;
                }
                else if(enable_return && *return_) {
                    return TRUE;
                }
                if(*rcode < 0) {
                    return FALSE;
                }

                time_t timer2;
                time(&timer2);
               

                int sec = timer2 - timer;
                int minuts = sec / 60;
                int sec2 = sec - minuts * 60;

                char buf[1024];
                snprintf(buf, 1024, "%d sec(%d minuts %d sec)\n", sec, minuts, sec2);

                if(!statment_tree_internal_commands_write_nextout(nextout, buf) )
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
            }
            }
            break;

        case kFSelector: {
            int i;
            BOOL multiple = FALSE;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-m") == 0) {
                    multiple = TRUE;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            if(!statment_tree_internal_commands_fselector(nextout, sname, sline, multiple))
            {
                return FALSE;
            }
            *rcode = 0;
            }
            break;

        case kUnset: {
            if(vector_size(argv) == 2) {
                char* name = string_c_str(vector_item(argv, 1));
                if(unsetenv(name) == 0) {
                    *rcode = 0;
                }
                else {
                    err_msg("invalid env name", sname, sline);
                    return FALSE;
                }
            }
            }
            break;

        case kUMask: {
            if(vector_size(argv) == 2) {
                int number = strtol(string_c_str(vector_item(argv, 1)), NULL, 8);
                umask(number);
                *rcode =0;
            }
            }
            break;

        case kErrMsg: {
            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(gErrMsg)) )
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            *rcode = 0;
            }
            break;

        case kRunInfo: {
            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Source Info +++")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_nextout(nextout, sname))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            char buf[128];
            snprintf(buf, 128, "%d", sline);
            if(!statment_tree_internal_commands_write_nextout(nextout, buf))
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }

            if(object) {
                if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Classes +++")) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }

                sObject* parent = object;
                while(parent) {
                    if(parent->mClassName) {
                        if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(parent->mClassName))) 
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }
                    else {
                        if(!statment_tree_internal_commands_write_nextout(nextout, "nothing")) 
                        {
                            err_msg("signal interrupt", sname, sline);
                            return FALSE;
                        }
                        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                        {
                            err_msg("singal interrupt", sname, sline);
                            return FALSE;
                        }
                    }

                    parent = parent->mParent;
                }

                if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Objects +++")) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }

                parent = object;
                while(parent) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(parent->mName))) 
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }

                    parent = parent->mParent;
                }
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Class +++")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            if(running_class) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(running_class->name))) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Class Info +++")) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                if(running_class->input) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "input"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                if(running_class->output) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "output"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Function +++")) 
            {
                err_msg("signal interrupt", sname, sline);
                return FALSE;
            }
            if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
            {
                err_msg("singal interrupt", sname, sline);
                return FALSE;
            }
            if(running_fun) {
                if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(running_fun->name))) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_nextout(nextout, "+++ Running Function Info +++")) 
                {
                    err_msg("signal interrupt", sname, sline);
                    return FALSE;
                }
                if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                {
                    err_msg("singal interrupt", sname, sline);
                    return FALSE;
                }
                if(running_fun->input) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "input"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
                if(running_fun->output) {
                    if(!statment_tree_internal_commands_write_nextout(nextout, "output"))
                    {
                        err_msg("signal interrupt", sname, sline);
                        return FALSE;
                    }
                    if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
                    {
                        err_msg("singal interrupt", sname, sline);
                        return FALSE;
                    }
                }
            }

            *rcode = 0;
            }
            break;
/*
        case kNum2Str: {
            enum eLineField lf = gLineField;

            int i;
            for(i=0; i<vector_size(argv); i++) {
                char* arg = string_c_str(vector_item(argv,i));
                if(strcmp(arg, "-Lw") == 0) {
                    lf = kCRLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lm") == 0) {
                    lf = kCR;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-Lu") == 0) {
                    lf = kLF;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
                else if(strcmp(arg, "-La") == 0) {
                    lf = kBel;
                    string_delete(vector_item(argv, i));
                    vector_erase(argv, i);
                    i--;
                    continue;
                }
            }

            string_obj* str = STRING_NEW("");

            while(1) {
                string_obj* str2 = STRING_NEW("");
                int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str2, lf);
                if(result < 0) {
                    err_msg("interrupt", sname, sline);
                    string_delete(str);
                    string_delete(str2);
                    return FALSE;
                }
                else if(result == 1) {
                    string_delete(str2);
                    break;
                }

                char buf[1024];
                snprintf(buf, 1024, "%c", atoi(string_c_str(str2)));

                string_push_back(str, buf);
            }

            if(!statment_tree_internal_commands_write_nextout(nextout, string_c_str(str)))
            {
                err_msg("signal interrupt", sname, sline);
                string_delete(str);
                return FALSE;
            }

            *rcode = 0;
            string_delete(str);
            }
            break;
*/

        default: {
            fprintf(stderr, "unexpected err. illegal command(%s)\n", string_c_str(vector_item(argv, 0)));
            exit(1);
        }
    }

    return TRUE;
}

