#if !defined(SAPHIRE_INNER_H)
#define SAPHIRE_INNER_H

////////////////////////////////////////////////////////////
/// from saphire_main.c
////////////////////////////////////////////////////////////
extern volatile BOOL gSigUser;

/// ޥɤбʸ
enum eCommandKind { 
    kObject, kRef, kVar, kGlobal, kExport, 
    kAry, kAryAdd, kAryErase, 
    kHash, kHashAdd, kHashErase,  
    kDef, kInherit, kSelf, kStackFrame, kClass,
    kSweep, kShow,
    kSubshell, kMSleep, kTrue, kFalse, kTest,
    kIndex, kRIndex, kLength, kLc, kUc,
    kChomp, kEval, kFg, kBg, 
    kJobs, kRehash, kKanjiCode, kLineField,
    kCalc, kPrint,  kPuts, kLoad, 
    kWhile, kBreak, kExit, kIf, kSplit, kX, kJoin, kSelect, kLines, kRows,
    kMatch, kScan, kSub, kGSub, 
    kRead, kClose, 
    kCd, 
    kAdd, kDel, kSelector, kMax, kMin,
    kExtName, kParentName, kNoExtName, 
    kCompile, kRaise,
    kPopd, kPushd,
    kPlusPlus,
    kMinusMinus,
    kPlus,
    kMinus,
    kMult,
    kDiv,
    kMod,
    kPow,
    kSort,
    kRange,
    kPrintf,
    kPomch,
    kPTee,
    kPCat,
    kReturn,
    kMInitScr,
    kMEndWin,
    kMClear,
    kMClearImmediately,
    kMRefresh,
    kMMove ,
    kMMoveImmediately,
    kMPrintw, 
    kYeild,
    kEach,
    kForeach,
//    kParse,
    kAbs,
    kFAbs,
    kP,
    kTry,
    kEnvSpace,
    kQuote,
    kTime,
    kFSelector,
    kCommandHistory,
    kUnset,
    kUMask,
    kErrMsg,
    kRunInfo, 
    kInnerCommand,
    kCommand 
};

extern char gTmpDir[PATH_MAX];
    // ե֤

extern char* gStatmentKindStrs[kCommand+1];
extern hash_obj* gFuncs;
    // 桼ؿ sFunction*äƤ
    // ϴؿ̾

extern hash_obj* gClasses;
    // 饹 sClass*äƤ
    // ϥ饹̾

extern vector_obj* gStackFrame;
extern vector_obj* gStackFramePointers;
extern vector_obj* gStackFrameArrays;
extern vector_obj* gStackFrameHashs;
extern vector_obj* gStackFrameObjects;
extern vector_obj* gStackFrameRefs;
    // ѿΥå
    // Ƥhash_obj*
    // Υϥѿ̾
    // Ƥstring_obj*
extern enum eAppType gAppType;
    // ץꥱμ
extern BOOL gJobControl;
    // ֤Υȥ򤹤뤫ɤ
extern vector_obj* gJobs;
    //  sJob*

extern char* gMagicNumber;
    // ֥ȥեΥޥåʥС

extern hash_obj* gReadBuffers;
    //  ե̾
    //  sRFd*
    // readѤΥեΥ꡼ɥХåե

extern string_obj* gGlobalPipe;
    // Хѥפɤ߹ߤǡ

extern string_obj* gGlobalPipeNum[10];
    // ʥСХѥפɤ߹ߤǡ
extern BOOL gSaphireBackground;
    // SaphireХå饦ɤưƤ뤫ɤ

extern hash_obj* gRegexs;
    // ɽΥå
    // ɽʸ
    // Ƥregex_t

extern hash_obj* gRegexsI;
    // ɽΥå(ignore case)
    // ɽʸ
    // Ƥregex_t

extern hash_obj* gRegexsM;
    // ɽΥå(multi line)
    // ɽʸ
    // Ƥregex_t

extern hash_obj* gRegexsIM;
    // ɽΥå(ignore case|multi line)
    // ɽʸ
    // Ƥregex_t

extern hash_obj* gInnerCommands;
    // Ͽޥ
    // saphireȤ߹ץꥱ
    // 줿ޥɤΥǡ
    // ϥޥ̾
    // ƤsInnerCommand

extern vector_obj* gDirStack;
    // popd, pushdǻȤǥ쥯ȥꥹå
    // Ƥ string_obj*
extern enum eLineField gLineField;
    // saphireʸޥɤǻȤԥ

extern vector_obj* gTmpFiles;
    // ץִǻȤեǾä
    // ¸Ƥ

BOOL is_line_field(char* p);
    // 饤եɤݥȤƤ뤫

BOOL is_line_field2(enum eLineField lf, char* p);
    // 饤եɤݥȤƤ뤫2

BOOL string_chomp(string_obj* str);
    // ԥɤ

BOOL string_chomp2(string_obj* str, enum eLineField lf);
    // ԥɤ

void string_ponch(string_obj* str);
    // ԥɤդ(\n)

void string_pomch(string_obj* str, enum eLineField lf);
    // ԥɤդ(ԥɤΤޤ)

int get_command_kind(char* arg0);
    // ޥ̾饳ޥIDõ

void null_fun();
    // gotoΥ٥򥳥ѥ顼̤δؿ

void get_quoted_linefield(char* str, string_obj* out);

void bash_get_quoted_fname(char* fname, string_obj* quoted_fname);
    // bashΥ

typedef struct _sJob {
    string_obj* mName;          // ֤̾
    pid_t mPGroup;              // ץ롼ID
    vector_obj* mPIDs;          // ҥץPIDΥꥹ
    struct termios* mTty;
} sJob;

sJob* sJob_new();
void sJob_delete(sJob* self);

enum eStatmentTerminated { kTNormal, kTOrOr, kTAndAnd };

typedef struct
{
    sStatments* joukensiki;
    sStatments* contents;
} sWhile;

sWhile* sWhile_new(sStatments* joukensiki, sStatments* contents);
sWhile* sWhile_new2(sWhile* while_);

void sWhile_delete(sWhile* self);
void sWhile_save(sWhile* self, int fd);
sWhile* sWhile_load(int fd);

typedef struct
{
    sStatments* contents;
} sSubshell;

sSubshell* sSubshell_new(sStatments* contents);
sSubshell* sSubshell_new2(sSubshell* subshell);
void sSubshell_delete(sSubshell* self);

void sSubshell_delete(sSubshell* self);
void sSubshell_save(sSubshell* self, int fd);
sSubshell* sSubshell_load(int fd);
void sSubshell_view(sSubshell* self);

typedef struct
{
    vector_obj* joukensiki_list;
    vector_obj* contents_list;
} sIf;

sIf* sIf_new(vector_obj* joukensiki_list, vector_obj* contents_list);
sIf* sIf_new2(sIf* if_);

void sIf_delete(sIf* self);
void sIf_save(sIf* self, int fd);
sIf* sIf_load(int fd);

enum eCommandKind2 {
    kCKLocalVar, kCKUserCommand, kCKExternInnerCommand, kCKInnerCommand,
    kCKExternCommand
};

typedef struct
{
    int mKind; // 0:string 2: statments 4: statments2 5: block 6: process substituion 7: here document 8:process substituion2 9 : redirect
    void* mBody;
} sArg; // mArgs


#ifdef MDEBUG

sArg* sArg_new_debug(int kind, MANAGED void* body, const char* fname, int line, const char* func);

#define ARG_NEW(o, o2) sArg_new_debug(o, o2, __FILE__, __LINE__, __FUNCTION__)

sArg* sArg_new2_debug(sArg* arg, const char* fname, int line, const char* func);

#define ARG_NEW2(o) sArg_new2_debug(o, __FILE__, __LINE__, __FUNCTION__)

#else

sArg* sArg_new(int kind, MANAGED void* body);

#define ARG_NEW(o, o2) sArg_new(o, o2)

sArg* sArg_new2(sArg* arg);

#define ARG_NEW2(o) sArg_new2(o)

#endif

void sArg_delete(sArg* self);

void sArg_save(sArg* self, int fd);
sArg* sArg_load(int fd);

enum eRedirect { kRedirectInput, kRedirectOverwrite, kRedirectAppend
          , kRedirectErrAndOutput };

typedef struct {
    enum eRedirect mType;
    int mFd;
    string_obj* mFName;      // ¹Ի˻Ȥ
} sRedirect; // ¹Ի˻Ȥ ֥ȥե¸

sRedirect* sRedirect_new(enum eRedirect type, int fd);
sRedirect* sRedirect_new2(sRedirect* redirect);
void sRedirect_delete(sRedirect* self);
void sRedirect_save(sRedirect* self, int fd);
sRedirect* sRedirect_load(int fd);
void sRedirect_delete(sRedirect* self);

sBlock* sBlock_new(sStatments* statments, vector_obj* args, int count);
sBlock* sBlock_new2(sBlock* block);
void sBlock_delete(sBlock* self);
void sBlock_save(sBlock* self, int fd);
sBlock* sBlock_load(int fd);

typedef struct
{
    string_obj* mFName;
    sStatments* mStatments;
} sPSub;

sPSub* sPSub_new(char* fname, sStatments* statments);
void sPSub_delete(sPSub* self);

typedef struct
{
    enum eCommandKind mKind;
    vector_obj* mArgs;
        // vector of sArg*
        // ޥɥ饤
    vector_obj* mRedirects;
        // vector of sRedirect* 
        // 쥯Υꥹ

    void* mExtra;
} sCommand;


#ifndef MDEBUG

sCommand* sCommand_new();
#define COMMAND_NEW() sCommand_new()

void sCommand_view(sCommand* self);

#else

sCommand* sCommand_new_debug(const char* fname, int line, const char* func);

#define COMMAND_NEW() sCommand_new_debug(__FILE__, __LINE__, __FUNCTION__)

#endif

void sCommand_save(sCommand* self, int fd);
sCommand* sCommand_load(int fd);
void sCommand_delete(sCommand* self);

typedef struct
{
    vector_obj* mCommands;   // ޥ

    string_obj* mFName;      // ʸե̾
    int mLine;               // ʸ

    string_obj* mNotEvaled;  // run˥ѡʸ
                             // Ķѿȥޥޤʸ
    string_obj* mTitle;      // ȥ

    enum eStatmentTerminated mTerminated;   
            // ʣʸκǸ夬ǶڤƤ뤫

    BOOL mRCodeReverse;      // ꥿󥳡ɤȿž

    BOOL mBackground;        // Хå饦ɤǼ¹

    int mGlobalPipeIn;       // ХѥפϤ뤫 1:  4: ʥС
    int mGlobalPipeOut;      // ХѥפνϤ뤫 1:  4:ʥС
    int mGlobalPipeInNum;    // ʥСХѥפֹ
    int mGlobalPipeOutNum;   // ʥСХѥפֹ

    int mSTDINPipe;         // STDIN ѥפ뤫ʤ
} sStatment;

#ifdef MDEBUG
sStatment* sStatment_new_debug(const char* fname, int line, const char* func_name);
#define STATMENT_NEW() sStatment_new_debug(__FILE__, __LINE__, __FUNCTION__)
sStatment* sStatment_new2_debug(sStatment* statment, const char* fname, int line, const char* func_name);
#define STATMENT_NEW2(o) sStatment_new2_debug(o, __FILE__, __LINE__, __FUNCTION__)
#else
sStatment* sStatment_new();
#define STATMENT_NEW() sStatment_new()
sStatment* sStatment_new2();
#define STATMENT_NEW2(o) sStatment_new2(o)
#endif

void sStatment_delete(sStatment* self);
void sStatment_save(sStatment* self, int fd);
sStatment* sStatment_load(int fd);

void sStatments_view(sStatments* self);

void sStatments_save(sStatments* self, int fd);
sStatments* sStatments_load(int fd);
void sStatments_delete(sStatments* self);

typedef struct _sFunction {
    string_obj* name;       // ޥ̾
    string_obj* arg_name;
    //vector_obj* args;       // ե󥹤ΰ
    sStatments* statments; // ̿ɽ
    BOOL input;             // ¹Իξ
    BOOL output;

    struct _sFunction* parent;     // С饤ɤȤο

    int mRefCount;
} sFunction;

sFunction* sFunction_new(char* name, sStatments* statments, char* arg_name, sFunction* parent, int ref_count);
  
void sFunction_delete(sFunction* self);
void sFunction_save(sFunction* self, int fd);
sFunction* sFunction_load(int fd);
void sFunction_view(sFunction* self);


typedef struct {
    string_obj* mName;
    fInnerCommand mFun;
} sInnerCommand;

sInnerCommand* sInnerCommand_new(char* name, fInnerCommand fun);
void sInnerCommand_delete(sInnerCommand* self);

void sigchld_block(int block);

extern hash_obj* gObjects;
// ֥ ϥ֥̾ ƤsObject*
//
extern hash_obj* gRefs;
// ֥ ϥ֥̾ ƤsObject*

typedef struct {
    char* mStr;
    int mLen;

    int mMallocLen;

    int mRefCount;
} sGlobal;

typedef struct {
   hash_it** mTable;
   int mTableSize;

   hash_it* mEntryIt;

   int mCounter;                // 
   int mRefCount;
} sHash;

typedef struct {
   void** mTable;
   int mTableSize;
   
   int mCount;

   int mRefCount;
} sAry;

string_obj* sVar_new(char* str);
void sVar_delete(string_obj* self);
string_obj* sGlobal_new(char* str, int ref_count);
void sGlobal_delete(string_obj* self);
vector_obj* sAry_new(int first_size, int ref_count);
void sAry_delete(vector_obj* self);
hash_obj* sHash_new(int size, int ref_count);
void sHash_delete(hash_obj* self);

typedef struct {
    sStatments* mStatments;
    enum eLineField mLineField;
} sAtCommand;

sAtCommand* sAtCommand_new(sStatments* statments, enum eLineField lf);
sAtCommand* sAtCommand_new2(sAtCommand* at_command);
void sAtCommand_delete(sAtCommand* self);
sAtCommand* sAtCommand_save(sAtCommand* self, int fd);
sAtCommand* sAtCommand_load(int fd);
void dig_stack_frame(char* sname, int sline, vector_obj** fun_argv_before, vector_obj* argv2);
void burry_stack_frame(vector_obj* fun_argv_before, string_obj** sname_strace, int* line_strace);

////////////////////////////////////////////////////////////
/// from saphire_commands.c
////////////////////////////////////////////////////////////
int statment_tree_internal_commands(sCommand* command, int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, int j, char* title, BOOL input, BOOL* return_, BOOL enable_return, BOOL* break_, BOOL enable_break, char* sname, int line, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class);
BOOL vcat_expand_env(string_obj* pipeout, char* env, vector_obj* numbers,char* sname, int line);

////////////////////////////////////////////////////////////
/// from saphire_parser.c
////////////////////////////////////////////////////////////
BOOL expand_env(char* p, string_obj* out, sRFd* rfd, char* sname, int* line, sObject* object);
BOOL parse(char* cmdline, char* sname, int* line, sStatments* statments);
BOOL delete_comments(char* p, string_obj* cmdline2, char* separator, char* sname, int* line);


BOOL read_until_next_cbrace_end(char** p, string_obj* not_evaled, int* read_end_of_statment, BOOL line_inc, char* sname, int* line);

////////////////////////////////////////////////////////////
// from saphire_vm.c
////////////////////////////////////////////////////////////
BOOL forground_job(int num);
void background_job(int num);
void tmpfile_all_sweep();
void tmpfile_sweep();

extern vector_obj* gStackTraceFName;
extern vector_obj* gStackTraceLineNum;
    // åե졼εϿ

int run(sStatments* statments, char* title, sWFd* pipeout, sRFd* pipein, int pipeerr, BOOL* return_, BOOL enable_return, BOOL* break_ , BOOL enable_break, vector_obj* parent_blocks, BOOL try_, vector_obj* envs, sObject* object, sFunction* running_fun, sClass* running_class);
    // saphire_compile2ǥѥ뤷ѥ̤¹Ԥ롣

int saphire_shell4(char* command, char* title, sWFd* pipeout, sRFd* pipein, int pipeerr, sObject* object);
    // ʸɤ߹Ǽ¹
int saphire_shell5(sWFd* pipeout, char* command, char* title, sRFd* pipein, sObject* object);
    // ʸɤ߹Ǽ¹ԡޥɤνϤpipeout->mBuffer
void saphire_set_global_var2(char* name, char* value, sObject* object);
    // ֥Ȥ°Хѿꤹ

#endif
