
#include "scale/heap.h"
#include "scale/alloc.h"


#define DEF_HEAP_SIZE 64


static void
_s_heap_grouth(sheap_t *heap, size_t tsize)
{
	spointer *p;

	if (heap->memsize >= tsize)
		return; /* nothiong to do. */

	heap->array = (spointer *)s_reallocn(heap->array,
										 sizeof(spointer) * heap->memsize,
										 sizeof(spointer) * tsize);

	/* clean the new memory */
	p = heap->array + heap->memsize;
	memset(p, 0x00, tsize - heap->memsize);

	heap->memsize = tsize;
}



sheap_t *
s_heap_alloc(sc_compf_t compare)
{
	return s_heap_allocn(compare, DEF_HEAP_SIZE);
}


sheap_t *
s_heap_allocn(sc_compf_t compare, size_t inisize)
{
	sheap_t *heap;

	/* we have to increment the inisize. because we are not using index=0. */
	if (++inisize <= 1)
		inisize = 2;

	heap = typed_malloc(sheap_t);
	heap->memsize = inisize;
	heap->count = 0;
	heap->next_index = 1; /* we are not using index=0. */
	heap->compare = compare;
	heap->array = (spointer *)s_calloc(heap->memsize, sizeof(spointer));
	
	return heap;
}


void
s_heap_free(sheap_t *heap)
{
	s_freen(heap->array, sizeof(spointer) * heap->memsize);
	s_freen(heap, sizeof(sheap_t));
}


void
s_heap_push(sheap_t *heap, spointer contents)
{
	size_t pindex, cindex;
	spointer temp;

	if (heap->next_index > heap->memsize - 1)
		_s_heap_grouth(heap, heap->memsize * 2);

	heap->array[heap->next_index] = contents;

	cindex = heap->next_index;
	while ((pindex = HEAP_PARENT_INDEX(cindex)) != 0 &&
		   heap->compare(heap->array[pindex], heap->array[cindex]) < 0) {
		temp = heap->array[pindex];
		heap->array[pindex] = heap->array[cindex];
		heap->array[cindex] = temp;

		cindex = pindex;
	}

	++heap->count;
	++heap->next_index;
}

#include <stdio.h>
spointer
s_heap_pop(sheap_t *heap)
{
	spointer contents;
	spointer temp;
	size_t pind, lind, rind, tind;

	if (s_heap_size(heap) == 0)
		return NULL;

	contents = heap->array[1];

	--heap->count;
	--heap->next_index;

	heap->array[1] = heap->array[heap->next_index];
	heap->array[heap->next_index] = NULL;

	pind = 1;
	while (1) {
		lind = HEAP_LCHILD_INDEX(pind);
		rind = HEAP_RCHILD_INDEX(pind);

		/* Chose the lager node.
		   Remember if right-node wasn't NULL, left-node isn't too.
		 */
		if (rind >= heap->count || heap->array[rind] == NULL) {
			if (lind >= heap->count || heap->array[lind] == NULL)
				tind = 0;
			else
				tind = lind;
		}
		else {
			tind = (heap->compare(heap->array[lind],
									heap->array[rind]) > 0)?lind:rind;
		}

		if (tind == 0 ||
			heap->compare(heap->array[tind], heap->array[pind]) <= 0)
			break;

		/* swap */
		temp = heap->array[tind];
		heap->array[tind] = heap->array[pind];
		heap->array[pind] = temp;

		pind = tind;
	}
	
	return contents;
}


spointer
s_heap_peek(sheap_t *heap)
{
	return heap->array[1];
}


size_t
s_heap_size(sheap_t *heap)
{
	return heap->count;
}


spointer
s_heap_get(sheap_t *heap, size_t ind)
{
	/* remember array index in heap-array is starting from 1. */
	++ind;

	if (ind >= s_heap_size(heap))
		return NULL;
	else
		return heap->array[ind];
}
