/*
 * $Id: hash.h,v 1.5 2004/08/03 05:49:50 jklein Exp $
 * $Author: jklein $
 * $Log: hash.h,v $
 * Revision 1.5  2004/08/03 05:49:50  jklein
 * Add sxtable_t structure.
 *
 * Revision 1.4  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.3  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 */

/**
   <p>$B%O%C%7%e9=B$$rDs6!$7$^$9!#;HMQ$9$k:]$K$O80!J(Bkey$B!K$H$J$k%G!<%?$r(B
   $BE:;z$KJQ49$9$k%O%C%7%e4X?t$r;XDj$9$kI,MW$,$"$j$^$9!#%O%C%7%e9=B$$N(B
   $B8zN($O$3$N%O%C%7%e4X?t$N@:EY$K0MB8$7$^$9$N$G!"Cm0U?<$/:n@.$7$F$/$@$5$$!#(B
   $B$?$@$7!"80$H$7$FIQHK$K;H$o$l$k$G$"$m$&J8;zNs!J(Bchar *$B!K$KBP$9$k(B
   $B%O%C%7%e4X?t$OMQ0U$7$F$"$j$^$9!J(Bs_string_hashfunc()$B!K!#M}M3$,L5$$8B$j(B
   $BJ8;zNs$KBP$7$F$O$3$N4X?t$rMxMQ$7$F$/$@$5$$!J$J$*!"$3$N%O%C%7%e4X?t$O(B
   $B!X(BAlfred V. Aho, Ravi Sethi, Jeffrey D. Ullman $BCx!&86ED8-0lLu(B
   $B!X%3%s%Q%$%i#2(B $B86M}!&5;K!!&%D!<%k!Y!Y$h$jGR<Z$$$?$7$^$7$?!K!#(B</p>

*/

#ifndef _S_HASH_H_
#define _S_HASH_H_


#include "scale/commons.h"
#include "scale/iterator.h"
#include "scale/xtable.h"


/*
 * This must be prime number.
 * Examples: 127, 251, 509, 1021, 2039, 4091, 8191, 16381, ...
*/
#define DEFAULT_HASH_SIZE 1021

/** $B%O%C%7%e4X?t(B */
typedef unsigned int (*hashfunc_t)(const spointer, size_t);
typedef struct _sc_hash_table shash_t;


shash_t *		s_hash_alloc(size_t hsize, hashfunc_t hfunc, sc_compf_t cmpf);
void			s_hash_free(shash_t *htable);
spointer		s_hash_get(shash_t *htable, const spointer key);
void			s_hash_put(shash_t *htable, spointer key, spointer contents);
void			s_hash_remove(shash_t *htable, const spointer key);
size_t			s_hash_size(shash_t *htable);
void			s_hash_clear(shash_t *htable);


siterator_t *s_hash_keys(shash_t *htable);

/** $BCj>]%F!<%V%k$KJQ49(B */
sxtable_t *s_hash_xtable(size_t hsize, hashfunc_t hfunc, sc_compf_t cmpf);

/** $B4{B8$N%O%C%7%e$rCj>]%F!<%V%k$K%"%?%C%A$9$k(B */
sxtable_t *s_hash_attach_xtable(shash_t *hash);

/* use this function for hashfunc_t. */
unsigned int	s_string_hashfunc(const spointer key, size_t hashsize);


#endif /* _S_HASH_H_ */
