/**
 * $Id: list.h,v 1.1 2004/06/21 11:28:00 jklein Exp $
 * $Author: jklein $
 * $Log: list.h,v $
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */

#ifndef _SC_LIST_H_
#define _SC_LIST_H_

#include "scale/commons.h"


typedef struct _sc_linklist slist_t;
typedef struct _sc_linklist_node slist_node_t;


/**
 * A list looks like this at intial state.
 *   head --> tail
 * And it becomes like this after you added a value.
 *   head --> node[0] --> node[1] -->...--> tail
 */
struct _sc_linklist {
	size_t count;
/*	sc_compf_t compare; */
	slist_node_t *head;
	slist_node_t *tail;
};


struct _sc_linklist_node {
	spointer contents;
	slist_node_t *next;
	slist_node_t *prev;
};


slist_t *		s_list_alloc();
void			s_list_free(slist_t *);
size_t			s_list_size(slist_t *);
void 			s_list_add(slist_t *, const spointer);
spointer		s_list_get(slist_t *, size_t);
spointer		s_list_remove(slist_t *, size_t);
sint32			s_list_find(slist_t *, sc_compf_t, spointer);
sboolean		s_list_join(slist_t *, slist_t *);

/* this is for debbuging.
 * or you can use this any time. */
void _sc_dump_list(const char *, slist_t *);


#endif /* _SC_LIST_H_ */
