/**
 * $Id: vector.h,v 1.1 2004/06/21 11:28:00 jklein Exp $
 * $Author: jklein $
 * $Log: vector.h,v $
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */

#ifndef _SC_VECTOR_H_
#define _SC_VECTOR_H_

#include "scale/commons.h"

typedef struct _vector svector_t;


struct _vector {
	size_t count;
	size_t memsize;
	size_t nextidx;
	spointer *array;
};


svector_t *		s_vector_alloc();
svector_t *		s_vector_allocn(size_t);
void			s_vector_free(svector_t *);
size_t			s_vector_size(svector_t *);
void			s_vector_add(svector_t *, const spointer);
spointer		s_vector_get(svector_t *, size_t);
spointer		s_vector_remove(svector_t *, size_t);
sint32			s_vector_find(svector_t *, sc_compf_t, spointer);
sboolean		s_vector_join(svector_t *, svector_t *);



#endif /* _SC_VECTOR_H_ */
