using System;
using System.Collections.Generic;
using System.Text;
using SCFiler2.FileSystem;

namespace SCFiler2.Action {
	public class MoveToRecycle : Action {
		public override string DisplayString {
			get { return "S~ɓ"; }
		}

		public override void execute() {
			MainForm main_form = MainForm.Instance;
			if (main_form.FocusedViewType == MainForm.EFocusedViewType.FileView) {
				FileView active_view = main_form.getLastFocusedFileView();

				List<FilerItem> list = active_view.SelectedFilerItems;
				foreach (FilerItem item in list) {
					if (item.Type == FilerItem.ItemType.File) {
						Microsoft.VisualBasic.FileIO.FileSystem.DeleteFile(item.Info.FullName, Microsoft.VisualBasic.FileIO.UIOption.OnlyErrorDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.SendToRecycleBin);
					} else {
						Microsoft.VisualBasic.FileIO.FileSystem.DeleteDirectory(item.Info.FullName, Microsoft.VisualBasic.FileIO.UIOption.AllDialogs, Microsoft.VisualBasic.FileIO.RecycleOption.SendToRecycleBin);
					}
				}
				active_view.drawView();
			} else {
				//ق̃r[ɃtH[JXƂ͉Ȃ
			}
		}
	}
}
