package Scheduler::Data::PlainText::Status;
@ISA = qw|Scheduler::Data::PlainText|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::PlainText;
use File::Find;
use File::Copy;

sub new(){
  shift;
  return bless{@_};
}
sub optimize(){
  my $oS = shift;
  $oS->initialize;
  my %hsOptimizedIDs = ();
  my @asDeletingFiles = ();
  find(sub{
	 return if $_ eq '.';
	 return if exists $hsOptimizedIDs{$_};
	 $hsOptimizedIDs{$_} = 1;
	 my $oSche = $oS->getScheByID($_);
	 return if !defined $oSche;
	 my $sStatus = $oSche->changeables->[0]->time->nowStatus;
	 my $sNewFileName = $oS->path.'status/'.$sStatus."/$_";
	 if($File::Find::name ne $sNewFileName){
	   move($File::Find::name,$sNewFileName); # using File::Copy
	   chmod(0777,$sNewFileName);
	   push(@asDeletingFiles,$File::Find::name);
	 }
	 foreach my $sPastStatus(qw|coming progress done halt|){
	   next if $sPastStatus eq $sStatus;
	   my $sFilePath = $oS->path.'status/'.$sPastStatus.'/'.$_;
	   unlink($sFilePath) if -e $sFilePath;
	 }
       },map{$oS->path.'status/'.$_}qw|coming progress|);
}
sub getIDList($){
  my $oS = shift;
  my $sStatus = shift;
  return if !defined $sStatus or $sStatus eq '';
  $oS->optimize;
  my @asResult = ();
  find(sub{
	 return if $_ eq '.';
	 push(@asResult,$_);
       },$oS->{path}.'status/'.$sStatus);
  return @asResult;
}
sub delScheByID($){
  my $oS = shift;
  my $sID = shift;
  return if !defined $sID;
  $oS->optimizePath;
  find(sub{
	 return if $_ eq '.';
	 my $sFileName = substr($_,rindex($_,'/')+1);
	 return if $sFileName ne $sID;
	 unlink($File::Find::name);
       },$oS->path.'status/');
}
sub setSche($$){
  my $oS = shift;
  $oS->optimize;
  my $sID = shift;
  return if !defined $sID or $sID eq '';
  my $oSche = $oS->getScheByID($sID);
  my $sNewFileDir = $oS->path.'status/'.$oSche->changeables->[0]->time->nowStatus;
  $oS->croakIfCannotMakeFile($sNewFileDir);
  my $sNewFileName = $sNewFileDir."/$sID";
  symlink($oS->path.'whole/'.$sID,$sNewFileName);
  $oS->optimize;
}
sub initialize(){
  my $oS = shift;
  $oS->optimizePath;
  $oS->makeDir;
  find(sub{
	   return if $_ =~ m|^\.|;
	   my $oSche = $oS->getScheByID($_);
	   next if !defined $oSche;
	   my $sNewFileDir = $oS->path.'status/'.$oSche->changeables->[0]->time->nowStatus;
	   my $sNewFileName = $sNewFileDir."/$_";
	   symlink($oS->path.'whole/'.$_,$sNewFileName) if !-e $sNewFileName;
	 },$oS->path.'whole/');
}
sub makeDir{
  my $oS = shift;
  $oS->makeDirectory($oS->path,'status/');
  foreach(qw|progress coming done halt|){
    $oS->makeDirectory($oS->path.'status/',$_);
  }
}

1;
