package Scheduler::Data::XML::Feed;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Data::XML::Sche;
use Scheduler::Data::XML::Generator;
use Scheduler::Feed;

sub obj($){
  shift;
  my $oFeed = new Scheduler::Feed;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'sche'){
      $oFeed->addSche(Scheduler::Data::XML::Sche->obj($_,$oDocument));
    }elsif($_->nodeName eq 'generator'){
      $oFeed->setGenerator(Scheduler::Data::XML::Generator->obj($_,$oDocument));
    }
  }
  return $oFeed;
}
sub element($){
  shift;
  my $oFeed = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('feed');
  $oRoot->setAttribute('version','2');
  $oRoot->addChild(Scheduler::Data::XML::Generator->element($oFeed->generator,$oDocument));
  foreach(@{$oFeed->sche}){
    $oRoot->addChild(Scheduler::Data::XML::Sche->element($_,$oDocument));
  }
  return $oRoot;
}

1;
