package Scheduler::Data::XML::Sche::Author;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Sche::Author;

sub obj($$){
  shift;
  my $oAuthor = new Scheduler::Sche::Author;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'name'){
      $oAuthor->setName($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'email'){
      $oAuthor->setEmail($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'uri'){
      $oAuthor->setUri($_->firstChild->nodeValue);
    }
  }
  return $oAuthor;
}
sub element($$){
  shift;
  my $oAuthor = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('author');
  $oRoot->appendTextChild('name',$oAuthor->name);
  $oRoot->appendTextChild('email',$oAuthor->email) if defined $oAuthor->email and $oAuthor->email ne '';
  $oRoot->appendTextChild('uri',$oAuthor->uri) if defined $oAuthor->uri and $oAuthor->uri ne '';
  return $oRoot;
}

1;
