package Scheduler::Data::XML::Sche::Time;
@ISA = qw|Scheduler::Data::XML::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Data::XML::base;
use Scheduler::Sche::Time;

sub obj($$){
  shift;
  my $oTime = new Scheduler::Sche::Time;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'begin'){
      $oTime->setBegin(new Scheduler::Sche::Time::Optimized($_->firstChild->nodeValue));
    }elsif($_->nodeName eq 'end'){
      $oTime->setEnd(new Scheduler::Sche::Time::Optimized($_->firstChild->nodeValue));
    }
  }
  return $oTime;
}
sub element($$){
  shift;
  my $oTime = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('time');
  $oRoot->appendTextChild('begin',$oTime->begin->ISO8601) if defined $oTime->begin;
  $oRoot->appendTextChild('end',$oTime->end->ISO8601) if defined $oTime->end;
  return $oRoot;
}

1;
