/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.morilib.lisp.CompiledCode.Builder;

/*package*/ class CompilerImpl extends LispCompiler {
	
	//private static Logger _log = LogEnv.init("schlush.compiler");
	
	private LispMessage message;
	
	
	/*package*/ CompilerImpl(LispMessage msg) {
		message = msg;
	}
	
	
	private Datum expandSyntax(
			UserSyntax syn, Datum body,
			Environment env2) {
		List<Datum> pat = syn.getPatternList();
		List<Datum> tmp = syn.getTemplateList();
		PatternDepthMap mp;
		boolean mtc = false;
		int ind = 0;
		
		do {
			// ѥȹ̤
			mp = new PatternDepthMap(syn.getParamList().get(ind));
			
			// ѥޥå
			mtc = PatternMatch.match(
					pat.get(ind), body, mp, syn.getReservedSet());
		} while(!mtc && ++ind < pat.size());
		
		if(mtc) {
			try {
				// ѥ˥ޥå
				Environment menv = new Environment();
				Datum t;
				Map<Symbol, Symbol> box = new HashMap<Symbol, Symbol>();
				
				//// ѿ֤
				//t = replaceLocalVals(tmp.get(ind), env, menv);
				t = tmp.get(ind);
				
				// ƥץ졼ȥѥ
				Datum tpl = PatternMatch.compileTemplate(t, mp);
				//_log.finer(LispUtils.print(tpl));
				
				// ƥץ졼Ÿ
				// ܥˡ֥ޥͳפΥޡɲä
				Datum res = PatternMatch.expand(tpl, mp, syn, box);
				//_log.finer(LispUtils.print(res));
				
				// ѿ֤
				res = replaceLocalVals(res, env2, menv, true);
				//_log.finer(LispUtils.print(res));
				
				// ׾ɲä
				res = PatternMatch.appendScope(res, mp, syn);
				//_log.finer(LispUtils.print(res));
				
				// ޡ򳰤
				res = PatternMatch.markReplace(box, res, false);
				//_log.finer(LispUtils.print(res));
				
				return res;
			} catch(PatternDepthException e) {
				throw message.getError(
						"err.wronglevel", e.getMessage());
			}
		} else {
			throw message.getError("err.malform", syn.getName());
			//throw new LispException("malformed " + syn.getName());
		}
	}
	
	private void compileArgsBind(
			Datum bcdr,
			Environment env,
			Builder builder,
			Cons symcall,
			List<Cons> symlist) {
		Datum prms = symcall.getCdr();
		List<Datum> vals = new ArrayList<Datum>();
		
		while(true) {
			if(prms == Nil.NIL) {
				if(bcdr != Nil.NIL) {
					throw message.getError(
							"err.parameter.insufficient");
				}
				break;
			} else if(prms instanceof Atom) {
				compile(bcdr, env, builder, symcall, false, symlist);
				builder.addBind(prms);
				break;
			} else if(!(bcdr instanceof Cons)) {
				throw message.getError("err.parameter.insufficient");
				//throw new LispException("insufficient parameter");
			} else if(prms instanceof Cons) {
				Datum a1 = ((Cons)prms).getCar();
				Datum a2 = ((Cons)bcdr).getCar();
				
				compile(a2, env, builder, symcall, false, symlist);
				//builder.addBind(a1);
				vals.add(a1);
				
				prms = ((Cons)prms).getCdr();
				bcdr = ((Cons)bcdr).getCdr();
			} else {
				throw message.getError("err.type.invalid");
				//throw new LispException("Invalid type");
			}
		}
		
		for(int i = vals.size() - 1; i >= 0; i--) {
			builder.addBind(vals.get(i));
		}
	}
	
	/*private int poppos(Datum bcar, List<Cons> symlist) {
		int res = 0;
		
		for(Cons c : symlist) {
			if(bcar.equals(c.getCar())) {
				return res;
			} else {
				res++;
			}
		}
		return -1;
	}*/
	
	private void compileSexp(
			Datum bcar,
			Datum bcdr,
			Environment env,
			Builder builder,
			Cons symcall,
			boolean istail,
			List<Cons> symlist) {
		//int pos = -1;
		
		if(istail && bcar.equals(symcall.getCar())) {
			compileArgsBind(bcdr, env, builder, symcall, symlist);
			builder.addJmpTop();
		/*} else if(istail && (pos = poppos(bcar, symlist)) >= 0) {
			Cons       s2 = symlist.get(pos);
			List<Cons> sl = symlist.subList(pos + 1, symlist.size());
			
			builder.addRewindEnv(pos);
			compileArgsBind(bcdr, env, builder, s2, sl);
			builder.addRewindCont(pos);*/
		} else {
			compile(bcar, env, builder, false, symcall, false, symlist);
			compileArgs(bcdr, env, builder, symcall, symlist);
			
			if(istail) {
				builder.addCallTail(symlist.size());
			} else {
				builder.addCall();
			}
		}
	}
	
	
	public void compileArgs(
			Datum bcdr,
			Environment env,
			Builder builder,
			Cons symcall,
			List<Cons> symlist) {
		builder.addBeginList();
		while(true) {
			if(bcdr instanceof Nil) {
				builder.addEndList();
				break;
			} else if(bcdr instanceof Atom) {
				compile(bcdr, env, builder, symcall, false, symlist);
				builder.addEndListDot();
				break;
			} else if(bcdr instanceof Cons) {
				compile(((Cons)bcdr).getCar(), env, builder,
						symcall, false, symlist);
				builder.addAppendList();
				
				bcdr = ((Cons)bcdr).getCdr();
			} else {
				throw message.getError("err.type.invalid");
				//throw new LispException("Invalid type");
			}
		}
	}
	
	private Datum getSym(Datum bcar, Environment env) {
		Datum ddd;
		
		if(bcar instanceof Symbol) {
			ddd = env.findDatum((Symbol)bcar);
		} else {
			SymbolScope ss   = (SymbolScope)bcar;
			Environment menv =
				ss.getUserSyntax().getCompileEnv();
			
			ddd = menv.findDatum(ss.getSymbol());
		}
		return ddd;
	}
	
	public void compile(
			Datum body,          // S-expression to be compiled
			Environment env,     // environment to be compiled
			Builder builder,     // builder of byte code
			boolean toplevel,    // is in top level
			Cons symcall,        // list of (<procedure name> <args>)
			boolean istail,      // is in tail
			List<Cons> symlist   // list of symcall
			) {
		if(body instanceof Symbol) {
			builder.addReferSymbol(body);
		} else if(body instanceof SymbolScope) {
			builder.addReferSymbol(body);
		} else if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();
			
			if(bcar instanceof Symbol || bcar instanceof SymbolScope) {
				Datum ddd = getSym(bcar, env);
				
				if(ddd instanceof Syntax) {
					// syntax
					Syntax syn = (Syntax)ddd;
					
					syn.compile(bcdr, env, this, builder, toplevel,
							symcall, istail, message, symlist);
				} else if(ddd instanceof UserSyntax) {
					// user defined syntax (RnRS macro)
					UserSyntax usyn = (UserSyntax)ddd;
					Environment env2 = usyn.getCompileEnv();
					//Environment env3 =
					//	env.copyChangeRoot(env2);
					
					//Datum exp = expandSyntax(usyn, bcdr, env2);
					Datum exp = expandSyntax(usyn, body, env2);
					//Datum exp = expandSyntax(usyn, body, env3);
					
					compile(exp, env, builder, toplevel,
							symcall, istail, symlist);
					//compile(exp, env3, builder, false,
					//		symcall, istail, symlist);
				} else {
					compileSexp(bcar, bcdr, env, builder,
							symcall, istail, symlist);
				}
			} else {
				compileSexp(bcar, bcdr, env, builder,
						symcall, istail, symlist);
			}
		} else {
			builder.addPush(body);
		}
		//builder.addReturnOp();
	}
	
	
	private Datum replaceLocalValsSexp(
			Datum bcar,
			Datum bcdr,
			Environment env,
			Environment ienv) {
		Cons res = new Cons();
		
		res.setCar(replaceLocalVals(bcar, env, ienv, false));
		
		res.setCdr(replaceLocalValsArgs(bcdr, env, ienv));
		
		return res;
	}
	
	
	public Datum replaceLocalValsArgs(
			Datum bcdr,
			Environment env,
			Environment ienv) {
		List<Datum> res = new ArrayList<Datum>();
		
		while(true) {
			if(bcdr instanceof Nil) {
				// «ѿϤʤ
				return LispUtils.listToCons(res);
				//break;
			} else if(bcdr instanceof Atom) {
				// «ѿϤʤ
				return LispUtils.listToCons(res,
						replaceLocalVals(bcdr, env, ienv, false));
				//break;
			} else if(bcdr instanceof Cons) {
				res.add(replaceLocalVals(
						((Cons)bcdr).getCar(), env, ienv, false));
				
				bcdr = ((Cons)bcdr).getCdr();
			} else {
				throw message.getError("err.type.invalid");
				//throw new LispException("Invalid type");
			}
		}
	}
	
	
	public Datum replaceLocalVals(
			Datum body,
			Environment env,
			Environment ienv, boolean toplv) {
		if(body instanceof Symbol) {
			// «ѿϤʤ
			Datum d = ienv.findDatum(body);
			
			return (d != null) ? d : body;
		} else if(body instanceof SymbolScope) {
			// «ѿϤʤ
			Symbol sym = ((SymbolScope)body).getSymbol();
			Datum d = ienv.findDatum(sym);
			
			return (d != null) ? d : body;
		} else if(body instanceof Cons) {
			Datum bcar = ((Cons)body).getCar();
			Datum bcdr = ((Cons)body).getCdr();
			
			if(bcar instanceof Symbol || bcar instanceof SymbolScope) {
				Datum d2 = getSym(bcar, env);
				
				if(d2 instanceof Syntax) {
					Syntax syn = (Syntax)d2;
					Cons res = new Cons();
					
					res.setCar(bcar);
					res.setCdr(syn.replaceLocalVals(
							bcdr, env, this, ienv, message, toplv));
					
					return res;
				} else {
					return replaceLocalValsSexp(bcar, bcdr, env, ienv);
				}
			} else {
				return replaceLocalValsSexp(bcar, bcdr, env, ienv);
			}
		} else {
			// «ѿϤʤ
			return body;
		}
	}
	
	
	// ͤѹե饰ξ뤿ΥǡǼ饹
	private class D2 {
		private Datum d;         // ͤȤʤǡ
		private boolean dirty;   // ѹ줿Ȥtrue
		
		private D2() {
			// default
		}
		
		private D2(Datum d, boolean dirty) {
			this.d = d;
			this.dirty = dirty;
		}
		
	}
	
	/*private static final Symbol DEFMACRO = 
		Symbol.getSymbol("define-macro");*/
	
	private D2 expandMacroSexp(
			Datum car,
			Datum cdr,
			Environment env,
			CodeExecutor exec,
			IntStack memento) {
		Cons res = new Cons();
		boolean dirty;
		
		D2 d2 = expandMacro1i(car, env, exec, memento);
		res.setCar(d2.d);
		dirty = d2.dirty;
		
		List<Datum> lst = new ArrayList<Datum>();
		while(true) {
			if(cdr instanceof Cons) {
				Cons c = (Cons)cdr;
				D2 d3 = expandMacro1i(c.getCar(), env, exec, memento);
				
				lst.add(d3.d);
				dirty = d3.dirty || dirty;
				cdr = c.getCdr();
			} else if(cdr == Nil.NIL) {
				res.setCdr(LispUtils.listToCons(lst));
				return new D2(res, dirty);
			} else {
				res.setCdr(LispUtils.listToCons(lst, cdr));
				return new D2(res, dirty);
			}
		}
	}
	
	
	private D2 expandMacro1i(
			Datum body,
			Environment env,
			CodeExecutor exec,
			IntStack memento) {
		D2 res = new D2();
		
		if(body instanceof Cons) {
			Cons c = (Cons)body;
			
			if(c.getCar() instanceof Symbol) {
				Datum d = env.findDatum(c.getCar());
				
				if(d instanceof Macro) {
					// ޥŸ
					Macro   m  = (Macro)d;
					Closure cl = m.getClosure();
					Environment nenv = new Environment(env);
					//Object memento = exec.newMemento();
					
					IntLispUtils.bindLocal(
							cl.getParameterList(),
							c.getCdr(), nenv, message);
					res.d = exec.exec(cl.getCode(), nenv, memento);
					res.dirty = true;
					return res;
				} else if(d instanceof SynQuote) {
					// quote: not expand macro
					res.d = body;
					res.dirty = false;
					return res;
				} else {
					return expandMacroSexp(
							c.getCar(), c.getCdr(), env, exec, memento);
				}
			} else {
				return expandMacroSexp(
						c.getCar(), c.getCdr(), env, exec, memento);
			}
		} else {
			res.d = body;
			res.dirty = false;
			return res;
		}
	}
	
	
	public Datum expandMacro1(
			Datum body,
			Environment env,
			CodeExecutor exec,
			IntStack memento) {
		return expandMacro1i(body, env, exec, memento).d;
	}
	
	
	public Datum expandMacro(
			Datum body,
			Environment env,
			CodeExecutor exec,
			IntStack memento) {
		D2    loop = new D2(body, false);
		
		// Ÿޥʤʤޤǥ롼
		do {
			Datum b = loop.d;
			
			// define-macroΤȤϥޥŸʤ
			if(b instanceof Cons) {
				Datum c1 = ((Cons)b).getCar();
				
				if(c1 instanceof Symbol) {
					if(env.findDatum(c1) instanceof SynDefineMacro) {
						return b;
					}
				} else if(c1 instanceof SymbolScope) {
					Datum d1 =
						env.findDatum(((SymbolScope)c1).getSymbol());
					
					if(d1 instanceof SynDefineMacro) {
						return b;
					}
				}
				/*if(DEFMACRO.equals(((Cons)body).getCar())) {
					return body;
				}*/
			}
			
			// ޥŸ
			loop = expandMacro1i(b, env, exec, memento);
		} while(loop.dirty);
		
		return loop.d;
	}
	
}
