/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

public final class LispString extends Atom {
	
	
	public static final LispString EMPTY = new LispString("");
	
	//
	private String value;
	
	
	public LispString(String value) {
		if(value == null) {
			throw new NullPointerException("string is null");
		}
		this.value = value;
	}
	
	
	public boolean isEqualTo(LispString a) {
		return value.equals(a.value);
	}
	
	
	public String getString() {
		return value;
	}
	
	
	/*package*/ void setString(String value) {
		this.value = value;
	}
	
	
	public LispString toLispString() {
		return this;
	}
	
	
	public String toString() {
		return "\"" + value + "\"";
	}


	public String print() {
		return value;
	}


	public String getResult() {
		StringBuilder b = new StringBuilder();
		
		for(int i = 0; i < value.length(); i++) {
			char c = value.charAt(i);
			
			if(c == '\\') {
				b.append("\\\\");
			} else if(c == '\"') {
				b.append("\\\"");
			} else {
				b.append(c);
			}
		}
		
		return "\"" + b.toString() + "\"";
	}
	
	
	public boolean isTypeString() {
		return true;
	}

}
