/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;

public class Quotient extends BinaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
		if((c1a instanceof LispReal) && (c2a instanceof LispReal)) {
			LispReal r1 = (LispReal)c1a;
			LispReal r2 = (LispReal)c2a;
			
			if(r1.isInteger() && r2.isInteger()) {
				BigInteger a = r1.getBigInteger();
				BigInteger b = r2.getBigInteger();
				
				if(b.equals(BigInteger.ZERO)) {
					throw mesg.getError("err.divbyzero");
					//throw new LispArithmeticException("divide by zero");
				} else if(r1.isExact() && r2.isExact()) {
					return LispInteger.valueOf(a.divide(b));
				} else {
					return new LispDouble(a.divide(b).doubleValue());
				}
			} else if(!r1.isInteger()) {
				throw mesg.getError("err.require.integer", r1);
			} else {
				throw mesg.getError("err.require.integer", r2);
				//throw new LispException("integer required");
			}
		} else if(!(c1a instanceof LispReal)) {
			throw mesg.getError("err.require.integer", c1a);
		} else {
			throw mesg.getError("err.require.integer", c2a);
		}
		//throw new LispException("integer required");
	}

}
