/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.grammar.lr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import net.morilib.util.Hashes;
import net.morilib.util.Objects;

/**
 * ʸ̮ͳε§ꤹ륯饹Ǥ롣
 * 
 * @author MORIGUCHI, Yuichiro 2006/06/23
 */
public class ContextFreeRule {
	
	//
	private Nonterminal left;
	private List<GrammarSymbol> derived;
	
	/**
	 * ʸ̮ͳε§롣
	 * 
	 * @param left ͤü
	 * @param derived ͤε
	 */
	public ContextFreeRule(
			Nonterminal left, GrammarSymbol... derived) {
		if(derived == null) {
			throw new NullPointerException(
					"Argument 'derived' must not be null");
		}
		
		this.left    = left;
		this.derived = Arrays.asList(derived);
	}
	
	/**
	 * §κͤ롣
	 * 
	 * @return §κ
	 */
	public Nonterminal getLeftSymbol() {
		return left;
	}
	
	/**
	 * §αͤε롣
	 * 
	 * @return ͤε
	 */
	public List<GrammarSymbol> getDerivedSymbols() {
		return Collections.unmodifiableList(derived);
	}
	
	/**
	 * §αͤεĹ롣
	 * 
	 * @return ͤεĹ
	 */
	public int getDerivedSymbolLength() {
		return derived.size();
	}
	
	/**
	 * ͤεˤơꤵ줿ǥåε
	 * 
	 * @param no ǥå
	 * @return ꤵ줿ǥåε
	 */
	public GrammarSymbol getDerivedSymbol(int no) {
		return derived.get(no);
	}
	
	/**
	 * ͤε¸ߤʤ(epsilonܤΤȤ)true롣
	 * 
	 * @return ͤε¸ߤʤ(epsilonܤΤȤ)true
	 */
	public boolean isEpsilon() {
		return derived.isEmpty();
	}
	
	/**
	 * §Ȥtrue롣
	 * 
	 * @param Ĵ٤륪֥
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o instanceof ContextFreeRule) {
			ContextFreeRule rule = (ContextFreeRule)o;
			
			return (Objects.equals(left, rule.left) &&
					Objects.equals(derived, rule.derived));
		}
		return false;
	}
	
	/**
	 * ϥåͤ롣
	 * 
	 * @return ϥå
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		int r = Hashes.INIT;
		r += Hashes.A * (Hashes.hashCode(left) + r);
		r += Hashes.A * (Hashes.hashCode(derived) + r);
		
		return r;
	}
	
	/**
	 * ʸɽ롣
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		
		buf.append(Objects.toString(left));
		buf.append(" -> ");
		for(int i = 0; i < derived.size(); i++) {
			buf.append(derived.get(i));
			buf.append(" ");
		}
		return buf.toString();
	}

}