/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.painter;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;

import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;
import net.morilib.lisp.painter.geom.Point2D;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2010/12/19
 */
public class SchlushPainterFrame extends ImagePainter
implements SchlushFrame {

	//
	/*package*/ BufferedImage image;
	private CoordinateMap coordinate;
	private final ImageFactory factory = new ImageFactory() {

		@Override
		public Image getImage() {
			return image;
		}
		
	};
	
	/**
	 * 
	 * @param x
	 * @param y
	 */
	public SchlushPainterFrame(
			int x, int y, CoordinateMap coordinate) {
		image = new BufferedImage(x, y, BufferedImage.TYPE_INT_ARGB);
		this.coordinate = coordinate;
	}
	
	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#addImage(net.morilib.lisp.painter.SchlushFrame.ImageInfo)
	 */
	@Override
	public void addImage(ImageInfo img) throws InterruptedException {
		Graphics g = image.createGraphics();
		Point2D p0, ps;

		if(coordinate != null) {
			p0 = coordinate.transform(
					image.getWidth(), image.getHeight(),
					img.x, img.y);
			ps = coordinate.transformSize(
					image.getWidth(),
					image.getHeight(),
					img.sx, img.sy);
			g.drawImage(img.img,
					p0.getXInt(), p0.getYInt() - ps.getYInt(),
					ps.getXInt(), ps.getYInt(),
					null);
		} else {
			g.drawImage(img.img,
					(int)img.x, (int)img.y,
					(int)img.sx, (int)img.sy,
					null);
		}
		g.dispose();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#addDrawer(net.morilib.lisp.painter.drawer.Drawer)
	 */
	@Override
	public void addDrawer(Drawer drawer) {
		Graphics g = image.createGraphics();
		
		drawer.draw(
				g,
				image.getWidth(),
				image.getHeight(),
				coordinate);
		g.dispose();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getImageWidth(java.awt.Image)
	 */
	@Override
	public int getImageWidth(Image img) {
		return img.getWidth(null);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getImageHeight(java.awt.Image)
	 */
	@Override
	public int getImageHeight(Image img) {
		return img.getHeight(null);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.ImagePainter#getImageFactory()
	 */
	@Override
	public ImageFactory getImageFactory() {
		return factory;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#clearScreen()
	 */
	@Override
	public void clearScreen() {
		Graphics g = image.createGraphics();
		
		g.clearRect(0, 0, image.getWidth(), image.getHeight());
		g.dispose();
	}

	/**
	 * @return the coordinate
	 */
	public CoordinateMap getCoordinate() {
		return coordinate;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getHeight()
	 */
	@Override
	public int getHeight() {
		return image.getHeight();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getWidth()
	 */
	@Override
	public int getWidth() {
		return image.getWidth();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<painter-frame>");
	}

}
