/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.sss.servlet.http;

import javax.servlet.http.HttpSession;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.UnaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/02/19
 */
public class LispHttpSession extends Datum implements HasAttribute {

	//
	private HttpSession session;

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/02/19
	 */
	public static class Invalidate extends UnaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(
				Datum c1a, Environment env, LispMessage mesg) {
			if(c1a instanceof LispHttpRequest) {
				HttpSession r = ((LispHttpSession)c1a).session;

				r.invalidate();
				return Undef.UNDEF;
			} else {
				throw mesg.getError(
						"err.sss.require.httprequest", c1a);
			}
		}

	}

	/**
	 * @param session
	 */
	/*package*/ LispHttpSession(HttpSession session) {
		this.session = session;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.sss.servlet.http.HasAttribute#getAttribute(java.lang.String)
	 */
	@Override
	public Object getAttribute(String name) {
		return session.getAttribute(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.sss.servlet.http.HasAttribute#setAttribute(java.lang.String, java.lang.Object)
	 */
	@Override
	public void setAttribute(String name, Object value) {
		session.setAttribute(name, value);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.sss.servlet.http.HasAttribute#removeAttribute(java.lang.String)
	 */
	@Override
	public void removeAttribute(String name) {
		session.removeAttribute(name);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<http-session>");
	}

}
