/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util.io.filter;

import java.io.File;
import java.io.FilenameFilter;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/04/29
 */
public class FilenameFilters {

	/**
	 * 
	 */
	public static final FilenameFilter
	IS_DIRECTORY = new FilenameFilter() {

		public boolean accept(File dir, String name) {
			return new File(dir, name).isDirectory();
		}

	};

	/**
	 * 
	 */
	public static final FilenameFilter
	IS_FILE = new FilenameFilter() {

		public boolean accept(File dir, String name) {
			return new File(dir, name).isFile();
		}

	};

	/**
	 * 
	 */
	public static final FilenameFilter
	IS_EXIST = new FilenameFilter() {

		public boolean accept(File dir, String name) {
			return new File(dir, name).exists();
		}

	};

	/**
	 * 
	 */
	public static final FilenameFilter
	TRUE = new FilenameFilter() {

		public boolean accept(File dir, String name) {
			return true;
		}

	};

	/**
	 * 
	 */
	public static final FilenameFilter
	FALSE = new FilenameFilter() {

		public boolean accept(File dir, String name) {
			return false;
		}

	};

}
