/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.engineer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.util.Maps;

public final class EngineerUtils {
    public static final double EXA = 1.0E18;
    public static final double PETA = 1.0E15;
    public static final double TERA = 1.0E12;
    public static final double GIGA = 1.0E9;
    public static final double MEGA = 1000000.0;
    public static final double KILO = 1000.0;
    public static final double HECTO = 100.0;
    public static final double DECA = 10.0;
    public static final double DECI = 0.1;
    public static final double CENTI = 0.01;
    public static final double MILLI = 0.001;
    public static final double MICRO = 1.0E-6;
    public static final double NANO = 1.0E-9;
    public static final double PICO = 1.0E-12;
    public static final double FEMTO = 1.0E-15;
    public static final double ATTO = 1.0E-18;
    public static final Map<String, Double> SI_PREFIX = Maps.initHashMap(new Object[][]{{"E", 1.0E18}, {"P", 1.0E15}, {"T", 1.0E12}, {"G", 1.0E9}, {"M", 1000000.0}, {"k", 1000.0}, {"h", 100.0}, {"da", 10.0}, {"d", 0.1}, {"c", 0.01}, {"m", 0.001}, {"\u03bc", 1.0E-6}, {"u", 1.0E-6}, {"n", 1.0E-9}, {"p", 1.0E-12}, {"f", 1.0E-15}, {"a", 1.0E-18}});

    private EngineerUtils() {
    }

    public static String toSIString(double val, int digit) {
        String si;
        double v2 = Math.abs(val);
        double ks = 0.0;
        if (v2 == 0.0) {
            return "0";
        }
        if (v2 >= 1.0E18) {
            si = null;
        } else if (v2 >= 1.0E15) {
            si = "P";
            ks = 1.0E15;
        } else if (v2 >= 1.0E12) {
            si = "T";
            ks = 1.0E12;
        } else if (v2 >= 1.0E9) {
            si = "G";
            ks = 1.0E9;
        } else if (v2 >= 1000000.0) {
            si = "M";
            ks = 1000000.0;
        } else if (v2 >= 1000.0) {
            si = "k";
            ks = 1000.0;
        } else if (v2 >= 1.0) {
            si = "";
            ks = 1.0;
        } else if (v2 >= 0.001) {
            si = "m";
            ks = 0.001;
        } else if (v2 >= 1.0E-6) {
            si = "u";
            ks = 1.0E-6;
        } else if (v2 >= 1.0E-9) {
            si = "n";
            ks = 1.0E-9;
        } else if (v2 >= 1.0E-12) {
            si = "p";
            ks = 1.0E-12;
        } else if (v2 >= 1.0E-15) {
            si = "f";
            ks = 1.0E-15;
        } else {
            si = null;
        }
        if (si == null) {
            BigDecimal d1 = BigDecimal.valueOf(val);
            d1 = d1.setScale(digit, RoundingMode.HALF_EVEN);
            return d1.toEngineeringString();
        }
        String fmts = "##0";
        if (v2 >= 100.0 * ks) {
            int i = 0;
            while (i < digit - 3) {
                if (i == 0) {
                    fmts = String.valueOf(fmts) + ".";
                }
                fmts = String.valueOf(fmts) + "0";
                ++i;
            }
        } else if (v2 >= 10.0 * ks) {
            fmts = String.valueOf(fmts) + ".";
            int i = 0;
            while (i < digit - 2) {
                fmts = String.valueOf(fmts) + "0";
                ++i;
            }
        } else {
            fmts = String.valueOf(fmts) + ".";
            int i = 0;
            while (i < digit - 1) {
                fmts = String.valueOf(fmts) + "0";
                ++i;
            }
        }
        DecimalFormat fmt = new DecimalFormat(fmts);
        return String.valueOf(fmt.format(val / ks)) + si;
    }

    public static double parseSIDouble(String si) {
        Pattern p = Pattern.compile("^([0-9eE.]*)([PTGMkmunpf]?)$");
        Matcher m = p.matcher(si);
        if (!m.matches()) {
            throw new NumberFormatException(si);
        }
        String num = m.group(1);
        String prf = m.group(2);
        double res = Double.parseDouble(num);
        if (SI_PREFIX.containsKey(prf)) {
            res *= SI_PREFIX.get(prf).doubleValue();
        }
        return res;
    }
}

