/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.SExpressionDatum;

public class ConsListBuilder {
    private SExpressionDatum res = null;
    private Cons rp = null;

    public ConsListBuilder() {
    }

    ConsListBuilder(ConsListBuilder src, LispMessage mesg) {
        if (src.res != null) {
            this.appendAll(src.res, mesg);
        }
    }

    public ConsListBuilder appendCons(Cons n) {
        if (this.res == null) {
            this.rp = n;
            this.res = this.rp;
        } else {
            this.rp.setCdr(n);
            this.rp = n;
        }
        return this;
    }

    public ConsListBuilder append(Datum d) {
        return this.appendCons(new Cons(d, Nil.NIL));
    }

    ConsListBuilder appendAll(Datum n, LispMessage mesg) {
        Datum p = n;
        while (p instanceof Cons) {
            Cons c = (Cons)p;
            this.append(c.getCar());
            p = c.getCdr();
        }
        if (p == Nil.NIL) {
            return this;
        }
        throw mesg.getError("err.list");
    }

    public SExpressionDatum get() {
        return this.res == null ? Nil.NIL : this.res;
    }

    public Datum get(Datum cdr) {
        if (this.res != null) {
            this.rp.setCdr(cdr);
            return this.res;
        }
        return cdr;
    }

    public String toString() {
        return LispUtils.print(this.get());
    }
}

