/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaUtils;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.ParameterNotFoundException;
import net.morilib.lisp.Subr;

class JavaProperty
extends Subr {
    private PropertyDescriptor propdesc;

    JavaProperty(String name, PropertyDescriptor pd) {
        this.symbolName = name;
        this.propdesc = pd;
        super.setSetter(new Setter(name));
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        if (this.propdesc instanceof IndexedPropertyDescriptor) {
            Cons c0;
            if (body instanceof Cons && (c0 = (Cons)body).getCdr() instanceof Cons) {
                Cons c1 = (Cons)c0.getCdr();
                if (c1.getCdr() != Nil.NIL) {
                    throw mesg.getError("err.argument");
                }
                if (!(c0.getCar() instanceof JavaInstance)) {
                    throw mesg.getError("err.require.java-bean", c0.getCar());
                }
                if (!(c1.getCar() instanceof LispSmallInt)) {
                    throw mesg.getError("err.require.smallint", c1.getCar());
                }
                try {
                    JavaInstance bn = (JavaInstance)c0.getCar();
                    LispSmallInt si = (LispSmallInt)c1.getCar();
                    int ix = si.getExactSmallInt();
                    Object jo = JavaUtils.invokeGetter(bn.getJavaInstance(), (IndexedPropertyDescriptor)this.propdesc, ix);
                    return LispUtils.toDatum(jo);
                }
                catch (ParameterNotFoundException e) {
                    throw mesg.getError("err.java.getter.notfound");
                }
            }
            throw mesg.getError("err.argument");
        }
        if (body instanceof Cons) {
            Cons c0 = (Cons)body;
            if (c0.getCdr() != Nil.NIL) {
                throw mesg.getError("err.argument");
            }
            if (!(c0.getCar() instanceof JavaInstance)) {
                throw mesg.getError("err.require.java-bean", c0.getCar());
            }
            try {
                JavaInstance bn = (JavaInstance)c0.getCar();
                Object jo = JavaUtils.invokeGetter(bn.getJavaInstance(), this.propdesc);
                return LispUtils.toDatum(jo);
            }
            catch (ParameterNotFoundException e) {
                throw mesg.getError("err.java.getter.notfound");
            }
        }
        throw mesg.getError("err.argument");
    }

    private class Setter
    extends Subr {
        private Setter(String name) {
            this.symbolName = String.valueOf(name) + "$setter";
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (JavaProperty.this.propdesc instanceof IndexedPropertyDescriptor) {
                if (lst.size() != 3) {
                    throw mesg.getError("err.argument");
                }
                if (!(lst.get(0) instanceof JavaInstance)) {
                    throw mesg.getError("err.require.java-bean", lst.get(0));
                }
                if (!(lst.get(1) instanceof LispSmallInt)) {
                    throw mesg.getError("err.require.smallint", lst.get(1));
                }
                try {
                    JavaInstance bn = (JavaInstance)lst.get(0);
                    LispSmallInt si = (LispSmallInt)lst.get(1);
                    int ix = si.getExactSmallInt();
                    Object jo = JavaUtils.invokeSetter(bn.getJavaInstance(), (IndexedPropertyDescriptor)JavaProperty.this.propdesc, ix, lst.get(2));
                    return LispUtils.toDatum(jo);
                }
                catch (ParameterNotFoundException e) {
                    throw mesg.getError("err.java.setter.notfound");
                }
            }
            if (lst.size() != 2) {
                throw mesg.getError("err.argument");
            }
            if (!(lst.get(0) instanceof JavaInstance)) {
                throw mesg.getError("err.require.java-bean", lst.get(0));
            }
            try {
                JavaInstance bn = (JavaInstance)lst.get(0);
                Object jo = JavaUtils.invokeSetter(bn.getJavaInstance(), JavaProperty.this.propdesc, lst.get(1));
                return LispUtils.toDatum(jo);
            }
            catch (ParameterNotFoundException e) {
                throw mesg.getError("err.java.getter.notfound");
            }
        }
    }
}

