/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;

public class SubrOpenInputFile
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 1) {
            Datum c1a = l.get(0);
            if (c1a instanceof LispString) {
                String fn = ((LispString)c1a).getString();
                try {
                    return new InputPort(LispFiles.getFile(env, fn), mesg);
                }
                catch (IOException e) {
                    throw mesg.getError("err.io", e.getMessage());
                }
            }
            throw mesg.getError("err.require.string", c1a);
        }
        if (l.size() == 2) {
            Datum c1a = l.get(0);
            Datum c2a = l.get(1);
            if (!(c1a instanceof LispString)) {
                throw mesg.getError("err.require.string", c1a);
            }
            if (!(c2a instanceof LispString)) {
                throw mesg.getError("err.require.string", c2a);
            }
            String fname = ((LispString)c1a).getString();
            String enc = c2a.getString();
            try {
                return new InputPort(fname, enc, mesg);
            }
            catch (UnsupportedEncodingException e) {
                throw mesg.getError("err.unsupportedencoding", enc);
            }
        }
        return null;
    }
}

