/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi013;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class StringPad
extends Subr {
    protected Datum execute(String s, int le, int ch, int b, int e, LispMessage mesg) {
        if (le <= e - b) {
            return new LispString(s.substring(e - le, e));
        }
        StringBuilder bf = new StringBuilder();
        int i = e - b;
        while (i < le) {
            bf.append((char)ch);
            ++i;
        }
        bf.append(s.substring(b, e));
        return new LispString(bf.toString());
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int e;
        int b;
        int ch;
        String s;
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 2) {
            s = SubrUtils.getString(l.get(0), mesg);
            ch = 32;
            b = 0;
            e = s.length();
        } else if (l.size() == 3) {
            s = SubrUtils.getString(l.get(0), mesg);
            ch = SubrUtils.getCharacter(l.get(2), mesg);
            b = 0;
            e = s.length();
        } else if (l.size() == 4) {
            s = SubrUtils.getString(l.get(0), mesg);
            ch = SubrUtils.getCharacter(l.get(2), mesg);
            b = SubrUtils.getSmallIntegerExact(l.get(3), mesg);
            e = s.length();
            if (b >= s.length()) {
                throw mesg.getError("err.string.outofrange", l.get(3));
            }
        } else if (l.size() == 5) {
            s = SubrUtils.getString(l.get(0), mesg);
            ch = SubrUtils.getCharacter(l.get(2), mesg);
            b = SubrUtils.getSmallIntegerExact(l.get(3), mesg);
            e = SubrUtils.getSmallIntegerExact(l.get(4), mesg);
            if (b >= s.length()) {
                throw mesg.getError("err.string.outofrange", l.get(3));
            }
            if (e > s.length()) {
                throw mesg.getError("err.string.outofrange", l.get(4));
            }
            if (b > e) {
                throw mesg.getError("err.range.invalid");
            }
        } else {
            throw mesg.getError("err.argument", body);
        }
        int le = SubrUtils.getSmallIntegerExact(l.get(1), mesg);
        return this.execute(s, le, ch, b, e, mesg);
    }
}

