/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nio;

import java.nio.ReadOnlyBufferException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.nio.LispBlob;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class BlobS8SetS
extends TernaryArgs {
    private static byte getNumber(Datum d, LispMessage mesg) {
        if (!(d instanceof LispInteger)) {
            throw mesg.getError("err.require.real", d);
        }
        if (((LispInteger)d).inByteRange()) {
            return (byte)d.getInt();
        }
        throw mesg.getError("err.uvector.outofrange.s8", d);
    }

    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispBlob) {
            int k = SubrUtils.getSmallIntegerExact(c2a, mesg);
            try {
                ((LispBlob)c1a).put(k, BlobS8SetS.getNumber(c3a, mesg));
                return Undef.UNDEF;
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi74.blob.outofrange", "" + k);
            }
            catch (ReadOnlyBufferException e) {
                throw mesg.getError("err.srfi74.buffer.readonly");
            }
        }
        throw mesg.getError("err.srfi74.require.blob", c1a);
    }
}

