/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousFloatArray;
import net.morilib.lisp.uvector.LispF32Vector;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.uvector.DoubleArray;

public class LispF64Vector
extends Atom
implements HomogeneousFloatArray {
    private DoubleArray vector;

    private LispF64Vector() {
    }

    public LispF64Vector(double ... bs) {
        this.vector = DoubleArray.newArray(bs);
    }

    public static LispF64Vector malloc(int size) {
        LispF64Vector res = new LispF64Vector();
        res.vector = DoubleArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        return d instanceof LispReal;
    }

    private static double[] toDoubleList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        DoubleArrayVector v = new DoubleArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispF64Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.f64", d);
            }
            v.add(d.getRealDouble());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toDoubleArray();
    }

    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#f64(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(this.vector.getDouble(i));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public String getResult() {
        return this.print();
    }

    public LispString toLispString() {
        return new LispString(this.print());
    }

    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispF64Vector)) {
            return false;
        }
        if (!(d2 instanceof LispF64Vector)) {
            return false;
        }
        return ((LispF64Vector)d1).vector.equals(((LispF64Vector)d2).vector);
    }

    public LispDouble get(int index) {
        return new LispDouble(this.vector.getDouble(index));
    }

    public void set(int index, LispReal x) {
        this.vector.setDouble(index, x.getRealDouble());
    }

    public int size() {
        return this.vector.size();
    }

    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispF64Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.f64", x);
        }
    }

    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public static class EqualF64Vector
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispF32Vector)) {
                throw mesg.getError("err.uvector.require.f64", c1a);
            }
            if (!(c2a instanceof LispF32Vector)) {
                throw mesg.getError("err.uvector.require.f64", c2a);
            }
            return LispBoolean.getInstance(((LispF64Vector)c1a).vector.equals(((LispF64Vector)c2a).vector));
        }
    }

    public static class F64Vector
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispF64Vector(LispF64Vector.toDoubleList(body, mesg));
        }
    }

    public static class F64VectorToList
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispF64Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispF64Vector v = (LispF64Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(new LispDouble(v.vector.getDouble(i)));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.f64", c1a);
        }
    }

    public static class IsF64Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispF64Vector);
        }
    }

    public static class ListToF64Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispF64Vector(LispF64Vector.toDoubleList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeF64Vector
    extends Subr {
        private double[] makeVector(int len, double d) {
            DoubleArrayVector b = new DoubleArrayVector();
            int i = 0;
            while (i < len) {
                b.add(d);
                ++i;
            }
            return b.toDoubleArray();
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispF64Vector(this.makeVector(t, 0.0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispF64Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.f64", lst.get(1));
                }
                return new LispF64Vector(this.makeVector(t, lst.get(1).getRealDouble()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }
}

