/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.morilib.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedSet<E>
extends AbstractSet<E> {
    private Set<E> composite;
    private E elem;

    private NestedSet(E elem, Set<E> composite) {
        this.elem = elem;
        this.composite = composite;
    }

    public static <E> Set<E> compose(E elem, Set<E> composite) {
        return composite.contains(elem) ? composite : new NestedSet<E>(elem, composite);
    }

    @Override
    public boolean contains(Object o) {
        if (Objects.equals(this.elem, o)) {
            return true;
        }
        if (this.composite != null) {
            return this.composite.contains(o);
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Set<E> c;
            private Iterator<E> it;
            {
                this.c = NestedSet.this;
                this.it = null;
            }

            @Override
            public boolean hasNext() {
                return this.c instanceof NestedSet || this.it != null && this.it.hasNext();
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.c instanceof NestedSet) {
                    Object res = ((NestedSet)this.c).elem;
                    this.c = ((NestedSet)this.c).composite;
                    if (!(this.c instanceof NestedSet)) {
                        this.it = this.c.iterator();
                    }
                    return res;
                }
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        Set<E> c = this;
        int res = 0;
        while (c instanceof NestedSet) {
            ++res;
            c = c.composite;
        }
        return res + c.size();
    }
}

