/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set.quotient;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.morilib.lang.Equivalence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Classifier {
    private Classifier() {
    }

    public static <E, Q> Map<Q, Set<E>> classify(Set<E> set, Equivalence<E, Q> eqv) {
        HashMap<Q, HashSet<E>> res = new HashMap<Q, HashSet<E>>();
        for (E e : set) {
            Q q = eqv.classify(e);
            HashSet<E> s0 = (HashSet<E>)res.get(q);
            if (s0 == null) {
                s0 = new HashSet<E>();
                res.put(q, s0);
            }
            s0.add(e);
        }
        return Collections.unmodifiableMap(res);
    }

    public static <E, Q, V> Map<Q, Set<V>> classify(Map<E, V> map, Equivalence<E, Q> eqv) {
        HashMap<Q, HashSet<V>> res = new HashMap<Q, HashSet<V>>();
        for (Map.Entry<E, V> e : map.entrySet()) {
            Q q = eqv.classify(e.getKey());
            HashSet<V> s0 = (HashSet<V>)res.get(q);
            if (s0 == null) {
                s0 = new HashSet<V>();
                res.put(q, s0);
            }
            s0.add(e.getValue());
        }
        return Collections.unmodifiableMap(res);
    }
}

