/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;

public class DoubleArray
extends AbstractUniformArray {
    private double[] array;

    private DoubleArray(double[] arr) {
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new double[arr.length];
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public DoubleArray(DoubleArray a) {
        this.array = Arrays2.copy(a.array);
    }

    public static DoubleArray newArray(double[] arr) {
        return new DoubleArray(arr);
    }

    public static DoubleArray malloc(int size) {
        return new DoubleArray(new double[size]);
    }

    public byte getByte(int i) {
        return (byte)this.getDouble(i);
    }

    public double getDouble(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    public float getFloat(int i) {
        return (float)this.getDouble(i);
    }

    public int getInt(int i) {
        return (int)this.getDouble(i);
    }

    public long getLong(int i) {
        return (long)this.getDouble(i);
    }

    public short getShort(int i) {
        return (short)this.getDouble(i);
    }

    public void setByte(int i, byte x) {
        this.setDouble(i, x);
    }

    public void setDouble(int i, double x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    public void setInt(int i, int x) {
        this.setDouble(i, x);
    }

    public void setLong(int i, long x) {
        this.setDouble(i, x);
    }

    public void setShort(int i, short x) {
        this.setDouble(i, x);
    }

    public int size() {
        return this.array.length;
    }

    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 3];
        int i = 0;
        while (i < this.array.length) {
            e.writeLong(res, i << 3, Double.doubleToLongBits(this.array[i]));
            ++i;
        }
        return res;
    }

    public double[] toArray() {
        return Arrays2.copy(this.array);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleArray) {
            return Arrays.equals(this.array, ((DoubleArray)obj).array);
        }
        return false;
    }
}

