/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.automata.nfa;

import java.util.Set;

import net.morilib.util.Tuple2;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2006/05/22
 */
public final class StringNFAMatcher<A> {
	
	//
	private NFAObject<Integer, A, Tuple2<A, Integer>> nfa;
	private Set<A>    result = null;
	private String    matched = null;
	//private Map<A, SortedMap<Integer, BE>> capture = null;
	
	/**
	 * 
	 * @param nfa
	 */
	public StringNFAMatcher(
			NFAObject<Integer, A, Tuple2<A, Integer>> nfa) {
		this.nfa = nfa;
	}
	
	//
	private Set<NFAState> getInitialStates() {
		return NFAs.getEpsilonReachable(nfa, nfa.getInitialStates());
	}
	
	/**
	 * 
	 * @param str
	 * @return
	 */
	public boolean match(String str) {
		StringBuilder matches = new StringBuilder();
		
		Set<NFAState> s = getInitialStates();
		Set<NFAState> t = s;
		int i = 0;
		
		while(i < str.length()) {
			int a = str.charAt(i);
			
			matches.append((char)a);
			t = NFAs.getStates(nfa, s, a);
			s = NFAs.getEpsilonReachable(nfa, t);
			if(s.isEmpty()) {
				return false;
			} else {
				i++;
			}
		}
		
		if(nfa.isFinalAny(s)) {
			matched = matches.toString();
			result  = NFAs.getAccept(nfa, s);
			//capture = cap2;
			return true;
		} else {
			matched = null;
			result  = null;
			//capture = null;
			return false;
		}
	}
	
	
	public Set<A> getResult() {
		// result is already unmodifiable
		return result;
	}
	
	
	public String getMatched() {
		return matched;
	}
	
	
	/*public String getCapture(A a, int cno) {
		if(capture == null) {
			return null;
		}
		return getCap(new Tuple2<A, Integer>(a, cno));
	}*/
	
}
