/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang;

import net.morilib.lang.Half;
import net.morilib.util.BitUtils;

public final class DoubleUtils {
    private static final int EMAX = 2047;
    private static final int EXPBIT = 52;
    private static final long EXPMASK = 0x7FF0000000000000L;
    private static final long SIGMASK = 0xFFFFFFFFFFFFFL;
    private static final long SGNMASK = Long.MIN_VALUE;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_NORMALIZED_EXPONENT = -1022;
    public static final int MIN_EXPONENT = -1074;
    public static final int FRACTION_BITS = 52;
    public static final int BIAS = 1023;
    public static final long POSITIVE_INFINITY_BY_LONG = 0x7FF0000000000000L;
    public static final long NEGATIVE_INFINITY_BY_LONG = -4503599627370496L;
    public static final long MAX_VALUE_BY_SHORT = 0x7FEFFFFFFFFFFFFFL;
    public static final long MIN_VALUE_BY_SHORT = -4503599627370497L;
    public static final long ZERO = 0L;
    public static final long MINUS_ZERO = -1152921504606846976L;
    private static final int DTOH = 42;

    static double _getDouble(int sign, int exp, long frac) {
        long l = 0L;
        l |= sign == 1 ? Long.MIN_VALUE : 0L;
        if (exp > 1023) {
            return l | 0x7FF0000000000000L;
        }
        if (exp >= -1022) {
            l |= (long)(exp + 1023) << 52;
        } else if (exp < -1074) {
            return Double.longBitsToDouble(l);
        }
        return Double.longBitsToDouble(l |= frac & 0xFFFFFFFFFFFFFL);
    }

    public static int getSignumField(long x) {
        return x < 0L ? 1 : 0;
    }

    public static int getExponentField(long x) {
        return (int)((x & 0x7FF0000000000000L) >> 52);
    }

    public static long getFractionField(long x) {
        return x & 0xFFFFFFFFFFFFFL;
    }

    public static int getSignum(long x) {
        return DoubleUtils.getSignumField(x) == 0 ? 1 : -1;
    }

    public static int getExponent(long x) {
        int e = DoubleUtils.getExponentField(x);
        long f = DoubleUtils.getFractionField(x);
        if (e == 2047) {
            if (f == 0L) {
                return 1024;
            }
            return -1;
        }
        if (e > 0) {
            return e;
        }
        return -1074 - (BitUtils.getMsb(f) - 1);
    }

    public static boolean isNormalized(long x) {
        int e = DoubleUtils.getExponentField(x);
        return e > 0 && e < 2047;
    }

    public static boolean isZero(long x) {
        return (x & Long.MAX_VALUE) == 0L;
    }

    public static double inclement(double x) {
        long l = Double.doubleToLongBits(x);
        int s = DoubleUtils.getSignumField(l);
        int e = DoubleUtils.getExponentField(l);
        long f = DoubleUtils.getFractionField(l);
        if (x == Double.POSITIVE_INFINITY) {
            return x;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.MIN_VALUE;
        }
        if (x == Double.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(x)) {
            return x;
        }
        if (f == 0xFFFFFFFFFFFFFL) {
            return DoubleUtils._getDouble(s, e + 1, f << 1);
        }
        return DoubleUtils._getDouble(s, e, f + 1L);
    }

    public static double declement(double x) {
        long l = Double.doubleToLongBits(x);
        int s = DoubleUtils.getSignumField(l);
        int e = DoubleUtils.getExponentField(l);
        long f = DoubleUtils.getFractionField(l);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return x;
        }
        if (x == Double.MIN_VALUE) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(x)) {
            return x;
        }
        if (f == 0L) {
            return DoubleUtils._getDouble(s, e - 1, 1L);
        }
        return DoubleUtils._getDouble(s, e, f - 1L);
    }

    public static int getSignumField(double x) {
        return DoubleUtils.getSignumField(Double.doubleToRawLongBits(x));
    }

    public static int getExponentField(double x) {
        return DoubleUtils.getExponentField(Double.doubleToRawLongBits(x));
    }

    public static long getFractionField(double x) {
        return DoubleUtils.getFractionField(Double.doubleToRawLongBits(x));
    }

    public static int getSignum(double x) {
        return DoubleUtils.getSignum(Double.doubleToRawLongBits(x));
    }

    public static int getExponent(double d) {
        long x = Double.doubleToLongBits(d);
        int e = DoubleUtils.getExponentField(x);
        long f = DoubleUtils.getFractionField(x);
        if (DoubleUtils.isZero(x)) {
            return 0;
        }
        if (e == 2047) {
            if (f == 0L) {
                return 1024;
            }
            return Integer.MIN_VALUE;
        }
        if (e > 0) {
            return e - 1023;
        }
        return -1074 + (BitUtils.getMsb(f) - 1);
    }

    public static boolean isNormalized(double x) {
        return DoubleUtils.isNormalized(Double.doubleToRawLongBits(x));
    }

    public static short toHalf(double x) {
        int e = DoubleUtils.getExponent(x);
        long l = DoubleUtils.getFractionField(x);
        if (e == Integer.MIN_VALUE) {
            return Short.MAX_VALUE;
        }
        if (x > Half.MAX_VALUE.doubleValue()) {
            return 31744;
        }
        if (x < Half.NEGATIVE_MAX_VALUE.doubleValue()) {
            return -1024;
        }
        if (Math.abs(x) < Half.MIN_VALUE.doubleValue()) {
            return x > 0.0 ? (short)0 : Short.MIN_VALUE;
        }
        if (e >= -14) {
            return Half._getHalf(DoubleUtils.getSignumField(x), e, (int)(l >> 42));
        }
        if (e >= -24) {
            short r = (short)((l | 0x10000000000000L) >> 52 - (-24 - e));
            return x > 0.0 ? r : Half.neg(r);
        }
        return x > 0.0 ? (short)0 : Short.MIN_VALUE;
    }
}

