/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.bean;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import net.morilib.lang.bean.BeanException;
import net.morilib.lang.bean.Property;

class BeanProperty
extends Property {
    private static final Object[] ZEROOBJ = new Object[0];
    private PropertyDescriptor prop;

    BeanProperty(PropertyDescriptor propertyDescriptor) {
        this.prop = propertyDescriptor;
    }

    @Override
    public Object get(Object bean) {
        try {
            return this.prop.getReadMethod().invoke(bean, ZEROOBJ);
        }
        catch (IllegalArgumentException e) {
            throw new BeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanException(e);
        }
    }

    @Override
    public void set(Object bean, Object value) {
        try {
            this.prop.getWriteMethod().invoke(bean, value);
        }
        catch (IllegalArgumentException e) {
            throw new BeanException(e);
        }
        catch (IllegalAccessException e) {
            throw new BeanException(e);
        }
        catch (InvocationTargetException e) {
            throw new BeanException(e);
        }
    }

    @Override
    public void setAccessible(boolean b) {
        this.prop.getReadMethod().setAccessible(b);
        this.prop.getWriteMethod().setAccessible(b);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        Method r = this.prop.getReadMethod();
        Method w = this.prop.getWriteMethod();
        return r.isAnnotationPresent(annotationClass) || w.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Method r = this.prop.getReadMethod();
        Method w = this.prop.getWriteMethod();
        T a = r.getAnnotation(annotationClass);
        return a != null ? a : w.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        Method r = this.prop.getReadMethod();
        Method w = this.prop.getWriteMethod();
        ArrayList<Annotation> res = new ArrayList<Annotation>(Arrays.asList(r.getAnnotations()));
        Annotation[] annotationArray = w.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                Annotation a = annotationArray[n2];
                for (Annotation b : res) {
                    if (!a.annotationType().equals(b.annotationType())) continue;
                    if (!a.equals(b)) {
                        throw new BeanException("contradicted annotation");
                    }
                    break block3;
                }
                res.add(a);
            }
            ++n2;
        }
        return res.toArray(new Annotation[0]);
    }

    @Override
    public String getName() {
        return this.prop.getName();
    }

    @Override
    public Class<?> getType() {
        return this.prop.getPropertyType();
    }
}

