/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EnvironmentObject;
import net.morilib.lisp.ILispDynamicSubr;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.ReadOnlyException;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.Undef;
import net.morilib.lisp.r6rs.LibraryID;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public final class Environment {
    private Environment rootenv;
    private Map<SymbolName, Datum> binds = Collections.synchronizedMap(new HashMap());
    private Set<Datum> rdonly = Collections.synchronizedSet(new HashSet());

    public Environment() {
        this.rootenv = null;
    }

    Environment(Environment rootenv) {
        this.rootenv = rootenv;
    }

    public void bindDatum(Datum sym, Datum d) {
        if (sym instanceof SymbolName) {
            this.binds.put((SymbolName)((Object)sym), d);
            if (d instanceof Subr) {
                ((Subr)d).symbolName = ((SymbolName)((Object)sym)).getName();
            }
        } else {
            throw new LispException("Parameter is not a symbol");
        }
    }

    void bindDatumReadOnly(Datum sym, Datum d) {
        this.bindDatum(sym, d);
        this.rdonly.add(sym);
    }

    void bindDatumWithoutScope(Datum sym, Datum d) {
        if (!(sym instanceof SymbolName)) {
            throw new LispException("Parameter is not a symbol");
        }
        this.binds.put(((SymbolName)((Object)sym)).getSymbol(), d);
    }

    public Datum getDatum(Datum sym) {
        if (sym instanceof Symbol) {
            return this.binds.get(sym);
        }
        throw new LispException("Parameter is not a symbol");
    }

    public Datum getDatumTop(Datum sym) {
        if (sym instanceof Symbol) {
            return this.getGlobal().binds.get(sym);
        }
        throw new LispException("Parameter is not a symbol");
    }

    public Datum findDatum(Datum sym) {
        if (sym instanceof SymbolName) {
            Environment env = this;
            SymbolName s1 = (SymbolName)((Object)sym);
            while (env != null) {
                Datum f = env.binds.get(sym);
                if (f != null) {
                    return f;
                }
                f = env.binds.get(Symbol.DEFAULT_NAMESPACE.getSymbol(s1.getName()));
                if (f != null) {
                    return f;
                }
                env = env.rootenv;
            }
            return null;
        }
        throw new LispException("Parameter is not a symbol");
    }

    public boolean setDatum(Datum sym, Datum d) throws ReadOnlyException {
        if (sym instanceof Symbol) {
            Environment env = this;
            Symbol s1 = (Symbol)sym;
            while (env != null) {
                Datum f = env.binds.get(sym);
                if (f != null) {
                    if (this.rdonly.contains(sym)) {
                        throw new ReadOnlyException();
                    }
                    env.binds.put((Symbol)sym, d);
                    return true;
                }
                Symbol s0 = Symbol.DEFAULT_NAMESPACE.getSymbol(s1.getName());
                f = env.binds.get(s0);
                if (f != null) {
                    if (this.rdonly.contains(sym)) {
                        throw new ReadOnlyException();
                    }
                    env.binds.put(s0, d);
                    return true;
                }
                env = env.rootenv;
            }
            return false;
        }
        throw new LispException("Parameter is not a symbol");
    }

    public Set<SymbolName> getBoundSymbols() {
        return Collections.unmodifiableSet(this.binds.keySet());
    }

    public Map<SymbolName, Datum> getData() {
        return Collections.unmodifiableMap(this.binds);
    }

    Environment getGlobal() {
        Environment env = this;
        while (env.rootenv != null) {
            env = env.rootenv;
        }
        return env;
    }

    Environment getRootenv() {
        return this.rootenv;
    }

    Environment copy() {
        Environment res = new Environment();
        res.rootenv = this.rootenv;
        res.binds = new HashMap<SymbolName, Datum>(this.binds);
        return res;
    }

    Environment copyNotRoot() {
        return this.rootenv != null ? this.copy() : this;
    }

    private static Environment _copyExceptRoot(Environment e) {
        if (e.rootenv != null) {
            Environment er = new Environment(Environment._copyExceptRoot(e.rootenv));
            er.binds = new HashMap<SymbolName, Datum>(e.binds);
            return er;
        }
        return e;
    }

    Environment copyExceptRoot() {
        return Environment._copyExceptRoot(this);
    }

    public boolean isFreeVariable(Datum x) {
        return x instanceof Symbol && !((Symbol)x).isMacroBound() && this.findDatum(x) == null;
    }

    public boolean isBoundVariable(Datum x) {
        return x instanceof Symbol && (((Symbol)x).isMacroBound() || this.findDatum(x) != null);
    }

    public String toString() {
        Environment env = this;
        StringBuilder buf = new StringBuilder();
        while (env.rootenv != null) {
            buf.append(env.binds).append("->");
            env = env.rootenv;
        }
        buf.append("{Global}");
        return buf.toString();
    }

    public static class Apropos
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            String s = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
            Datum d = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            Environment e = d == null ? env : LibraryID.getNamespace(new LibraryID(d));
            while (e != null) {
                for (SymbolName sym : e.binds.keySet()) {
                    if (sym.getName().indexOf(s) < 0) continue;
                    System.out.println(sym.getName());
                }
                e = e.rootenv;
            }
            return Undef.UNDEF;
        }
    }

    public static class PreviousEnvironment
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            int c = SubrUtils.getSmallInt(c2a, mesg);
            if (c < 0) {
                throw mesg.getError("err.require.int.nonnegative", c2a);
            }
            if (c1a instanceof EnvironmentObject) {
                Environment e = ((EnvironmentObject)c1a).getEnvironment();
                int i = 0;
                while (i < c && e != null) {
                    ++i;
                    e = e.rootenv;
                }
                return e != null ? new EnvironmentObject(e, false) : LispBoolean.FALSE;
            }
            throw mesg.getError("err.environment", c1a);
        }
    }

    public static class PreviousInteractionEnvironment
    extends UnaryArgs
    implements ILispDynamicSubr {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            int c = SubrUtils.getSmallInt(c1a, mesg);
            if (c < 0) {
                throw mesg.getError("err.require.int.nonnegative", c1a);
            }
            Environment e = env;
            int i = 0;
            while (i < c && e != null) {
                ++i;
                e = e.rootenv;
            }
            return e != null ? new EnvironmentObject(e, false) : LispBoolean.FALSE;
        }
    }
}

