/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Parser;
import net.morilib.lisp.ReadUnreadable;
import net.morilib.lisp.r6rs.io.ILispSimpleInputPort;
import net.morilib.lisp.r6rs.io.ILispTextualInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.util.io.CharUnreadBuffer;
import net.morilib.util.tape.CharTape;

public class InputPort
extends Datum
implements CharTape,
CharUnreadBuffer,
ILispSimpleInputPort,
ReadUnreadable,
ILispTextualInputPort {
    private Reader reader;
    private boolean standard;
    private Parser parser;
    private boolean reachedEOF = false;
    private boolean closed = false;
    private LispMessage msg;
    private int unreadbuf = -1;

    private InputPort(Reader rd, boolean std, LispMessage msg) {
        this.reader = rd;
        this.standard = std;
        this.msg = msg;
        this.parser = new Parser(this, msg);
    }

    public InputPort(Reader rd, LispMessage msg) {
        this(rd, false, msg);
    }

    public InputPort(File fname, LispMessage msg) {
        try {
            InputStreamReader rd = new InputStreamReader(new FileInputStream(fname));
            this.reader = new PushbackReader(rd);
            this.standard = false;
            this.msg = msg;
            this.parser = new Parser(this, msg);
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public InputPort(String fname, String enconding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            InputStreamReader rd = new InputStreamReader((InputStream)new FileInputStream(fname), enconding);
            this.reader = new PushbackReader(rd);
            this.standard = false;
            this.msg = msg;
            this.parser = new Parser(this, msg);
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static InputPort getStandard(LispMessage msg) {
        return new InputPort(new InputStreamReader(System.in), true, msg);
    }

    @Override
    public int getc() throws IOException {
        int ch;
        if (this.unreadbuf == -1) {
            ch = this.reader.read();
        } else {
            ch = this.unreadbuf;
            this.unreadbuf = -1;
        }
        return ch;
    }

    @Override
    public Datum readChar() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            int ch = this.getc();
            if (ch < 0) {
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            return new LispCharacter((char)ch);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public Datum peekChar() {
        int c = this.readc();
        return c != -1 ? new LispCharacter((char)c) : EOFObject.EOF;
    }

    @Override
    public Datum readS() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return EOFObject.EOF;
        }
        try {
            this.parser.clear();
            if (this.parser.parse()) {
                Datum res = this.parser.getDatum();
                if (res != null) {
                    return res;
                }
                this.reachedEOF = true;
                return EOFObject.EOF;
            }
            this.reachedEOF = true;
            if (!this.parser.isReadBefore()) {
                return EOFObject.EOF;
            }
            throw this.msg.getReadError("err.read.eof");
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.closed && !this.standard) {
                this.reader.close();
                this.closed = true;
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    void skipShebang() {
        try {
            this.reachedEOF = !IntLispUtils.skipShebang(this.reader, this);
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    @Override
    public boolean isReachedEOF() {
        return this.reachedEOF;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    Parser getParser() {
        return this.parser;
    }

    @Override
    public Integer read() {
        return this.readc();
    }

    @Override
    public boolean write(Integer symbol) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean moveRight() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return false;
        }
        try {
            int ch = this.getc();
            if (ch < 0) {
                this.reachedEOF = true;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public boolean moveLeft() {
        return false;
    }

    @Override
    public int readc() {
        int ch;
        block5: {
            if (this.closed) {
                throw this.msg.getError("err.port.closed");
            }
            if (this.reachedEOF) {
                return -1;
            }
            try {
                ch = this.getc();
                if (ch >= 0) break block5;
                this.reachedEOF = true;
                return -1;
            }
            catch (IOException e) {
                throw new LispIOException(e);
            }
        }
        this.unread((char)ch);
        return ch;
    }

    @Override
    public boolean writec(int c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int mark() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int back() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unread(int c) {
        this.unreadbuf = c;
    }

    @Override
    public void unread(char c) {
        this.unreadbuf = c;
    }

    public boolean ready() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return false;
        }
        try {
            return this.reader.ready();
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public int getChar() throws IOException {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return -1;
        }
        try {
            int ch = this.getc();
            if (ch < 0) {
                this.reachedEOF = true;
                return ch;
            }
            return ch;
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
    }

    @Override
    public int lookaheadChar() throws IOException {
        return this.readc();
    }

    @Override
    public String getString(int n) throws IOException {
        StringBuilder b = new StringBuilder();
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return null;
        }
        int i = 0;
        while (i < n) {
            int c = this.getChar();
            if (c < 0) {
                if (i != 0) break;
                this.reachedEOF = true;
                return null;
            }
            b.appendCodePoint(c);
            ++i;
        }
        return b.toString();
    }

    @Override
    public int getChars(int[] buf, int start, int end) throws IOException {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return -1;
        }
        int i = start;
        while (i < end) {
            int c = this.getChar();
            if (c < 0) {
                if (i != start) break;
                this.reachedEOF = true;
                return -1;
            }
            buf[i] = c;
            ++i;
        }
        return end - start;
    }

    @Override
    public String getStringAll() throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return null;
        }
        while ((c = this.getChar()) >= 0) {
            b.appendCodePoint(c);
        }
        if (b.length() == 0) {
            this.reachedEOF = true;
            return null;
        }
        return b.toString();
    }

    @Override
    public String getLine() throws IOException {
        int c;
        StringBuilder b = new StringBuilder();
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.reachedEOF) {
            return null;
        }
        while ((c = this.getChar()) != 10) {
            if (c >= 0) {
                b.appendCodePoint(c);
                continue;
            }
            if (b.length() != 0) break;
            this.reachedEOF = true;
            return null;
        }
        return b.toString();
    }

    @Override
    public Datum getDatum() throws IOException {
        return this.readS();
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public boolean isPortEof() {
        return this.reachedEOF;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<iport>");
    }
}

