/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispComplexImpl;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public abstract class LispComplex
extends LispQuaternion {
    public static LispComplex newComplex(LispReal r, LispReal i) {
        if (r.isNaN() || i.isNaN()) {
            return LispDouble.NaN;
        }
        if (i.signum() == 0) {
            return r;
        }
        if (r.isExact() && i.isExact()) {
            return new LispComplexImpl(r, i);
        }
        return new LispComplexImpl(r.toInexact(), i.toInexact());
    }

    public static LispComplex newComplex(double r, double i) {
        if (Double.isNaN(r) || Double.isNaN(i)) {
            return LispDouble.NaN;
        }
        if (i == 0.0) {
            return new LispDouble(r);
        }
        return new LispComplexImpl(new LispDouble(r), new LispDouble(i));
    }

    public static LispComplex newComplex(float r, float i) {
        if (Float.isNaN(r) || Float.isNaN(i)) {
            return LispFloat.NaN;
        }
        if ((double)i == 0.0) {
            return new LispFloat(r);
        }
        return new LispComplexImpl(new LispFloat(r), new LispFloat(i));
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isRational() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isNaN() {
        return this.getReal().isNaN() || this.getImag().isNaN();
    }

    @Override
    public boolean isOne() {
        return this.getReal().isOne() && this.getImag().isZero();
    }

    @Override
    public BigInteger getBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getDenominator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getNumerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract LispComplex uminus();

    @Override
    public abstract LispComplex toExact();

    @Override
    public abstract LispComplex toInexact();

    @Override
    public abstract LispComplex conjugate();

    @Override
    public LispReal[] getImags() {
        return new LispReal[]{this.getImag()};
    }

    @Override
    public double[] getImagsDouble() {
        return new double[]{this.getImagDouble()};
    }

    @Override
    public LispReal[] getImagsAsQuaternion() {
        LispReal im = this.getImag();
        LispReal o = this.isExact() ? LispInteger.ZERO : new LispDouble(0.0);
        return new LispReal[]{im, o, o};
    }

    @Override
    public double[] getImagsDoubleAsQuaternion() {
        double im = this.getImagDouble();
        return new double[]{im, 0.0, 0.0};
    }

    @Override
    public LispReal[] getImagsAsOctonion() {
        LispReal im = this.getImag();
        LispReal o = this.isExact() ? LispInteger.ZERO : new LispDouble(0.0);
        return new LispReal[]{im, o, o, o, o, o, o};
    }

    @Override
    public double[] getImagsDoubleAsOctonion() {
        double im = this.getImagDouble();
        return new double[]{im, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @Override
    LispComplex getComplexPairA() {
        return this;
    }

    @Override
    LispComplex getComplexPairB() {
        return LispInteger.ZERO;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (this.getImag().signum() > 0 && !this.getImag().isInfinity()) {
            return new LispString(String.valueOf(LispUtils.getResult(this.getReal())) + "+" + LispUtils.getResult(this.getImag()) + "i");
        }
        return new LispString(String.valueOf(LispUtils.getResult(this.getReal())) + LispUtils.getResult(this.getImag()) + "i");
    }

    @Override
    public String getResult() {
        if (this.getImag().signum() > 0 && !this.getImag().isInfinity()) {
            return String.valueOf(LispUtils.getResult(this.getReal())) + "+" + LispUtils.getResult(this.getImag()) + "i";
        }
        return String.valueOf(LispUtils.getResult(this.getReal())) + LispUtils.getResult(this.getImag()) + "i";
    }

    @Override
    public String print() {
        return this.getResult();
    }

    @Override
    public LispType getType() {
        return LispType.COMPLEX;
    }

    @Override
    public String toString() {
        return this.getResult();
    }
}

