/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import java.math.BigDecimal;
import net.morilib.lang.Decimal32;
import net.morilib.lang.Decimal64;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDecimal64;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispHalf;
import net.morilib.lisp.LispInexactReal;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispRangedDouble;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;

public class LispDecimal32
extends LispInexactReal
implements JavaObjective,
Serializable {
    public static final LispDecimal32 ZERO = new LispDecimal32(Decimal32.ZERO_BY_INT);
    public static final LispDecimal32 ONE = new LispDecimal32(Decimal32.parseDecimal("1"));
    public static final NumericalField<LispReal> FIELD = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(int v) {
            return this.valueOf((long)v);
        }

        @Override
        public LispReal valueOf(long v) {
            return new LispDecimal32(Decimal32.toDecimal(v));
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return this.valueOf(v.doubleValue());
        }

        @Override
        public LispReal getUnit() {
            return LispFloat.ONE;
        }

        @Override
        public LispReal getZero() {
            return LispFloat.ZERO;
        }

        @Override
        public LispReal valueOf(float v) {
            return this.valueOf((double)v);
        }

        @Override
        public LispReal valueOf(double v) {
            return new LispDecimal32(Decimal32.toDecimal(v));
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return this.valueOf(v.floatValue());
        }

        @Override
        public LispReal valueOf(Rational v) {
            return this.valueOf(v.floatValue());
        }
    };
    private int number;

    public LispDecimal32(int number) {
        this.number = number;
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return FIELD;
    }

    @Override
    public int castInt() {
        return Decimal32.toBigDecimal(this.number).intValue();
    }

    @Override
    public long castLong() {
        return Decimal32.toBigDecimal(this.number).longValue();
    }

    @Override
    public Integer2 castInteger2() {
        return Integer2.valueOf(Decimal32.toBigDecimal(this.number).toBigInteger());
    }

    @Override
    public int intFloor() {
        return Decimal32.toBigDecimal(Decimal32.floor(this.number, 0)).intValue();
    }

    @Override
    public long longFloor() {
        return Decimal32.toBigDecimal(Decimal32.floor(this.number, 0)).longValue();
    }

    @Override
    public Integer2 getInteger2Floor() {
        return Integer2.valueOf(Decimal32.toBigDecimal(Decimal32.floor(this.number, 0)).toBigInteger());
    }

    @Override
    public int intCeil() {
        return Decimal32.toBigDecimal(Decimal32.ceil(this.number, 0)).intValue();
    }

    @Override
    public long longCeil() {
        return Decimal32.toBigDecimal(Decimal32.ceil(this.number, 0)).longValue();
    }

    @Override
    public Integer2 getInteger2Ceil() {
        return Integer2.valueOf(Decimal32.toBigDecimal(Decimal32.ceil(this.number, 0)).toBigInteger());
    }

    @Override
    public Rational getRational() {
        return Rational.valueOf(Decimal32.toBigDecimal(this.number));
    }

    @Override
    public float floatValue() {
        return Decimal32.floatValue(this.number);
    }

    @Override
    public double doubleValue() {
        return Decimal32.doubleValue(this.number);
    }

    @Override
    public boolean isUnit() {
        return this.doubleValue() == 1.0;
    }

    @Override
    public LispReal multiply(int n) {
        return new LispDecimal32(Decimal32.multiply(this.number, Decimal32.toDecimal(n)));
    }

    @Override
    public LispReal power(int n) {
        int x = this.number;
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ZERO;
        }
        int i = 1;
        while (i < n) {
            x = Decimal32.multiply(x, this.number);
            ++i;
        }
        return new LispDecimal32(x);
    }

    @Override
    public LispReal invert() {
        return new LispDecimal32(Decimal32.divide(Decimal32.toDecimal(1L), this.number));
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return Decimal32.compare(this.number, x.getRealDecimal32()) < 0;
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return Decimal32.compare(this.number, x.getRealDecimal32()) > 0;
    }

    @Override
    public int signum() {
        return Decimal32.getSignum(this.number);
    }

    @Override
    public LispExactReal toExact() {
        return LispUtils.bigDecimalToRational(Decimal32.toBigDecimal(this.number));
    }

    @Override
    public boolean isInfinity() {
        return Decimal32.isInfinite(this.number);
    }

    @Override
    public LispReal uminus() {
        return new LispDecimal32(Decimal32.negate(this.number));
    }

    @Override
    public double getRealDouble() {
        return Decimal32.doubleValue(this.number);
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble(Decimal32.doubleValue(this.number) + x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispDecimal32(Decimal32.add(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispFloat) {
            return new LispDecimal32(Decimal32.add(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Decimal32.doubleValue(this.number) + x.getRealDouble());
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.add(Decimal64.decimal32To64(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispDecimal32(Decimal32.add(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.add(c.getReal()), c.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return new LispRangedDouble(Decimal32.doubleValue(this.number) - x.getRealDouble(), ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispDecimal32(Decimal32.subtract(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispFloat) {
            return new LispDecimal32(Decimal32.subtract(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Decimal32.doubleValue(this.number) - x.getRealDouble());
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.subtract(Decimal64.decimal32To64(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispDecimal32(Decimal32.subtract(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.subtract(c.getReal()), c.getImag().uminus());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf(Decimal32.doubleValue(this.number) * x.getRealDouble(), Decimal32.doubleValue(this.number) * ((LispRangedDouble)x).error);
        }
        if (x instanceof LispHalf) {
            return new LispDecimal32(Decimal32.multiply(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispFloat) {
            return new LispDecimal32(Decimal32.multiply(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Decimal32.doubleValue(this.number) * x.getRealDouble());
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.multiply(Decimal64.decimal32To64(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispDecimal32(Decimal32.multiply(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.multiply(c.getReal()), this.multiply(c.getImag()));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            if (x0.isZeroIncluded()) {
                return LispDouble.NaN;
            }
            double y1 = this.doubleValue() / x0.getRealDouble() + this.doubleValue() * x0.error;
            double y2 = this.doubleValue() / x0.getRealDouble() - this.doubleValue() * x0.error;
            return LispRangedDouble.valueOf((y1 + y2) / 2.0, Math.abs(y1 - y2) / 2.0);
        }
        if (x instanceof LispHalf) {
            return new LispDecimal32(Decimal32.divide(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispFloat) {
            return new LispDecimal32(Decimal32.divide(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispDouble) {
            return new LispDouble(Decimal32.doubleValue(this.number) / x.getRealDouble());
        }
        if (x instanceof LispDecimal64) {
            return new LispDecimal64(Decimal64.divide(Decimal64.decimal32To64(this.number), x.getRealDecimal64()));
        }
        if (x instanceof LispReal) {
            return new LispDecimal32(Decimal32.divide(this.number, x.getRealDecimal32()));
        }
        if (x instanceof LispComplex) {
            LispReal xr = x.getReal();
            LispReal xi = x.getImag();
            LispReal xn = xr.multiply(xr).add(xi.multiply(xi));
            return LispComplex.newComplex(this.multiply(xr).divide(xn), this.multiply(xi).uminus().divide(xn));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public Object toObject() {
        return new Decimal32(this.number);
    }

    @Override
    public long getRealDecimal64() {
        return Decimal64.decimal32To64(this.number);
    }

    @Override
    public int getRealDecimal32() {
        return this.number;
    }

    @Override
    public boolean isNaN() {
        return Decimal32.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return this.equals(ONE);
    }

    @Override
    public String getResult() {
        return Decimal32.toString(this.number);
    }

    @Override
    public LispReal floor() {
        return new LispDecimal32(Decimal32.floor(this.number, 0));
    }

    @Override
    public LispReal ceil() {
        return new LispDecimal32(Decimal32.ceil(this.number, 0));
    }

    @Override
    public int hashCode() {
        return this.number;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LispDecimal32) {
            return Decimal32.compare(this.number, ((LispDecimal32)o).number) == 0;
        }
        return false;
    }
}

