/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArrayIndices;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.LispSharedArray;
import net.morilib.lisp.array.SRFI25Array;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;
import net.morilib.util.primitive.IntegerArrayVector;

public interface LispArray {
    public int rank();

    public int startIndex(int var1);

    public int endIndex(int var1);

    public LispVector toVector();

    public Datum getFromArray(int ... var1);

    public void setToArray(Datum var1, int ... var2);

    public boolean isIndexEqualTo(LispArray var1);

    public boolean isEqualTo(LispArray var1);

    public String getTypeSpecifier();

    public void fill(Iterator<Datum> var1);

    public LispArrayShape getShape();

    public static class ArrayEnd
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            int dim = SubrUtils.getSmallInt(c2a, mesg);
            if (c1a instanceof LispArray) {
                try {
                    return LispInteger.valueOf(((LispArray)((Object)c1a)).endIndex(dim));
                }
                catch (IndexOutOfBoundsException e) {
                    throw mesg.getError("err.srfi25.dimension.invalid", c2a);
                }
            }
            throw mesg.getError("err.srfi25.require.array", c1a);
        }
    }

    public static class ArrayRank
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispArray) {
                return LispInteger.valueOf(((LispArray)((Object)c1a)).rank());
            }
            throw mesg.getError("err.srfi25.require.array", c1a);
        }
    }

    public static class ArrayRef
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            int[] i;
            ConsIterator itr = new ConsIterator(body);
            Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum d = Iterators.nextIf(itr);
            if (!(a instanceof LispArray)) {
                throw mesg.getError("err.srfi25.require.array", a);
            }
            if (d == null) {
                return ((LispArray)((Object)a)).getFromArray(new int[0]);
            }
            if (d instanceof LispArrayIndices) {
                i = ((LispArrayIndices)d).getpos();
            } else if (d instanceof LispArray) {
                LispArray b = (LispArray)((Object)d);
                if (b.rank() != 1) {
                    throw mesg.getError("err.srfi25.dimension.invalid", d);
                }
                LispVector v = b.toVector();
                i = new int[v.size()];
                int j = 0;
                while (j < v.size()) {
                    i[j] = SubrUtils.getSmallInt(v.get(j), mesg);
                    ++j;
                }
            } else {
                IntegerArrayVector iv = new IntegerArrayVector();
                do {
                    iv.add(SubrUtils.getSmallInt(d, mesg));
                } while ((d = Iterators.nextIf(itr)) != null);
                i = iv.toIntArray();
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                return ((LispArray)((Object)a)).getFromArray(i);
            }
            catch (InvalidDimensionException e) {
                throw mesg.getError("err.srfi25.dimension.invalid");
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.range.invalid");
            }
        }
    }

    public static class ArraySetS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            int[] i;
            ConsIterator itr = new ConsIterator(body);
            Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (!(a instanceof LispArray)) {
                throw mesg.getError("err.srfi25.require.array", a);
            }
            if (d instanceof LispArrayIndices) {
                i = ((LispArrayIndices)d).getpos();
            } else if (d instanceof LispArray) {
                LispArray b = (LispArray)((Object)d);
                if (b.rank() != 1) {
                    throw mesg.getError("err.srfi25.dimension.invalid", d);
                }
                LispVector v = b.toVector();
                i = new int[v.size()];
                int j = 0;
                while (j < v.size()) {
                    i[j] = SubrUtils.getSmallInt(v.get(j), mesg);
                    ++j;
                }
                d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            } else {
                IntegerArrayVector iv = new IntegerArrayVector();
                while (itr.hasNext()) {
                    iv.add(SubrUtils.getSmallInt(d, mesg));
                    d = Iterators.nextIf(itr);
                    if (d != null) continue;
                }
                i = iv.toIntArray();
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                ((LispArray)((Object)a)).setToArray(d, i);
                return Undef.UNDEF;
            }
            catch (InvalidDimensionException e) {
                throw mesg.getError("err.srfi25.dimension.invalid");
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.range.invalid");
            }
            catch (ClassCastException e) {
                throw mesg.getError("err.srfi25.typemismatch");
            }
            catch (ValueOutOfBoundsException e) {
                throw mesg.getError("err.srfi47.valueoutofrange", e.getMessage());
            }
        }
    }

    public static class ArrayStart
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            int dim = SubrUtils.getSmallInt(c2a, mesg);
            if (c1a instanceof LispArray) {
                try {
                    return LispInteger.valueOf(((LispArray)((Object)c1a)).startIndex(dim));
                }
                catch (IndexOutOfBoundsException e) {
                    throw mesg.getError("err.srfi25.dimension.invalid", c2a);
                }
            }
            throw mesg.getError("err.srfi25.require.array", c1a);
        }
    }

    public static class IsArray
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispArray);
        }
    }

    public static class MakeArray
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum s = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (s instanceof LispArrayShape) {
                Datum o = Iterators.nextIf(itr, Undef.UNDEF);
                SubrUtils.checkTerminated(itr, body, mesg);
                return LispDefaultArray.malloc((LispArrayShape)s, o);
            }
            if (s instanceof LispArrayPrototype) {
                IntegerArrayVector bin = new IntegerArrayVector();
                while (itr.hasNext()) {
                    int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
                    if (b < 0) {
                        throw mesg.getError("err.srfi25.arraysize.invalid", LispInteger.valueOf(b));
                    }
                    bin.add(b);
                }
                SubrUtils.checkTerminated(itr, body, mesg);
                return (Datum)((Object)((LispArrayPrototype)((Object)s)).makeArray(bin.toIntArray()));
            }
            throw mesg.getError("err.srfi25.require.shape", s);
        }
    }

    public static class ShareArray
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispArray)) {
                throw mesg.getError("err.srfi25.require.array", c1a);
            }
            if (!(c2a instanceof LispArrayShape)) {
                throw mesg.getError("err.srfi25.require.shape", c2a);
            }
            if (!(c3a instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", c3a);
            }
            return new LispSharedArray((LispArray)((Object)c1a), (LispArrayShape)c2a, (Procedure)((Object)c3a), env, mesg);
        }
    }

    public static class SubrArray
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum s = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (s instanceof LispArrayShape) {
                SRFI25Array a = LispDefaultArray.malloc((LispArrayShape)s, (Datum)Undef.UNDEF);
                a.fill(itr);
                return a;
            }
            throw mesg.getError("err.srfi25.require.shape", s);
        }
    }
}

