/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.desktop;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class DesktopMail
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = Iterators.nextIf(itr);
        URI s = c1a == null ? SubrUtils.getURI(c1a, mesg) : null;
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!Desktop.isDesktopSupported()) {
            return LispBoolean.FALSE;
        }
        Desktop dsk = Desktop.getDesktop();
        if (!dsk.isSupported(Desktop.Action.BROWSE)) {
            return LispBoolean.FALSE;
        }
        if (s == null) {
            try {
                dsk.mail();
                return LispBoolean.TRUE;
            }
            catch (IOException e) {
                throw mesg.getError("err.io");
            }
        }
        try {
            dsk.mail(s);
            return LispBoolean.TRUE;
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
    }
}

