/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.env;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.awt.ILispAWTWindow;
import net.morilib.lisp.awt.env.LispGraphicsDevice;
import net.morilib.lisp.subr.SubrUtils;

public class GraphicsDeviceFullScreenSetS
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum w;
        GraphicsDevice dev;
        ConsIterator itr = new ConsIterator(body);
        Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (d instanceof LispGraphicsDevice) {
            dev = ((LispGraphicsDevice)d).device;
            w = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        } else {
            dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            w = d;
        }
        if (w instanceof ILispAWTWindow) {
            dev.setFullScreenWindow(((ILispAWTWindow)((Object)w)).getFrame());
        } else if (!w.isTrue()) {
            dev.setFullScreenWindow(null);
        } else {
            throw mesg.getError("err.awt.require.window", w);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        return Undef.UNDEF;
    }
}

