/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.tray;

import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.awt.tray.LispTrayIcon;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.painter.ILispImage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.LispSwing;
import net.morilib.util.Iterators;

public class MakeTrayIcon
extends Subr {
    static MenuItem parseMenu(Datum d, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(d, mesg);
        if (l.size() == 2) {
            String t = SubrUtils.getString(l.get(0), mesg);
            if (l.get(1) instanceof Procedure) {
                MenuItem itm = new MenuItem(t);
                itm.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
                return itm;
            }
            if (l.get(1) instanceof Cons) {
                Menu men = new Menu(t);
                ConsIterator itr = new ConsIterator(l.get(1));
                while (itr.hasNext()) {
                    Datum z = itr.next();
                    if (z.equals(Symbol.getSymbol("separator"))) {
                        men.addSeparator();
                        continue;
                    }
                    men.add(MakeTrayIcon.parseMenu(z, env, mesg));
                }
                if (!itr.getTerminal().isNil()) {
                    throw mesg.getError("err.list", l.get(1));
                }
                return men;
            }
            if (!l.get(1).isTrue()) {
                return new MenuItem(t);
            }
            throw mesg.getError("err.awt.invalidmenu", d);
        }
        throw mesg.getError("err.awt.invalidmenu", d);
    }

    static PopupMenu parsePopupMenu(Datum d, Environment env, LispMessage mesg) {
        PopupMenu mb = new PopupMenu();
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            mb.add(MakeTrayIcon.parseMenu(itr.next(), env, mesg));
        }
        SubrUtils.checkProper(itr, d, mesg);
        return mb;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c3a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c4a = Iterators.nextIf(itr);
        Datum c5a = Iterators.nextIf(itr);
        Datum c6a = Iterators.nextIf(itr);
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            Image img;
            if (c1a instanceof LispString) {
                img = ImageIO.read(LispFiles.getFile(env, c1a, mesg));
            } else if (c1a instanceof ILispImage) {
                img = ((ILispImage)((Object)c1a)).getImage();
            } else {
                throw mesg.getError("err.awt.require.image", c1a);
            }
            String tt = c2a.isTrue() ? SubrUtils.getString(c2a, mesg) : null;
            PopupMenu men = c3a.isTrue() ? MakeTrayIcon.parsePopupMenu(c3a, env, mesg) : null;
            TrayIcon ico = new TrayIcon(img, tt, men);
            if (c4a != null) {
                ico.addActionListener(LispSwing.createActionListener(c4a, env, mesg));
            }
            if (c5a != null) {
                ico.addMouseListener(LispSwing.createMouseListener(c5a, body, env, mesg));
            }
            if (c6a != null) {
                ico.addMouseMotionListener(LispSwing.createMouseMotionListener(c6a, body, env, mesg));
            }
            ico.setImageAutoSize(true);
            return new LispTrayIcon(ico);
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
    }
}

