/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispDirectionalCollection
extends LispCollection {
    public Datum first();

    public Datum last();

    public Datum insertFirst(Datum var1) throws ImmutableException;

    public Datum insertLast(Datum var1) throws ImmutableException;

    public Datum copyInsertFirst(Datum var1);

    public Datum copyInsertLast(Datum var1);

    public Datum[] removeFirst() throws ImmutableException;

    public Datum[] removeLast() throws ImmutableException;

    public Datum[] copyWithoutFirst();

    public Datum[] copyWithoutLast();

    public static class DirectedCollectionDeleteLeft
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionDeleteLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum[] r2 = ((LispDirectionalCollection)((Object)c1a)).copyWithoutFirst();
                return MultiValues.newValues(r2);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
        }
    }

    public static class DirectedCollectionDeleteLeftS
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionDeleteLeftS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum[] r2 = ((LispDirectionalCollection)((Object)c1a)).removeFirst();
                return MultiValues.newValues(r2);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
        }
    }

    public static class DirectedCollectionDeleteRight
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionDeleteRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum[] r2 = ((LispDirectionalCollection)((Object)c1a)).copyWithoutLast();
                return MultiValues.newValues(r2);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
        }
    }

    public static class DirectedCollectionDeleteRightS
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionDeleteRightS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum[] r2 = ((LispDirectionalCollection)((Object)c1a)).removeLast();
                return MultiValues.newValues(r2);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class DirectedCollectionGetLeft
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionGetLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispDirectionalCollection c = (LispDirectionalCollection)((Object)d);
            if (c.size() > 0) {
                return c.first();
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class DirectedCollectionGetRight
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionGetRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispDirectionalCollection c = (LispDirectionalCollection)((Object)d);
            if (c.size() > 0) {
                return c.last();
            }
            if (c.size() < 0) {
                throw mesg.getError("err.srfi44.infinite", d);
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class DirectedCollectionInsertLeft
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionInsertLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDirectionalCollection)((Object)c1a)).copyInsertFirst(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class DirectedCollectionInsertLeftS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionInsertLeftS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDirectionalCollection)((Object)c1a)).insertFirst(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class DirectedCollectionInsertRight
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionInsertRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDirectionalCollection)((Object)c1a)).copyInsertLast(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class DirectedCollectionInsertRightS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DirectedCollectionInsertRightS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDirectionalCollection)((Object)c1a)).insertLast(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class IsDirectedCollection
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispDirectionalCollection);
        }
    }
}

