/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection.enums;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ISubr;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispCollections;
import net.morilib.lisp.collection.LispMap;
import net.morilib.lisp.collection.hash.LispHash;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LispEnumMapClass
extends Datum2
implements ISubr {
    private OneToOneSet<Integer, Datum> map;

    public LispEnumMapClass(Collection<Datum> data) {
        int i = 0;
        this.map = new HashOneToOneSet<Integer, Datum>();
        for (Datum d : data) {
            this.map.put(i++, d);
        }
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum[] a = new Datum[this.map.size()];
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        ConsIterator jtr = new ConsIterator(c1a);
        while (jtr.hasNext()) {
            Datum y;
            Datum x;
            Datum d = jtr.next();
            if (d instanceof Cons) {
                x = ((Cons)d).getCar();
                y = ((Cons)d).getCdr();
            } else {
                x = d;
                y = Undef.UNDEF;
            }
            Integer i = (Integer)this.map.getKey(x);
            if (i == null) continue;
            a[i.intValue()] = y;
        }
        return new LispEnumMap(this, a);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<enum-map-class>");
    }

    public static class LispEnumMap
    extends Datum2
    implements LispMap {
        private Datum[] data;
        private LispEnumMapClass cls;

        private LispEnumMap(LispEnumMapClass cls) {
            this.cls = cls;
        }

        private LispEnumMap(LispEnumMapClass cls, Datum ... data) {
            this.cls = cls;
            this.data = new Datum[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
        }

        @Override
        public Symbol getCollectionName() {
            return Symbol.getSymbol("enum-map");
        }

        @Override
        public Datum toList() {
            ConsListBuilder b = new ConsListBuilder();
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != null) {
                    b.append(new Cons((Datum)this.cls.map.getValue(i), this.data[i]));
                }
                ++i;
            }
            return b.get();
        }

        @Override
        public int count(Datum c2a) {
            int c = 0;
            Datum[] datumArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                Datum d = datumArray[n2];
                if (d != null && c2a.equals(d)) {
                    ++c;
                }
                ++n2;
            }
            return c;
        }

        @Override
        public int size() {
            int c = 0;
            Datum[] datumArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                Datum d = datumArray[n2];
                if (d != null) {
                    ++c;
                }
                ++n2;
            }
            return c;
        }

        @Override
        public Datum prototype() {
            return new LispEnumMap(this.cls);
        }

        @Override
        public Datum clear() {
            int i = 0;
            while (i < this.data.length) {
                this.data[i] = null;
                ++i;
            }
            return this;
        }

        @Override
        public boolean equalTo(LispCollection col) {
            return LispCollections.equalsMapEntry(this, col);
        }

        @Override
        public boolean equalTo(LispCollection col, Procedure p, Environment env, LispMessage mesg) {
            return LispCollections.equalsMapEntry(this, col);
        }

        @Override
        public LispEnumMap duplicate() {
            return new LispEnumMap(this.cls, this.data);
        }

        @Override
        public boolean contains(Datum d) {
            if (d instanceof Cons) {
                return LispCollections.equivalence(this, ((Cons)d).getCar(), ((Cons)d).getCdr());
            }
            return false;
        }

        @Override
        public Iterator<Datum> iterator() {
            final int[] p = new int[2];
            p[1] = 0;
            p[0] = 0;
            while (p[0] < this.data.length && this.data[p[0]] == null) {
                p[0] = p[0] + 1;
            }
            return new Iterator<Datum>(){

                private void seeknext() {
                    p[0] = p[0] + 1;
                    while (p[0] < LispEnumMap.this.data.length && LispEnumMap.this.data[p[0]] == null) {
                        p[0] = p[0] + 1;
                    }
                    p[1] = 0;
                }

                @Override
                public boolean hasNext() {
                    return p[0] < LispEnumMap.this.data.length;
                }

                @Override
                public Datum next() {
                    int i = p[0];
                    this.seeknext();
                    return new Cons((Datum)LispEnumMap.this.cls.map.getValue(i), LispEnumMap.this.data[i]);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
            final int[] p = new int[2];
            p[1] = 0;
            p[0] = 0;
            while (p[0] < this.data.length && this.data[p[0]] == null) {
                p[0] = p[0] + 1;
            }
            return new Iterator<Map.Entry<Datum, Datum>>(){

                private void seeknext() {
                    p[0] = p[0] + 1;
                    while (p[0] < LispEnumMap.this.data.length && LispEnumMap.this.data[p[0]] == null) {
                        p[0] = p[0] + 1;
                    }
                    p[1] = 0;
                }

                @Override
                public boolean hasNext() {
                    return p[0] < LispEnumMap.this.data.length;
                }

                @Override
                public Map.Entry<Datum, Datum> next() {
                    final int i = p[0];
                    this.seeknext();
                    return new Map.Entry<Datum, Datum>(){

                        @Override
                        public Datum getKey() {
                            return (Datum)LispEnumMap.this.cls.map.getValue(i);
                        }

                        @Override
                        public Datum getValue() {
                            return LispEnumMap.this.data[i];
                        }

                        @Override
                        public Datum setValue(Datum value) {
                            Datum r = LispEnumMap.this.data[i];
                            ((LispEnumMap)(this).LispEnumMap.this).data[i] = value;
                            return r;
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Procedure keyEquivalence() {
            return LispHash.EQV_HASH;
        }

        @Override
        public boolean equivalenceKey(Datum a, Datum b) {
            return a.equals(b);
        }

        @Override
        public Procedure valueEquivalence() {
            return LispHash.EQV_HASH;
        }

        @Override
        public boolean equivalenceValue(Datum a, Datum b) {
            return a.equals(b);
        }

        @Override
        public boolean containsKey(Datum k) {
            Integer p = (Integer)this.cls.map.getKey(k);
            return p == null ? false : this.data[p] != null;
        }

        @Override
        public SExpressionDatum keysToList() {
            ConsListBuilder b = new ConsListBuilder();
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != null) {
                    b.append((Datum)this.cls.map.getValue(i));
                }
                ++i;
            }
            return b.get();
        }

        @Override
        public Datum get(Datum k) {
            Integer p = (Integer)this.cls.map.getKey(k);
            return p == null ? null : this.data[p];
        }

        @Override
        public Datum[] copyPut(Datum k, Datum v) {
            return this.duplicate().put(k, v);
        }

        @Override
        public Datum[] put(Datum k, Datum v) {
            Integer p = (Integer)this.cls.map.getKey(k);
            if (p != null) {
                Datum r = this.data[p];
                this.data[p.intValue()] = v;
                return new Datum[]{this, r};
            }
            Datum[] datumArray = new Datum[2];
            datumArray[0] = this;
            return datumArray;
        }

        @Override
        public Datum copyDeleteKey(Datum k) {
            return this.duplicate().deleteKey(k);
        }

        @Override
        public Datum deleteKey(Datum k) {
            Integer p = (Integer)this.cls.map.getKey(k);
            if (p != null) {
                this.data[p.intValue()] = null;
            }
            return this;
        }

        @Override
        public Datum copyDeleteFromKey(LispBag k) {
            return this.duplicate().deleteFromKey(k);
        }

        @Override
        public Datum deleteFromKey(LispBag k) {
            Iterator i = k.iterator();
            while (i.hasNext()) {
                this.deleteKey((Datum)i.next());
            }
            return this;
        }

        @Override
        public Datum copyAddFrom(LispMap m) {
            return this.duplicate().addFrom(m);
        }

        @Override
        public Datum addFrom(LispMap m) {
            Iterator<Map.Entry<Datum, Datum>> i = m.entryIterator();
            while (i.hasNext()) {
                Map.Entry<Datum, Datum> e = i.next();
                Integer p = (Integer)this.cls.map.getKey(e.getKey());
                if (p == null) continue;
                this.data[p.intValue()] = e.getValue();
            }
            return this;
        }

        @Override
        public int countValue(Datum d) {
            int c = 0;
            Datum[] datumArray = this.data;
            int n = this.data.length;
            int n2 = 0;
            while (n2 < n) {
                Datum x = datumArray[n2];
                if (x != null && d.equals(x)) {
                    ++c;
                }
                ++n2;
            }
            return c;
        }

        @Override
        public boolean equalToMap(LispMap e, Procedure p, Environment env, LispMessage mesg) {
            return LispCollections.contains(this, e, p, env, mesg) && LispCollections.contains(e, this, p, env, mesg);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            String dlm = "";
            buf.append("#<enum-map (");
            Iterator<Map.Entry<Datum, Datum>> i = this.entryIterator();
            while (i.hasNext()) {
                Map.Entry<Datum, Datum> e = i.next();
                buf.append(dlm);
                buf.append("(").append(LispUtils.print(e.getKey()));
                buf.append(" . ");
                buf.append(LispUtils.print(e.getValue())).append(")");
                dlm = " ";
            }
            buf.append(")>");
        }
    }
}

