/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.filter.AndFilenameFilter;
import net.morilib.util.io.filter.FilenameFilters;
import net.morilib.util.io.filter.NotFilenameFilter;
import net.morilib.util.io.filter.OrFilenameFilter;
import net.morilib.util.io.filter.WildcardFilenameFilter;

public final class LispFiles {
    static String chdir = null;

    private LispFiles() {
    }

    public static File getFile(Environment env, String s) throws IOException {
        File f = new File(s.replaceFirst("^~/", String.valueOf(System.getProperty("user.home")) + "/"));
        if (f.isAbsolute()) {
            return f;
        }
        if (chdir != null) {
            return new File(chdir, s).getCanonicalFile();
        }
        return new File(System.getProperty("user.dir"), s).getCanonicalFile();
    }

    public static File getFile(Environment env, Datum d, LispMessage mesg) throws IOException {
        return LispFiles.getFile(env, SubrUtils.getString(d, mesg));
    }

    public static File nextFile(ConsIterator itr, Environment env, LispMessage mesg, Datum body) throws IOException {
        return LispFiles.getFile(env, SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body), mesg);
    }

    public static File pwd(Environment env) {
        if (chdir != null) {
            return new File(chdir);
        }
        return new File(System.getProperty("user.dir"));
    }

    private static FilenameFilter[] tofarray(ConsIterator itr, Datum d, LispMessage mesg) {
        ArrayList<FilenameFilter> l = new ArrayList<FilenameFilter>();
        while (itr.hasNext()) {
            l.add(LispFiles.compileFilter(itr.next(), mesg));
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", d);
        }
        return l.toArray(new FilenameFilter[0]);
    }

    static FilenameFilter compileFilter(Datum d, LispMessage mesg) {
        if (d instanceof Cons) {
            ConsIterator itr = new ConsIterator(d);
            String lg = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, d);
            if (lg.equalsIgnoreCase("and")) {
                return new AndFilenameFilter(LispFiles.tofarray(itr, d, mesg));
            }
            if (lg.equalsIgnoreCase("or")) {
                return new OrFilenameFilter(LispFiles.tofarray(itr, d, mesg));
            }
            if (lg.equalsIgnoreCase("not")) {
                Datum x = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.file.invalid.findop");
                if (itr.hasNext()) {
                    throw mesg.getError("err.file.invalid.findop");
                }
                return new NotFilenameFilter(LispFiles.compileFilter(x, mesg));
            }
            throw mesg.getError("err.file.invalid.findop");
        }
        if (d.isNil()) {
            return FilenameFilters.TRUE;
        }
        if (d.equals(Symbol.getSymbol("directory"))) {
            return FilenameFilters.IS_DIRECTORY;
        }
        if (d.equals(Symbol.getSymbol("file"))) {
            return FilenameFilters.IS_FILE;
        }
        if (d.equals(Symbol.getSymbol("exist"))) {
            return FilenameFilters.IS_EXIST;
        }
        return new WildcardFilenameFilter(SubrUtils.getString(d, mesg));
    }
}

