/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.constants;

import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.math.constants.Pi;

public final class LispPi
extends LispAlternatingSeriesNumber {
    public static final LispPi PI = new LispPi(Pi.PI);
    public static final LispPi ONE_DEGREE = new LispPi(Pi.ONE_DEGREE);

    private LispPi(Pi pi) {
        super(pi);
    }

    private LispPi(Rational scale, Rational shift) {
        super(new Pi(scale, shift));
    }

    public static LispReal scaled(LispReal scale, LispReal shift) {
        return scale.isZero() ? LispInteger.ZERO : new LispPi(scale.getRational(), shift.getRational());
    }

    @Override
    public LispPi uminus() {
        return new LispPi(this.value.getScale().negate(), this.value.getShift().negate());
    }

    @Override
    public LispExactReal prototype(Rational scale, Rational shift) {
        return scale.isZero() ? LispRational.valueOf(shift) : new LispPi(scale, shift);
    }
}

