/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.math.matrix.AbstractImmutableLispMatrix;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.LispMatrix;
import net.morilib.lisp.math.matrix.LispMatrixException;

public class LUDecomposedUMatrix
extends AbstractImmutableLispMatrix {
    private ILispMatrix a;

    LUDecomposedUMatrix(ILispMatrix a) {
        this.a = a;
    }

    @Override
    public LispNumber get(int row, int column) {
        return row > column ? LispInteger.ZERO : this.a.get(row, column);
    }

    @Override
    public int rowSize() {
        return this.a.rowSize();
    }

    @Override
    public int columnSize() {
        return this.a.columnSize();
    }

    @Override
    public LispNumber determinant() {
        LispNumber r = LispInteger.ONE;
        int i = 0;
        while (i < this.a.rowSize()) {
            r = ((LispNumber)r).mul(this.a.get(i, i));
            ++i;
        }
        return r;
    }

    @Override
    public ILispMatrix inv() throws LispMatrixException {
        LispMatrix r = new LispMatrix(this);
        if (this.determinant().isZero()) {
            throw new LispMatrixException();
        }
        int i = 0;
        while (i < this.columnSize()) {
            r.set(i, i, LispInteger.ONE.div(r.get(i, i)));
            ++i;
        }
        int c = 1;
        while (c < this.rowSize()) {
            int i2 = c;
            while (i2 < this.columnSize()) {
                int j = i2 - c;
                LispNumber x = LispInteger.ZERO;
                int k = j + 1;
                while (k <= i2) {
                    LispNumber c1 = this.get(j, k);
                    LispNumber c2 = r.get(k, i2);
                    x = ((LispNumber)x).add(c1.mul(c2));
                    ++k;
                }
                r.set(j, i2, ((LispNumber)x).mul(r.get(j, j)).uminus());
                ++i2;
            }
            ++c;
        }
        return r;
    }
}

